/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.coreservice.impl.namespace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.coreservice.api.namespace.Namespace;
import org.kuali.rice.coreservice.api.namespace.NamespaceService;
import org.kuali.rice.coreservice.impl.namespace.NamespaceBo;
import org.kuali.rice.krad.data.CompoundKey;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class NamespaceServiceImpl
implements NamespaceService {
    private DataObjectService dataObjectService;

    public Namespace getNamespace(String code) {
        if (StringUtils.isBlank((String)code)) {
            throw new RiceIllegalArgumentException("the code is blank");
        }
        return NamespaceBo.to((NamespaceBo)((Object)this.dataObjectService.find(NamespaceBo.class, (Object)new CompoundKey(Collections.singletonMap("code", code)))));
    }

    public List<Namespace> findAllNamespaces() {
        QueryResults namespaceBos = this.dataObjectService.findAll(NamespaceBo.class);
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        if (namespaceBos != null) {
            for (NamespaceBo bo : namespaceBos.getResults()) {
                namespaces.add(NamespaceBo.to(bo));
            }
        }
        return Collections.unmodifiableList(namespaces);
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

