/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.document.rule;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.entity.EntityDefault;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.role.RoleMember;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimAttributeField;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleMember;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleQualifier;
import org.kuali.rice.kim.bo.ui.PersonDocumentAffiliation;
import org.kuali.rice.kim.bo.ui.PersonDocumentBoDefaultBase;
import org.kuali.rice.kim.bo.ui.PersonDocumentEmploymentInfo;
import org.kuali.rice.kim.bo.ui.PersonDocumentGroup;
import org.kuali.rice.kim.bo.ui.PersonDocumentName;
import org.kuali.rice.kim.bo.ui.PersonDocumentRole;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegationMember;
import org.kuali.rice.kim.document.IdentityManagementPersonDocument;
import org.kuali.rice.kim.document.authorization.IdentityManagementKimDocumentAuthorizer;
import org.kuali.rice.kim.document.rule.ActiveRoleMemberHelper;
import org.kuali.rice.kim.document.rule.AttributeValidationHelper;
import org.kuali.rice.kim.framework.services.KimFrameworkServiceLocator;
import org.kuali.rice.kim.framework.type.KimTypeService;
import org.kuali.rice.kim.impl.identity.affiliation.EntityAffiliationTypeBo;
import org.kuali.rice.kim.impl.identity.principal.PrincipalBo;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.kuali.rice.kim.rule.event.ui.AddGroupEvent;
import org.kuali.rice.kim.rule.event.ui.AddPersonDelegationMemberEvent;
import org.kuali.rice.kim.rule.event.ui.AddRoleEvent;
import org.kuali.rice.kim.rule.ui.AddGroupRule;
import org.kuali.rice.kim.rule.ui.AddPersonDelegationMemberRule;
import org.kuali.rice.kim.rule.ui.AddPersonDocumentRoleQualifierRule;
import org.kuali.rice.kim.rule.ui.AddRoleRule;
import org.kuali.rice.kim.rules.ui.PersonDocumentDelegationMemberRule;
import org.kuali.rice.kim.rules.ui.PersonDocumentGroupRule;
import org.kuali.rice.kim.rules.ui.PersonDocumentRoleRule;
import org.kuali.rice.kns.kim.type.DataDictionaryTypeServiceHelper;
import org.kuali.rice.kns.rules.TransactionalDocumentRuleBase;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;

public class IdentityManagementPersonDocumentRule
extends TransactionalDocumentRuleBase
implements AddGroupRule,
AddRoleRule,
AddPersonDocumentRoleQualifierRule,
AddPersonDelegationMemberRule {
    protected AddGroupRule addGroupRule;
    protected AddRoleRule addRoleRule;
    protected AddPersonDelegationMemberRule addPersonDelegationMemberRule;
    protected IdentityManagementKimDocumentAuthorizer authorizer;
    private IdentityService identityService;
    private RoleService roleService;
    protected Class<? extends AddGroupRule> addGroupRuleClass = PersonDocumentGroupRule.class;
    protected Class<? extends AddRoleRule> addRoleRuleClass = PersonDocumentRoleRule.class;
    protected Class<? extends AddPersonDelegationMemberRule> addPersonDelegationMemberRuleClass = PersonDocumentDelegationMemberRule.class;
    protected ActiveRoleMemberHelper activeRoleMemberHelper = new ActiveRoleMemberHelper();
    protected AttributeValidationHelper attributeValidationHelper = new AttributeValidationHelper();

    protected boolean processCustomSaveDocumentBusinessRules(Document document) {
        boolean isCreatingNew;
        if (!(document instanceof IdentityManagementPersonDocument)) {
            return false;
        }
        IdentityManagementPersonDocument personDoc = (IdentityManagementPersonDocument)document;
        boolean valid = true;
        GlobalVariables.getMessageMap().addToErrorPath("document");
        this.getDictionaryValidationService().validateDocumentAndUpdatableReferencesRecursively(document, this.getMaxDictionaryValidationDepth(), true, false);
        valid &= this.validDuplicatePrincipalName(personDoc);
        EntityDefault origEntity = this.getIdentityService().getEntityDefault(personDoc.getEntityId());
        boolean bl = isCreatingNew = origEntity == null;
        if (this.canModifyEntity(GlobalVariables.getUserSession().getPrincipalId(), personDoc.getPrincipalId()) || isCreatingNew) {
            valid &= this.validateEntityInformation(isCreatingNew, personDoc);
        }
        valid &= this.validateRoleQualifier(personDoc.getRoles());
        valid &= this.validateDelegationMemberRoleQualifier(personDoc.getDelegationMembers());
        if (StringUtils.isNotBlank((String)personDoc.getPrincipalName())) {
            valid &= this.doesPrincipalNameExist(personDoc.getPrincipalName(), personDoc.getPrincipalId());
        }
        valid &= this.validActiveDatesForRole(personDoc.getRoles());
        valid &= this.validActiveDatesForGroup(personDoc.getGroups());
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        return valid &= this.validActiveDatesForDelegations(personDoc.getDelegationMembers());
    }

    protected boolean validateEntityInformation(boolean isCreatingNew, IdentityManagementPersonDocument personDoc) {
        boolean valid = true;
        boolean canOverridePrivacyPreferences = this.canOverrideEntityPrivacyPreferences(GlobalVariables.getUserSession().getPrincipalId(), personDoc.getPrincipalId());
        valid &= this.checkMultipleDefault(personDoc.getAffiliations(), "affiliations");
        if (isCreatingNew || canOverridePrivacyPreferences || !personDoc.getPrivacy().isSuppressName()) {
            valid &= this.checkMultipleDefault(personDoc.getNames(), "names");
        }
        if (isCreatingNew || canOverridePrivacyPreferences || !personDoc.getPrivacy().isSuppressAddress()) {
            valid &= this.checkMultipleDefault(personDoc.getAddrs(), "addrs");
        }
        if (isCreatingNew || canOverridePrivacyPreferences || !personDoc.getPrivacy().isSuppressPhone()) {
            valid &= this.checkMultipleDefault(personDoc.getPhones(), "phones");
        }
        if (isCreatingNew || canOverridePrivacyPreferences || !personDoc.getPrivacy().isSuppressEmail()) {
            valid &= this.checkMultipleDefault(personDoc.getEmails(), "emails");
        }
        valid &= this.checkPrimaryEmploymentInfo(personDoc.getAffiliations());
        valid &= this.validEmployeeIDForAffiliation(personDoc.getAffiliations());
        valid &= this.checkAffiliationTypeChange(personDoc.getAffiliations());
        return valid &= this.checkUniqueAffiliationTypePerCampus(personDoc.getAffiliations());
    }

    protected boolean validDuplicatePrincipalName(IdentityManagementPersonDocument personDoc) {
        List prncplImpls = KradDataServiceLocator.getDataObjectService().findMatching(PrincipalBo.class, QueryByCriteria.Builder.forAttribute((String)"principalName", (Object)personDoc.getPrincipalName()).build()).getResults();
        boolean rulePassed = true;
        if (!prncplImpls.isEmpty()) {
            if (prncplImpls.size() == 1 && StringUtils.equals((String)((PrincipalBo)prncplImpls.get(0)).getPrincipalId(), (String)personDoc.getPrincipalId())) {
                rulePassed = true;
            } else {
                GlobalVariables.getMessageMap().putError("document.principalName", "error.duplicate.entry", new String[]{"Principal Name"});
                rulePassed = false;
            }
        }
        return rulePassed;
    }

    protected boolean processCustomRouteDocumentBusinessRules(Document document) {
        super.processCustomRouteDocumentBusinessRules(document);
        IdentityManagementPersonDocument personDoc = (IdentityManagementPersonDocument)document;
        boolean valid = true;
        GlobalVariables.getMessageMap().addToErrorPath("document");
        valid &= this.validateAffiliationAndName(personDoc);
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        return valid &= this.checkAffiliationEithOneEMpInfo(personDoc.getAffiliations());
    }

    protected boolean checkMultipleDefault(List<? extends PersonDocumentBoDefaultBase> boList, String listName) {
        boolean valid = true;
        boolean isDefaultSet = false;
        int i = 0;
        for (PersonDocumentBoDefaultBase personDocumentBoDefaultBase : boList) {
            if (personDocumentBoDefaultBase.isDflt()) {
                if (isDefaultSet) {
                    GlobalVariables.getMessageMap().putError(listName + "[" + i + "].dflt", "error.multiple.default.selection", new String[0]);
                    valid = false;
                } else {
                    isDefaultSet = true;
                }
            }
            ++i;
        }
        if (!boList.isEmpty() && !isDefaultSet) {
            GlobalVariables.getMessageMap().putError(listName + "[0].dflt", "error.no.default.selection", new String[0]);
        }
        return valid;
    }

    protected boolean checkPrimaryEmploymentInfo(List<PersonDocumentAffiliation> affiliations) {
        boolean valid = true;
        int i = 0;
        int firstAfflnCounter = -1;
        boolean isPrimarySet = false;
        for (PersonDocumentAffiliation affiliation : affiliations) {
            int j = 0;
            for (PersonDocumentEmploymentInfo empInfo : affiliation.getEmpInfos()) {
                if (firstAfflnCounter == -1) {
                    firstAfflnCounter = i;
                }
                if (!empInfo.isPrimary()) continue;
                if (isPrimarySet) {
                    GlobalVariables.getMessageMap().putError("affiliations[" + i + "].empInfos[" + j + "].primary", "error.multiple.primary.employment", new String[0]);
                    valid = false;
                } else {
                    isPrimarySet = true;
                }
                ++j;
            }
            ++i;
        }
        if (!isPrimarySet && firstAfflnCounter != -1) {
            GlobalVariables.getMessageMap().putError("affiliations[" + firstAfflnCounter + "].empInfos[0].primary", "error.no.primary.employment", new String[0]);
            valid = false;
        }
        return valid;
    }

    protected boolean checkAffiliationTypeChange(List<PersonDocumentAffiliation> affiliations) {
        boolean valid = true;
        int i = 0;
        for (PersonDocumentAffiliation affiliation : affiliations) {
            EntityAffiliationTypeBo newAffiliationType;
            if (affiliation.getAffiliationType() != null && !affiliation.getAffiliationTypeCode().equals(affiliation.getAffiliationType().getCode()) && !(newAffiliationType = (EntityAffiliationTypeBo)KradDataServiceLocator.getDataObjectService().find(EntityAffiliationTypeBo.class, (Object)affiliation.getAffiliationTypeCode())).isEmploymentAffiliationType() && affiliation.getAffiliationType().isEmploymentAffiliationType() && !affiliation.getEmpInfos().isEmpty()) {
                GlobalVariables.getMessageMap().putError("affiliations[" + i + "].affiliationTypeCode", "error.not.employment.affilationType", new String[]{affiliation.getAffiliationType().getName(), newAffiliationType.getName()});
                valid = false;
            }
            ++i;
        }
        return valid;
    }

    protected boolean validEmployeeIDForAffiliation(List<PersonDocumentAffiliation> affiliations) {
        boolean valid = true;
        int i = 0;
        int j = 0;
        for (PersonDocumentAffiliation affiliation : affiliations) {
            if (affiliation.getAffiliationType() != null && affiliation.getAffiliationType().isEmploymentAffiliationType() && affiliation.getEmpInfos() != null) {
                j = 0;
                for (PersonDocumentEmploymentInfo empInfo : affiliation.getEmpInfos()) {
                    if (!StringUtils.isEmpty((String)empInfo.getEmployeeId())) continue;
                    GlobalVariables.getMessageMap().putError("affiliations[" + i + "].empInfos[" + j + "].employeeId", "error.required.conditionally", new String[]{"Employee ID", "an employee"});
                    valid = false;
                    ++j;
                }
            }
            ++i;
        }
        return valid;
    }

    protected boolean isPersonAnEmployee(List<PersonDocumentAffiliation> affiliations) {
        boolean isEmployee = false;
        for (PersonDocumentAffiliation affiliation : affiliations) {
            if (affiliation.getAffiliationType() == null || !affiliation.getAffiliationType().isEmploymentAffiliationType()) continue;
            isEmployee = true;
            break;
        }
        return isEmployee;
    }

    protected boolean checkUniqueAffiliationTypePerCampus(List<PersonDocumentAffiliation> affiliations) {
        boolean valid = true;
        int i = 0;
        for (PersonDocumentAffiliation affiliation : affiliations) {
            int j = 0;
            for (PersonDocumentAffiliation affiliation1 : affiliations) {
                if (j > i && affiliation.getAffiliationTypeCode().equals(affiliation1.getAffiliationTypeCode()) && affiliation.getCampusCode().equals(affiliation1.getCampusCode())) {
                    GlobalVariables.getMessageMap().putError("affiliations[" + j + "].affiliationTypeCode", "error.not.unique.affilationType.per.campus", new String[]{affiliation.getAffiliationType().getName()});
                    valid = false;
                }
                ++j;
            }
            ++i;
        }
        return valid;
    }

    protected boolean checkAffiliationEithOneEMpInfo(List<PersonDocumentAffiliation> affiliations) {
        boolean valid = true;
        int i = 0;
        for (PersonDocumentAffiliation affiliation : affiliations) {
            if (affiliation.getAffiliationType().isEmploymentAffiliationType() && affiliation.getEmpInfos().isEmpty()) {
                GlobalVariables.getMessageMap().putError("affiliations[" + i + "].affiliationTypeCode", "error.one.item.required", new String[]{"Employment Information"});
                valid = false;
            }
            ++i;
        }
        return valid;
    }

    protected boolean validateAffiliationAndName(IdentityManagementPersonDocument personDoc) {
        boolean valid = true;
        if (personDoc.getAffiliations().isEmpty()) {
            GlobalVariables.getMessageMap().putError("affiliations[0]", "error.one.item.required", new String[]{"affiliation"});
            valid = false;
        }
        if (!personDoc.getNames().isEmpty()) {
            boolean activeExists = false;
            for (PersonDocumentName name : personDoc.getNames()) {
                if (!name.isActive()) continue;
                activeExists = true;
            }
            if (!activeExists) {
                GlobalVariables.getMessageMap().putError("names[0]", "error.one.active.item.required", new String[]{"name"});
                valid = false;
            }
            return valid;
        }
        GlobalVariables.getMessageMap().putError("names[0]", "error.one.item.required", new String[]{"name"});
        valid = false;
        return valid;
    }

    protected boolean doesPrincipalNameExist(String principalName, String principalId) {
        Principal principal = this.getIdentityService().getPrincipalByPrincipalName(principalName);
        if (principal != null && (StringUtils.isBlank((String)principalId) || !principal.getPrincipalId().equals(principalId))) {
            GlobalVariables.getMessageMap().putError("principalName", "error.exist.principalName", new String[]{principalName});
            return false;
        }
        return true;
    }

    protected boolean validateRoleQualifier(List<PersonDocumentRole> roles) {
        ArrayList<RemotableAttributeError> validationErrors = new ArrayList<RemotableAttributeError>();
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        int i = 0;
        for (PersonDocumentRole role : roles) {
            KimTypeService kimTypeService = KimFrameworkServiceLocator.getKimTypeService((KimType)KimTypeBo.to((KimTypeBo)role.getKimRoleType()));
            if (CollectionUtils.isEmpty(role.getRolePrncpls()) && !role.getDefinitions().isEmpty()) {
                KimType kimTypeInfo = KimApiServiceLocator.getKimTypeInfoService().getKimType(role.getKimRoleType().getId());
                Map<String, String> blankQualifiers = this.attributeValidationHelper.getBlankValueQualifiersMap(kimTypeInfo.getAttributeDefinitions());
                List localErrors = kimTypeService.validateAttributes(role.getKimRoleType().getId(), blankQualifiers);
                if (localErrors != null && !localErrors.isEmpty()) {
                    GlobalVariables.getMessageMap().putError("document.roles[" + i + "].newRolePrncpl.qualifiers[0].attrVal", "error.one.item.required", new String[]{"Role Qualifier"});
                    return false;
                }
            }
            List<KimAttributeField> attributeDefinitions = role.getDefinitions();
            Set<String> uniqueQualifierAttributes = this.findUniqueQualificationAttributes(role, attributeDefinitions);
            if (kimTypeService != null) {
                int j = 0;
                for (KimDocumentRoleMember rolePrincipal : this.activeRoleMemberHelper.getActiveRoleMembers(role.getRolePrncpls())) {
                    List localErrors = kimTypeService.validateAttributes(role.getKimRoleType().getId(), this.attributeValidationHelper.convertQualifiersToMap(rolePrincipal.getQualifiers()));
                    validationErrors.addAll(this.attributeValidationHelper.convertErrors("roles[" + i + "].rolePrncpls[" + j + "]", this.attributeValidationHelper.convertQualifiersToAttrIdxMap(rolePrincipal.getQualifiers()), localErrors));
                    if (uniqueQualifierAttributes.size() > 0) {
                        this.validateUniquePersonRoleQualifiersUniqueForMembership(role, rolePrincipal, j, uniqueQualifierAttributes, i, validationErrors);
                    }
                    ++j;
                }
            }
            ++i;
        }
        GlobalVariables.getMessageMap().addToErrorPath("document");
        if (validationErrors.isEmpty()) {
            return true;
        }
        this.attributeValidationHelper.moveValidationErrorsToErrorMap(validationErrors);
        return false;
    }

    protected boolean validateUniquePersonRoleQualifiersUniqueForMembership(PersonDocumentRole role, KimDocumentRoleMember membershipToCheck, int membershipToCheckIndex, Set<String> uniqueQualifierAttributes, int roleIndex, List<RemotableAttributeError> validationErrors) {
        boolean foundError = false;
        int count = 0;
        for (KimDocumentRoleMember membership : role.getRolePrncpls()) {
            if (!this.sameMembershipQualifications(membershipToCheck, membership, uniqueQualifierAttributes)) continue;
            if (count == 0) {
                ++count;
                continue;
            }
            ++count;
            foundError = true;
            int qualifierCount = 0;
            for (KimDocumentRoleQualifier qualifier : membership.getQualifiers()) {
                if (qualifier != null && uniqueQualifierAttributes.contains(qualifier.getKimAttrDefnId())) {
                    validationErrors.add(RemotableAttributeError.Builder.create((String)("document.roles[" + roleIndex + "].rolePrncpls[" + membershipToCheckIndex + "].qualifiers[" + qualifierCount + "].attrVal"), (String[])new String[]{"error.document.identityManagementPerson.qualifier.valueNotUnique:" + qualifier.getKimAttribute().getAttributeName() + ";" + qualifier.getAttrVal()}).build());
                }
                ++qualifierCount;
            }
        }
        return foundError;
    }

    protected boolean sameMembershipQualifications(KimDocumentRoleMember membershipA, KimDocumentRoleMember membershipB, Set<String> uniqueQualifierAttributes) {
        boolean equalSoFar = true;
        for (String uniqueQualifierAttributeDefinitionId : uniqueQualifierAttributes) {
            KimDocumentRoleQualifier qualifierA = membershipA.getQualifier(uniqueQualifierAttributeDefinitionId);
            KimDocumentRoleQualifier qualifierB = membershipB.getQualifier(uniqueQualifierAttributeDefinitionId);
            if (qualifierA == null || qualifierB == null) continue;
            equalSoFar &= qualifierA.getAttrVal() == null && qualifierB.getAttrVal() == null || qualifierA.getAttrVal() == null || qualifierA.getAttrVal().equals(qualifierB.getAttrVal());
        }
        return equalSoFar;
    }

    public Set<String> findUniqueQualificationAttributes(PersonDocumentRole role, List<KimAttributeField> attributeDefinitions) {
        HashSet<String> uniqueQualifications = new HashSet<String>();
        if (role.getRolePrncpls() != null && role.getRolePrncpls().size() > 1) {
            KimDocumentRoleMember membership = role.getRolePrncpls().get(0);
            for (KimDocumentRoleQualifier qualifier : membership.getQualifiers()) {
                KimAttributeField relatedDefinition;
                if (qualifier == null || qualifier.getKimAttribute() == null || StringUtils.isBlank((String)qualifier.getKimAttribute().getAttributeName()) || (relatedDefinition = DataDictionaryTypeServiceHelper.findAttributeField((String)qualifier.getKimAttribute().getAttributeName(), attributeDefinitions)) == null || !relatedDefinition.isUnique()) continue;
                uniqueQualifications.add(qualifier.getKimAttrDefnId());
            }
        }
        return uniqueQualifications;
    }

    protected boolean validActiveDatesForRole(List<PersonDocumentRole> roles) {
        boolean valid = true;
        int i = 0;
        for (PersonDocumentRole role : roles) {
            int j = 0;
            for (KimDocumentRoleMember principal : role.getRolePrncpls()) {
                valid &= this.validateActiveDate("roles[" + i + "].rolePrncpls[" + j + "].activeToDate", principal.getActiveFromDate(), principal.getActiveToDate());
                ++j;
            }
            ++i;
        }
        return valid;
    }

    protected boolean validActiveDatesForGroup(List<PersonDocumentGroup> groups) {
        boolean valid = true;
        int i = 0;
        for (PersonDocumentGroup group : groups) {
            valid &= this.validateActiveDate("groups[" + i + "].activeToDate", group.getActiveFromDate(), group.getActiveToDate());
            ++i;
        }
        return valid;
    }

    protected boolean validActiveDatesForDelegations(List<RoleDocumentDelegationMember> delegationMembers) {
        boolean valid = true;
        int i = 0;
        for (RoleDocumentDelegationMember delegationMember : delegationMembers) {
            valid &= this.validateActiveDate("delegationMembers[" + i + "].activeToDate", delegationMember.getActiveFromDate(), delegationMember.getActiveToDate());
            ++i;
        }
        return valid;
    }

    protected boolean validateActiveDate(String errorPath, Timestamp activeFromDate, Timestamp activeToDate) {
        boolean valid = true;
        if (activeFromDate != null && activeToDate != null && activeToDate.before(activeFromDate)) {
            GlobalVariables.getMessageMap().putError(errorPath, "error.active.todate.before.fromdate", new String[0]);
            valid = false;
        }
        return valid;
    }

    @Override
    public boolean processAddGroup(AddGroupEvent addGroupEvent) {
        return this.getAddGroupRule().processAddGroup(addGroupEvent);
    }

    @Override
    public boolean processAddRole(AddRoleEvent addRoleEvent) {
        return this.getAddRoleRule().processAddRole(addRoleEvent);
    }

    @Override
    public boolean processAddPersonDelegationMember(AddPersonDelegationMemberEvent addPersonDelegationMemberEvent) {
        return this.getAddPersonDelegationMemberRule().processAddPersonDelegationMember(addPersonDelegationMemberEvent);
    }

    protected IdentityService getIdentityService() {
        if (this.identityService == null) {
            this.identityService = KimApiServiceLocator.getIdentityService();
        }
        return this.identityService;
    }

    protected RoleService getRoleService() {
        if (this.roleService == null) {
            this.roleService = KimApiServiceLocator.getRoleService();
        }
        return this.roleService;
    }

    protected IdentityManagementKimDocumentAuthorizer getAuthorizer(IdentityManagementPersonDocument document) {
        if (this.authorizer == null) {
            this.authorizer = (IdentityManagementKimDocumentAuthorizer)KRADServiceLocatorWeb.getDocumentDictionaryService().getDocumentAuthorizer((Document)document);
        }
        return this.authorizer;
    }

    public Class<? extends AddGroupRule> getAddGroupRuleClass() {
        return this.addGroupRuleClass;
    }

    public void setAddGroupRuleClass(Class<? extends AddGroupRule> addGroupRuleClass) {
        this.addGroupRuleClass = addGroupRuleClass;
    }

    public Class<? extends AddRoleRule> getAddRoleRuleClass() {
        return this.addRoleRuleClass;
    }

    public void setAddRoleRuleClass(Class<? extends AddRoleRule> addRoleRuleClass) {
        this.addRoleRuleClass = addRoleRuleClass;
    }

    public AddGroupRule getAddGroupRule() {
        if (this.addGroupRule == null) {
            try {
                this.addGroupRule = this.addGroupRuleClass.newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to create AddGroupRule instance using class: " + this.addGroupRuleClass, ex);
            }
        }
        return this.addGroupRule;
    }

    public AddRoleRule getAddRoleRule() {
        if (this.addRoleRule == null) {
            try {
                this.addRoleRule = this.addRoleRuleClass.newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to create AddRoleRule instance using class: " + this.addRoleRuleClass, ex);
            }
        }
        return this.addRoleRule;
    }

    public AddPersonDelegationMemberRule getAddPersonDelegationMemberRule() {
        if (this.addPersonDelegationMemberRule == null) {
            try {
                this.addPersonDelegationMemberRule = this.addPersonDelegationMemberRuleClass.newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to create AddPersonDelegationMemberRuleClass instance using class: " + this.addPersonDelegationMemberRuleClass, ex);
            }
        }
        return this.addPersonDelegationMemberRule;
    }

    @Override
    public boolean processAddPersonDocumentRoleQualifier(IdentityManagementPersonDocument document, PersonDocumentRole role, KimDocumentRoleMember kimDocumentRoleMember, int selectedRoleIdx) {
        boolean dateValidationSuccess = this.validateActiveDate("document.roles[" + selectedRoleIdx + "].newRolePrncpl.activeFromDate", kimDocumentRoleMember.getActiveFromDate(), kimDocumentRoleMember.getActiveToDate());
        String errorPath = "roles[" + selectedRoleIdx + "].newRolePrncpl";
        ArrayList<RemotableAttributeError> validationErrors = new ArrayList<RemotableAttributeError>();
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        KimTypeService kimTypeService = KimFrameworkServiceLocator.getKimTypeService((KimType)KimTypeBo.to((KimTypeBo)role.getKimRoleType()));
        boolean rulePassed = true;
        Map<String, String> newMemberQualifiers = this.attributeValidationHelper.convertQualifiersToMap(kimDocumentRoleMember.getQualifiers());
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add(role.getRoleId());
        for (KimDocumentRoleMember member : role.getRolePrncpls()) {
            Map<String, String> oldMemberQualifiers = member.getQualifierAsMap();
            List errorsAttributesAgainstExisting = kimTypeService.validateUniqueAttributes(role.getKimRoleType().getId(), newMemberQualifiers, oldMemberQualifiers);
            validationErrors.addAll(this.attributeValidationHelper.convertErrors(errorPath, this.attributeValidationHelper.convertQualifiersToAttrIdxMap(kimDocumentRoleMember.getQualifiers()), errorsAttributesAgainstExisting));
        }
        if (kimTypeService != null) {
            List localErrors = kimTypeService.validateAttributes(role.getKimRoleType().getId(), newMemberQualifiers);
            validationErrors.addAll(this.attributeValidationHelper.convertErrors(errorPath, this.attributeValidationHelper.convertQualifiersToAttrIdxMap(kimDocumentRoleMember.getQualifiers()), localErrors));
        }
        GlobalVariables.getMessageMap().addToErrorPath("document");
        if (validationErrors.isEmpty()) {
            rulePassed = dateValidationSuccess;
        } else {
            this.attributeValidationHelper.moveValidationErrorsToErrorMap(validationErrors);
            rulePassed = false;
        }
        return rulePassed;
    }

    protected boolean validateDelegationMemberRoleQualifier(List<RoleDocumentDelegationMember> delegationMembers) {
        ArrayList<RemotableAttributeError> validationErrors = new ArrayList<RemotableAttributeError>();
        boolean valid = false;
        int memberCounter = 0;
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        for (RoleDocumentDelegationMember delegationMember : delegationMembers) {
            KimType kimType = KimTypeBo.to((KimTypeBo)delegationMember.getRoleBo().getKimRoleType());
            KimTypeService kimTypeService = KimFrameworkServiceLocator.getKimTypeService((KimType)kimType);
            String errorPath = "delegationMembers[" + memberCounter + "]";
            Map<String, String> mapToValidate = this.attributeValidationHelper.convertQualifiersToMap(delegationMember.getQualifiers());
            List errorsTemp = kimTypeService.validateAttributes(kimType.getId(), mapToValidate);
            validationErrors.addAll(this.attributeValidationHelper.convertErrors(errorPath, this.attributeValidationHelper.convertQualifiersToAttrIdxMap(delegationMember.getQualifiers()), errorsTemp));
            List roleMembers = this.getRoleService().findRoleMembers(QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)"id", (Object)delegationMember.getRoleMemberId())})).getResults();
            if (roleMembers.isEmpty()) {
                valid = false;
                GlobalVariables.getMessageMap().putError("document." + errorPath, "error.delegation.notassociatedwith.rolemember", new String[0]);
            } else {
                kimTypeService.validateUnmodifiableAttributes(kimType.getId(), ((RoleMember)roleMembers.get(0)).getAttributes(), mapToValidate);
                validationErrors.addAll(this.attributeValidationHelper.convertErrors(errorPath, this.attributeValidationHelper.convertQualifiersToAttrIdxMap(delegationMember.getQualifiers()), errorsTemp));
            }
            ++memberCounter;
        }
        GlobalVariables.getMessageMap().addToErrorPath("document");
        if (validationErrors.isEmpty()) {
            valid = true;
        } else {
            this.attributeValidationHelper.moveValidationErrorsToErrorMap(validationErrors);
            valid = false;
        }
        return valid;
    }

    public boolean canModifyEntity(String currentUserPrincipalId, String toModifyPrincipalId) {
        return StringUtils.isNotBlank((String)currentUserPrincipalId) && StringUtils.isNotBlank((String)toModifyPrincipalId) && currentUserPrincipalId.equals(toModifyPrincipalId) || IdentityManagementPersonDocumentRule.getPermissionService().isAuthorized(currentUserPrincipalId, "KR-IDM", "Modify Entity", Collections.singletonMap("principalId", currentUserPrincipalId));
    }

    public boolean canOverrideEntityPrivacyPreferences(String currentUserPrincipalId, String toModifyPrincipalId) {
        return StringUtils.isNotBlank((String)currentUserPrincipalId) && StringUtils.isNotBlank((String)toModifyPrincipalId) && currentUserPrincipalId.equals(toModifyPrincipalId) || IdentityManagementPersonDocumentRule.getPermissionService().isAuthorized(currentUserPrincipalId, "KR-IDM", "Override Entity Privacy Preferences", Collections.singletonMap("principalId", currentUserPrincipalId));
    }
}

