-- namespaces & parameters

INSERT INTO KRCR_NMSPC_T (APPL_ID , NMSPC_CD , NM , ACTV_IND , OBJ_ID , VER_NBR)
VALUES ('KC','KC-EXCON','Kuali Coeus Export Control Module','Y',UUID(),'1');

insert into krcr_cmpnt_t (NMSPC_CD, CMPNT_CD, NM, ACTV_IND, OBJ_ID, VER_NBR) VALUES ('KC-EXCON', 'All', 'All', 'Y', UUID(), 1);
insert into krcr_cmpnt_t (NMSPC_CD, CMPNT_CD, NM, ACTV_IND, OBJ_ID, VER_NBR) VALUES ('KC-EXCON', 'Document', 'Document', 'Y', UUID(), 1);

UPDATE KRCR_PARM_T SET val = concat(val,';ECPJ=Export Control Project')
WHERE NMSPC_CD = 'KC-GEN' AND PARM_NM = 'customAttributeDocumentType' AND val not like '%;ECPJ%';

insert into krcr_parm_t (appl_id, nmspc_cd, cmpnt_cd, parm_nm, parm_typ_cd, val, parm_desc_txt, eval_oprtr_cd, obj_id, ver_nbr)
values ('KC', 'KC-GEN', 'All', 'EXCON_CUSTOM_ATTRIBUTE_LIST', 'CONFG', '',
        'Semicolon separated list of Custom Attribute IDs associated with the Export Control Y/N questions.', 'A', UUID(), 1 );

-- kim attributes

INSERT INTO KRIM_ATTR_DEFN_T ( KIM_ATTR_DEFN_ID, NMSPC_CD, NM, ACTV_IND, LBL, CMPNT_NM, OBJ_ID, VER_NBR )
VALUES ('RESBOOT-1000', 'KC-EXCON', 'projectTypeCode', 'Y', 'Project Type Code', null, UUID(), 1);

-- kim types

INSERT INTO KRIM_TYP_T ( KIM_TYP_ID, NMSPC_CD, NM, SRVC_NM, ACTV_IND, OBJ_ID, VER_NBR )
VALUES ('RESBOOT-1003', 'KC-EXCON', 'ProjectType', null, 'Y', UUID(), 1);

INSERT INTO KRIM_TYP_ATTR_T ( KIM_TYP_ATTR_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ACTV_IND, SORT_CD, OBJ_ID, VER_NBR )
VALUES ('RESBOOT-1000', 'RESBOOT-1003', 'RESBOOT-1000', 'Y', 'A', UUID(), 1);

-- kim groups

INSERT INTO KRIM_GRP_T ( GRP_ID, OBJ_ID, VER_NBR, GRP_NM, NMSPC_CD, GRP_DESC, KIM_TYP_ID, ACTV_IND, LAST_UPDT_DT )
VALUES
( 'RESBOOT-2003',  UUID(), 1, 'Export Control Project Approvers', 'KC-WKFLW', 'Approvers of Export Control Projects',
  (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NM = 'Default' AND NMSPC_CD='KUALI'), 'Y', NOW());

-- kim permissions

INSERT INTO KRIM_PERM_T (PERM_ID, PERM_TMPL_ID, NMSPC_CD, NM, DESC_TXT, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1012',
        (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Initiate Document'),
        'KC-EXCON','Create Project Document','Create a new Export Control Project Document','Y',UUID(),'1');

INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1010','RESBOOT-1012',
        (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND nm = 'Document Type (Permission)'),
        (SELECT KIM_ATTR_DEFN_ID FROM krim_attr_defn_t WHERE nmspc_cd = 'KR-WKFLW' AND nm = 'documentTypeName'),
        'ExconProjectDocument',UUID(),'1');

INSERT INTO KRIM_PERM_T (PERM_ID, PERM_TMPL_ID, NMSPC_CD, NM, DESC_TXT, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1013',
        (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'Open Document'),
        'KC-EXCON','Open Project Document','Open an Export Control Project Document','Y',UUID(),'1');

INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1011','RESBOOT-1013',
        (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND nm = 'Document Type (Permission)'),
        (SELECT KIM_ATTR_DEFN_ID FROM krim_attr_defn_t WHERE nmspc_cd = 'KR-WKFLW' AND nm = 'documentTypeName'),
        'ExconProjectDocument',UUID(),'1');

INSERT INTO KRIM_PERM_T (PERM_ID, PERM_TMPL_ID, NMSPC_CD, NM, DESC_TXT, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1014',
        (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'Edit Document'),
        'KC-EXCON','Modify Project Document','Modify an Export Control Project Document','Y',UUID(),'1');

INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1012','RESBOOT-1014',
        (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND nm = 'Document Type (Permission)'),
        (SELECT KIM_ATTR_DEFN_ID FROM krim_attr_defn_t WHERE nmspc_cd = 'KR-WKFLW' AND nm = 'documentTypeName'),
        'ExconProjectDocument',UUID(),'1');

INSERT INTO KRIM_PERM_T (PERM_ID, PERM_TMPL_ID, NMSPC_CD, NM, DESC_TXT, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1015',
        (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-IDM' AND NM = 'View Document Section'),
        'KC-EXCON','View Project Document','View an Export Control Project Document','Y',UUID(),'1');

INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1013','RESBOOT-1015',
        (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND nm = 'Document Type (Permission)'),
        (SELECT KIM_ATTR_DEFN_ID FROM krim_attr_defn_t WHERE nmspc_cd = 'KR-WKFLW' AND nm = 'documentTypeName'),
        'ExconProjectDocument',UUID(),'1');

INSERT INTO KRIM_PERM_T (PERM_ID, PERM_TMPL_ID, NMSPC_CD, NM, DESC_TXT, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1016',
        (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'Save Document'),
        'KC-EXCON','Save Project Document','Save an Export Control Project Document','Y',UUID(),'1');

INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1014','RESBOOT-1016',
        (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND nm = 'Document Type (Permission)'),
        (SELECT KIM_ATTR_DEFN_ID FROM krim_attr_defn_t WHERE nmspc_cd = 'KR-WKFLW' AND nm = 'documentTypeName'),
        'ExconProjectDocument',UUID(),'1');

INSERT INTO KRIM_PERM_T (PERM_ID, PERM_TMPL_ID, NMSPC_CD, NM, DESC_TXT, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1017',
        (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'Route Document'),
        'KC-EXCON','Submit Project Document','Submit an Export Control Project Document','Y',UUID(),'1');

INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1015','RESBOOT-1017',
        (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND nm = 'Document Type (Permission)'),
        (SELECT KIM_ATTR_DEFN_ID FROM krim_attr_defn_t WHERE nmspc_cd = 'KR-WKFLW' AND nm = 'documentTypeName'),
        'ExconProjectDocument',UUID(),'1');

INSERT INTO KRIM_PERM_T (PERM_ID, PERM_TMPL_ID, NMSPC_CD, NM, DESC_TXT, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1018',
        (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'Cancel Document'),
        'KC-EXCON','Cancel Project Document','Cancel an Export Control Project Document','Y',UUID(),'1');

INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1016','RESBOOT-1018',
        (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND nm = 'Document Type (Permission)'),
        (SELECT KIM_ATTR_DEFN_ID FROM krim_attr_defn_t WHERE nmspc_cd = 'KR-WKFLW' AND nm = 'documentTypeName'),
        'ExconProjectDocument',UUID(),'1');

INSERT INTO KRIM_PERM_T (PERM_ID, PERM_TMPL_ID, NMSPC_CD, NM, DESC_TXT, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1019',
        (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Initiate Document'),
        'KC-EXCON','Create Maintenance Document','Create a new Export Control Maintenance Document','Y',UUID(),'1');

INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1017','RESBOOT-1019',
        (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND nm = 'Document Type (Permission)'),
        (SELECT KIM_ATTR_DEFN_ID FROM krim_attr_defn_t WHERE nmspc_cd = 'KR-WKFLW' AND nm = 'documentTypeName'),
        'KcExconMaintenanceDocument',UUID(),'1');

INSERT INTO KRIM_PERM_T (PERM_ID, PERM_TMPL_ID, NMSPC_CD, NM, DESC_TXT, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1020',
        (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'Save Document'),
        'KC-EXCON','Save Maintenance Document','Save an Export Control Maintenance Document','Y',UUID(),'1');

INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1018','RESBOOT-1020',
        (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND nm = 'Document Type & Routing Node or State'),
        (SELECT KIM_ATTR_DEFN_ID FROM krim_attr_defn_t WHERE nmspc_cd = 'KR-WKFLW' AND nm = 'documentTypeName'),
        'KcExconMaintenanceDocument',UUID(),'1');

INSERT INTO KRIM_PERM_T (PERM_ID, PERM_TMPL_ID, NMSPC_CD, NM, DESC_TXT, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1021',
        (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KC-IDM' and NM = 'Edit Document Section'),
        'KC-EXCON','Edit HR Custom Data','Allows person to edit the HR Custom Data panel','Y',UUID(),'1');

INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1019', 'RESBOOT-1021',
        (SELECT kim_typ_id FROM krim_typ_t WHERE nmspc_cd = 'KC-SYS' AND nm = 'Document Section'),
        (SELECT kim_attr_defn_id FROM krim_attr_defn_t WHERE nmspc_cd = 'KR-WKFLW' AND nm = 'documentTypeName'),
        'ExconProjectDocument', UUID(), '1');

INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1020', 'RESBOOT-1021',
        (SELECT kim_typ_id FROM krim_typ_t WHERE nmspc_cd = 'KC-SYS' AND nm = 'Document Section'),
        (select kim_attr_defn_id from krim_attr_defn_t where nmspc_cd = 'KC-SYS' and nm = 'sectionName'),
        'hrCustomData', UUID(), '1');

INSERT INTO KRIM_PERM_T (PERM_ID, PERM_TMPL_ID, NMSPC_CD, NM, DESC_TXT, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1022',
        (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'Ad Hoc Review Document'),
        'KC-EXCON','Complete Project Document','Complete a new Export Control Project Document','Y',UUID(),'1');

INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1021','RESBOOT-1022',
        (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-WKFLW' AND nm = 'Ad Hoc Review'),
        (SELECT KIM_ATTR_DEFN_ID FROM krim_attr_defn_t WHERE nmspc_cd = 'KR-WKFLW' AND nm = 'actionRequestCd'),
        'C',UUID(),'1');

INSERT INTO KRIM_PERM_ATTR_DATA_T (ATTR_DATA_ID, PERM_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1022','RESBOOT-1022',
        (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-WKFLW' AND nm = 'Ad Hoc Review'),
        (SELECT KIM_ATTR_DEFN_ID FROM krim_attr_defn_t WHERE nmspc_cd = 'KR-WKFLW' AND nm = 'documentTypeName'),
        'ExconProjectDocument',UUID(),'1');

-- kim roles

INSERT INTO KRIM_ROLE_T (ROLE_ID, NMSPC_CD, ROLE_NM, KIM_TYP_ID, DESC_TXT, ACTV_IND, OBJ_ID, VER_NBR )
VALUES ('RESBOOT-1003','KC-EXCON','Export Control Administrator',
        (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KUALI' AND nm = 'Default'),
        'Export Control Administrator','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_T (ROLE_ID, NMSPC_CD, ROLE_NM, KIM_TYP_ID, DESC_TXT, OBJ_ID, VER_NBR )
VALUES ('RESBOOT-1004','KC-EXCON','Export Control Project Coordinator',
        (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KUALI' AND nm = 'Default'),
        'Export Control Project Coordinator',UUID(),'1');

INSERT INTO KRIM_ROLE_T (ROLE_ID, NMSPC_CD, ROLE_NM, KIM_TYP_ID, DESC_TXT, ACTV_IND, OBJ_ID, VER_NBR )
VALUES ('RESBOOT-1005','KC-EXCON','Export Control Project Maintainer','RESBOOT-1003',
        'Allow person to maintain only qualified types of project documents.','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_T (ROLE_ID, NMSPC_CD, ROLE_NM, KIM_TYP_ID, DESC_TXT, ACTV_IND, OBJ_ID, VER_NBR )
VALUES ('RESBOOT-1006','KC-EXCON','Export Control HR Project Maintainer',
        (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KUALI' AND nm = 'Default'),
        'Allow person to maintain only qualified types of project documents and HR custom data.','Y',UUID(),'1');

-- kim role perm assignment

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, ROLE_ID, PERM_ID, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1013','RESBOOT-1003','RESBOOT-1012','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, ROLE_ID, PERM_ID, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1014','RESBOOT-1003','RESBOOT-1013','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, ROLE_ID, PERM_ID, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1015','RESBOOT-1003','RESBOOT-1014','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, ROLE_ID, PERM_ID, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1016','RESBOOT-1003','RESBOOT-1015','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, ROLE_ID, PERM_ID, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1017','RESBOOT-1003','RESBOOT-1016','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, ROLE_ID, PERM_ID, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1018','RESBOOT-1003','RESBOOT-1017','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, ROLE_ID, PERM_ID, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1019','RESBOOT-1003','RESBOOT-1018','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, ROLE_ID, PERM_ID, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1020','RESBOOT-1003','RESBOOT-1019','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, ROLE_ID, PERM_ID, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1021','RESBOOT-1003','RESBOOT-1020','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, ROLE_ID, PERM_ID, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1022','RESBOOT-1004','RESBOOT-1012','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, ROLE_ID, PERM_ID, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1023','RESBOOT-1004','RESBOOT-1013','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, ROLE_ID, PERM_ID, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1024','RESBOOT-1004','RESBOOT-1014','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, ROLE_ID, PERM_ID, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1025','RESBOOT-1004','RESBOOT-1015','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, ROLE_ID, PERM_ID, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1026','RESBOOT-1004','RESBOOT-1016','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, ROLE_ID, PERM_ID, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1027','RESBOOT-1004','RESBOOT-1017','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, ROLE_ID, PERM_ID, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1028','RESBOOT-1004','RESBOOT-1018','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, ROLE_ID, PERM_ID, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1029','RESBOOT-1004','RESBOOT-1019','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, ROLE_ID, PERM_ID, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1030','RESBOOT-1004','RESBOOT-1020','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, ROLE_ID, PERM_ID, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1031','RESBOOT-1005','RESBOOT-1012','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, ROLE_ID, PERM_ID, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1032','RESBOOT-1005','RESBOOT-1013','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, ROLE_ID, PERM_ID, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1033','RESBOOT-1005','RESBOOT-1014','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, ROLE_ID, PERM_ID, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1034','RESBOOT-1005','RESBOOT-1015','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, ROLE_ID, PERM_ID, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1035','RESBOOT-1005','RESBOOT-1016','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, ROLE_ID, PERM_ID, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1036','RESBOOT-1005','RESBOOT-1017','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, ROLE_ID, PERM_ID, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1037','RESBOOT-1005','RESBOOT-1018','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, ROLE_ID, PERM_ID, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1038','RESBOOT-1006','RESBOOT-1021','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, ROLE_ID, PERM_ID, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1039','RESBOOT-1003','RESBOOT-1022','Y',UUID(),'1');

INSERT INTO KRIM_ROLE_PERM_T (ROLE_PERM_ID, ROLE_ID, PERM_ID, ACTV_IND, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1040','RESBOOT-1004','RESBOOT-1022','Y',UUID(),'1');

-- kim role member assignment

INSERT INTO KRIM_ROLE_MBR_T (ROLE_MBR_ID, ROLE_ID, MBR_TYP_CD, MBR_ID, LAST_UPDT_DT, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1000', 'RESBOOT-1005', 'R','RESBOOT-1006', NOW(), UUID(),'1');

INSERT INTO KRIM_ROLE_MBR_ATTR_DATA_T (ATTR_DATA_ID, ROLE_MBR_ID, KIM_TYP_ID, KIM_ATTR_DEFN_ID, ATTR_VAL, OBJ_ID, VER_NBR)
VALUES ('RESBOOT-1000','RESBOOT-1000', 'RESBOOT-1003', 'RESBOOT-1000', 'RPS', UUID(),'1');
