CREATE TABLE EXCON_PROJECT_DOCUMENT  (
  DOCUMENT_NUMBER     VARCHAR2(40) NOT NULL,
  VER_NBR             NUMBER(8,0) DEFAULT 1 NOT NULL,
  OBJ_ID              VARCHAR2(36) NOT NULL,
  UPDATE_TIMESTAMP    DATE NOT NULL,
  UPDATE_USER         VARCHAR2(60) NOT NULL);
ALTER TABLE EXCON_PROJECT_DOCUMENT
ADD CONSTRAINT EXCON_PROJECT_DOCUMENTP1
PRIMARY KEY (DOCUMENT_NUMBER);

ALTER TABLE EXCON_PROJECT_DOCUMENT
    ADD CONSTRAINT EXCON_PROJECT_DOCUMENTUQ1
        UNIQUE(OBJ_ID);

CREATE TABLE EXCON_PROJECT_TYPE
(
    PROJECT_TYPE_CODE     VARCHAR2(3) NOT NULL,
    DESCRIPTION           VARCHAR2(300) NOT NULL,
    UPDATE_TIMESTAMP      DATE NOT NULL,
    UPDATE_USER           VARCHAR2(60) NOT NULL,
    OBJ_ID                VARCHAR2(36) NOT NULL,
    VER_NBR               NUMBER(8) DEFAULT 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_TYPE
    ADD CONSTRAINT EXCON_PROJECT_TYPEP1
        PRIMARY KEY (PROJECT_TYPE_CODE);

ALTER TABLE EXCON_PROJECT_TYPE
    ADD CONSTRAINT EXCON_PROJECT_TYPEUQ1
        UNIQUE(OBJ_ID);

CREATE TABLE EXCON_PROJECT_STATUS_TYPE
(
    STATUS_TYPE_CODE      VARCHAR2(3) NOT NULL,
    DESCRIPTION           VARCHAR2(300) NOT NULL,
    UPDATE_TIMESTAMP      DATE NOT NULL,
    UPDATE_USER           VARCHAR2(60) NOT NULL,
    OBJ_ID                VARCHAR2(36) NOT NULL,
    VER_NBR               NUMBER(8) DEFAULT 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_STATUS_TYPE
    ADD CONSTRAINT EXCON_PROJECT_STATUS_TYPEP1
        PRIMARY KEY (STATUS_TYPE_CODE);

ALTER TABLE EXCON_PROJECT_STATUS_TYPE
    ADD CONSTRAINT EXCON_PROJECT_STATUS_TYPEUQ1
        UNIQUE(OBJ_ID);

CREATE TABLE EXCON_PROJECT
(
  PROJECT_ID            NUMBER(22) NOT NULL,
  PROJECT_NUMBER        VARCHAR2(12) NOT NULL,
  SEQUENCE_NUMBER       NUMBER(4) DEFAULT 1,
  DOCUMENT_NUMBER       VARCHAR2(40) NOT NULL,
  PROJECT_TITLE         VARCHAR2(100) NOT NULL,
  PROJECT_TYPE_CODE     VARCHAR2(3) NOT NULL,
  LEAD_UNIT_NUMBER      VARCHAR2(8),
  SPONSOR_CODE          VARCHAR2(6),
  FUNDMNTL_RESEARCH_IND VARCHAR2(1),
  PROJECT_START_DATE    DATE,
  PROJECT_END_DATE      DATE,
  PROJECT_STATUS_CODE   VARCHAR2(3) NOT NULL,
  PROJECT_SEQUENCE_STATUS VARCHAR2(10),
  agreement_role        char(1),
  responsible_party     varchar2(40),
  international_ind     varchar2(1),
  classified_ind        varchar2(1),
  restriction_ind       varchar2(1),
  UPDATE_TIMESTAMP      DATE NOT NULL,
  UPDATE_USER           VARCHAR2(60) NOT NULL,
  OBJ_ID                VARCHAR2(36) NOT NULL,
  VER_NBR               NUMBER(8) DEFAULT 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT
    ADD CONSTRAINT EXCON_PROJECTP1
PRIMARY KEY (PROJECT_ID);

ALTER TABLE EXCON_PROJECT
    ADD CONSTRAINT EXCON_PROJECTUQ1
        UNIQUE(OBJ_ID);

ALTER TABLE EXCON_PROJECT
    ADD CONSTRAINT EXCON_PROJECTUQ2
        UNIQUE(PROJECT_NUMBER, SEQUENCE_NUMBER);

ALTER TABLE EXCON_PROJECT
    ADD CONSTRAINT EXCON_PROJECTFK1
        FOREIGN KEY (PROJECT_TYPE_CODE)
            REFERENCES EXCON_PROJECT_TYPE (PROJECT_TYPE_CODE);

ALTER TABLE EXCON_PROJECT
    ADD CONSTRAINT EXCON_PROJECTFK2
        FOREIGN KEY (PROJECT_STATUS_CODE)
            REFERENCES EXCON_PROJECT_STATUS_TYPE (STATUS_TYPE_CODE);

ALTER TABLE EXCON_PROJECT
    ADD CONSTRAINT EXCON_PROJECTFK3
        FOREIGN KEY (SPONSOR_CODE)
            REFERENCES SPONSOR (SPONSOR_CODE);

ALTER TABLE EXCON_PROJECT
    ADD CONSTRAINT EXCON_PROJECTFK4
        FOREIGN KEY (LEAD_UNIT_NUMBER)
            REFERENCES UNIT (UNIT_NUMBER);

CREATE SEQUENCE EXCON_PROJECT_S INCREMENT BY 1 START WITH 1 NOCACHE;
CREATE SEQUENCE EXCON_PROJECT_NUMBER_S INCREMENT BY 1 START WITH 1 NOCACHE;

CREATE TABLE EXCON_PROJECT_PERSON_ROLE_TYPE
(
    PROJECT_PERSON_ROLE_TYPE_CODE VARCHAR2(3) NOT NULL,
    DESCRIPTION                   VARCHAR2(300) NOT NULL,
    UPDATE_TIMESTAMP              DATE NOT NULL,
    UPDATE_USER                   VARCHAR2(60) NOT NULL,
    OBJ_ID                        VARCHAR2(36) NOT NULL,
    VER_NBR                       NUMBER(8) DEFAULT 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_PERSON_ROLE_TYPE
    ADD CONSTRAINT EXCON_PROJECT_PERSON_RTP1
        PRIMARY KEY (PROJECT_PERSON_ROLE_TYPE_CODE);

ALTER TABLE EXCON_PROJECT_PERSON_ROLE_TYPE
    ADD CONSTRAINT EXCON_PROJECT_PERSON_RTUQ1
        UNIQUE(OBJ_ID);

CREATE TABLE EXCON_PROJECT_PERSONS
(
  PROJECT_PERSON_ID     NUMBER(22) NOT NULL,
  PERSON_ID             VARCHAR2(40) NOT NULL,
  ROLODEX_ID            NUMBER(6),
  FULL_NAME             VARCHAR2(90) NOT NULL,
  PERSON_ROLE_TYPE_CODE VARCHAR2(12) NOT NULL,
  PROJECT_ID            NUMBER(22) NOT NULL,
  PROJECT_NUMBER        VARCHAR2(12) NOT NULL,
  SEQUENCE_NUMBER       NUMBER(4) DEFAULT 1,
  UPDATE_TIMESTAMP      DATE NOT NULL,
  UPDATE_USER           VARCHAR2(60) NOT NULL,
  OBJ_ID                VARCHAR2(36) NOT NULL,
  VER_NBR               NUMBER(8) DEFAULT 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_PERSONS
  ADD CONSTRAINT EXCON_PROJECT_PERSONSP1
  PRIMARY KEY (PROJECT_PERSON_ID);

ALTER TABLE EXCON_PROJECT_PERSONS
    ADD CONSTRAINT EXCON_PROJECT_PERSONSUQ1
        UNIQUE(OBJ_ID);

CREATE INDEX EXCON_PROJECT_PERSONSIDX1
    ON EXCON_PROJECT_PERSONS (PROJECT_NUMBER, SEQUENCE_NUMBER);

ALTER TABLE EXCON_PROJECT_PERSONS
    ADD CONSTRAINT EXCON_PROJECT_PERSONSFK1
        FOREIGN KEY (PROJECT_ID)
            REFERENCES EXCON_PROJECT (PROJECT_ID);

ALTER TABLE EXCON_PROJECT_PERSONS
    ADD CONSTRAINT EXCON_PROJECT_PERSONSFK2
        FOREIGN KEY (PERSON_ROLE_TYPE_CODE)
            REFERENCES EXCON_PROJECT_PERSON_ROLE_TYPE (PROJECT_PERSON_ROLE_TYPE_CODE);

ALTER TABLE EXCON_PROJECT_PERSONS
    ADD CONSTRAINT EXCON_PROJECT_PERSONSFK3
        FOREIGN KEY (ROLODEX_ID)
            REFERENCES ROLODEX (ROLODEX_ID);

CREATE SEQUENCE EXCON_PROJECT_PERSON_S INCREMENT BY 1 START WITH 1 NOCACHE;

CREATE TABLE EXCON_PROJECT_CNTNT_TYPE_CODE
(
    CONTENT_TYPE_CODE     VARCHAR2(5),
    DESCRIPTION           VARCHAR2(200),
    UPDATE_TIMESTAMP      DATE NOT NULL,
    UPDATE_USER           VARCHAR2(60) NOT NULL,
    OBJ_ID                VARCHAR2(36) NOT NULL,
    VER_NBR               NUMBER(8) DEFAULT 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_CNTNT_TYPE_CODE
    ADD CONSTRAINT EXCON_PROJECT_CNTNT_TCP1
        PRIMARY KEY (CONTENT_TYPE_CODE);

ALTER TABLE EXCON_PROJECT_CNTNT_TYPE_CODE
    ADD CONSTRAINT EXCON_PROJECT_CNTNT_TCUQ1
        UNIQUE(OBJ_ID);

CREATE TABLE EXCON_PROJECT_EMAIL_CONTENT
(
    CONTENT_CODE          VARCHAR2(20) NOT NULL,
    DESCRIPTION           VARCHAR2(200),
    CONTENT_TYPE_CODE     VARCHAR2(5),
    FILE_NAME             VARCHAR2(150),
    CONTENT_TYPE          VARCHAR2(255),
    CONTENT               BLOB,
    UPDATE_TIMESTAMP      DATE NOT NULL,
    UPDATE_USER           VARCHAR2(60) NOT NULL,
    OBJ_ID                VARCHAR2(36) NOT NULL,
    VER_NBR               NUMBER(8) DEFAULT 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_EMAIL_CONTENT
    ADD CONSTRAINT EXCON_PROJECT_EMAIL_CONTENTP1
        PRIMARY KEY (CONTENT_CODE);

ALTER TABLE EXCON_PROJECT_EMAIL_CONTENT
    ADD CONSTRAINT EXCON_PROJECT_EMAIL_CONTENTUQ1
        UNIQUE(OBJ_ID);

ALTER TABLE EXCON_PROJECT_EMAIL_CONTENT
    ADD CONSTRAINT EXCON_PROJECT_EMAIL_CONTENTFK1
        FOREIGN KEY (CONTENT_TYPE_CODE)
            REFERENCES EXCON_PROJECT_CNTNT_TYPE_CODE (CONTENT_TYPE_CODE);

CREATE TABLE EXCON_PROJECT_TRAVELER_COM
(
    PROJECT_TRAVELER_COM_ID           NUMBER(22) NOT NULL,
    PROJECT_PERSON_ID                 NUMBER(22) NOT NULL,
    COMMUNICATION_DATE                DATE NOT NULL,
    EMAIL_BODY_CONTENT_CODE           VARCHAR2(20),
    EMAIL_ATTACHMENT_CONTENT_CODE     VARCHAR2(20),
    AGENDA_CONTENT_CODE               VARCHAR2(20),
    TRAVEL_COMMENT                    CLOB,
    UPDATE_TIMESTAMP                  DATE NOT NULL,
    UPDATE_USER                       VARCHAR2(60) NOT NULL,
    OBJ_ID                            VARCHAR2(36) NOT NULL,
    VER_NBR                           NUMBER(8) DEFAULT 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_TRAVELER_COM
    ADD CONSTRAINT EXCON_PROJECT_TRAVELER_COMSP1
        PRIMARY KEY (PROJECT_TRAVELER_COM_ID);

ALTER TABLE EXCON_PROJECT_TRAVELER_COM
    ADD CONSTRAINT EXCON_PROJECT_TRAVELER_COMUQ1
        UNIQUE(OBJ_ID);

ALTER TABLE EXCON_PROJECT_TRAVELER_COM
    ADD CONSTRAINT EXCON_PROJECT_TRAVELER_COMFK1
        FOREIGN KEY (PROJECT_PERSON_ID)
            REFERENCES EXCON_PROJECT_PERSONS (PROJECT_PERSON_ID);

ALTER TABLE EXCON_PROJECT_TRAVELER_COM
    ADD CONSTRAINT EXCON_PROJECT_TRAVELER_COMFK2
        FOREIGN KEY (EMAIL_BODY_CONTENT_CODE)
            REFERENCES EXCON_PROJECT_EMAIL_CONTENT (CONTENT_CODE);

ALTER TABLE EXCON_PROJECT_TRAVELER_COM
    ADD CONSTRAINT EXCON_PROJECT_TRAVELER_COMFK3
        FOREIGN KEY (EMAIL_ATTACHMENT_CONTENT_CODE)
            REFERENCES EXCON_PROJECT_EMAIL_CONTENT (CONTENT_CODE);

ALTER TABLE EXCON_PROJECT_TRAVELER_COM
    ADD CONSTRAINT EXCON_PROJECT_TRAVELER_COMFK4
        FOREIGN KEY (AGENDA_CONTENT_CODE)
            REFERENCES EXCON_PROJECT_EMAIL_CONTENT (CONTENT_CODE);

CREATE SEQUENCE EXCON_PROJECT_TRAVELER_COM_S INCREMENT BY 1 START WITH 1 NOCACHE;

CREATE TABLE EXCON_PROJECT_EVENT_TYPE
(
    PROJECT_EVENT_TYPE_CODE VARCHAR2(3) NOT NULL,
    DESCRIPTION             VARCHAR2(300) NOT NULL,
    UPDATE_TIMESTAMP        DATE NOT NULL,
    UPDATE_USER             VARCHAR2(60) NOT NULL,
    OBJ_ID                  VARCHAR2(36) NOT NULL,
    VER_NBR                 NUMBER(8) DEFAULT 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_EVENT_TYPE
    ADD CONSTRAINT EXCON_PROJECT_EVENT_TYPEP1
        PRIMARY KEY (PROJECT_EVENT_TYPE_CODE);

ALTER TABLE EXCON_PROJECT_EVENT_TYPE
    ADD CONSTRAINT EXCON_PROJECT_EVENT_TYPEUQ1
        UNIQUE(OBJ_ID);

CREATE TABLE EXCON_PROJECT_EVENTS
(
  PROJECT_EVENT_ID        NUMBER(22) NOT NULL,
  PROJECT_ID              NUMBER(22) NOT NULL,
  PROJECT_NUMBER        VARCHAR2(12) NOT NULL,
  SEQUENCE_NUMBER       NUMBER(4) DEFAULT 1,
  PROJECT_EVENT_TYPE_CODE VARCHAR2(3) NOT NULL,
  EVENT_DATE              DATE NOT NULL,
  EVENT_COMMENT           CLOB,
  UPDATE_TIMESTAMP        DATE NOT NULL,
  UPDATE_USER             VARCHAR2(60) NOT NULL,
  OBJ_ID                  VARCHAR2(36) NOT NULL,
  VER_NBR                 NUMBER(8) DEFAULT 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_EVENTS
  ADD CONSTRAINT EXCON_PROJECT_EVENTSP1
  PRIMARY KEY (PROJECT_EVENT_ID);

ALTER TABLE EXCON_PROJECT_EVENTS
    ADD CONSTRAINT EXCON_PROJECT_EVENTSUQ1
        UNIQUE(OBJ_ID);

CREATE INDEX EXCON_PROJECT_EVENTSIDX1
    ON EXCON_PROJECT_EVENTS (PROJECT_NUMBER, SEQUENCE_NUMBER);

ALTER TABLE EXCON_PROJECT_EVENTS
    ADD CONSTRAINT EXCON_PROJECT_EVENTSFK1
        FOREIGN KEY (PROJECT_ID)
            REFERENCES EXCON_PROJECT (PROJECT_ID);

ALTER TABLE EXCON_PROJECT_EVENTS
    ADD CONSTRAINT EXCON_PROJECT_EVENTSFK2
        FOREIGN KEY (PROJECT_EVENT_TYPE_CODE)
            REFERENCES EXCON_PROJECT_EVENT_TYPE (PROJECT_EVENT_TYPE_CODE);

CREATE SEQUENCE EXCON_PROJECT_EVENT_S INCREMENT BY 1 START WITH 1 NOCACHE;

CREATE TABLE EXCON_PROJECT_COMMENT_TYPE
(
    PROJECT_COMMENT_TYPE_CODE VARCHAR2(3) NOT NULL,
    DESCRIPTION               VARCHAR2(300) NOT NULL,
    UPDATE_TIMESTAMP          DATE NOT NULL,
    UPDATE_USER               VARCHAR2(60) NOT NULL,
    OBJ_ID                    VARCHAR2(36) NOT NULL,
    VER_NBR                   NUMBER(8) DEFAULT 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_COMMENT_TYPE
    ADD CONSTRAINT EXCON_PROJECT_COMMENT_TYPEP1
        PRIMARY KEY (PROJECT_COMMENT_TYPE_CODE);

ALTER TABLE EXCON_PROJECT_COMMENT_TYPE
    ADD CONSTRAINT EXCON_PROJECT_COMMENT_TYPEUQ1
        UNIQUE(OBJ_ID);

CREATE TABLE EXCON_PROJECT_COMMENTS
(
  PROJECT_COMMENT_ID    NUMBER(22) NOT NULL,
  PROJECT_ID            NUMBER(22) NOT NULL,
  PROJECT_NUMBER        VARCHAR2(12) NOT NULL,
  SEQUENCE_NUMBER       NUMBER(4) DEFAULT 1,
  COMMENT_TYPE_CODE     VARCHAR2(3) NOT NULL,
  COMMENTS              CLOB,
  COMMENT_AUTHOR        VARCHAR2(60),
  COMMENT_DATE          DATE,
  UPDATE_TIMESTAMP      DATE NOT NULL,
  UPDATE_USER           VARCHAR2(60) NOT NULL,
  OBJ_ID                VARCHAR2(36) NOT NULL,
  VER_NBR               NUMBER(8) DEFAULT 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_COMMENTS
  ADD CONSTRAINT EXCON_PROJECT_COMMENTSP1
  PRIMARY KEY (PROJECT_COMMENT_ID);

ALTER TABLE EXCON_PROJECT_COMMENTS
    ADD CONSTRAINT EXCON_PROJECT_COMMENTSUQ1
        UNIQUE(OBJ_ID);

CREATE INDEX EXCON_PROJECT_COMMENTSIDX1
    ON EXCON_PROJECT_COMMENTS (PROJECT_NUMBER, SEQUENCE_NUMBER);

ALTER TABLE EXCON_PROJECT_COMMENTS
    ADD CONSTRAINT EXCON_PROJECT_COMMENTSFK1
        FOREIGN KEY (PROJECT_ID)
            REFERENCES EXCON_PROJECT (PROJECT_ID);

ALTER TABLE EXCON_PROJECT_COMMENTS
    ADD CONSTRAINT EXCON_PROJECT_COMMENTSFK2
        FOREIGN KEY (COMMENT_TYPE_CODE)
            REFERENCES EXCON_PROJECT_COMMENT_TYPE (PROJECT_COMMENT_TYPE_CODE);

CREATE SEQUENCE EXCON_PROJECT_COMMENT_S INCREMENT BY 1 START WITH 1 NOCACHE;

CREATE TABLE EXCON_PROJECT_UNIT_PERSONS
(
  PROJECT_UNIT_PERSON_ID        NUMBER(22) NOT NULL,
  PERSON_ID                     VARCHAR2(40) NOT NULL,
  FULL_NAME                     VARCHAR2(90) NOT NULL,
  UNIT_ADMINISTRATOR_TYPE_CODE   varchar(5) NOT NULL,
  UNIT_ADMINISTRATOR_UNIT_NUMBER  VARCHAR2(8) NOT NULL,
  PROJECT_ID                    NUMBER(22) NOT NULL,
  PROJECT_NUMBER        VARCHAR2(12) NOT NULL,
  SEQUENCE_NUMBER       NUMBER(4) DEFAULT 1,
  UPDATE_TIMESTAMP              DATE NOT NULL,
  UPDATE_USER                   VARCHAR2(60) NOT NULL,
  OBJ_ID                        VARCHAR2(36) NOT NULL,
  VER_NBR                       NUMBER(8) DEFAULT 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_UNIT_PERSONS
  ADD CONSTRAINT EXCON_PROJECT_UNIT_PERSONSP1
  PRIMARY KEY (PROJECT_UNIT_PERSON_ID);

ALTER TABLE EXCON_PROJECT_UNIT_PERSONS
    ADD CONSTRAINT EXCON_PROJECT_UNIT_PERSONSUQ1
        UNIQUE(OBJ_ID);

CREATE INDEX EXCON_PROJECT_UNIT_PERSONSIDX1
    ON EXCON_PROJECT_UNIT_PERSONS (PROJECT_NUMBER, SEQUENCE_NUMBER);

ALTER TABLE EXCON_PROJECT_UNIT_PERSONS
    ADD CONSTRAINT EXCON_PROJECT_UNIT_PERSONSFK1
        FOREIGN KEY (PROJECT_ID)
            REFERENCES EXCON_PROJECT (PROJECT_ID);

CREATE SEQUENCE EXCON_PROJECT_UNIT_PERSON_S INCREMENT BY 1 START WITH 1 NOCACHE;

CREATE TABLE EXCON_PROJECT_CUSTOM_DATA
(
  EXCON_PROJECT_CUSTOM_DATA_ID  NUMBER(8),
  PROJECT_ID            NUMBER(22),
  PROJECT_NUMBER        VARCHAR2(12) NOT NULL,
  SEQUENCE_NUMBER       NUMBER(4) DEFAULT 1,
  CUSTOM_ATTRIBUTE_ID   NUMBER(12),
  VALUE                 VARCHAR2(2000),
  UPDATE_TIMESTAMP      DATE,
  UPDATE_USER           VARCHAR2(60),
  VER_NBR               NUMBER(8) default 1 NOT NULL,
  OBJ_ID                VARCHAR2(36) NOT NULL
);
ALTER TABLE EXCON_PROJECT_CUSTOM_DATA
  ADD CONSTRAINT EXCON_PROJECT_CUSTOM_DATAP1
  PRIMARY KEY (EXCON_PROJECT_CUSTOM_DATA_ID);

ALTER TABLE EXCON_PROJECT_CUSTOM_DATA
    ADD CONSTRAINT EXCON_PROJECT_CUSTOM_DATAUQ1
        UNIQUE(OBJ_ID);

CREATE INDEX EXCON_PROJECT_CUSTOM_DATAIDX1
    ON EXCON_PROJECT_CUSTOM_DATA (PROJECT_NUMBER, SEQUENCE_NUMBER);

ALTER TABLE EXCON_PROJECT_CUSTOM_DATA
    ADD CONSTRAINT EXCON_PROJECT_CUSTOM_DATAFK1
        FOREIGN KEY (PROJECT_ID)
            REFERENCES EXCON_PROJECT (PROJECT_ID);

ALTER TABLE EXCON_PROJECT_CUSTOM_DATA
    ADD CONSTRAINT EXCON_PROJECT_CUSTOM_DATAFK2
        FOREIGN KEY (CUSTOM_ATTRIBUTE_ID)
            REFERENCES CUSTOM_ATTRIBUTE (ID);

CREATE SEQUENCE EXCON_PROJECT_CUSTOM_DATA_S INCREMENT BY 1 START WITH 1 NOCACHE;

CREATE TABLE EXCON_PROJECT_ATTACHMENT_TYPE
(
    TYPE_CODE     VARCHAR2(3) NOT NULL,
    DESCRIPTION   VARCHAR2(200) NOT NULL,
    UPDATE_TIMESTAMP      DATE NOT NULL,
    UPDATE_USER           VARCHAR2(60) NOT NULL,
    OBJ_ID                VARCHAR2(36) NOT NULL,
    VER_NBR               NUMBER(8) DEFAULT 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_ATTACHMENT_TYPE
    ADD CONSTRAINT EXCON_PROJECT_ATT_TYPEP1
        PRIMARY KEY (TYPE_CODE);

ALTER TABLE EXCON_PROJECT_ATTACHMENT_TYPE
    ADD CONSTRAINT EXCON_PROJECT_ATT_TYPEUQ1
        UNIQUE(OBJ_ID);

CREATE TABLE EXCON_PROJECT_ATTACHMENTS
(
  PROJECT_ATTACHMENT_ID NUMBER(22) NOT NULL,
  PROJECT_ID            NUMBER(22) NOT NULL,
  PROJECT_NUMBER        VARCHAR2(12) NOT NULL,
  SEQUENCE_NUMBER       NUMBER(4) DEFAULT 1,
  TYPE_CODE             VARCHAR2(3) NOT NULL,
  DOCUMENT_ID           NUMBER(4) NOT NULL,
  FILE_ID               NUMBER(22) NOT NULL,
  DESCRIPTION           VARCHAR2(200),
  attach_user           varchar2(60),
  attach_date           date,
  UPDATE_TIMESTAMP      DATE NOT NULL,
  UPDATE_USER           VARCHAR2(60) NOT NULL,
  OBJ_ID                VARCHAR2(36) NOT NULL,
  VER_NBR               NUMBER(8) DEFAULT 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_ATTACHMENTS
  ADD CONSTRAINT EXCON_PROJECT_ATTACHMENTSP1
  PRIMARY KEY (PROJECT_ATTACHMENT_ID);

ALTER TABLE EXCON_PROJECT_ATTACHMENTS
    ADD CONSTRAINT EXCON_PROJECT_ATTACHMENTSUQ1
        UNIQUE(OBJ_ID);

CREATE INDEX EXCON_PROJECT_ATTACHMENTSIDX1
    ON EXCON_PROJECT_ATTACHMENTS (PROJECT_NUMBER, SEQUENCE_NUMBER);

ALTER TABLE EXCON_PROJECT_ATTACHMENTS
    ADD CONSTRAINT EXCON_PROJECT_ATTACHMENTSFK1
        FOREIGN KEY (PROJECT_ID)
            REFERENCES EXCON_PROJECT (PROJECT_ID);

ALTER TABLE EXCON_PROJECT_ATTACHMENTS
    ADD CONSTRAINT EXCON_PROJECT_ATTACHMENTSFK2
        FOREIGN KEY (TYPE_CODE)
            REFERENCES EXCON_PROJECT_ATTACHMENT_TYPE (TYPE_CODE);

ALTER TABLE EXCON_PROJECT_ATTACHMENTS
    ADD CONSTRAINT EXCON_PROJECT_ATTACHMENTSFK3
        FOREIGN KEY (FILE_ID)
            REFERENCES ATTACHMENT_FILE (FILE_ID);

CREATE SEQUENCE EXCON_PROJECT_ATTACHMENT_S INCREMENT BY 1 START WITH 1 NOCACHE;

CREATE TABLE EXCON_PROJECT_RSTRCT_CNTRY
(
    POSTAL_CNTRY_CD      VARCHAR2(3),
    SANCTION_LIST_CODE   VARCHAR2(4),
    UPDATE_TIMESTAMP      DATE NOT NULL,
    UPDATE_USER           VARCHAR2(60) NOT NULL,
    OBJ_ID               VARCHAR2(36) NOT NULL,
    VER_NBR              NUMBER(8) DEFAULT 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_RSTRCT_CNTRY
  ADD CONSTRAINT EXCON_PROJECT_RST_CTRYP1
  PRIMARY KEY (POSTAL_CNTRY_CD);

ALTER TABLE EXCON_PROJECT_RSTRCT_CNTRY
    ADD CONSTRAINT EXCON_PROJECT_RST_CTRYUQ1
        UNIQUE(OBJ_ID);

CREATE TABLE EXCON_PROJECT_DESTINATIONS
(
  PROJECT_DEST_ID         NUMBER(22) NOT NULL,
  PROJECT_ID              NUMBER(22) NOT NULL,
  PROJECT_NUMBER          VARCHAR2(12) NOT NULL,
  SEQUENCE_NUMBER         NUMBER(4) DEFAULT 1,
  DESTINATION_COUNTRY_CD  VARCHAR2(3) NOT NULL,
  ARRIVAL_DATE            DATE,
  DEPARTURE_DATE          DATE,
  DESTINATION_COMMENT     CLOB,
  SANCTION_LIST           VARCHAR2(4),
  UPDATE_TIMESTAMP        DATE NOT NULL,
  UPDATE_USER             VARCHAR2(60) NOT NULL,
  OBJ_ID                  VARCHAR2(36) NOT NULL,
  VER_NBR                 NUMBER(8) DEFAULT 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_DESTINATIONS
  ADD CONSTRAINT EXCON_PROJECT_DESTINATIONSP1
  PRIMARY KEY (PROJECT_DEST_ID);

ALTER TABLE EXCON_PROJECT_DESTINATIONS
    ADD CONSTRAINT EXCON_PROJECT_DESTINATIONSUQ1
        UNIQUE(OBJ_ID);

CREATE INDEX EXCON_PROJECT_DESTINATIONSIDX1
    ON EXCON_PROJECT_DESTINATIONS (PROJECT_NUMBER, SEQUENCE_NUMBER);

ALTER TABLE EXCON_PROJECT_DESTINATIONS
    ADD CONSTRAINT EXCON_PROJECT_DESTINATIONSFK1
        FOREIGN KEY (PROJECT_ID)
            REFERENCES EXCON_PROJECT (PROJECT_ID);

CREATE SEQUENCE EXCON_PROJECT_DEST_S INCREMENT BY 1 START WITH 1 NOCACHE;

CREATE TABLE EXCON_PROJECT_RSTRCT_UNIT
(
    UNIT_NUMBER      VARCHAR2(8),
    UPDATE_TIMESTAMP      DATE NOT NULL,
    UPDATE_USER           VARCHAR2(60) NOT NULL,
    OBJ_ID               VARCHAR2(36) NOT NULL,
    VER_NBR              NUMBER(8) DEFAULT 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_RSTRCT_UNIT
  ADD CONSTRAINT EXCON_PROJECT_RST_UNITP1
  PRIMARY KEY (UNIT_NUMBER);

ALTER TABLE EXCON_PROJECT_RSTRCT_UNIT
    ADD CONSTRAINT EXCON_PROJECT_RST_UNITUQ1
        UNIQUE(OBJ_ID);

ALTER TABLE EXCON_PROJECT_RSTRCT_UNIT
    ADD CONSTRAINT EXCON_PROJECT_RST_UNITFK1
        FOREIGN KEY (UNIT_NUMBER)
            REFERENCES UNIT (UNIT_NUMBER);

CREATE TABLE EXCON_PROJECT_EXT_INSTS
(
    PROJECT_EXT_INST_ID     NUMBER(22) NOT NULL,
    ROLODEX_ID            NUMBER(6) NOT NULL,
    PROJECT_ID            NUMBER(22) NOT NULL,
    PROJECT_NUMBER        VARCHAR2(12) NOT NULL,
    SEQUENCE_NUMBER       NUMBER(4) DEFAULT 1,
    UPDATE_TIMESTAMP      DATE NOT NULL,
    UPDATE_USER           VARCHAR2(60) NOT NULL,
    OBJ_ID                VARCHAR2(36) NOT NULL,
    VER_NBR               NUMBER(8) DEFAULT 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_EXT_INSTS
    ADD CONSTRAINT EXCON_PROJECT_EXT_INSTSP1
        PRIMARY KEY (PROJECT_EXT_INST_ID);

ALTER TABLE EXCON_PROJECT_EXT_INSTS
    ADD CONSTRAINT EXCON_PROJECT_EXT_INSTSUQ1
        UNIQUE(OBJ_ID);

CREATE INDEX EXCON_PROJECT_EXT_INSTSIDX1
    ON EXCON_PROJECT_EXT_INSTS (PROJECT_NUMBER, SEQUENCE_NUMBER);

ALTER TABLE EXCON_PROJECT_EXT_INSTS
    ADD CONSTRAINT EXCON_PROJECT_EXT_INSTSFK1
        FOREIGN KEY (PROJECT_ID)
            REFERENCES EXCON_PROJECT (PROJECT_ID);

ALTER TABLE EXCON_PROJECT_EXT_INSTS
    ADD CONSTRAINT EXCON_PROJECT_EXT_INSTSFK2
        FOREIGN KEY (ROLODEX_ID)
            REFERENCES ROLODEX (ROLODEX_ID);

CREATE SEQUENCE EXCON_PROJECT_EXT_INSTS_S INCREMENT BY 1 START WITH 1 NOCACHE;

CREATE TABLE EXCON_PROJECT_REVIEWS
(
    PROJECT_REVIEW_ID     NUMBER(22) NOT NULL,
    REVIEW_TYPE_CODE 		  VARCHAR2(3) NOT NULL,
    REVIEW_COMMENT        VARCHAR2(100),
    PROJECT_ID            NUMBER(22) NOT NULL,
    PROJECT_NUMBER        VARCHAR2(12) NOT NULL,
    SEQUENCE_NUMBER       NUMBER(4) DEFAULT 1,
    UPDATE_TIMESTAMP      DATE NOT NULL,
    UPDATE_USER           VARCHAR2(60) NOT NULL,
    OBJ_ID                VARCHAR2(36) NOT NULL,
    VER_NBR               NUMBER(8) DEFAULT 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_REVIEWS
    ADD CONSTRAINT EXCON_PROJECT_REVIEWSP1
        PRIMARY KEY (PROJECT_REVIEW_ID);

ALTER TABLE EXCON_PROJECT_REVIEWS
    ADD CONSTRAINT EXCON_PROJECT_REVIEWSUQ1
        UNIQUE(OBJ_ID);

CREATE INDEX EXCON_PROJECT_REVIEWSIDX1
    ON EXCON_PROJECT_REVIEWS (PROJECT_NUMBER, SEQUENCE_NUMBER);

ALTER TABLE EXCON_PROJECT_REVIEWS
    ADD CONSTRAINT EXCON_PROJECT_REVIEWSFK1
        FOREIGN KEY (PROJECT_ID)
            REFERENCES EXCON_PROJECT (PROJECT_ID);

CREATE SEQUENCE EXCON_PROJECT_REVIEWS_S INCREMENT BY 1 START WITH 1 NOCACHE;

CREATE TABLE EXCON_PROJECT_ASSOC_DOC_TYPE
(
    ASSOC_DOC_TYPE_CODE     	VARCHAR2(8) NOT NULL,
    ASSOC_DOC_TYPE_NAME	  	VARCHAR2(40) NOT NULL,
    ASSOC_DOC_TYPE_CLASS_NAME VARCHAR2(100),
    ASSOC_DOC_TYPE_NBR_ATTR	VARCHAR2(40),
    RETURNS_VALS				CHAR(1) DEFAULT 'N',
    UPDATE_TIMESTAMP        	DATE NOT NULL,
    UPDATE_USER             	VARCHAR2(60) NOT NULL,
    OBJ_ID                  	VARCHAR2(36) NOT NULL,
    VER_NBR                 	NUMBER(8) DEFAULT 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_ASSOC_DOC_TYPE
    ADD CONSTRAINT EXCON_PROJ_ASSOC_DOC_TYPEP1
        PRIMARY KEY (ASSOC_DOC_TYPE_CODE);

ALTER TABLE EXCON_PROJECT_ASSOC_DOC_TYPE
    ADD CONSTRAINT EXCON_PROJ_ASSOC_DOC_TYPEUQ1
        UNIQUE(OBJ_ID);

CREATE TABLE EXCON_PROJECT_ASSOC_DOCS
(
    ASSOC_DOC_ID         	  NUMBER(22) NOT NULL,
    ASSOC_DOC_TYPE_CODE	  VARCHAR2(8) NOT NULL,
    ASSOC_DOC_NUMBER        VARCHAR2(12) NOT NULL,
    ASSOC_DOC_TITLE		  VARCHAR2(200),
    PROJECT_ID              NUMBER(22) NOT NULL,
    PROJECT_NUMBER          VARCHAR2(12) NOT NULL,
    SEQUENCE_NUMBER         NUMBER(4) DEFAULT 1,
    UPDATE_TIMESTAMP        DATE NOT NULL,
    UPDATE_USER             VARCHAR2(60) NOT NULL,
    OBJ_ID                  VARCHAR2(36) NOT NULL,
    VER_NBR                 NUMBER(8) DEFAULT 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_ASSOC_DOCS
    ADD CONSTRAINT EXCON_PROJECT_ASSOC_DOCSP1
        PRIMARY KEY (ASSOC_DOC_ID);

ALTER TABLE EXCON_PROJECT_ASSOC_DOCS
    ADD CONSTRAINT EXCON_PROJECT_ASSOC_DOCSUQ1
        UNIQUE(OBJ_ID);

CREATE INDEX EXCON_PROJECT_ASSOC_DOCSIDX1
    ON EXCON_PROJECT_ASSOC_DOCS (PROJECT_NUMBER, SEQUENCE_NUMBER);

ALTER TABLE EXCON_PROJECT_ASSOC_DOCS
    ADD CONSTRAINT EXCON_PROJECT_ASSOC_DOCSFK1
        FOREIGN KEY (PROJECT_ID)
            REFERENCES EXCON_PROJECT (PROJECT_ID);

ALTER TABLE EXCON_PROJECT_ASSOC_DOCS
    ADD CONSTRAINT EXCON_PROJECT_ASSOC_DOCSFK2
        FOREIGN KEY (ASSOC_DOC_TYPE_CODE)
            REFERENCES EXCON_PROJECT_ASSOC_DOC_TYPE (ASSOC_DOC_TYPE_CODE);

CREATE SEQUENCE EXCON_PROJECT_ASSOC_DOCS_S INCREMENT BY 1 START WITH 1 NOCACHE;

CREATE TABLE EXCON_PROJECT_RPS_ENTITY
(
    RPS_ENTITY_ID         NUMBER(22) NOT NULL,
    PROJECT_ID            NUMBER(22) NOT NULL,
    PROJECT_NUMBER        VARCHAR2(12) NOT NULL,
    SEQUENCE_NUMBER       NUMBER(4) DEFAULT 1,
    FIRST_NAME            VARCHAR2(60),
    LAST_NAME             VARCHAR2(60),
    OTHER_NAMES           VARCHAR2(200),
    CONCAT_NAMES          VARCHAR2(320),
    COMPANY_NAME			VARCHAR2(100),
    STREET_ADDRESS			VARCHAR2(80),
    CITY					VARCHAR2(50),
    STATE					VARCHAR2(50),
    COUNTRY_CODE          VARCHAR2(3),
    BIRTHDATE             DATE,
    OTHER_INFO            CLOB,
    RPS_MATCH_CODE        VARCHAR2(3),
    UPDATE_TIMESTAMP      DATE NOT NULL,
    UPDATE_USER           VARCHAR2(60) NOT NULL,
    OBJ_ID                VARCHAR2(36) NOT NULL,
    VER_NBR               NUMBER(8) DEFAULT 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_RPS_ENTITY
    ADD CONSTRAINT EXCON_PROJECT_RPS_ENTITYP1
        PRIMARY KEY (RPS_ENTITY_ID);

ALTER TABLE EXCON_PROJECT_RPS_ENTITY
    ADD CONSTRAINT EXCON_PROJECT_RPS_ENTITYUQ1
        UNIQUE(OBJ_ID);

CREATE INDEX EXCON_PROJECT_RPS_ENTITYIDX1
    ON EXCON_PROJECT_RPS_ENTITY (PROJECT_NUMBER, SEQUENCE_NUMBER);

ALTER TABLE EXCON_PROJECT_RPS_ENTITY
    ADD CONSTRAINT EXCON_PROJECT_RPS_ENTITYFK1
        FOREIGN KEY (PROJECT_ID)
            REFERENCES EXCON_PROJECT (PROJECT_ID);

CREATE SEQUENCE EXCON_PROJECT_RPS_ENTITY_S INCREMENT BY 1 START WITH 1 NOCACHE;

CREATE TABLE EXCON_PROJECT_HR_EXTENSION
(
    REQUEST_TYPE			VARCHAR2(6),
    EMPLOYEE_TYPE			VARCHAR2(6),
    JOB_CODE				VARCHAR2(6),
    BC_RESULT				VARCHAR2(6),
    BC_STATUS				VARCHAR2(6),
    SELF_DISCLOSED		VARCHAR2(6),
    CRIMINAL_DISC			CLOB,
    CRIMINAL_OFFENSES		CLOB,
    MVR_DISC				CLOB,
    NOTES					CLOB,
    CONTACT				VARCHAR2(80),
    CRIMINAL_CHK			VARCHAR2(1),
    CRIMINAL_PRV			VARCHAR2(1),
    MVR_CHK				VARCHAR2(1),
    MVR_PRV				VARCHAR2(1),
    STATE_CHK				VARCHAR2(1),
    CREDIT_CHK			VARCHAR2(1),
    SEX_OFFENDER_CHK		VARCHAR2(1),
    EDUCATION_CHK			VARCHAR2(1),
    SSN_NO_DATA			VARCHAR2(1),
    HARD_COPY_REQ			VARCHAR2(1),
    CAND_DISPUTE			VARCHAR2(1),
    RERUN_REASON			VARCHAR2(6),
    PROJECT_ID            NUMBER(22) NOT NULL,
    PROJECT_NUMBER        VARCHAR2(12) NOT NULL,
    SEQUENCE_NUMBER       NUMBER(4) DEFAULT 1,
    UPDATE_TIMESTAMP      DATE NOT NULL,
    UPDATE_USER           VARCHAR2(60) NOT NULL,
    OBJ_ID                VARCHAR2(36) NOT NULL,
    VER_NBR               NUMBER(8) DEFAULT 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_HR_EXTENSION
    ADD CONSTRAINT EXCON_PROJECT_HR_EXTENSIONP1
        PRIMARY KEY (PROJECT_ID);

ALTER TABLE EXCON_PROJECT_HR_EXTENSION
    ADD CONSTRAINT EXCON_PROJECT_HR_EXTENSIONUQ1
        UNIQUE(OBJ_ID);

CREATE INDEX EXCON_PROJECT_HR_EXTENSIONIDX1
    ON EXCON_PROJECT_HR_EXTENSION (PROJECT_NUMBER, SEQUENCE_NUMBER);

ALTER TABLE EXCON_PROJECT_HR_EXTENSION
    ADD CONSTRAINT EXCON_PROJECT_HR_EXTENSIONFK1
        FOREIGN KEY (PROJECT_ID)
            REFERENCES EXCON_PROJECT (PROJECT_ID);

CREATE TABLE EXCON_PROJECT_UNIT_ROLE_TYPE
(
    UNIT_PERSON_ROLE_TYPE_CODE 	VARCHAR2(5) NOT NULL,
    DESCRIPTION                   VARCHAR2(300) NOT NULL,
    UPDATE_TIMESTAMP              DATE NOT NULL,
    UPDATE_USER                   VARCHAR2(60) NOT NULL,
    OBJ_ID                        VARCHAR2(36) NOT NULL,
    VER_NBR                       NUMBER(8) DEFAULT 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_UNIT_ROLE_TYPE
    ADD CONSTRAINT EXCON_PROJ_UNIT_ROLE_TYPE_P1
        PRIMARY KEY (UNIT_PERSON_ROLE_TYPE_CODE);

ALTER TABLE EXCON_PROJECT_UNIT_ROLE_TYPE
    ADD CONSTRAINT EXCON_PROJ_UNIT_ROLE_TYPEUQ1
        UNIQUE(OBJ_ID);

CREATE TABLE EXCON_PROJECT_RPS_RESULTS
(
    RPS_RESULT_ID      	NUMBER(22) NOT NULL,
    RPS_RESULT_CONTENT	CLOB NOT NULL,
    RPS_SEARCH_DATE		DATE NOT NULL,
    RPS_SEARCH_USER		VARCHAR2(60) NOT NULL,
    PROJECT_ID            NUMBER(22) NOT NULL,
    PROJECT_NUMBER        VARCHAR2(12) NOT NULL,
    SEQUENCE_NUMBER       NUMBER(4) DEFAULT 1,
    UPDATE_TIMESTAMP      DATE NOT NULL,
    UPDATE_USER           VARCHAR2(60) NOT NULL,
    OBJ_ID                VARCHAR2(36),
    VER_NBR               NUMBER(8) DEFAULT 1 NOT NULL
);
ALTER TABLE EXCON_PROJECT_RPS_RESULTS
    ADD CONSTRAINT EXCON_PROJECT_RPS_RESULTSP1
        PRIMARY KEY (RPS_RESULT_ID);

ALTER TABLE EXCON_PROJECT_RPS_RESULTS
    ADD CONSTRAINT EXCON_PROJECT_RPS_RESULTSUQ1
        UNIQUE(OBJ_ID);

CREATE INDEX EXCON_PROJECT_RPS_RESULTSIDX1
    ON EXCON_PROJECT_RPS_RESULTS (PROJECT_NUMBER, SEQUENCE_NUMBER);

ALTER TABLE EXCON_PROJECT_RPS_RESULTS
    ADD CONSTRAINT EXCON_PROJECT_RPS_RESULTSFK1
        FOREIGN KEY (PROJECT_ID)
            REFERENCES EXCON_PROJECT (PROJECT_ID);

CREATE SEQUENCE EXCON_PROJECT_RPS_RESULTS_S INCREMENT BY 1 START WITH 1 NOCACHE;

CREATE TABLE EXCON_INTL_SHIPMENT_DOCUMENT (
                                               DOCUMENT_NUMBER     VARCHAR2(40) NOT NULL,
                                               VER_NBR             NUMBER(8,0) DEFAULT 1 NOT NULL,
                                               OBJ_ID              VARCHAR2(36) NOT NULL,
                                               UPDATE_TIMESTAMP    DATE NOT NULL,
                                               UPDATE_USER         VARCHAR2(60) NOT NULL);
ALTER TABLE EXCON_INTL_SHIPMENT_DOCUMENT
    ADD CONSTRAINT EXCON_INTL_SHIPMENT_DOCP1
        PRIMARY KEY (DOCUMENT_NUMBER);

ALTER TABLE EXCON_INTL_SHIPMENT_DOCUMENT
    ADD CONSTRAINT EXCON_INTL_SHIPMENT_DOCUQ1
        UNIQUE(OBJ_ID);

CREATE TABLE EXCON_INTL_SHIPMENT
(
    DOCUMENT_NUMBER     VARCHAR2(40) NOT NULL,
    SHIPMENT_ID      		NUMBER(22) NOT NULL,
    RESTRICTED_EXPORT		VARCHAR2(1) NOT NULL,
    SHIPMENT_DESC			CLOB NOT NULL,
    RESTRICTED_COUNTRY	VARCHAR2(1) NOT NULL,
    COUNTRY_CODE			VARCHAR2(3) NOT NULL,
    SANCTION_LIST_CODE	VARCHAR2(4),
    RESTRICTED_PARTY		VARCHAR2(1) NOT NULL,
    RECEIVING_PARTY		CLOB NOT NULL,
    RPS_RESULT_CONTENT	CLOB,
    CERTIFICATION_IND		VARCHAR2(1) NOT NULL,
    APPLICANT_ID			VARCHAR2(40) NOT NULL,
    APPLICANT_NAME		VARCHAR2(200) NOT NULL,
    SUPERVISOR_ID			VARCHAR2(40) NOT NULL,
    SUPERVISOR_NAME		VARCHAR2(200) NOT NULL,
    UNIT_NUMBER			VARCHAR2(8) NOT NULL,
    UNIT_NAME				VARCHAR2(200) NOT NULL,
    UPDATE_TIMESTAMP      DATE NOT NULL,
    UPDATE_USER           VARCHAR2(60) NOT NULL,
    OBJ_ID                VARCHAR2(36),
    VER_NBR               NUMBER(8) DEFAULT 1 NOT NULL
);
ALTER TABLE EXCON_INTL_SHIPMENT
    ADD CONSTRAINT EXCON_INTL_SHIPMENTP1
        PRIMARY KEY (SHIPMENT_ID);

ALTER TABLE EXCON_INTL_SHIPMENT
    ADD CONSTRAINT EXCON_INTL_SHIPMENTUQ1
        UNIQUE(OBJ_ID);

ALTER TABLE EXCON_INTL_SHIPMENT
    ADD CONSTRAINT EXCON_INTL_SHIPMENTFK1
        FOREIGN KEY (DOCUMENT_NUMBER)
            REFERENCES EXCON_INTL_SHIPMENT_DOCUMENT (DOCUMENT_NUMBER);

CREATE SEQUENCE EXCON_INTL_SHIPMENT_S INCREMENT BY 1 START WITH 1000 NOCACHE;
