/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.lucene.search.IndexSearcher;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.BucketUtils;
import org.elasticsearch.search.aggregations.bucket.terms.DoubleTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.GlobalOrdinalsStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.LongTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.StringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregatorSupplier;
import org.elasticsearch.search.aggregations.bucket.terms.UnmappedTerms;
import org.elasticsearch.search.aggregations.support.AggregatorSupplier;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.internal.SearchContext;

public class TermsAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(TermsAggregatorFactory.class));
    static Boolean REMAP_GLOBAL_ORDS;
    static Boolean COLLECT_SEGMENT_ORDS;
    private final BucketOrder order;
    private final IncludeExclude includeExclude;
    private final String executionHint;
    private final Aggregator.SubAggCollectionMode collectMode;
    private final TermsAggregator.BucketCountThresholds bucketCountThresholds;
    private final boolean showTermDocCountError;

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register("terms", Arrays.asList(CoreValuesSourceType.BYTES, CoreValuesSourceType.IP), (AggregatorSupplier)TermsAggregatorFactory.bytesSupplier());
        builder.register("terms", Arrays.asList(CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN, CoreValuesSourceType.NUMERIC), (AggregatorSupplier)TermsAggregatorFactory.numericSupplier());
    }

    private static TermsAggregatorSupplier bytesSupplier() {
        return new TermsAggregatorSupplier(){

            @Override
            public Aggregator build(String name, AggregatorFactories factories, ValuesSource valuesSource, BucketOrder order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, String executionHint, SearchContext context, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode, boolean showTermDocCountError, Map<String, Object> metadata) throws IOException {
                long maxOrd;
                ExecutionMode execution = null;
                if (executionHint != null) {
                    execution = ExecutionMode.fromString(executionHint, deprecationLogger);
                }
                if (!(valuesSource instanceof ValuesSource.Bytes.WithOrdinals)) {
                    execution = ExecutionMode.MAP;
                }
                if (execution == null) {
                    execution = ExecutionMode.GLOBAL_ORDINALS;
                }
                long l = maxOrd = execution == ExecutionMode.GLOBAL_ORDINALS ? TermsAggregatorFactory.getMaxOrd(valuesSource, context.searcher()) : -1L;
                if (subAggCollectMode == null) {
                    subAggCollectMode = Aggregator.SubAggCollectionMode.DEPTH_FIRST;
                    if (factories != AggregatorFactories.EMPTY) {
                        subAggCollectMode = TermsAggregatorFactory.subAggCollectionMode(bucketCountThresholds.getShardSize(), maxOrd);
                    }
                }
                if (includeExclude != null && includeExclude.isRegexBased() && format != DocValueFormat.RAW) {
                    throw new AggregationExecutionException("Aggregation [" + name + "] cannot support regular expression style include/exclude settings as they can only be applied to string fields. Use an array of values for include/exclude clauses");
                }
                return execution.create(name, factories, valuesSource, order, format, bucketCountThresholds, includeExclude, context, parent, subAggCollectMode, showTermDocCountError, metadata);
            }
        };
    }

    private static TermsAggregatorSupplier numericSupplier() {
        return new TermsAggregatorSupplier(){

            @Override
            public Aggregator build(String name, AggregatorFactories factories, ValuesSource valuesSource, BucketOrder order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, String executionHint, SearchContext context, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode, boolean showTermDocCountError, Map<String, Object> metadata) throws IOException {
                if (includeExclude != null && includeExclude.isRegexBased()) {
                    throw new AggregationExecutionException("Aggregation [" + name + "] cannot support regular expression style include/exclude settings as they can only be applied to string fields. Use an array of numeric values for include/exclude clauses used to filter numeric fields");
                }
                IncludeExclude.LongFilter longFilter = null;
                if (subAggCollectMode == null) {
                    subAggCollectMode = factories != AggregatorFactories.EMPTY ? TermsAggregatorFactory.subAggCollectionMode(bucketCountThresholds.getShardSize(), -1L) : Aggregator.SubAggCollectionMode.DEPTH_FIRST;
                }
                if (((ValuesSource.Numeric)valuesSource).isFloatingPoint()) {
                    if (includeExclude != null) {
                        longFilter = includeExclude.convertToDoubleFilter();
                    }
                    return new DoubleTermsAggregator(name, factories, (ValuesSource.Numeric)valuesSource, format, order, bucketCountThresholds, context, parent, subAggCollectMode, showTermDocCountError, longFilter, metadata);
                }
                if (includeExclude != null) {
                    longFilter = includeExclude.convertToLongFilter(format);
                }
                return new LongTermsAggregator(name, factories, (ValuesSource.Numeric)valuesSource, format, order, bucketCountThresholds, context, parent, subAggCollectMode, showTermDocCountError, longFilter, metadata);
            }
        };
    }

    TermsAggregatorFactory(String name, ValuesSourceConfig config, BucketOrder order, IncludeExclude includeExclude, String executionHint, Aggregator.SubAggCollectionMode collectMode, TermsAggregator.BucketCountThresholds bucketCountThresholds, boolean showTermDocCountError, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.order = order;
        this.includeExclude = includeExclude;
        this.executionHint = executionHint;
        this.collectMode = collectMode;
        this.bucketCountThresholds = bucketCountThresholds;
        this.showTermDocCountError = showTermDocCountError;
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        final UnmappedTerms aggregation = new UnmappedTerms(this.name, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), metadata);
        NonCollectingAggregator agg = new NonCollectingAggregator(this.name, searchContext, parent, this.factories, metadata){

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return aggregation;
            }
        };
        this.order.validate(agg);
        return agg;
    }

    private static boolean isAggregationSort(BucketOrder order) {
        if (order instanceof InternalOrder.Aggregation) {
            return true;
        }
        if (order instanceof InternalOrder.CompoundOrder) {
            InternalOrder.CompoundOrder compoundOrder = (InternalOrder.CompoundOrder)order;
            return compoundOrder.orderElements().stream().anyMatch(TermsAggregatorFactory::isAggregationSort);
        }
        return false;
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource valuesSource, SearchContext searchContext, Aggregator parent, boolean collectsFromSingleBucket, Map<String, Object> metadata) throws IOException {
        if (!collectsFromSingleBucket) {
            return TermsAggregatorFactory.asMultiBucketAggregator(this, searchContext, parent);
        }
        AggregatorSupplier aggregatorSupplier = this.queryShardContext.getValuesSourceRegistry().getAggregator(this.config.valueSourceType(), "terms");
        if (!(aggregatorSupplier instanceof TermsAggregatorSupplier)) {
            throw new AggregationExecutionException("Registry miss-match - expected TermsAggregatorSupplier, found [" + aggregatorSupplier.getClass().toString() + "]");
        }
        TermsAggregatorSupplier termsAggregatorSupplier = (TermsAggregatorSupplier)aggregatorSupplier;
        TermsAggregator.BucketCountThresholds bucketCountThresholds = new TermsAggregator.BucketCountThresholds(this.bucketCountThresholds);
        if (!InternalOrder.isKeyOrder(this.order) && bucketCountThresholds.getShardSize() == TermsAggregationBuilder.DEFAULT_BUCKET_COUNT_THRESHOLDS.getShardSize()) {
            bucketCountThresholds.setShardSize(BucketUtils.suggestShardSideQueueSize(bucketCountThresholds.getRequiredSize()));
        }
        bucketCountThresholds.ensureValidity();
        return termsAggregatorSupplier.build(this.name, this.factories, valuesSource, this.order, this.config.format(), bucketCountThresholds, this.includeExclude, this.executionHint, searchContext, parent, this.collectMode, this.showTermDocCountError, metadata);
    }

    static Aggregator.SubAggCollectionMode subAggCollectionMode(int expectedSize, long maxOrd) {
        if (expectedSize == Integer.MAX_VALUE) {
            return Aggregator.SubAggCollectionMode.DEPTH_FIRST;
        }
        if (maxOrd == -1L || maxOrd > (long)expectedSize) {
            return Aggregator.SubAggCollectionMode.BREADTH_FIRST;
        }
        return Aggregator.SubAggCollectionMode.DEPTH_FIRST;
    }

    private static long getMaxOrd(ValuesSource source, IndexSearcher searcher) throws IOException {
        if (source instanceof ValuesSource.Bytes.WithOrdinals) {
            ValuesSource.Bytes.WithOrdinals valueSourceWithOrdinals = (ValuesSource.Bytes.WithOrdinals)source;
            return valueSourceWithOrdinals.globalMaxOrd(searcher);
        }
        return -1L;
    }

    public static enum ExecutionMode {
        MAP(new ParseField("map", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, BucketOrder order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, SearchContext context, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode, boolean showTermDocCountError, Map<String, Object> metadata) throws IOException {
                IncludeExclude.StringFilter filter = includeExclude == null ? null : includeExclude.convertToStringFilter(format);
                return new StringTermsAggregator(name, factories, valuesSource, order, format, bucketCountThresholds, filter, context, parent, subAggCollectMode, showTermDocCountError, metadata);
            }
        }
        ,
        GLOBAL_ORDINALS(new ParseField("global_ordinals", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, BucketOrder order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, SearchContext context, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode, boolean showTermDocCountError, Map<String, Object> metadata) throws IOException {
                boolean remapGlobalOrds;
                IncludeExclude.OrdinalsFilter filter;
                long maxOrd = TermsAggregatorFactory.getMaxOrd(valuesSource, context.searcher());
                assert (maxOrd != -1L);
                double ratio = (double)maxOrd / (double)context.searcher().getIndexReader().numDocs();
                assert (valuesSource instanceof ValuesSource.Bytes.WithOrdinals);
                ValuesSource.Bytes.WithOrdinals ordinalsValuesSource = (ValuesSource.Bytes.WithOrdinals)valuesSource;
                if (factories == AggregatorFactories.EMPTY && includeExclude == null && !Aggregator.descendsFromBucketAggregator(parent) && ordinalsValuesSource.supportsGlobalOrdinalsMapping() && (COLLECT_SEGMENT_ORDS != null ? COLLECT_SEGMENT_ORDS != false : ratio <= 0.5 && maxOrd <= 2048L)) {
                    return new GlobalOrdinalsStringTermsAggregator.LowCardinality(name, factories, ordinalsValuesSource, order, format, bucketCountThresholds, context, parent, false, subAggCollectMode, showTermDocCountError, metadata);
                }
                IncludeExclude.OrdinalsFilter ordinalsFilter = filter = includeExclude == null ? null : includeExclude.convertToOrdinalsFilter(format);
                if (REMAP_GLOBAL_ORDS != null) {
                    remapGlobalOrds = REMAP_GLOBAL_ORDS;
                } else {
                    remapGlobalOrds = true;
                    if (includeExclude == null && !Aggregator.descendsFromBucketAggregator(parent) && (factories == AggregatorFactories.EMPTY || !TermsAggregatorFactory.isAggregationSort(order) && subAggCollectMode == Aggregator.SubAggCollectionMode.BREADTH_FIRST)) {
                        remapGlobalOrds = false;
                    }
                }
                return new GlobalOrdinalsStringTermsAggregator(name, factories, ordinalsValuesSource, order, format, bucketCountThresholds, filter, context, parent, remapGlobalOrds, subAggCollectMode, showTermDocCountError, metadata);
            }
        };

        private final ParseField parseField;

        public static ExecutionMode fromString(String value, DeprecationLogger deprecationLogger) {
            switch (value) {
                case "global_ordinals": {
                    return GLOBAL_ORDINALS;
                }
                case "map": {
                    return MAP;
                }
            }
            throw new IllegalArgumentException("Unknown `execution_hint`: [" + value + "], expected any of [map, global_ordinals]");
        }

        private ExecutionMode(ParseField parseField) {
            this.parseField = parseField;
        }

        abstract Aggregator create(String var1, AggregatorFactories var2, ValuesSource var3, BucketOrder var4, DocValueFormat var5, TermsAggregator.BucketCountThresholds var6, IncludeExclude var7, SearchContext var8, Aggregator var9, Aggregator.SubAggCollectionMode var10, boolean var11, Map<String, Object> var12) throws IOException;

        public String toString() {
            return this.parseField.getPreferredName();
        }
    }
}

