/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.InternalGeoBounds;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.internal.SearchContext;

final class GeoBoundsAggregator
extends MetricsAggregator {
    static final ParseField WRAP_LONGITUDE_FIELD = new ParseField("wrap_longitude", new String[0]);
    private final ValuesSource.GeoPoint valuesSource;
    private final boolean wrapLongitude;
    DoubleArray tops;
    DoubleArray bottoms;
    DoubleArray posLefts;
    DoubleArray posRights;
    DoubleArray negLefts;
    DoubleArray negRights;

    GeoBoundsAggregator(String name, SearchContext aggregationContext, Aggregator parent, ValuesSource.GeoPoint valuesSource, boolean wrapLongitude, Map<String, Object> metadata) throws IOException {
        super(name, aggregationContext, parent, metadata);
        this.valuesSource = valuesSource;
        this.wrapLongitude = wrapLongitude;
        if (valuesSource != null) {
            BigArrays bigArrays = this.context.bigArrays();
            this.tops = bigArrays.newDoubleArray(1L, false);
            this.tops.fill(0L, this.tops.size(), Double.NEGATIVE_INFINITY);
            this.bottoms = bigArrays.newDoubleArray(1L, false);
            this.bottoms.fill(0L, this.bottoms.size(), Double.POSITIVE_INFINITY);
            this.posLefts = bigArrays.newDoubleArray(1L, false);
            this.posLefts.fill(0L, this.posLefts.size(), Double.POSITIVE_INFINITY);
            this.posRights = bigArrays.newDoubleArray(1L, false);
            this.posRights.fill(0L, this.posRights.size(), Double.NEGATIVE_INFINITY);
            this.negLefts = bigArrays.newDoubleArray(1L, false);
            this.negLefts.fill(0L, this.negLefts.size(), Double.POSITIVE_INFINITY);
            this.negRights = bigArrays.newDoubleArray(1L, false);
            this.negRights.fill(0L, this.negRights.size(), Double.NEGATIVE_INFINITY);
        }
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final MultiGeoPointValues values = this.valuesSource.geoPointValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (bucket >= GeoBoundsAggregator.this.tops.size()) {
                    long from = GeoBoundsAggregator.this.tops.size();
                    GeoBoundsAggregator.this.tops = bigArrays.grow(GeoBoundsAggregator.this.tops, bucket + 1L);
                    GeoBoundsAggregator.this.tops.fill(from, GeoBoundsAggregator.this.tops.size(), Double.NEGATIVE_INFINITY);
                    GeoBoundsAggregator.this.bottoms = bigArrays.resize(GeoBoundsAggregator.this.bottoms, GeoBoundsAggregator.this.tops.size());
                    GeoBoundsAggregator.this.bottoms.fill(from, GeoBoundsAggregator.this.bottoms.size(), Double.POSITIVE_INFINITY);
                    GeoBoundsAggregator.this.posLefts = bigArrays.resize(GeoBoundsAggregator.this.posLefts, GeoBoundsAggregator.this.tops.size());
                    GeoBoundsAggregator.this.posLefts.fill(from, GeoBoundsAggregator.this.posLefts.size(), Double.POSITIVE_INFINITY);
                    GeoBoundsAggregator.this.posRights = bigArrays.resize(GeoBoundsAggregator.this.posRights, GeoBoundsAggregator.this.tops.size());
                    GeoBoundsAggregator.this.posRights.fill(from, GeoBoundsAggregator.this.posRights.size(), Double.NEGATIVE_INFINITY);
                    GeoBoundsAggregator.this.negLefts = bigArrays.resize(GeoBoundsAggregator.this.negLefts, GeoBoundsAggregator.this.tops.size());
                    GeoBoundsAggregator.this.negLefts.fill(from, GeoBoundsAggregator.this.negLefts.size(), Double.POSITIVE_INFINITY);
                    GeoBoundsAggregator.this.negRights = bigArrays.resize(GeoBoundsAggregator.this.negRights, GeoBoundsAggregator.this.tops.size());
                    GeoBoundsAggregator.this.negRights.fill(from, GeoBoundsAggregator.this.negRights.size(), Double.NEGATIVE_INFINITY);
                }
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    for (int i = 0; i < valuesCount; ++i) {
                        GeoPoint value = values.nextValue();
                        double top = GeoBoundsAggregator.this.tops.get(bucket);
                        if (value.lat() > top) {
                            top = value.lat();
                        }
                        double bottom = GeoBoundsAggregator.this.bottoms.get(bucket);
                        if (value.lat() < bottom) {
                            bottom = value.lat();
                        }
                        double posLeft = GeoBoundsAggregator.this.posLefts.get(bucket);
                        if (value.lon() >= 0.0 && value.lon() < posLeft) {
                            posLeft = value.lon();
                        }
                        double posRight = GeoBoundsAggregator.this.posRights.get(bucket);
                        if (value.lon() >= 0.0 && value.lon() > posRight) {
                            posRight = value.lon();
                        }
                        double negLeft = GeoBoundsAggregator.this.negLefts.get(bucket);
                        if (value.lon() < 0.0 && value.lon() < negLeft) {
                            negLeft = value.lon();
                        }
                        double negRight = GeoBoundsAggregator.this.negRights.get(bucket);
                        if (value.lon() < 0.0 && value.lon() > negRight) {
                            negRight = value.lon();
                        }
                        GeoBoundsAggregator.this.tops.set(bucket, top);
                        GeoBoundsAggregator.this.bottoms.set(bucket, bottom);
                        GeoBoundsAggregator.this.posLefts.set(bucket, posLeft);
                        GeoBoundsAggregator.this.posRights.set(bucket, posRight);
                        GeoBoundsAggregator.this.negLefts.set(bucket, negLeft);
                        GeoBoundsAggregator.this.negRights.set(bucket, negRight);
                    }
                }
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        if (this.valuesSource == null) {
            return this.buildEmptyAggregation();
        }
        double top = this.tops.get(owningBucketOrdinal);
        double bottom = this.bottoms.get(owningBucketOrdinal);
        double posLeft = this.posLefts.get(owningBucketOrdinal);
        double posRight = this.posRights.get(owningBucketOrdinal);
        double negLeft = this.negLefts.get(owningBucketOrdinal);
        double negRight = this.negRights.get(owningBucketOrdinal);
        return new InternalGeoBounds(this.name, top, bottom, posLeft, posRight, negLeft, negRight, this.wrapLongitude, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalGeoBounds(this.name, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, this.wrapLongitude, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close(this.tops, this.bottoms, this.posLefts, this.posRights, this.negLefts, this.negRights);
    }
}

