/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.capabilities.descriptors;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.terracotta.management.model.capabilities.descriptors.Descriptor;

public class Settings
extends AbstractMap<String, Object>
implements Descriptor,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Object> map = new LinkedHashMap<String, Object>();

    public Settings() {
    }

    public Settings(Map<String, String> map) {
        this.map.putAll(map);
    }

    public Settings(Settings settings) {
        this.map.putAll(settings.map);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    public <T> T get(String key, Class<T> type) {
        return type.cast(this.map.get(key));
    }

    public <T> T getOrDefault(String key, Class<T> type, T def) {
        T o = this.get(key, type);
        return o == null ? def : o;
    }

    public String getString(String key) {
        return this.get(key, String.class);
    }

    public String getStringOrDefault(String key, String def) {
        return this.getOrDefault(key, String.class, def);
    }

    public Number getNumber(String key) {
        return this.get(key, Number.class);
    }

    public Number getNumberOrDefault(String key, Number def) {
        return this.getOrDefault(key, Number.class, def);
    }

    public boolean getBool(String key) {
        return this.get(key, Boolean.class);
    }

    public boolean getBoolOrDefault(String key, boolean def) {
        return this.getOrDefault(key, Boolean.class, def);
    }

    public String[] getStrings(String key) {
        return this.get(key, String[].class);
    }

    public String[] getStringsOrDefault(String key, String ... def) {
        return this.getOrDefault(key, String[].class, def);
    }

    public Settings set(String key, Settings settings) {
        this.map.put(key, settings);
        return this;
    }

    public Settings set(String key, String value) {
        this.map.put(key, value);
        return this;
    }

    public Settings set(String key, Number value) {
        this.map.put(key, value);
        return this;
    }

    public Settings set(String key, boolean value) {
        this.map.put(key, value);
        return this;
    }

    public Settings set(String key, Enum<?> value) {
        return this.set(key, value == null ? null : value.name());
    }

    public Settings set(String key, Class<?> value) {
        return this.set(key, value == null ? null : value.getName());
    }

    public Settings set(String key, String ... items) {
        this.map.put(key, items);
        return this;
    }

    public <T> Settings with(String key, T object, Builder<T> builder) {
        Settings child = new Settings();
        this.map.put(key, child);
        builder.build(child, object);
        return this;
    }

    public <T> Settings withEach(String containerKey, Collection<T> list, Builder<T> builder) {
        Settings container = new Settings();
        this.map.put(containerKey, container);
        int i = 0;
        for (T o : list) {
            Settings child = new Settings();
            container.set(String.valueOf(i++), child);
            builder.build(child, o);
        }
        return this;
    }

    public <V> Settings withEach(String containerKey, Map<String, V> map, Builder<V> builder) {
        Settings container = new Settings();
        this.map.put(containerKey, container);
        for (Map.Entry<String, V> entry : map.entrySet()) {
            Settings child = new Settings();
            container.set(entry.getKey(), child);
            builder.build(child, entry.getValue());
        }
        return this;
    }

    public static interface Builder<T> {
        public void build(Settings var1, T var2);
    }
}

