/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.owasp.esapi.errors.ValidationException;

public class ValidationErrorList {
    private HashMap<String, ValidationException> errorList = new HashMap();

    public void addError(String context, ValidationException vex) {
        if (context == null) {
            throw new RuntimeException("Context cannot be null: " + vex.getLogMessage(), vex);
        }
        if (vex == null) {
            throw new RuntimeException("ValidationException cannot be null for context  (" + context + ")");
        }
        if (this.getError(context) != null) {
            throw new RuntimeException("Context (" + context + ") already exists, must be unique");
        }
        this.errorList.put(context, vex);
    }

    public List<ValidationException> errors() {
        return new ArrayList<ValidationException>(this.errorList.values());
    }

    public ValidationException getError(String context) {
        if (context == null) {
            return null;
        }
        return this.errorList.get(context);
    }

    public boolean isEmpty() {
        return this.errorList.isEmpty();
    }

    public int size() {
        return this.errorList.size();
    }
}

