/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.uif.util.ProcessLogger;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.util.CsrfValidator;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.controller.MethodAccessException;
import org.kuali.rice.krad.web.controller.MethodAccessible;
import org.kuali.rice.krad.web.form.HistoryManager;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.form.UifFormManager;
import org.kuali.rice.krad.web.service.ModelAndViewService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class UifControllerHandlerInterceptor
implements HandlerInterceptor {
    @Autowired
    private ModelAndViewService modelAndViewService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.checkHandlerMethodAccess(request, handler);
        ParameterService parameterService = CoreFrameworkServiceLocator.getParameterService();
        if (parameterService.getParameterValueAsBoolean("KR-SYS", "All", "CSRF_PROTECTION_ENABLED").booleanValue() && !CsrfValidator.validateCsrf(request, response)) {
            return false;
        }
        UserSession session = KRADUtils.getUserSessionFromRequest(request);
        GlobalVariables.setUserSession(session);
        GlobalVariables.clear();
        this.createUifFormManagerIfNecessary(request);
        if (request.getSession().getAttribute("historyManager") == null) {
            request.getSession().setAttribute("historyManager", (Object)new HistoryManager());
        }
        ProcessLogger.trace("pre-handle");
        return true;
    }

    protected void checkHandlerMethodAccess(HttpServletRequest request, Object handler) throws Exception {
        String requestMethod = request.getMethod();
        if (requestMethod.equalsIgnoreCase(RequestMethod.GET.name())) {
            return;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        MethodAccessible methodAccessible = (MethodAccessible)handlerMethod.getMethodAnnotation(MethodAccessible.class);
        if (methodAccessible != null) {
            return;
        }
        boolean isMethodAccessible = this.checkForMethodAccess(request);
        if (!isMethodAccessible) {
            throw new MethodAccessException(handlerMethod.getBeanType(), handlerMethod.getMethod().getName());
        }
    }

    protected boolean checkForMethodAccess(HttpServletRequest request) {
        String methodToCall = request.getParameter("methodToCall");
        if (StringUtils.isBlank((String)methodToCall)) {
            return true;
        }
        UifFormManager uifFormManager = (UifFormManager)request.getSession().getAttribute("formManager");
        UifFormBase form = null;
        String formKeyParam = request.getParameter("formKey");
        if (StringUtils.isNotBlank((String)formKeyParam) && uifFormManager != null) {
            form = uifFormManager.getSessionForm(formKeyParam);
        }
        if (form == null || form.getViewPostMetadata() == null) {
            return true;
        }
        return !form.getViewPostMetadata().getAvailableMethodToCalls().contains(methodToCall) || form.getViewPostMetadata().getAccessibleMethodToCalls() != null && form.getViewPostMetadata().getAccessibleMethodToCalls().contains(methodToCall);
    }

    protected void createUifFormManagerIfNecessary(HttpServletRequest request) {
        UifFormManager uifFormManager = (UifFormManager)request.getSession().getAttribute("formManager");
        if (uifFormManager == null) {
            uifFormManager = new UifFormManager();
            request.getSession().setAttribute("formManager", (Object)uifFormManager);
        }
        GlobalVariables.setUifFormManager(uifFormManager);
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        Object model;
        if (request.getAttribute("ViewLifecycleComplete") == null) {
            this.getModelAndViewService().prepareView(request, modelAndView);
        }
        if (modelAndView != null && modelAndView.getModelMap() != null && (model = modelAndView.getModelMap().get((Object)"KualiForm")) != null && model instanceof ViewModel) {
            ((ViewModel)model).preRender(request);
        }
        ProcessLogger.trace("post-handle");
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        ProcessLogger.trace("after-completion");
        UifFormManager uifFormManager = (UifFormManager)request.getSession().getAttribute("formManager");
        UifFormBase uifForm = (UifFormBase)request.getAttribute("requestForm");
        if (uifForm == null || uifForm.getView() == null) {
            return;
        }
        boolean persistFormToSession = uifForm.getView().isPersistFormToSession();
        if (persistFormToSession && uifFormManager != null) {
            uifFormManager.purgeForm(uifForm);
            uifFormManager.addSessionForm(uifForm);
        }
        uifForm.setView(null);
        ProcessLogger.trace("after-completion-end");
    }

    protected ModelAndViewService getModelAndViewService() {
        return this.modelAndViewService;
    }

    public void setModelAndViewService(ModelAndViewService modelAndViewService) {
        this.modelAndViewService = modelAndViewService;
    }
}

