/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.api.rate.RateClassType;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetParentDocument;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.rate.BudgetRate;
import org.kuali.coeus.common.budget.framework.rate.RateType;
import org.kuali.coeus.common.framework.auth.perm.Permissionable;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.framework.krms.KrmsRulesContext;
import org.kuali.coeus.common.impl.krms.KcKrmsFactBuilderServiceHelper;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.KcDocumentRejectionService;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.AwardBudgetLineItemExt;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.award.commitments.FandaRateType;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.DocumentNextvalue;
import org.kuali.rice.coreservice.framework.parameter.ParameterConstants;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.postprocessor.ActionTakenEvent;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Copyable;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.SessionDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krms.api.engine.Facts;

@ParameterConstants.NAMESPACE(namespace="KC-AB")
@ParameterConstants.COMPONENT(component="Document")
public class AwardBudgetDocument
extends KcTransactionalDocumentBase
implements Copyable,
SessionDocument,
Permissionable,
KrmsRulesContext {
    private static final String AWARD_BUDGET_DOCUMENT_TYPE_CODE = "ABGT";
    private static Logger LOG = LogManager.getLogger(AwardBudgetDocument.class);
    private ScaleTwoDecimal obligatedTotal;
    private transient AwardBudgetService awardBudgetService;
    private Award currentAward;
    private List<AwardBudgetExt> budgets;
    private static final long serialVersionUID = 3564659576355229703L;
    private transient BusinessObjectService businessObjectService;

    @Override
    public void populateAgendaQualifiers(Map<String, String> qualifiers) {
        qualifiers.put("Unit Number", this.getLeadUnitNumber());
    }

    @Override
    public void initialize() {
        Award award = this.getBudget().getBudgetParent();
        this.setCurrentAward(award);
        AwardBudgetExt awardBudget = this.getAwardBudget();
        awardBudget.setObligatedTotal(new ScaleTwoDecimal(award.getBudgetTotalCostLimit().bigDecimalValue()));
        List<BudgetRate> budgetRates = awardBudget.getBudgetRates();
        this.populateBudgetRateTypes(awardBudget, budgetRates);
    }

    public Award getCurrentAward() {
        return this.currentAward;
    }

    public void setCurrentAward(Award currentAward) {
        this.currentAward = currentAward;
    }

    @Override
    public String getDocumentTypeCode() {
        return AWARD_BUDGET_DOCUMENT_TYPE_CODE;
    }

    public AwardBudgetExt getBudget() {
        if (this.budgets == null) {
            this.budgets = new ArrayList<AwardBudgetExt>();
        }
        if (this.budgets.isEmpty()) {
            this.budgets.add(new AwardBudgetExt());
        }
        return this.budgets.get(0);
    }

    @Override
    public KcPersistableBusinessObjectBase getBusinessObject() {
        return this.getBudget();
    }

    private void populateBudgetRateTypes(Budget budget, List<BudgetRate> budgetRates) {
        for (BudgetRate budgetRate : budgetRates) {
            if (!RateClassType.OVERHEAD.getRateClassType().equals(budgetRate.getRateClassType())) continue;
            budgetRate.setBudget(budget);
            if (!budgetRate.getNonEditableRateFlag()) continue;
            budgetRate.setRateType(this.createAwardRateType(budgetRate));
        }
    }

    private RateType createAwardRateType(BudgetRate rate) {
        FandaRateType awardRateType = (FandaRateType)this.getBusinessObjectService().findBySinglePrimaryKey(FandaRateType.class, (Object)rate.getRateTypeCode());
        RateType newRateType = new RateType();
        newRateType.setRateClassCode(rate.getRateClassCode());
        newRateType.setRateTypeCode(awardRateType.getFandaRateTypeCode().toString());
        newRateType.setDescription(awardRateType.getDescription());
        return newRateType;
    }

    public AwardBudgetExt getAwardBudget() {
        return this.getBudget();
    }

    public ScaleTwoDecimal getObligatedTotal() {
        return this.obligatedTotal;
    }

    public void setObligatedTotal(ScaleTwoDecimal obligatedTotal) {
        this.obligatedTotal = obligatedTotal;
    }

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange dto) {
        this.executeAsLastActionUser(() -> {
            super.doRouteStatusChange(dto);
            String newStatus = dto.getNewRouteStatus();
            String oldStatus = dto.getOldRouteStatus();
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Route status change on AwardBudgetDocument #%s from %s to %s.", this.getDocumentNumber(), oldStatus, newStatus));
            }
            this.setCurrentAward(this.getBudget().getBudgetParent());
            if (StringUtils.equals((CharSequence)newStatus, (CharSequence)"D")) {
                this.getAwardBudget().setAwardBudgetStatusCode("13");
                this.getBusinessObjectService().save((PersistableBusinessObject)this.getAwardBudget());
            } else if (StringUtils.equals((CharSequence)newStatus, (CharSequence)"X")) {
                this.getAwardBudget().setAwardBudgetStatusCode("14");
                this.getBusinessObjectService().save((PersistableBusinessObject)this.getAwardBudget());
            } else if (StringUtils.equals((CharSequence)newStatus, (CharSequence)"F")) {
                this.getAwardBudget().setAwardBudgetStatusCode("10");
                this.getBusinessObjectService().save((PersistableBusinessObject)this.getAwardBudget());
            }
            return null;
        });
    }

    public void doActionTaken(ActionTakenEvent event) {
        this.executeAsLastActionUser(() -> {
            super.doActionTaken(event);
            ActionTaken actionTaken = event.getActionTaken();
            KcDocumentRejectionService documentRejectionService = KcServiceLocator.getService(KcDocumentRejectionService.class);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Action taken on document %s: event code %s, action taken is %s", this.getDocumentNumber(), event.getDocumentEventCode(), actionTaken.getActionTaken().getCode()));
            }
            if (StringUtils.equals((CharSequence)"A", (CharSequence)actionTaken.getActionTaken().getCode()) && documentRejectionService.isDocumentOnInitialNode(this.getDocumentHeader().getWorkflowDocument())) {
                this.getAwardBudget().setAwardBudgetStatusCode("1");
                this.getBusinessObjectService().save((PersistableBusinessObject)this.getAwardBudget());
            }
            return null;
        });
    }

    public void documentHasBeenRejected(String reason) {
        this.getAwardBudget().setAwardBudgetStatusCode("8");
        try {
            KcServiceLocator.getService(DocumentService.class).saveDocument((Document)this);
        }
        catch (WorkflowException e) {
            throw new RuntimeException("Could not save award document on action  taken.", e);
        }
    }

    public void prepareForSave() {
        if (this.getBudget() != null && this.getBudget().getBudgetId() != null) {
            AwardBudgetExt budget = (AwardBudgetExt)this.getBusinessObjectService().findBySinglePrimaryKey(AwardBudgetExt.class, (Object)this.getBudget().getBudgetId());
            HashMap<String, Long> params = new HashMap<String, Long>();
            params.put("budgetId", budget.getBudgetId());
            Collection collection = this.getBusinessObjectService().findMatching(AwardBudgetLineItemExt.class, params);
        }
        if (ObjectUtils.isNull((Object)this.getVersionNumber())) {
            this.setVersionNumber(new Long(0L));
        }
        this.getBudget().getRateClassTypes();
        this.getBudget().handlePeriodToProjectIncomeRelationship();
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected AwardBudgetService getAwardBudgetService() {
        if (this.awardBudgetService == null) {
            this.awardBudgetService = KcServiceLocator.getService(AwardBudgetService.class);
        }
        return this.awardBudgetService;
    }

    public void setAwardBudgetService(AwardBudgetService awardBudgetService) {
        this.awardBudgetService = awardBudgetService;
    }

    @Override
    public void populateContextQualifiers(Map<String, String> qualifiers) {
        qualifiers.put("namespaceCode", "KC-AB");
        qualifiers.put("name", "KC Award Budget Context");
    }

    @Override
    public void addFacts(Facts.Builder factsBuilder) {
        KcKrmsFactBuilderServiceHelper fbService = (KcKrmsFactBuilderServiceHelper)KcServiceLocator.getService("awardBudgetFactBuilderService");
        fbService.addFacts(factsBuilder, this);
    }

    public List<AwardBudgetExt> getBudgets() {
        return this.budgets;
    }

    public void setBudgets(List<AwardBudgetExt> budgets) {
        this.budgets = budgets;
    }

    public Integer getHackedDocumentNextValue(String propertyName) {
        Integer propNextValue = 1;
        for (DocumentNextvalue element : this.getDocumentNextvalues()) {
            List lineItemNumber;
            DocumentNextvalue documentNextvalue = element;
            if (!documentNextvalue.getPropertyName().equalsIgnoreCase(propertyName)) continue;
            propNextValue = documentNextvalue.getNextValue();
            HashMap<String, Long> budgetIdMap = new HashMap<String, Long>();
            budgetIdMap.put("budgetId", this.getBudget().getBudgetId());
            if (budgetIdMap != null && (lineItemNumber = (List)this.getBusinessObjectService().findMatchingOrderBy(BudgetLineItem.class, budgetIdMap, "lineItemNumber", true)) != null) {
                for (BudgetLineItem budgetLineItem : lineItemNumber) {
                    if (propNextValue.intValue() != budgetLineItem.getLineItemNumber().intValue()) continue;
                    Integer n = propNextValue;
                    Integer n2 = propNextValue = Integer.valueOf(propNextValue + 1);
                }
            }
            documentNextvalue.setNextValue(propNextValue + 1);
        }
        if (propNextValue == 1) {
            HashMap<String, Object> pkMap = new HashMap<String, Object>();
            pkMap.put("documentKey", this.getBudget().getBudgetId());
            pkMap.put("propertyName", propertyName);
            DocumentNextvalue documentNextvalue = (DocumentNextvalue)this.getBusinessObjectService().findByPrimaryKey(DocumentNextvalue.class, pkMap);
            if (documentNextvalue != null) {
                propNextValue = documentNextvalue.getNextValue();
                documentNextvalue.setNextValue(propNextValue + 1);
                this.getDocumentNextvalues().add(documentNextvalue);
            }
        }
        if (propNextValue == 1) {
            DocumentNextvalue documentNextvalue = new DocumentNextvalue();
            documentNextvalue.setNextValue(propNextValue + 1);
            documentNextvalue.setPropertyName(propertyName);
            documentNextvalue.setDocumentKey(this.getDocumentNumber());
            this.getDocumentNextvalues().add(documentNextvalue);
        }
        this.setDocumentNextvalues(this.getDocumentNextvalues());
        return propNextValue;
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.addAll(this.getBudget().buildListOfDeletionAwareLists());
        return managedLists;
    }

    @Override
    public String getCustomLockDescriptor(Person user) {
        String activeLockRegion = (String)GlobalVariables.getUserSession().retrieveObject("ACTIVE_LOCK_REGION");
        if (StringUtils.isNotEmpty((CharSequence)activeLockRegion)) {
            return this.getDocumentBoNumber() + "-" + activeLockRegion + "-" + activeLockRegion + "-" + GlobalVariables.getUserSession().getPrincipalName();
        }
        return null;
    }

    @Override
    public String getDocumentBoNumber() {
        return this.getBudget().getBudgetId().toString();
    }

    @Override
    public String getDocumentKey() {
        return this.getBudget().getBudgetParent().getDocument().getBudgetPermissionable().getDocumentKey();
    }

    @Override
    public String getDocumentNumberForPermission() {
        return this.getDocumentNumber();
    }

    @Override
    public List<String> getRoleNames() {
        return this.getBudget().getBudgetParent().getDocument().getBudgetPermissionable().getRoleNames();
    }

    @Override
    public String getNamespace() {
        return "KC-B";
    }

    @Override
    public String getLeadUnitNumber() {
        return this.getBudget().getBudgetParent().getDocument().getBudgetPermissionable().getLeadUnitNumber();
    }

    @Override
    public String getDocumentRoleTypeCode() {
        return "KC-PD";
    }

    public List<String> getLockClearningMethodNames() {
        List methodToCalls = super.getLockClearningMethodNames();
        methodToCalls.add("returnToProposal");
        methodToCalls.add("returnToAward");
        return methodToCalls;
    }

    @Override
    public boolean isProcessComplete() {
        return true;
    }

    @Override
    public List<? extends DocumentCustomData> getDocumentCustomData() {
        return new ArrayList();
    }

    public BudgetParentDocument getParentDocument() {
        return this.getBudget().getBudgetParent().getDocument();
    }
}

