/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.util.JavascriptUtil;

public class EnginePrivate {
    public static String remoteBeginWrapper(String instanceId, boolean useWindowParent, String documentDomain) {
        StringBuilder buf = new StringBuilder();
        if (documentDomain != null && !documentDomain.equals("")) {
            buf.append("document.domain='").append(documentDomain).append("';\r\n");
        }
        if (useWindowParent) {
            buf.append("try{\r\n");
            buf.append("if(window.parent.dwr){\r\n");
            buf.append("var dwr=window.parent.dwr._[" + instanceId + "];");
        } else {
            buf.append("(function(){\r\n");
            buf.append("if(!window.dwr)return;\r\n");
            buf.append("var dwr=window.dwr._[" + instanceId + "];");
        }
        return buf.toString();
    }

    public static String remoteEndWrapper(String instanceId, boolean useWindowParent) {
        StringBuilder buf = new StringBuilder();
        if (useWindowParent) {
            buf.append("dwr.engine.transport.iframe.remote.endChunk(window);\r\n");
            buf.append("}\r\n");
            buf.append("}catch(e){}");
        } else {
            buf.append("})();");
        }
        return buf.toString();
    }

    public static ScriptBuffer getRemoteHandleCallbackScript(String batchId, String callId, Object data) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall("dwr.engine.remote.handleCallback", batchId, callId, data);
        return script;
    }

    public static ScriptBuffer getRemoteHandleExceptionScript(String batchId, String callId, Throwable ex) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall("dwr.engine.remote.handleException", batchId, callId, ex);
        return script;
    }

    public static String getRemoteHandleReverseAjaxScript(long scriptIndex, String script) {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("dwr.engine.remote.handleReverseAjax(").append(scriptIndex).append(",function(){\r\n");
        strbuf.append(script).append("\r\n");
        strbuf.append("});");
        return strbuf.toString();
    }

    public static String getRemoteHandleBatchExceptionScript(String batchId, Exception ex) {
        StringBuffer reply = new StringBuffer();
        String output = JavascriptUtil.escapeJavaScript(ex.getMessage());
        String params = "{ name:'" + ex.getClass().getName() + "', message:'" + output + "' }";
        params = params + ", " + (batchId != null ? "'" + batchId + "'" : "null");
        reply.append("//#DWR-REPLY").append("\r\n");
        reply.append("dwr.engine.remote.handleBatchException(").append(params).append(");");
        return reply.toString();
    }

    public static ScriptBuffer getRemoteExecuteFunctionScript(String id, Object[] params) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall("dwr.engine.remote.handleFunctionCall", id, params);
        return script;
    }

    public static ScriptBuffer getRemoteExecuteObjectScript(String id, String methodName, Object[] params) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall("dwr.engine.remote.handleObjectCall", id, methodName, params);
        return script;
    }

    public static ScriptBuffer getRemoteSetObjectScript(String id, String propertyName, Object data) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall("dwr.engine.remote.handleSetCall", id, propertyName, data);
        return script;
    }

    public static ScriptBuffer getRemoteCloseFunctionScript(String id) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendCall("dwr.engine.remote.handleFunctionClose", id);
        return script;
    }

    public static String getRemotePollCometDisabledScript(String batchId) {
        StringBuffer reply = new StringBuffer();
        String params = "{name:'dwr.engine.pollAndCometDisabled',message:'Polling and Comet are disabled. See the server logs.'}";
        if (batchId != null) {
            params = params + ",'" + batchId + "'";
        }
        reply.append("//#DWR-REPLY").append("\r\n");
        reply.append("dwr.engine.remote.pollCometDisabled(").append(params).append(");");
        return reply.toString();
    }

    public static String remoteNewObjectFunction() {
        return "dwr.engine.remote.newObject";
    }

    public static String xmlStringToJavascriptDomElement(String xml) {
        String xmlout = JavascriptUtil.escapeJavaScript(xml);
        return "dwr.engine.serialize.toDomElement(\"" + xmlout + "\")";
    }

    public static String xmlStringToJavascriptDomDocument(String xml) {
        String xmlout = JavascriptUtil.escapeJavaScript(xml);
        return "dwr.engine.serialize.toDomDocument(\"" + xmlout + "\")";
    }

    public static String getRequireEngineScript() {
        return "if (typeof dwr == 'undefined' || dwr.engine == undefined) throw new Error('You must include DWR engine before including this file');\n";
    }

    public static String getExecuteFunctionName() {
        return "dwr.engine._execute";
    }

    public static String remoteBeginIFrameResponse(String batchId, boolean useWindowParent) {
        return "dwr.engine.transport.iframe.remote.beginIFrameResponse(this.frameElement" + (batchId == null ? "" : ",'" + batchId + "'") + ");";
    }

    public static String remoteEndIFrameResponse(String batchId, boolean useWindowParent) {
        return "dwr.engine.transport.iframe.remote.endIFrameResponse(" + (batchId == null ? "" : "'" + batchId + "'") + ");";
    }

    public static String remoteExecute(String script) {
        return "dwr.engine._executeScript(\"" + JavascriptUtil.escapeJavaScript(script) + "\");";
    }
}

