/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.api.medusa;

import com.codiform.moo.curry.Translate;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.medusa.dto.MedusaAwardAmountDto;
import org.kuali.coeus.common.api.medusa.dto.MedusaAwardDto;
import org.kuali.coeus.common.api.medusa.dto.MedusaChildDto;
import org.kuali.coeus.common.api.medusa.dto.MedusaDevelopmentProposalDto;
import org.kuali.coeus.common.api.medusa.dto.MedusaInstitutionalProposalDto;
import org.kuali.coeus.common.api.medusa.dto.MedusaNegotiationDto;
import org.kuali.coeus.common.api.medusa.dto.MedusaSubAwardDto;
import org.kuali.coeus.common.framework.medusa.MedusaNode;
import org.kuali.coeus.common.framework.medusa.MedusaService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.ViewResolver;

@Controller
public class MedusaRestController {
    public static final String MODULE_ID_PARAM = "moduleId";
    public static final String MODULE_PARAM = "module";
    public static final String PREFERRED_MODULE_PARAM = "preferredModule";
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Lazy
    @Qualifier(value="medusaService")
    private MedusaService medusaService;
    @Autowired
    @Qualifier(value="jspViewResolver")
    private ViewResolver jspViewResolver;

    @GetMapping(value={"/api/v1/medusa/tree"})
    @ResponseBody
    public List<MedusaChildDto> getMedusaTree(@RequestParam(value="module") String module, @RequestParam(value="moduleId") Long docNumber, @RequestParam(value="preferredModule", required=false) String preferredModule) {
        List<MedusaNode> branches = "award".equals(preferredModule) ? this.medusaService.getMedusaByAward(module, docNumber) : this.medusaService.getMedusaByProposal(module, docNumber);
        return branches.stream().map(this::translateMedusaBranch).collect(Collectors.toList());
    }

    @GetMapping(value={"/api/v1/medusa/node"})
    @ResponseBody
    public Object getMedusaNode(@RequestParam(value="module") String module, @RequestParam(value="moduleId") Long docNumber) {
        MedusaNode node = this.medusaService.getMedusaNode(module, docNumber);
        return this.translateMedusaBoToDto(node);
    }

    private MedusaChildDto translateMedusaBranch(MedusaNode node) {
        MedusaChildDto translatedNode = this.translateMedusaNode(node);
        if (CollectionUtils.isNotEmpty(node.getChildNodes())) {
            node.getChildNodes().forEach(childNode -> translatedNode.addChild(this.translateMedusaBranch((MedusaNode)childNode)));
        }
        return translatedNode;
    }

    private MedusaChildDto translateMedusaNode(MedusaNode node) {
        MedusaChildDto translatedNode = new MedusaChildDto();
        translatedNode.setModuleCode(node.getType());
        if (StringUtils.equals((CharSequence)node.getType(), (CharSequence)"award")) {
            Award award = (Award)node.getBo();
            translatedNode.setModuleId(award.getAwardId());
        } else if (StringUtils.equals((CharSequence)node.getType(), (CharSequence)"IP")) {
            InstitutionalProposal ip = (InstitutionalProposal)node.getBo();
            translatedNode.setModuleId(ip.getProposalId());
        } else if (StringUtils.equals((CharSequence)node.getType(), (CharSequence)"DP")) {
            DevelopmentProposal proposal = (DevelopmentProposal)node.getBo();
            translatedNode.setModuleId(Long.valueOf(proposal.getProposalNumber()));
        } else if (StringUtils.equals((CharSequence)node.getType(), (CharSequence)"neg")) {
            Negotiation negotiation = (Negotiation)node.getBo();
            translatedNode.setModuleId(negotiation.getNegotiationId());
        } else if (StringUtils.equals((CharSequence)node.getType(), (CharSequence)"subaward")) {
            SubAward subAward = (SubAward)node.getBo();
            translatedNode.setModuleId(Long.valueOf(subAward.getSubAwardCode()));
        }
        translatedNode.setDescription(node.getNodeLabel());
        translatedNode.setDetailedDescription(node.getDocumentDescription());
        return translatedNode;
    }

    private Object translateMedusaBoToDto(MedusaNode node) {
        if (node == null || node.getBo() == null || node.getType() == null) {
            return null;
        }
        if (StringUtils.equals((CharSequence)node.getType(), (CharSequence)"award")) {
            MedusaAwardDto awardDto = (MedusaAwardDto)Translate.to(MedusaAwardDto.class).from(node.getBo());
            if (node.getExtraInfo() != null && node.getExtraInfo() instanceof AwardAmountInfo) {
                awardDto.setAwardAmountInfo((MedusaAwardAmountDto)Translate.to(MedusaAwardAmountDto.class).from(node.getExtraInfo()));
            }
            return awardDto;
        }
        if (StringUtils.equals((CharSequence)node.getType(), (CharSequence)"IP")) {
            return Translate.to(MedusaInstitutionalProposalDto.class).from(node.getBo());
        }
        if (StringUtils.equals((CharSequence)node.getType(), (CharSequence)"DP")) {
            return Translate.to(MedusaDevelopmentProposalDto.class).from(node.getBo());
        }
        if (StringUtils.equals((CharSequence)node.getType(), (CharSequence)"neg")) {
            return Translate.to(MedusaNegotiationDto.class).from(node.getBo());
        }
        if (StringUtils.equals((CharSequence)node.getType(), (CharSequence)"subaward")) {
            return Translate.to(MedusaSubAwardDto.class).from(node.getBo());
        }
        return null;
    }

    @GetMapping(value={"/medusa"})
    public ModelAndView getMedusaPage(@RequestParam(value="module") String module, @RequestParam(value="moduleId") Long moduleId) throws Exception {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.addObject("appContext", (Object)this.configurationService.getPropertyValueAsString("app.context.name"));
        modelAndView.addObject("version", (Object)this.configurationService.getPropertyValueAsString("version"));
        modelAndView.addObject("riceVersion", (Object)this.configurationService.getPropertyValueAsString("rice.version"));
        modelAndView.addObject(MODULE_PARAM, (Object)module);
        modelAndView.addObject(MODULE_ID_PARAM, (Object)moduleId);
        modelAndView.setView(this.jspViewResolver.resolveViewName("medusa/medusaReact", Locale.US));
        return modelAndView;
    }
}

