/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.print;

import java.io.ByteArrayInputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.xmlbeans.XmlObject;
import org.kuali.coeus.common.framework.print.AbstractPrint;
import org.kuali.coeus.common.framework.print.PrintingException;
import org.kuali.coeus.common.framework.sponsor.form.SponsorFormTemplate;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.print.NIHResearchAndRelatedXmlStream;
import org.kuali.coeus.propdev.impl.print.ProposalDevelopmentXmlStream;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="proposalSponsorFormsPrint")
@Scope(value="prototype")
public class ProposalSponsorFormsPrint
extends AbstractPrint {
    private static final String LOCAL_PRINT_FORM_SPONSOR_CODE = "LOCAL_PRINT_FORM_SPONSOR_CODE";
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="nihResearchAndRelatedXmlStream")
    private NIHResearchAndRelatedXmlStream nihResearchAndRelatedXmlStream;
    @Autowired
    @Qualifier(value="proposalDevelopmentXmlStream")
    private ProposalDevelopmentXmlStream proposalDevelopmentXmlStream;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;

    @Override
    public Map<String, Source> getXSLTemplateWithBookmarks() {
        LinkedHashMap<String, Source> sourceMap = new LinkedHashMap<String, Source>();
        List printFormTemplates = (List)this.getReportParameters().get("Selected Templates");
        for (SponsorFormTemplate sponsorFormTemplate : printFormTemplates) {
            SponsorFormTemplate sponsorTemplate = (SponsorFormTemplate)this.getBusinessObjectService().findBySinglePrimaryKey(SponsorFormTemplate.class, (Object)sponsorFormTemplate.getSponsorFormTemplateId());
            sourceMap.put(sponsorFormTemplate.getPageDescription(), new StreamSource(new ByteArrayInputStream(sponsorTemplate.getAttachmentContent())));
        }
        return sourceMap;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ProposalDevelopmentXmlStream getProposalDevelopmentXmlStream() {
        return this.proposalDevelopmentXmlStream;
    }

    public void setProposalDevelopmentXmlStream(ProposalDevelopmentXmlStream proposalDevelopmentXmlStream) {
        this.proposalDevelopmentXmlStream = proposalDevelopmentXmlStream;
    }

    @Override
    public Map<String, XmlObject> renderXML() throws PrintingException {
        DevelopmentProposal developmentProposal = (DevelopmentProposal)this.getPrintableBusinessObject();
        if (developmentProposal.getSponsorCode().equals(this.getProposalParameterValue(LOCAL_PRINT_FORM_SPONSOR_CODE))) {
            this.setXmlStream(this.proposalDevelopmentXmlStream);
        } else {
            this.setXmlStream(this.nihResearchAndRelatedXmlStream);
        }
        return super.renderXML();
    }

    private String getProposalParameterValue(String param) {
        return this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, param);
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public NIHResearchAndRelatedXmlStream getNihResearchAndRelatedXmlStream() {
        return this.nihResearchAndRelatedXmlStream;
    }

    public void setNihResearchAndRelatedXmlStream(NIHResearchAndRelatedXmlStream nihResearchAndRelatedXmlStream) {
        this.nihResearchAndRelatedXmlStream = nihResearchAndRelatedXmlStream;
    }
}

