/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.person;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.multicampus.MultiCampusIdentityService;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.person.attr.PersonAppointment;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.identity.entity.EntityContract;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.impl.identity.employment.EntityEmploymentBo;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.lookup.CollectionIncomplete;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="kcPersonService")
public class KcPersonServiceImpl
implements KcPersonService {
    private static final String ACTIVE = "active";
    private static final String PRIMARY = "primary";
    private static final String PRIMARY_DEPARTMENT_CODE = "primaryDepartmentCode";
    private static final String UNIT_NUMBER = "unitNumber";
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="identityService")
    private IdentityService identityService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="multiCampusIdentityService")
    private MultiCampusIdentityService multiCampusIdentityService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;

    @Override
    public void modifyFieldValues(Map<String, String> fieldValues) {
        boolean multiCampusEnabled = this.parameterService.getParameterValueAsBoolean("KC-GEN", "All", "MULTI_CAMPUS_ENABLED");
        if (StringUtils.isNotBlank((CharSequence)fieldValues.get("userName"))) {
            String userNameSearchValue = fieldValues.get("userName");
            if (multiCampusEnabled) {
                String campusCode = fieldValues.get("campusCode");
                userNameSearchValue = this.multiCampusIdentityService.getMultiCampusPrincipalName(userNameSearchValue, campusCode);
            }
            fieldValues.put("principalName", userNameSearchValue);
        }
        if (StringUtils.isNotBlank((CharSequence)fieldValues.get("personId"))) {
            String personIdSearchValue = fieldValues.get("personId");
            fieldValues.put("principalId", personIdSearchValue);
        }
        if (StringUtils.isNotBlank((CharSequence)fieldValues.get("officePhone"))) {
            String officePhoneSerachValue = fieldValues.get("officePhone");
            fieldValues.put("phoneNumber", officePhoneSerachValue);
        }
        if (StringUtils.isNotBlank((CharSequence)fieldValues.get("organizationIdentifier"))) {
            String primaryDeptCodeSearchValue = fieldValues.get("organizationIdentifier");
            fieldValues.put(PRIMARY_DEPARTMENT_CODE, primaryDeptCodeSearchValue);
        }
    }

    @Override
    public KcPerson getKcPersonByUserName(String userName) {
        KcPerson person = null;
        if (StringUtils.isEmpty((CharSequence)userName)) {
            throw new IllegalArgumentException("the userName is null or empty");
        }
        boolean multiCampusEnabled = this.parameterService.getParameterValueAsBoolean("KC-GEN", "All", "MULTI_CAMPUS_ENABLED");
        if (multiCampusEnabled && this.globalVariableService.getUserSession() != null) {
            String campusCode = (String)this.globalVariableService.getUserSession().retrieveObject("userCampusCode");
            String multiCampusUserName = this.multiCampusIdentityService.getMultiCampusPrincipalName(userName, campusCode);
            Entity entity = this.identityService.getEntityByPrincipalName(multiCampusUserName);
            if (entity != null) {
                person = KcPerson.fromEntityAndUserName((EntityContract)entity, multiCampusUserName);
            }
        } else {
            Entity entity = this.identityService.getEntityByPrincipalName(userName);
            if (entity != null) {
                person = KcPerson.fromEntityAndUserName((EntityContract)entity, userName);
            }
        }
        return person;
    }

    @Override
    public KcPerson getKcPersonByPersonId(String personId) {
        if (StringUtils.isEmpty((CharSequence)personId)) {
            throw new IllegalArgumentException("the personId is null or empty");
        }
        return KcPerson.fromEntityAndPersonId((EntityContract)this.identityService.getEntityByPrincipalId(personId), personId);
    }

    @Override
    public List<KcPerson> createKcPersonsFromPeople(List<Person> people) {
        CollectionIncomplete persons = new ArrayList();
        if (people instanceof CollectionIncomplete) {
            persons = new CollectionIncomplete(new ArrayList(), ((CollectionIncomplete)people).getActualSizeIfTruncated());
        }
        for (Person person : people) {
            if (!person.getEntityTypeCode().equals("PERSON")) continue;
            persons.add(KcPerson.fromPersonId(person.getPrincipalId()));
        }
        return persons;
    }

    @Override
    public Map<String, Set<String>> findPersonAppointmentUnits(Collection<String> activeUnits) {
        return this.getBusinessObjectService().findMatching(PersonAppointment.class, Map.of(UNIT_NUMBER, activeUnits)).stream().collect(Collectors.groupingBy(PersonAppointment::getPersonId, Collectors.mapping(PersonAppointment::getUnitNumber, Collectors.toSet())));
    }

    @Override
    public Map<String, Set<String>> findPersonEmploymentUnits(Collection<String> activeUnits, boolean primary) {
        return this.getDataObjectService().findMatching(EntityEmploymentBo.class, QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)ACTIVE, (Object)true), PredicateFactory.equal((String)PRIMARY, (Object)primary), PredicateFactory.in((String)PRIMARY_DEPARTMENT_CODE, activeUnits)})).getResults().stream().flatMap(emp -> {
            List principals = this.identityService.getPrincipalsByEntityId(emp.getEntityId());
            return (principals != null ? principals.stream() : Stream.empty()).filter(Principal::isActive).map(Principal::getPrincipalId).map(principalId -> CollectionUtils.entry(principalId, emp.getPrimaryDepartmentCode()));
        }).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toSet())));
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setMultiCampusIdentityService(MultiCampusIdentityService multiCampusIdentityService) {
        this.multiCampusIdentityService = multiCampusIdentityService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public MultiCampusIdentityService getMultiCampusIdentityService() {
        return this.multiCampusIdentityService;
    }
}

