/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.resilience;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.ehcache.impl.internal.resilience.AbstractResilienceStrategy;
import org.ehcache.spi.resilience.RecoveryStore;
import org.ehcache.spi.resilience.StoreAccessException;

public class RobustResilienceStrategy<K, V>
extends AbstractResilienceStrategy<K, V> {
    public RobustResilienceStrategy(RecoveryStore<K> store) {
        super(store);
    }

    public V getFailure(K key, StoreAccessException e) {
        this.cleanup(key, e);
        return null;
    }

    public boolean containsKeyFailure(K key, StoreAccessException e) {
        this.cleanup(key, e);
        return false;
    }

    public void putFailure(K key, V value, StoreAccessException e) {
        this.cleanup(key, e);
    }

    public void removeFailure(K key, StoreAccessException e) {
        this.cleanup(key, e);
    }

    public void clearFailure(StoreAccessException e) {
        this.cleanup(e);
    }

    public V putIfAbsentFailure(K key, V value, StoreAccessException e) {
        this.cleanup(key, e);
        return null;
    }

    public boolean removeFailure(K key, V value, StoreAccessException e) {
        this.cleanup(key, e);
        return false;
    }

    public V replaceFailure(K key, V value, StoreAccessException e) {
        this.cleanup(key, e);
        return null;
    }

    public boolean replaceFailure(K key, V value, V newValue, StoreAccessException e) {
        this.cleanup(key, e);
        return false;
    }

    public Map<K, V> getAllFailure(Iterable<? extends K> keys, StoreAccessException e) {
        this.cleanup(keys, e);
        HashMap<K, Object> result = keys instanceof Collection ? new HashMap<K, Object>(((Collection)keys).size()) : new HashMap();
        for (K key : keys) {
            result.put(key, null);
        }
        return result;
    }

    public void putAllFailure(Map<? extends K, ? extends V> entries, StoreAccessException e) {
        this.cleanup(entries.keySet(), e);
    }

    public void removeAllFailure(Iterable<? extends K> keys, StoreAccessException e) {
        this.cleanup(keys, e);
    }
}

