/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.ui.browser;

import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.ScriptSessions;
import org.directwebremoting.extend.CallbackHelperFactory;
import org.directwebremoting.ui.Callback;

public class Window {
    private static final Log log = LogFactory.getLog(Window.class);

    public static void alert(String message) {
        ScriptSessions.addFunctionCall("alert", message);
    }

    public static void confirm(String message, Callback<Boolean> callback) {
        ScriptBuffer script = new ScriptBuffer();
        String callbackPrefix = "";
        if (callback != null) {
            callbackPrefix = "var reply = ";
        }
        script.appendCall(callbackPrefix + "confirm", message);
        if (callback != null) {
            String key = CallbackHelperFactory.get().saveCallback(callback, Boolean.class);
            script.appendCall("__System.activateCallback", key, "reply");
        }
        ScriptSessions.addScript(script);
    }

    public static void prompt(String message, Callback<String> callback) {
        ScriptBuffer script = new ScriptBuffer();
        String callbackPrefix = "";
        if (callback != null) {
            callbackPrefix = "var reply = ";
        }
        script.appendCall(callbackPrefix + "prompt", message);
        if (callback != null) {
            String key = CallbackHelperFactory.get().saveCallback(callback, String.class);
            script.appendCall("__System.activateCallback", key, "reply");
        }
        ScriptSessions.addScript(script);
    }

    public static void close() {
        ScriptSessions.addFunctionCall("close", new Object[0]);
    }

    public static void setLocation(URI newPage) {
        Window.setLocation(newPage.toASCIIString());
    }

    public static void setLocation(URL newPage) {
        Window.setLocation(newPage.toExternalForm());
    }

    public static void setLocation(String newPage) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendData("window.location = '" + newPage + "';");
        ScriptSessions.addScript(script);
    }

    public static void open(String url, String windowName) {
        ScriptSessions.addFunctionCall("open", url, windowName);
    }

    public static void open(URL url, String windowName) {
        Window.open(url.toExternalForm(), windowName);
    }

    public static void open(URI uri, String windowName) {
        Window.open(uri.toASCIIString(), windowName);
    }

    public static void open(String url, String windowName, OptionBuilder builder) {
        ScriptSessions.addFunctionCall("open", url, windowName, builder.createWindowFeatures());
    }

    public static void open(URL url, String windowName, OptionBuilder builder) {
        Window.open(url.toExternalForm(), windowName, builder);
    }

    public static void open(URI uri, String windowName, OptionBuilder builder) {
        Window.open(uri.toASCIIString(), windowName, builder);
    }

    public static class OptionBuilder {
        private final Map<String, Object> options = new HashMap<String, Object>();

        public OptionBuilder() {
            this.addOption("menubar", true);
            this.addOption("toolbar", true);
            this.addOption("location", true);
            this.addOption("status", true);
        }

        public OptionBuilder left(int value) {
            return this.addOption("left", value);
        }

        public OptionBuilder top(int value) {
            return this.addOption("top", value);
        }

        public OptionBuilder height(int value) {
            if (value < 100) {
                log.warn((Object)"Setting height < 100 will fail in some browsers");
            }
            return this.addOption("height", value);
        }

        public OptionBuilder width(int value) {
            if (value < 100) {
                log.warn((Object)"Setting width < 100 will fail in some browsers");
            }
            return this.addOption("width", value);
        }

        public OptionBuilder hideMenubar() {
            return this.addOption("menubar", false);
        }

        public OptionBuilder hideToolbar() {
            return this.addOption("toolbar", false);
        }

        public OptionBuilder hideLocation() {
            return this.addOption("location", false);
        }

        public OptionBuilder hideStatus() {
            return this.addOption("status", false);
        }

        public OptionBuilder notResizable() {
            return this.addOption("resizable", false);
        }

        public OptionBuilder hideScrollbars() {
            return this.addOption("scrollbars", false);
        }

        private OptionBuilder addOption(String name, Object value) {
            this.options.put(name, value);
            return this;
        }

        protected String createWindowFeatures() {
            StringBuilder reply = new StringBuilder();
            for (Map.Entry<String, Object> entry : this.options.entrySet()) {
                if (reply.length() > 0) {
                    reply.append(',');
                }
                reply.append(entry.getKey());
                reply.append("=");
                reply.append(entry.getValue());
            }
            return reply.toString();
        }
    }
}

