/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.hr.impl;

import org.kuali.coeus.hr.impl.Employment;
import org.kuali.coeus.hr.impl.PersistableBoMergeAdapter;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kim.impl.identity.employment.EntityEmploymentBo;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.springframework.stereotype.Component;

@Component(value="entityEmploymentBoAdapter")
public class EntityEmploymentBoAdapter
extends PersistableBoMergeAdapter<EntityEmploymentBo, Employment> {
    @Override
    public int compareBOProperties(EntityEmploymentBo emp0, EntityEmploymentBo emp1) {
        int comp = this.nullSafeCompare(emp0.getEmployeeId(), emp1.getEmployeeId());
        if (comp != 0) {
            return comp;
        }
        comp = this.nullSafeCompare(emp0.getEmployeeStatusCode(), emp1.getEmployeeStatusCode());
        if (comp != 0) {
            return comp;
        }
        comp = this.nullSafeCompare(emp0.getEmployeeTypeCode(), emp1.getEmployeeTypeCode());
        if (comp != 0) {
            return comp;
        }
        comp = this.nullSafeCompare(emp0.getPrimaryDepartmentCode(), emp1.getPrimaryDepartmentCode());
        if (comp != 0) {
            return comp;
        }
        KualiDecimal emp0Base = emp0.getBaseSalaryAmount();
        KualiDecimal emp1Base = emp1.getBaseSalaryAmount();
        if (emp0Base == null && emp1Base != null) {
            return -1;
        }
        if (emp0Base != null && emp1Base == null) {
            return 1;
        }
        comp = emp0Base != null && emp1Base != null ? emp0.getBaseSalaryAmount().compareTo((AbstractKualiDecimal)emp1.getBaseSalaryAmount()) : 0;
        if (comp != 0) {
            return comp;
        }
        return comp;
    }

    @Override
    public EntityEmploymentBo newBO(String entityId) {
        EntityEmploymentBo empl = new EntityEmploymentBo();
        empl.setEntityId(entityId);
        return empl;
    }

    @Override
    public Class<EntityEmploymentBo> getBusinessObjectClass() {
        return EntityEmploymentBo.class;
    }

    @Override
    public Class<Employment> getIncomingClass() {
        return Employment.class;
    }

    @Override
    public EntityEmploymentBo setFields(EntityEmploymentBo bo, Employment source) {
        bo.setActive(true);
        bo.setBaseSalaryAmount(new KualiDecimal((double)source.getBaseSalaryAmount()));
        bo.setEmployeeId(source.getEmployeeId());
        bo.setEmployeeStatusCode(source.getEmployeeStatus());
        bo.setEmployeeTypeCode(source.getEmployeeType());
        bo.setPrimary(source.isPrimaryEmployment());
        bo.setPrimaryDepartmentCode(source.getPrimaryDepartment());
        bo.setEntityAffiliationId(source.getEntityAffiliationId());
        return bo;
    }

    @Override
    public EntityEmploymentBo setFields(int index, EntityEmploymentBo bo, Employment source) {
        if (bo.getEmploymentRecordId() == null) {
            bo.setEmploymentRecordId(Integer.toString(index));
        }
        return this.setFields(bo, source);
    }

    @Override
    public EntityEmploymentBo save(int index, LegacyDataAdapter legacyDataAdapter, EntityEmploymentBo bo) {
        if (bo.getEmploymentRecordId() == null) {
            bo.setEmploymentRecordId(Integer.toString(index));
        }
        return (EntityEmploymentBo)legacyDataAdapter.save((Object)bo);
    }

    @Override
    public void delete(LegacyDataAdapter legacyDataAdapter, EntityEmploymentBo bo) {
        legacyDataAdapter.delete((Object)bo);
    }
}

