/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.sponsor.hierarchy.SponsorHierarchy;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministrator;
import org.kuali.coeus.common.framework.version.VersionStatusConstants;
import org.kuali.coeus.common.impl.krms.KcKrmsJavaFunctionTermServiceBase;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyService;
import org.kuali.kra.award.contacts.AwardUnitContact;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardComment;
import org.kuali.kra.award.home.AwardSponsorTerm;
import org.kuali.kra.award.notesandattachments.attachments.AwardAttachment;
import org.kuali.kra.award.service.AwardJavaFunctionKrmsTermService;
import org.kuali.kra.award.specialreview.AwardSpecialReview;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class AwardJavaFunctionKrmsTermServiceImpl
extends KcKrmsJavaFunctionTermServiceBase
implements AwardJavaFunctionKrmsTermService {
    @Autowired
    @Qualifier(value="awardHierarchyService")
    private AwardHierarchyService awardHierarchyService;
    @Autowired
    @Qualifier(value="unitService")
    private UnitService unitService;

    public AwardHierarchyService getAwardHierarchyService() {
        return this.awardHierarchyService;
    }

    public void setAwardHierarchyService(AwardHierarchyService awardHierarchyService) {
        this.awardHierarchyService = awardHierarchyService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    @Override
    public Boolean checkCommentEntered(Award award, String commentTypeCode) {
        if (commentTypeCode != null && commentTypeCode.equalsIgnoreCase("null")) {
            commentTypeCode = null;
        }
        for (AwardComment comment : award.getAwardComments()) {
            if (!StringUtils.equals((CharSequence)comment.getCommentTypeCode(), (CharSequence)commentTypeCode) || !StringUtils.isNotBlank((CharSequence)comment.getComments())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean hasSpecialReviewOfType(Award award, String specialReviewType) {
        return award.getSpecialReviews().stream().anyMatch(awardReview -> this.doesSpecialReviewMatch((AwardSpecialReview)awardReview, specialReviewType));
    }

    public boolean doesSpecialReviewMatch(AwardSpecialReview specialReview, String specialReviewType) {
        return StringUtils.equals((CharSequence)specialReview.getSpecialReviewTypeCode(), (CharSequence)specialReviewType) || specialReview.getSpecialReviewType() != null && StringUtils.equals((CharSequence)specialReview.getSpecialReviewType().getDescription(), (CharSequence)specialReviewType);
    }

    @Override
    public Boolean awardPersonnelTotalEffort(Award award, String effortToMatch) {
        ScaleTwoDecimal effort = this.convertToScaleTwoDecimal(effortToMatch);
        return award.getProjectPersons().size() == 0 ? Boolean.FALSE.booleanValue() : award.getProjectPersons().stream().anyMatch(person -> Objects.equals(person.getTotalEffort(), effort));
    }

    @Override
    public Boolean awardPersonnelCalendarEffort(Award award, String effortToMatch) {
        ScaleTwoDecimal effort = this.convertToScaleTwoDecimal(effortToMatch);
        return award.getProjectPersons().size() == 0 ? Boolean.FALSE.booleanValue() : award.getProjectPersons().stream().anyMatch(person -> Objects.equals(person.getCalendarYearEffort(), effort));
    }

    @Override
    public Boolean awardCommentsRule(Award award, String comments, String commentTypeCode) {
        String commentOfSameType = this.getCommentOfType(commentTypeCode, award);
        return commentOfSameType == null && comments.equalsIgnoreCase("null") || StringUtils.equalsIgnoreCase((CharSequence)comments, (CharSequence)commentOfSameType);
    }

    private String getCommentOfType(String commentTypeCode, Award award) {
        AwardComment awardComment = award.getAwardComments().stream().filter(comment -> StringUtils.equals((CharSequence)comment.getCommentTypeCode(), (CharSequence)commentTypeCode)).findFirst().orElse(null);
        return awardComment == null ? null : awardComment.getComments();
    }

    protected ScaleTwoDecimal convertToScaleTwoDecimal(String effortToMatch) {
        ScaleTwoDecimal effort = effortToMatch.equalsIgnoreCase("null") || StringUtils.isEmpty((CharSequence)effortToMatch) ? null : new ScaleTwoDecimal(effortToMatch);
        return effort;
    }

    @Override
    public Boolean specialReviewAndApprovalTypeRule(Award award, String specialReviewTypeCode, String approvalTypeCode) {
        List<AwardSpecialReview> specialReviews = award.getSpecialReviews();
        return this.specialReviewTypeCodeAndApprovalTypeCodeMatch(specialReviews, specialReviewTypeCode, approvalTypeCode);
    }

    @Override
    public String monitoredSponsorRule(Award award, String monitoredSponsorHierarchies) {
        String[] sponsoredHierarchyArray = this.buildArrayFromCommaList(monitoredSponsorHierarchies);
        Map<String, List<String>> fieldValues = Map.of("hierarchyName", Arrays.asList(sponsoredHierarchyArray));
        if (this.getBusinessObjectService().findMatching(SponsorHierarchy.class, fieldValues).stream().anyMatch(sh -> StringUtils.equalsIgnoreCase((CharSequence)sh.getSponsorCode(), (CharSequence)award.getSponsorCode()) || award.getPrimeSponsor() != null && StringUtils.equalsIgnoreCase((CharSequence)sh.getSponsorCode(), (CharSequence)award.getPrimeSponsorCode()))) {
            return "true";
        }
        return "false";
    }

    @Override
    public String sponsorTypeRule(Award award, String sponsorTypeCode) {
        if (StringUtils.equals((CharSequence)award.getSponsor().getSponsorTypeCode(), (CharSequence)sponsorTypeCode)) {
            return "true";
        }
        return "false";
    }

    @Override
    public String primeSponsorTypeRule(Award award, String primeSponsorTypeCode) {
        if (award.getPrimeSponsor() != null) {
            if (StringUtils.equals((CharSequence)award.getPrimeSponsor().getSponsorTypeCode(), (CharSequence)primeSponsorTypeCode)) {
                return "true";
            }
            return "false";
        }
        return "false";
    }

    @Override
    public Boolean checkCFDAEntered(Award award) {
        return !award.getAwardCfdas().isEmpty();
    }

    @Override
    public Boolean checkAnticipatedEqualsObligatedCostRule(Award award) {
        if (award.getObligatedTotalDirect().compareTo((AbstractDecimal)award.getAnticipatedTotalDirect()) != 0) {
            return false;
        }
        if (award.getObligatedTotalIndirect().compareTo((AbstractDecimal)award.getAnticipatedTotalIndirect()) != 0) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean sponsorTermIdRule(Award award, String termIds) {
        String[] termIdsArray;
        for (String termId : termIdsArray = this.buildArrayFromCommaList(termIds)) {
            try {
                long term = Long.parseLong(termId);
                for (AwardSponsorTerm sat : award.getAwardSponsorTerms()) {
                    if (!sat.getSponsorTermId().equals(term)) continue;
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public Integer fundingProposalRule(Award award) {
        return award.getAllFundingProposals().size();
    }

    @Override
    public Boolean obligationStartEndExistsRule(Award award) {
        return award.getLatestAwardAmountInfo().getCurrentFundEffectiveDate() != null && award.getLatestAwardAmountInfo().getObligationExpirationDate() != null;
    }

    @Override
    public Boolean unitContactTypeRule(Award award, String adminContactTypeCodes) {
        String[] adminContactTypeCodesArray;
        for (String adminContactTypeCode : adminContactTypeCodesArray = this.buildArrayFromCommaList(adminContactTypeCodes)) {
            for (AwardUnitContact awardUnitContact : award.getAwardUnitContacts()) {
                if (!StringUtils.equals((CharSequence)awardUnitContact.getUnitAdministratorTypeCode(), (CharSequence)adminContactTypeCode)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Boolean attachmentTypeRule(Award award, String attachmentTypeCode) {
        List<AwardAttachment> attachments = award.getAwardAttachments();
        for (AwardAttachment attachment : attachments) {
            if (!StringUtils.equals((CharSequence)attachment.getTypeCode(), (CharSequence)attachmentTypeCode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Integer hierarchyLevel(Award award) {
        AwardHierarchy rootAwardHierarchy = this.getAwardHierarchyService().loadFullHierarchyFromAnyNode(award.getAwardNumber());
        Map<String, AwardHierarchy> hierarchy = this.getAwardHierarchyService().getAwardHierarchy(rootAwardHierarchy, new ArrayList<String>());
        AwardHierarchy thisNode = hierarchy.get(award.getAwardNumber());
        return this.countParents(thisNode);
    }

    private Integer countParents(AwardHierarchy awardHierarchy) {
        if (awardHierarchy == null) {
            return 0;
        }
        if (StringUtils.equals((CharSequence)awardHierarchy.getParentAwardNumber(), (CharSequence)"000000-00000")) {
            return 0;
        }
        return 1 + this.countParents(awardHierarchy.getParent());
    }

    @Override
    public Boolean uniqueSponsorAwardIdByHierarchy(Award award) {
        if (StringUtils.isEmpty((CharSequence)award.getSponsorAwardNumber())) {
            return true;
        }
        String awardPrefix = this.getAwardNumberPrefix(award.getAwardNumber());
        Map<String, String> fieldValues = Map.of("sponsorAwardNumber", award.getSponsorAwardNumber());
        return this.getBusinessObjectService().findMatching(Award.class, fieldValues).stream().noneMatch(a -> !StringUtils.equals((CharSequence)awardPrefix, (CharSequence)this.getAwardNumberPrefix(a.getAwardNumber())) && !StringUtils.equals((CharSequence)a.getAwardSequenceStatus(), (CharSequence)VersionStatusConstants.CANCELED.getCode()));
    }

    private String getAwardNumberPrefix(String awardNumber) {
        return awardNumber.substring(0, 6);
    }

    @Override
    public Boolean monitoredUnitRule(Award award, String unitAdministratorTypes) {
        if (award == null || StringUtils.isEmpty((CharSequence)award.getUnitNumber()) || StringUtils.isEmpty((CharSequence)unitAdministratorTypes)) {
            return false;
        }
        List<String> unitAdminTypesArray = List.of(this.buildArrayFromCommaList(unitAdministratorTypes));
        for (String unitAdministratorType : unitAdminTypesArray) {
            List<UnitAdministrator> results = this.unitService.retrieveUnitAdministratorsByUnitNumberAndType(award.getUnitNumber(), unitAdministratorType);
            if (results == null || results.size() <= 0) continue;
            return true;
        }
        return false;
    }
}

