/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.lifecycle;

import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.lifecycle.BaseLifecycle;
import org.kuali.rice.core.api.lifecycle.Lifecycle;

public abstract class BaseCompositeLifecycle
extends BaseLifecycle {
    private static final Logger LOG = LogManager.getLogger(BaseCompositeLifecycle.class);
    private List<Lifecycle> lifecycles;

    protected abstract List<Lifecycle> loadLifecycles() throws Exception;

    @Override
    public void start() throws Exception {
        this.lifecycles = this.loadLifecycles();
        for (Lifecycle lifecycle : this.lifecycles) {
            lifecycle.start();
        }
        super.start();
    }

    @Override
    public void stop() throws Exception {
        for (Lifecycle lifecycle : this.reverseLifecycles()) {
            try {
                lifecycle.stop();
            }
            catch (Throwable t) {
                LOG.error("Failed to stop Lifecycle: " + lifecycle.getClass().getName(), t);
            }
        }
        super.stop();
    }

    private List<Lifecycle> reverseLifecycles() {
        LinkedList<Lifecycle> reversed = new LinkedList<Lifecycle>();
        for (Lifecycle lifecycle : this.lifecycles) {
            reversed.addFirst(lifecycle);
        }
        return reversed;
    }
}

