/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.instprop.impl.coi;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.coi.framework.AbstractProjectRetrievalService;
import org.kuali.coeus.coi.framework.PersonType;
import org.kuali.coeus.coi.framework.Project;
import org.kuali.coeus.coi.framework.ProjectPerson;
import org.kuali.coeus.coi.framework.ProjectSponsor;
import org.kuali.coeus.coi.framework.ProjectTypeCode;
import org.kuali.coeus.coi.framework.Versionedproject;
import org.springframework.stereotype.Component;

@Component(value="instPropProjectRetrievalService")
public class InstPropProjectRetrievalServiceImpl
extends AbstractProjectRetrievalService {
    private static final String IP_ALL_HIGHEST_SEQUENCE_QUERY = "SELECT PROPOSAL_NUMBER, MAX(SEQUENCE_NUMBER) maxseq FROM PROPOSAL WHERE PROPOSAL_SEQUENCE_STATUS = 'ACTIVE' or PROPOSAL_SEQUENCE_STATUS='PENDING' GROUP BY PROPOSAL_NUMBER";
    private static final String IP_ALL_PROJECT_QUERY = "SELECT t.TITLE, t.PROPOSAL_ID, t.STATUS_CODE, t.REQUESTED_START_DATE_INITIAL, t.REQUESTED_END_DATE_INITIAL, t.SPONSOR_CODE, u.SPONSOR_NAME, t.PROPOSAL_NUMBER, t.SEQUENCE_NUMBER, t.PRIME_SPONSOR_CODE, p.SPONSOR_NAME, t.NOTICE_OF_OPPORTUNITY_CODE, n.DESCRIPTION, t.SPONSOR_PROPOSAL_NUMBER, u.SPONSOR_TYPE_CODE, st.DESCRIPTION as SPONSOR_TYPE_DESCRIPTION, pst.SPONSOR_TYPE_CODE as PRIME_SPONSOR_TYPE_CODE, pst.DESCRIPTION as PRIME_SPONSOR_TYPE_DESCRIPTION, t.AWARD_TYPE_CODE, at.DESCRIPTION as AWARD_TYPE_DESCRIPTION FROM (SELECT PROPOSAL_NUMBER, MAX(SEQUENCE_NUMBER) maxseq FROM PROPOSAL WHERE PROPOSAL_SEQUENCE_STATUS = 'ACTIVE' or PROPOSAL_SEQUENCE_STATUS='PENDING' GROUP BY PROPOSAL_NUMBER) x INNER JOIN PROPOSAL t ON t.PROPOSAL_NUMBER = x.PROPOSAL_NUMBER and t.SEQUENCE_NUMBER = x.maxseq LEFT OUTER JOIN SPONSOR u ON t.SPONSOR_CODE = u.SPONSOR_CODE LEFT OUTER JOIN SPONSOR p ON t.PRIME_SPONSOR_CODE = p.SPONSOR_CODE LEFT OUTER JOIN NOTICE_OF_OPPORTUNITY n ON t.NOTICE_OF_OPPORTUNITY_CODE = n.NOTICE_OF_OPPORTUNITY_CODE LEFT OUTER JOIN SPONSOR_TYPE st ON u.SPONSOR_TYPE_CODE = st.SPONSOR_TYPE_CODE LEFT OUTER JOIN SPONSOR_TYPE pst ON p.SPONSOR_TYPE_CODE = pst.SPONSOR_TYPE_CODE LEFT OUTER JOIN AWARD_TYPE at ON t.AWARD_TYPE_CODE = at.AWARD_TYPE_CODE ";
    private static final String IP_ALL_PROJECT_PERSON_QUERY = "SELECT t.PROPOSAL_ID, t.PERSON_ID, t.ROLODEX_ID, t.CONTACT_ROLE_CODE, t.PROPOSAL_NUMBER, t.SEQUENCE_NUMBER FROM (SELECT PROPOSAL_NUMBER, MAX(SEQUENCE_NUMBER) maxseq FROM PROPOSAL WHERE PROPOSAL_SEQUENCE_STATUS = 'ACTIVE' or PROPOSAL_SEQUENCE_STATUS='PENDING' GROUP BY PROPOSAL_NUMBER) x INNER JOIN PROPOSAL_PERSONS t ON t.PROPOSAL_NUMBER = x.PROPOSAL_NUMBER and t.SEQUENCE_NUMBER = x.maxseq";
    private static final String IP_PROJECT_QUERY = "SELECT t.TITLE, t.PROPOSAL_ID, t.STATUS_CODE, t.REQUESTED_START_DATE_INITIAL, t.REQUESTED_END_DATE_INITIAL, t.SPONSOR_CODE, u.SPONSOR_NAME, t.PROPOSAL_NUMBER, t.SEQUENCE_NUMBER, t.PRIME_SPONSOR_CODE, p.SPONSOR_NAME, t.NOTICE_OF_OPPORTUNITY_CODE, n.DESCRIPTION, t.SPONSOR_PROPOSAL_NUMBER, u.SPONSOR_TYPE_CODE, st.DESCRIPTION as SPONSOR_TYPE_DESCRIPTION, pst.SPONSOR_TYPE_CODE as PRIME_SPONSOR_TYPE_CODE, pst.DESCRIPTION as PRIME_SPONSOR_TYPE_DESCRIPTION, t.AWARD_TYPE_CODE, at.DESCRIPTION as AWARD_TYPE_DESCRIPTION FROM (SELECT PROPOSAL_NUMBER, MAX(SEQUENCE_NUMBER) maxseq FROM PROPOSAL WHERE PROPOSAL_SEQUENCE_STATUS = 'ACTIVE' or PROPOSAL_SEQUENCE_STATUS='PENDING' GROUP BY PROPOSAL_NUMBER) x INNER JOIN PROPOSAL t ON t.PROPOSAL_NUMBER = x.PROPOSAL_NUMBER and t.SEQUENCE_NUMBER = x.maxseq LEFT OUTER JOIN SPONSOR u ON t.SPONSOR_CODE = u.SPONSOR_CODE LEFT OUTER JOIN SPONSOR p ON t.PRIME_SPONSOR_CODE = p.SPONSOR_CODE LEFT OUTER JOIN NOTICE_OF_OPPORTUNITY n ON t.NOTICE_OF_OPPORTUNITY_CODE = n.NOTICE_OF_OPPORTUNITY_CODE LEFT OUTER JOIN SPONSOR_TYPE st ON u.SPONSOR_TYPE_CODE = st.SPONSOR_TYPE_CODE LEFT OUTER JOIN SPONSOR_TYPE pst ON p.SPONSOR_TYPE_CODE = pst.SPONSOR_TYPE_CODE LEFT OUTER JOIN AWARD_TYPE at ON t.AWARD_TYPE_CODE = at.AWARD_TYPE_CODE  WHERE t.PROPOSAL_NUMBER = ?";
    private static final String IP_PROJECT_PERSON_QUERY = "SELECT t.PROPOSAL_ID, t.PERSON_ID, t.ROLODEX_ID, t.CONTACT_ROLE_CODE, t.PROPOSAL_NUMBER, t.SEQUENCE_NUMBER FROM (SELECT PROPOSAL_NUMBER, MAX(SEQUENCE_NUMBER) maxseq FROM PROPOSAL WHERE PROPOSAL_SEQUENCE_STATUS = 'ACTIVE' or PROPOSAL_SEQUENCE_STATUS='PENDING' GROUP BY PROPOSAL_NUMBER) x INNER JOIN PROPOSAL_PERSONS t ON t.PROPOSAL_NUMBER = x.PROPOSAL_NUMBER and t.SEQUENCE_NUMBER = x.maxseq WHERE t.PROPOSAL_NUMBER = ?";
    private static final String CREATED_DATE_QUERY = "select CRTE_DT from KREW_DOC_HDR_T where DOC_HDR_ID =(select DOCUMENT_NUMBER from PROPOSAL where PROPOSAL_NUMBER = ? and SEQUENCE_NUMBER = '1')";

    @Override
    public Project convertObjectToProject(Versionedproject versionedproject) throws SQLException {
        return null;
    }

    @Override
    public String getCreatedDateQuery() {
        return CREATED_DATE_QUERY;
    }

    @Override
    protected Project toProject(ResultSet rs) throws SQLException {
        Project project = new Project();
        project.setTitle(rs.getString(1));
        project.setTypeCode(ProjectTypeCode.INSTITUTIONAL_PROPOSAL.getId());
        project.setSourceSystem("KC-IP");
        String sourceIdentifier = rs.getString(8);
        project.setSourceIdentifier(sourceIdentifier);
        project.setSourceStatus(rs.getString(3));
        project.setStartDate(rs.getDate(4));
        project.setEndDate(rs.getDate(5));
        project.setPrimeSponsorCode(rs.getString(10));
        project.setPrimeSponsorName(rs.getString(11));
        project.setPrimeSponsorTypeCode(rs.getString(17));
        project.setPrimeSponsorTypeDescription(rs.getString(18));
        project.setAwardTypeCode(rs.getString(19));
        project.setAwardTypeDescription(rs.getString(20));
        project.setNoticeOfOpportunityCode(rs.getString(12));
        project.setNoticeOfOpportunityDescription(rs.getString(13));
        project.setSponsorProjectId(rs.getString(14));
        project.setShortUrl(this.getBaseShortUrl() + "/kc-common/proposals/" + sourceIdentifier);
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("sourceUniqueIdentifier", rs.getString(2));
        project.setMetadata(metadata);
        this.setSponsorFields(Collections.singletonList(new ProjectSponsor("KC-IP", sourceIdentifier, rs.getString(6), rs.getString(7), new HashMap<String, String>(metadata), rs.getString(15), rs.getString(16))), project);
        if (this.getParameterService().getParameterValueAsBoolean("KC-SYS", "All", "Linked_Project_Push_Enabled").booleanValue()) {
            project.setLinkedProjects(this.getLinkedProjects(this.getMedusaService().getMedusaByProposal("IP", rs.getLong(2)).get(0)));
        }
        project.setCreatedOn(this.getCreatedDate(sourceIdentifier));
        return project;
    }

    @Override
    protected ProjectPerson toProjectPerson(ResultSet rs) throws SQLException {
        ProjectPerson person = new ProjectPerson();
        person.setSourceSystem("KC-IP");
        person.setSourceIdentifier(rs.getString(5));
        String personId = rs.getString(2);
        String rolodexId = rs.getString(3);
        person.setPersonId(StringUtils.isNotBlank((CharSequence)personId) ? personId : rolodexId);
        person.setSourcePersonType(StringUtils.isNotBlank((CharSequence)personId) ? PersonType.EMPLOYEE.toString() : PersonType.NONEMPLOYEE.toString());
        person.setRoleCode(rs.getString(4));
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("sourceUniqueIdentifier", rs.getString(1));
        person.setMetadata(metadata);
        return person;
    }

    @Override
    protected String allProjectQuery() {
        return IP_ALL_PROJECT_QUERY;
    }

    @Override
    protected String allProjectPersonQuery() {
        return IP_ALL_PROJECT_PERSON_QUERY;
    }

    @Override
    protected String projectQuery() {
        return IP_PROJECT_QUERY;
    }

    @Override
    protected String projectPersonQuery() {
        return IP_PROJECT_PERSON_QUERY;
    }
}

