/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterables;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.api.pdf.PdfService;
import org.kuali.coeus.common.api.pdf.dto.ActionDto;
import org.kuali.coeus.common.api.pdf.dto.AttachmentPutActionDto;
import org.kuali.coeus.common.api.pdf.dto.GenerateXmlActionDto;
import org.kuali.coeus.common.api.pdf.dto.JobDto;
import org.kuali.coeus.common.api.pdf.dto.LinkDto;
import org.kuali.coeus.common.api.pdf.dto.MapActionDto;
import org.kuali.coeus.common.api.pdf.dto.MapAndGenerateXmlDto;
import org.kuali.coeus.common.api.pdf.dto.MapAndGenerateXmlResponseDto;
import org.kuali.coeus.common.api.pdf.dto.MappingDefinitionDto;
import org.kuali.coeus.common.api.pdf.dto.MessageDto;
import org.kuali.coeus.common.api.pdf.dto.SingleTargetAction;
import org.kuali.coeus.common.api.pdf.dto.Status;
import org.kuali.coeus.common.api.pdf.dto.XfaPutActionDto;
import org.kuali.coeus.common.api.pdf.dto.XmlSchemaQNameDto;
import org.kuali.coeus.common.budget.impl.modular.ModularBudgetCommunicationException;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.s2s.S2sUserAttachedFormContract;
import org.kuali.coeus.propdev.api.s2s.S2sUserAttachedFormFileContract;
import org.kuali.coeus.propdev.api.s2s.UserAttachedFormService;
import org.kuali.coeus.propdev.impl.auth.ProposalDevelopmentDocumentAuthorizer;
import org.kuali.coeus.propdev.impl.auth.ProposalDevelopmentDocumentViewAuthorizer;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentControllerBase;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentForm;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentViewHelperServiceImpl;
import org.kuali.coeus.propdev.impl.s2s.S2sAppSubmission;
import org.kuali.coeus.propdev.impl.s2s.S2sApplication;
import org.kuali.coeus.propdev.impl.s2s.S2sOppForms;
import org.kuali.coeus.propdev.impl.s2s.S2sOpportunity;
import org.kuali.coeus.propdev.impl.s2s.S2sOpportunityCfda;
import org.kuali.coeus.propdev.impl.s2s.S2sUserAttachedForm;
import org.kuali.coeus.propdev.impl.s2s.S2sUserAttachedFormService;
import org.kuali.coeus.propdev.impl.s2s.connect.S2sCommunicationException;
import org.kuali.coeus.propdev.impl.s2s.map.Project;
import org.kuali.coeus.propdev.impl.s2s.map.S2sMappingService;
import org.kuali.coeus.propdev.impl.s2s.nih.NihSubmissionImageService;
import org.kuali.coeus.propdev.impl.s2s.override.S2sOverride;
import org.kuali.coeus.propdev.impl.s2s.override.S2sOverrideApplicationData;
import org.kuali.coeus.propdev.impl.s2s.override.S2sOverrideAttachment;
import org.kuali.coeus.s2sgen.api.core.AuditError;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.api.generate.FormGenerationResults;
import org.kuali.coeus.s2sgen.api.generate.FormGeneratorService;
import org.kuali.coeus.s2sgen.api.print.FormPrintResult;
import org.kuali.coeus.s2sgen.api.print.FormPrintService;
import org.kuali.coeus.sys.api.model.KcFile;
import org.kuali.coeus.sys.framework.controller.ControllerFileUtils;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.xml.SafeXmlUtils;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewPostMetadata;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.RefreshControllerService;
import org.kuali.rice.krad.web.service.impl.CollectionControllerServiceImpl;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Controller
public class ProposalDevelopmentS2SController
extends ProposalDevelopmentControllerBase
implements InitializingBean {
    private static final Logger LOG = LogManager.getLogger(ProposalDevelopmentS2SController.class);
    private static final String CONTENT_TYPE_XML = "text/xml";
    private static final String CONTENT_TYPE_PDF = "application/pdf";
    private static final String GRANTS_GOV_FORM_VALIDATION_ERRORS = "grantsGovFormValidationErrors";
    private static final String CURRENT_GRANT_APPLICATION_XML = "Current Grant Application.xml";
    private static final String OVERRRIDDEN_GRANT_APPLICATION_XML = "Overridden Grant Application.xml";
    private static final String ERROR_NO_GRANTS_GOV_FORM_SELECTED = "error.proposalDevelopment.no.grants.gov.form.selected";
    private static final String ERROR_NO_GRANTS_GOV_FORM_SELECTED_SUPPORTED = "error.proposalDevelopment.no.grants.gov.form.selected.supported";
    private static final String GG_LOBBYING_FORM_V_1_1 = "http://apply.grants.gov/forms/GG_LobbyingForm-V1.1";
    private static final String GG_LOBBYING_FORM_V_1_1_LOCAL_PART = "LobbyingForm";
    private static final String CD_511_V_1_1 = "http://apply.grants.gov/forms/CD511-V1.1";
    private static final String CD_511_V_1_1_LOCAL_PART = "CD511";
    private static final String SF_424_SHORT_V_1_1 = "http://apply.grants.gov/forms/SF424_Short_1_1-V1.1";
    private static final String SF_424_SHORT_V_1_1_LOCAL_PART = "SF424_Short_1_1";
    private static final String PHS398_COVERPAGE_SUPPLEMENT_5_0 = "http://apply.grants.gov/forms/PHS398_CoverPageSupplement_5_0-V5.0";
    private static final String PHS398_COVERPAGE_SUPPLEMENT_5_0_LOCAL_PART = "PHS398_CoverPageSupplement_5_0";
    private static final String RR_SF424_V_2_0 = "http://apply.grants.gov/forms/RR_SF424_2_0-V2.0";
    private static final String RR_SF424_V_2_0_LOCAL_PART = "RR_SF424_2_0";
    private static final String XML_VALIDATION_ERROR = "xml.validation.error";
    private Map<String, Form> mappings;
    @Value(value="classpath:org/kuali/coeus/propdev/impl/s2s/map/cfg/CD511-V1.1.json")
    private Resource cd51111Mapping;
    @Value(value="classpath:org/kuali/coeus/propdev/impl/s2s/map/cfg/GG_LobbyingForm-V1.1.json")
    private Resource ggLobbyingForm11Mapping;
    @Value(value="classpath:org/kuali/coeus/propdev/impl/s2s/map/cfg/SF424_Short-V1.1.json")
    private Resource sf424Short11Mapping;
    @Value(value="classpath:org/kuali/coeus/propdev/impl/s2s/map/cfg/PHS398_CoverPageSupplement_5_0-V5.0.json")
    private Resource phs398CoverPageSupplementMapping;
    @Value(value="classpath:org/kuali/coeus/propdev/impl/s2s/map/cfg/RR_SF424_2_0-V2.0.json")
    private Resource rrSf42420Mapping;
    @Value(value="classpath:org/kuali/coeus/propdev/impl/s2s/map/form/CD511-V1.1.pdf")
    private Resource cd51111Form;
    @Value(value="classpath:org/kuali/coeus/propdev/impl/s2s/map/form/GG_LobbyingForm-V1.1.pdf")
    private Resource ggLobbyingForm11Form;
    @Value(value="classpath:org/kuali/coeus/propdev/impl/s2s/map/form/SF424_Short-V1.1.pdf")
    private Resource sf424Short11Form;
    @Value(value="classpath:org/kuali/coeus/propdev/impl/s2s/map/form/PHS398_CoverPageSupplement_5_0-V5.0.pdf")
    private Resource phs398CoverPageSupplementForm;
    @Value(value="classpath:org/kuali/coeus/propdev/impl/s2s/map/form/RR_SF424_2_0-V2.0.pdf")
    private Resource rrSf42420Form;
    private List<Resource> schemas;
    @Autowired
    @Qualifier(value="refreshControllerService")
    private RefreshControllerService refreshControllerService;
    @Autowired
    @Qualifier(value="s2sUserAttachedFormService")
    private S2sUserAttachedFormService s2sUserAttachedFormService;
    @Autowired
    @Qualifier(value="userAttachedFormService")
    private UserAttachedFormService userAttachedFormService;
    @Autowired
    @Qualifier(value="formPrintService")
    private FormPrintService formPrintService;
    @Autowired
    @Qualifier(value="proposalDevelopmentDocumentViewAuthorizer")
    private ProposalDevelopmentDocumentViewAuthorizer proposalDevelopmentDocumentViewAuthorizer;
    @Autowired
    @Qualifier(value="formGeneratorService")
    private FormGeneratorService formGeneratorService;
    @Autowired
    @Qualifier(value="nihSubmissionImageService")
    private NihSubmissionImageService nihSubmissionImageService;
    @Autowired
    @Qualifier(value="dateTimeService")
    private DateTimeService dateTimeService;
    @Autowired
    @Qualifier(value="s2sMappingService")
    private S2sMappingService s2sMappingService;
    @Autowired
    @Qualifier(value="pdfService")
    private PdfService pdfService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="pdfObjectMapper")
    private ObjectMapper objectMapper;

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=refresh", "refreshCaller=S2sOpportunity-LookupView"})
    public ModelAndView refresh(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentDocument document = form.getProposalDevelopmentDocument();
        DevelopmentProposal proposal = document.getDevelopmentProposal();
        if (form.getNewS2sOpportunity() != null && StringUtils.isNotEmpty((CharSequence)form.getNewS2sOpportunity().getOpportunityId())) {
            proposal.setS2sOpportunity(form.getNewS2sOpportunity());
            proposal.getS2sOpportunity().setDevelopmentProposal(proposal);
            if (StringUtils.isBlank((CharSequence)form.getNewS2sOpportunity().getS2sSubmissionTypeCode())) {
                String defaultS2sSubmissionTypeCode = this.getProposalTypeService().getDefaultSubmissionTypeCode(proposal.getProposalTypeCode());
                proposal.getS2sOpportunity().setS2sSubmissionTypeCode(defaultS2sSubmissionTypeCode);
                this.getDataObjectService().wrap((Object)proposal.getS2sOpportunity()).fetchRelationship("s2sSubmissionType");
            }
            proposal.updateFromS2sOpportunity(form.getNewS2sOpportunity());
            form.setNewS2sOpportunity(new S2sOpportunity());
        }
        this.setAndValidateMandatoryForms(proposal);
        super.save(form, result, request, response);
        proposal.refreshNihOpportunity();
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=clearOpportunity"})
    public ModelAndView clearOpportunity(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        ((ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService()).clearOpportunity(form.getDevelopmentProposal());
        form.getDevelopmentProposal().refreshNihOpportunity();
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=printFormsXml"})
    public ModelAndView printFormsXml(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, HttpServletResponse response) throws Exception {
        form.getDevelopmentProposal().setGrantsGovSelectFlag(true);
        return this.printForms(form, response);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=retrieveGrantApplicationXml"})
    public ModelAndView retrieveGrantApplicationXml(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, HttpServletResponse response) throws Exception {
        S2sAppSubmission submission = form.getDisplayedS2sAppSubmission();
        if (submission != null && submission.getS2sApplication() != null) {
            S2sApplication application = submission.getS2sApplication();
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();
                 StringReader in = new StringReader(application.getApplication());){
                Transformer tf = SafeXmlUtils.safeTransformerFactory().newTransformer();
                tf.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
                tf.setOutputProperty("indent", "yes");
                org.w3c.dom.Document doc = SafeXmlUtils.safeDocumentBuilderFactory().newDocumentBuilder().parse(new InputSource(in));
                tf.transform(new DOMSource(doc), new StreamResult(out));
                ControllerFileUtils.streamOutputToResponse(response, out, application.getContentType(), application.getName(), out.size());
            }
        }
        return null;
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=retrieveGrantApplicationZip"})
    public ModelAndView retrieveGrantApplicationZip(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, HttpServletResponse response) {
        ProposalDevelopmentDocument document = form.getProposalDevelopmentDocument();
        Optional.of(document.getDevelopmentProposal().getDisplayedS2sAppSubmission()).ifPresent(submission -> {
            if (StringUtils.isNotBlank((CharSequence)submission.getGgApplicationZipFileId())) {
                try {
                    ControllerFileUtils.streamToResponse(submission.getGgApplicationZipData(), "Grant Submission.zip", "application/octet-stream", response);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else if (submission.getGgTrackingId() != null) {
                this.getS2sSubmissionService().getApplicationZip(document.getDevelopmentProposal().getS2sOpportunity(), (S2sAppSubmission)submission).ifPresent(file -> {
                    if (ArrayUtils.isNotEmpty((byte[])file.getData())) {
                        submission.setGgApplicationZipData(file.getData());
                        this.getDataObjectService().save(submission, new PersistenceOption[]{PersistenceOption.FLUSH});
                        try {
                            ControllerFileUtils.streamToResponse(file, response);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
        });
        return null;
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=printForms"})
    public ModelAndView printForms(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, HttpServletResponse response) throws Exception {
        FormPrintResult formPrintResult;
        ProposalDevelopmentDocument proposalDevelopmentDocument = form.getProposalDevelopmentDocument();
        this.proposalDevelopmentDocumentViewAuthorizer.initializeDocumentAuthorizerIfNecessary((Document)form.getProposalDevelopmentDocument());
        if (!((ProposalDevelopmentDocumentAuthorizer)this.proposalDevelopmentDocumentViewAuthorizer.getDocumentAuthorizer()).isAuthorizedToPrint((Document)proposalDevelopmentDocument, this.getGlobalVariableService().getUserSession().getPerson())) {
            throw new AuthorizationException(this.getGlobalVariableService().getUserSession().getPrincipalName(), "printForms", "Proposal");
        }
        if (proposalDevelopmentDocument.getDevelopmentProposal().getSelectedS2sOppForms().isEmpty()) {
            this.getGlobalVariableService().getMessageMap().putError("noKey", ERROR_NO_GRANTS_GOV_FORM_SELECTED, new String[0]);
            return this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        if (form.getDevelopmentProposal().getS2sOpportunity().isUsePdfService()) {
            return this.printNewForms(form, response);
        }
        try {
            formPrintResult = this.getFormPrintService().printForm((ProposalDevelopmentDocumentContract)proposalDevelopmentDocument);
        }
        catch (ModularBudgetCommunicationException e) {
            LOG.error("Error communicating with standalone Budget service", (Throwable)e);
            this.getGlobalVariableService().getMessageMap().putError("noField", "error.standalone.budget.communication.error", new String[0]);
            return this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        this.setValidationErrorMessage(formPrintResult.getErrors());
        KcFile attachmentDataSource = formPrintResult.getFile();
        if ((attachmentDataSource == null || attachmentDataSource.getData() == null || attachmentDataSource.getData().length == 0) && !proposalDevelopmentDocument.getDevelopmentProposal().getGrantsGovSelectFlag().booleanValue() || CollectionUtils.isNotEmpty((Collection)formPrintResult.getErrors())) {
            boolean grantsGovErrorExists = this.copyAuditErrorsToPage();
            if (grantsGovErrorExists) {
                this.getGlobalVariableService().getMessageMap().putError(GRANTS_GOV_FORM_VALIDATION_ERRORS, "validation.errors.before.grantsGov.submission", new String[0]);
            }
            proposalDevelopmentDocument.getDevelopmentProposal().setGrantsGovSelectFlag(false);
            return this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        if (proposalDevelopmentDocument.getDevelopmentProposal().getGrantsGovSelectFlag().booleanValue()) {
            File grantsGovXmlDirectoryFile = this.getS2sSubmissionService().getGrantsGovSavedFile(proposalDevelopmentDocument.getDevelopmentProposal());
            byte[] bytes = new byte[(int)grantsGovXmlDirectoryFile.length()];
            FileInputStream fileInputStream = new FileInputStream(grantsGovXmlDirectoryFile);
            fileInputStream.read(bytes);
            int size = bytes.length;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(size);){
                outputStream.write(bytes);
                ControllerFileUtils.streamOutputToResponse(response, outputStream, "binary/octet-stream", grantsGovXmlDirectoryFile.getName(), size);
                response.flushBuffer();
            }
            proposalDevelopmentDocument.getDevelopmentProposal().setGrantsGovSelectFlag(false);
            return this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        ControllerFileUtils.streamToResponse(attachmentDataSource, response);
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    public ModelAndView printNewForms(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, HttpServletResponse response) throws IOException, ParserConfigurationException {
        ProposalDevelopmentDocument proposalDevelopmentDocument = form.getProposalDevelopmentDocument();
        Set selectedFormNamespaces = proposalDevelopmentDocument.getDevelopmentProposal().getSelectedS2sOppForms().stream().map(S2sOppForms::getOppNameSpace).collect(Collectors.toSet());
        Set notSupportedForms = selectedFormNamespaces.stream().filter(formNameSpace -> !this.mappings.containsKey(formNameSpace)).collect(Collectors.toSet());
        if (notSupportedForms.size() > 0) {
            notSupportedForms.stream().forEach(formName -> {
                LOG.warn("The user tried to print the form " + formName + " which doesn't have a mapping available to use thru the PDF service.");
                this.getGlobalVariableService().getMessageMap().putWarning("noField", "error.s2s.form.not.available", new String[]{formName});
            });
            return this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        Project project = this.s2sMappingService.toProject(proposalDevelopmentDocument);
        Boolean foundError = false;
        org.w3c.dom.Document document = this.getNewXmlDocument();
        Element rootElement = document.createElement("xml-fragment");
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ModelAndView modelAndView;
            ZipOutputStream zos;
            block24: {
                block23: {
                    zos = new ZipOutputStream(baos);
                    try {
                        for (String formNameSpace2 : selectedFormNamespaces) {
                            String formName2 = this.getFormNameFromNamespace(formNameSpace2);
                            Form currentForm = this.mappings.get(formNameSpace2);
                            String name = formName2 + ".pdf";
                            try {
                                MappedFileResult mappedFileResult;
                                MappedFileResult mappedFileResult2 = mappedFileResult = form.getDevelopmentProposal().getGrantsGovSelectFlag() != false ? this.getMappedXmlFromPdfService(currentForm, project) : this.getMappedFileFromPdfService(currentForm, project);
                                if (mappedFileResult.isValid()) {
                                    if (form.getDevelopmentProposal().getGrantsGovSelectFlag().booleanValue()) {
                                        rootElement.appendChild(document.importNode(this.getXmlDocument(mappedFileResult.getXml()).getFirstChild(), true));
                                        continue;
                                    }
                                    ZipEntry zipEntry = new ZipEntry(name);
                                    zos.putNextEntry(zipEntry);
                                    zos.write(mappedFileResult.getFile());
                                    zos.closeEntry();
                                    continue;
                                }
                                mappedFileResult.getXmlValidationWarnings().stream().forEach(xmlValidationWarning -> this.getGlobalVariableService().getMessageMap().putError("noField", "validation.error.s2s.generating.mapped.file", new String[]{formName2, xmlValidationWarning}));
                                mappedFileResult.getErrors().stream().forEach(error -> this.getGlobalVariableService().getMessageMap().putError("noField", "error.s2s.generating.mapped.file", new String[]{formName2, error}));
                                foundError = true;
                            }
                            catch (IOException | HttpClientErrorException | HttpServerErrorException e) {
                                LOG.error("Error communicating with the PDF service.", e);
                                this.getGlobalVariableService().getMessageMap().putError("noField", "error.s2s.communication.pdf.service", new String[0]);
                                foundError = true;
                            }
                            catch (SAXException e) {
                                LOG.error("Error parsing XML from the PDF Service.", (Throwable)e);
                                this.getGlobalVariableService().getMessageMap().putError("noField", "error.s2s.communication.pdf.service", new String[0]);
                                foundError = true;
                            }
                        }
                        if (!foundError.booleanValue()) break block23;
                        modelAndView = this.getModelAndViewService().getModelAndView((UifFormBase)form);
                    }
                    catch (Throwable throwable) {
                        try {
                            zos.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    zos.close();
                    return modelAndView;
                }
                if (!form.getDevelopmentProposal().getGrantsGovSelectFlag().booleanValue()) break block24;
                form.getDevelopmentProposal().setGrantsGovSelectFlag(false);
                document.appendChild(rootElement);
                try {
                    ZipEntry zipEntry = new ZipEntry("all_forms.xml");
                    zos.putNextEntry(zipEntry);
                    zos.write(this.getByteArrayFromDocument(document));
                    zos.closeEntry();
                }
                catch (TransformerException e) {
                    LOG.error("Error transforming XML to a file.", (Throwable)e);
                    this.getGlobalVariableService().getMessageMap().putError("noField", "error.s2s.communication.pdf.service", new String[0]);
                    ModelAndView modelAndView2 = this.getModelAndViewService().getModelAndView((UifFormBase)form);
                    zos.close();
                    baos.close();
                    return modelAndView2;
                }
            }
            zos.flush();
            zos.finish();
            ControllerFileUtils.streamOutputToResponse(response, baos, "application/zip", proposalDevelopmentDocument.getDevelopmentProposal().getProposalNumber() + "_package.zip", baos.size());
            modelAndView = null;
            zos.close();
            return modelAndView;
        }
    }

    private org.w3c.dom.Document getXmlDocument(byte[] xml) throws ParserConfigurationException, IOException, SAXException {
        org.w3c.dom.Document document;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try (ByteArrayInputStream bais = new ByteArrayInputStream(xml);){
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            document = builder.parse(bais);
        }
        return document;
    }

    private org.w3c.dom.Document getNewXmlDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbf.newDocumentBuilder();
        return builder.newDocument();
    }

    private byte[] getByteArrayFromDocument(org.w3c.dom.Document document) throws IOException, TransformerException {
        Transformer tf = TransformerFactory.newInstance().newTransformer();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            tf.transform(new DOMSource(document), new StreamResult(baos));
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=previewPackage"})
    public ModelAndView previewPackage(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, HttpServletResponse response) throws Exception {
        ProposalDevelopmentDocument proposalDevelopmentDocument = form.getProposalDevelopmentDocument();
        this.proposalDevelopmentDocumentViewAuthorizer.initializeDocumentAuthorizerIfNecessary((Document)form.getProposalDevelopmentDocument());
        if (!((ProposalDevelopmentDocumentAuthorizer)this.proposalDevelopmentDocumentViewAuthorizer.getDocumentAuthorizer()).isAuthorizedToPrint((Document)proposalDevelopmentDocument, this.getGlobalVariableService().getUserSession().getPerson())) {
            throw new AuthorizationException(this.getGlobalVariableService().getUserSession().getPrincipalName(), "printForms", "Proposal");
        }
        Set selectedForms = proposalDevelopmentDocument.getDevelopmentProposal().getSelectedS2sOppForms().stream().map(S2sOppForms::getOppNameSpace).collect(Collectors.toSet());
        Map toPrint = this.mappings.entrySet().stream().filter(supportedForm -> selectedForms.contains(supportedForm.getKey())).collect(org.kuali.coeus.sys.framework.util.CollectionUtils.entriesToMap());
        if (toPrint.isEmpty()) {
            this.getGlobalVariableService().getMessageMap().putError("noKey", ERROR_NO_GRANTS_GOV_FORM_SELECTED_SUPPORTED, new String[]{this.mappings.keySet().stream().map(s -> this.getFormNameFromNamespace((String)s)).collect(Collectors.joining(", "))});
            return this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        S2sOpportunity opp = proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ZipOutputStream zos = new ZipOutputStream(baos);){
            ZipEntry oZipEntry;
            byte[] file;
            String name;
            Object file2;
            StringBuilder manifest = new StringBuilder();
            manifest.append("Manifest for Grant Application Preview");
            manifest.append("\n");
            manifest.append("\n");
            manifest.append("Proposal Number: ");
            manifest.append(opp.getProposalNumber());
            manifest.append("\n");
            if (opp.getOpeningDate() != null) {
                manifest.append("Opening Date: ");
                manifest.append(this.dateTimeService.toDateTimeString(opp.getOpeningDate().getTime()));
                manifest.append("\n");
            }
            if (opp.getClosingDate() != null) {
                manifest.append("Closing Date: ");
                manifest.append(this.dateTimeService.toDateTimeString(opp.getClosingDate().getTime()));
                manifest.append("\n");
            }
            manifest.append("Competition Id: ");
            manifest.append(StringUtils.defaultString((String)opp.getCompetitionId()));
            manifest.append("\n");
            manifest.append("Competition Title: ");
            manifest.append(StringUtils.defaultString((String)opp.getCompetitionTitle()));
            manifest.append("\n");
            manifest.append("Package Id: ");
            manifest.append(StringUtils.defaultString((String)opp.getPackageId()));
            manifest.append("\n");
            manifest.append("Instruction Url: ");
            manifest.append(StringUtils.defaultString((String)opp.getInstructionUrl()));
            manifest.append("\n");
            manifest.append("Opportunity Id: ");
            manifest.append(StringUtils.defaultString((String)opp.getOpportunityId()));
            manifest.append("\n");
            manifest.append("Opportunity Title: ");
            manifest.append(StringUtils.defaultString((String)opp.getOpportunityTitle()));
            manifest.append("\n");
            manifest.append("CFDA Numbers: ");
            manifest.append(opp.getS2sOpportunityCfdas().stream().map(S2sOpportunityCfda::getCfdaNumber).collect(Collectors.joining(", ")));
            manifest.append("\n");
            if (opp.getS2sRevisionType() != null) {
                manifest.append("Revision Type: ");
                manifest.append(opp.getS2sRevisionType().getCode());
                manifest.append(" - ");
                manifest.append(StringUtils.defaultString((String)opp.getS2sRevisionType().getDescription()));
                manifest.append("\n");
            }
            manifest.append("Revision Other Description: ");
            manifest.append(StringUtils.defaultString((String)opp.getRevisionOtherDescription()));
            manifest.append("\n");
            if (opp.getS2sSubmissionType() != null) {
                manifest.append("Submission Type: ");
                manifest.append(opp.getS2sSubmissionType().getCode());
                manifest.append(" - ");
                manifest.append(StringUtils.defaultString((String)opp.getS2sSubmissionType().getDescription()));
                manifest.append("\n");
            }
            manifest.append("Schema Url: ");
            manifest.append(StringUtils.defaultString((String)opp.getSchemaUrl()));
            manifest.append("\n");
            manifest.append("Offering Agency: ");
            manifest.append(StringUtils.defaultString((String)opp.getOfferingAgency()));
            manifest.append("\n");
            manifest.append("Agency Contact Information: ");
            manifest.append(StringUtils.defaultString((String)opp.getAgencyContactInfo()));
            manifest.append("\n");
            if (opp.isMultiProject()) {
                manifest.append("Multi Project: ");
                manifest.append(opp.isMultiProject());
                manifest.append("\n");
                manifest.append("Component Type: ");
                manifest.append(StringUtils.defaultString((String)opp.getComponentType()));
                manifest.append("\n");
                manifest.append("Overall Schema Url: ");
                manifest.append(StringUtils.defaultString((String)opp.getOverallSchemaUrl()));
                manifest.append("\n");
            }
            manifest.append("\n");
            manifest.append(String.format("Empty Forms (total %s): ", toPrint.size()));
            manifest.append("\n");
            manifest.append("\n");
            int fcnt = 1;
            for (Map.Entry entry : toPrint.entrySet()) {
                String string = this.getFormNameFromNamespace((String)entry.getKey()) + ".pdf";
                byte[] file3 = ((Form)entry.getValue()).form.getInputStream().readAllBytes();
                manifest.append(String.format("%s. %s %s (size %s bytes)", fcnt, string, ((Form)entry.getValue()).namespace, file3.length));
                manifest.append("\n");
                ZipEntry zipEntry = new ZipEntry("empty_forms/" + string);
                zos.putNextEntry(zipEntry);
                zos.write(file3);
                zos.closeEntry();
                ++fcnt;
            }
            manifest.append("\n");
            manifest.append(String.format("Form Mappings (total %s): ", toPrint.size()));
            manifest.append("\n");
            manifest.append("\n");
            int mcnt = 1;
            for (Map.Entry entry : toPrint.entrySet()) {
                String name3 = this.getFormNameFromNamespace((String)entry.getKey()) + ".json";
                file2 = ((Form)entry.getValue()).mapping.getInputStream().readAllBytes();
                manifest.append(String.format("%s. %s %s (size %s bytes)", mcnt, name3, ((Form)entry.getValue()).namespace, ((byte[])file2).length));
                manifest.append("\n");
                ZipEntry zipEntry = new ZipEntry("form_mappings/" + name3);
                zos.putNextEntry(zipEntry);
                zos.write((byte[])file2);
                zos.closeEntry();
                ++mcnt;
            }
            Project project = this.s2sMappingService.toProject(proposalDevelopmentDocument);
            String string = this.objectMapper.writeValueAsString((Object)project);
            manifest.append("\n");
            manifest.append(String.format("Filled Forms (total %s): ", toPrint.size()));
            manifest.append("\n");
            manifest.append("\n");
            int ffcnt = 1;
            file2 = toPrint.entrySet().iterator();
            while (file2.hasNext()) {
                Map.Entry e = (Map.Entry)file2.next();
                String name4 = this.getFormNameFromNamespace((String)e.getKey()) + "_filled.pdf";
                try {
                    MappedFileResult mappedFileResult = this.getMappedFileFromPdfService((Form)e.getValue(), project);
                    if (mappedFileResult.isValid()) {
                        manifest.append(String.format("%s. %s %s (size %s bytes)", ffcnt, name4, ((Form)e.getValue()).namespace, mappedFileResult.getFile().length));
                        manifest.append("\n");
                        ZipEntry zipEntry = new ZipEntry("filled_forms/" + name4);
                        zos.putNextEntry(zipEntry);
                        zos.write(mappedFileResult.getFile());
                        zos.closeEntry();
                        ++ffcnt;
                        continue;
                    }
                    manifest.append("\n");
                    manifest.append(String.format("There was a problem getting the mapped file for %s from the PDF Service.\n", name4));
                    if (mappedFileResult.getXmlValidationWarnings().size() > 0) {
                        manifest.append("XML Validation:\n");
                        manifest.append(mappedFileResult.getXmlValidationWarnings().stream().collect(Collectors.joining("\n")));
                    }
                    if (mappedFileResult.getErrors().size() > 0) {
                        manifest.append("Errors:\n");
                        manifest.append(mappedFileResult.getErrors().stream().collect(Collectors.joining("\n")));
                    }
                    manifest.append("\n");
                }
                catch (Exception exception) {
                    manifest.append("\n");
                    manifest.append(String.format("There was a problem getting the mapped file for %s from the PDF Service.", name4));
                    manifest.append(exception.getMessage());
                    manifest.append("\n");
                }
            }
            manifest.append("\n");
            manifest.append(String.format("Project schemas (total %s): ", this.schemas.size()));
            manifest.append("\n");
            manifest.append("\n");
            int scnt = 1;
            for (Resource r : this.schemas) {
                String name5 = r.getFilename();
                byte[] file4 = r.getInputStream().readAllBytes();
                manifest.append(String.format("%s. %s (size %s bytes)", scnt, name5, file4.length));
                manifest.append("\n");
                ZipEntry zipEntry = new ZipEntry("project_schemas/" + name5);
                zos.putNextEntry(zipEntry);
                zos.write(file4);
                zos.closeEntry();
                ++scnt;
            }
            String projectName = "projectData.json";
            byte[] projectFile = string.getBytes();
            manifest.append("\n");
            manifest.append(String.format("Project Data (total %s): ", 1));
            manifest.append("\n");
            manifest.append("\n");
            manifest.append(String.format("%s. %s (size %s bytes)", 1, "projectData.json", projectFile.length));
            manifest.append("\n");
            ZipEntry pZipEntry = new ZipEntry("projectData.json");
            zos.putNextEntry(pZipEntry);
            zos.write(projectFile);
            zos.closeEntry();
            if (StringUtils.isNotBlank((CharSequence)opp.getOpportunity()) && StringUtils.isNotBlank((CharSequence)opp.getSchemaUrl())) {
                name = opp.getSchemaUrl().substring(opp.getSchemaUrl().lastIndexOf(47) + 1);
                file = opp.getOpportunity().getBytes();
                manifest.append("\n");
                manifest.append(String.format("Opportunity Schema (total %s): ", 1));
                manifest.append("\n");
                manifest.append("\n");
                manifest.append(String.format("%s. %s (size %s bytes)", 1, name, file.length));
                manifest.append("\n");
                oZipEntry = new ZipEntry(name);
                zos.putNextEntry(oZipEntry);
                zos.write(file);
                zos.closeEntry();
            }
            if (StringUtils.isNotBlank((CharSequence)opp.getOverallSchema()) && StringUtils.isNotBlank((CharSequence)opp.getOverallSchemaUrl())) {
                name = opp.getSchemaUrl().substring(opp.getOverallSchemaUrl().lastIndexOf(47) + 1);
                file = opp.getOverallSchema().getBytes();
                manifest.append("\n");
                manifest.append(String.format("Overall Opportunity Schema (total %s): ", 1));
                manifest.append("\n");
                manifest.append("\n");
                manifest.append(String.format("%s. %s (size %s bytes)", 1, name, file.length));
                manifest.append("\n");
                oZipEntry = new ZipEntry(name);
                zos.putNextEntry(oZipEntry);
                zos.write(file);
                zos.closeEntry();
            }
            manifest.append("\n");
            manifest.append("\n");
            manifest.append("Generated By: ");
            manifest.append(this.getGlobalVariableService().getUserSession().getPrincipalName());
            manifest.append(" at ");
            manifest.append(this.dateTimeService.toDateTimeString((Date)this.dateTimeService.getCurrentTimestamp()));
            manifest.append("\n");
            ZipEntry mZipEntry = new ZipEntry("manifest.txt");
            zos.putNextEntry(mZipEntry);
            zos.write(manifest.toString().getBytes());
            zos.closeEntry();
            zos.flush();
            zos.finish();
            ControllerFileUtils.streamOutputToResponse(response, baos, "application/zip", "package.zip", baos.size());
        }
        return null;
    }

    private MappedFileResult getMappedFileFromPdfService(Form form, Project project) throws IOException {
        List mappings = (List)this.objectMapper.readValue(form.getMapping().getURL(), (TypeReference)new TypeReference<List<MappingDefinitionDto>>(){});
        Map mapInput = (Map)this.objectMapper.convertValue((Object)project, (TypeReference)new TypeReference<Map<String, Object>>(){});
        JobDto job = new JobDto().addActionsItem(new MapActionDto().mappings(mappings).input(mapInput).actionId("map")).addActionsItem(new GenerateXmlActionDto().fieldActionSource(new LinkDto().url("action://{$jobId}/map/0")).fieldActions(Collections.emptyMap()).schemas(Collections.emptyList()).actionId("genX").type(new XmlSchemaQNameDto().namespaceURI(form.getNamespace()).localPart(form.getLocalPart()))).addActionsItem(new XfaPutActionDto().xfaDataSource(new LinkDto().url("action://{$jobId}/genX/0")).source(new LinkDto().url(this.getPdfUrl(form.getForm().getFilename())).method(HttpMethod.GET.name())).actionId("xfaPut")).addActionsItem(new AttachmentPutActionDto().source(new LinkDto().url("action://{$jobId}/xfaPut/0")).attachmentActionSource(new LinkDto().url("action://{$jobId}/map/0")).showAttachments(false));
        JobDto pdfServiceResponse = this.getPdfService().submitAndAwaitJob(job);
        String formName = this.getFormNameFromNamespace(form.getNamespace());
        ArrayList<String> errors = new ArrayList<String>();
        byte[] file = null;
        byte[] xml = null;
        List<String> xmlValidationWarnings = pdfServiceResponse.getActions().stream().flatMap(action -> action.getMessages().stream()).filter(message -> message.getKey().equals(XML_VALIDATION_ERROR)).map(MessageDto::getMessage).distinct().collect(Collectors.toList());
        if (pdfServiceResponse.getStatus() != Status.SUCCESS) {
            errors.addAll(pdfServiceResponse.getMessages().stream().filter(MessageDto::isError).map(MessageDto::getMessage).collect(Collectors.toList()));
            errors.addAll(pdfServiceResponse.getActions().stream().flatMap(action -> action.getMessages().stream()).filter(MessageDto::isError).map(MessageDto::getMessage).collect(Collectors.toList()));
            LOG.error(this.objectMapper.writeValueAsString((Object)pdfServiceResponse));
        } else {
            URL fileTargetUrl = new URL(((SingleTargetAction)Iterables.getLast(pdfServiceResponse.getActions())).getTarget().getUrl());
            file = IOUtils.toByteArray((URL)fileTargetUrl);
            Optional<ActionDto> xmlAction = pdfServiceResponse.getActions().stream().filter(actionDto -> actionDto.getActionId().equals("genX")).findFirst();
            if (xmlAction.isPresent()) {
                URL xmlTargetUrl = new URL(((SingleTargetAction)((Object)xmlAction.get())).getTarget().getUrl());
                xml = IOUtils.toByteArray((URL)xmlTargetUrl);
            }
        }
        return new MappedFileResult(formName, errors.isEmpty() && xmlValidationWarnings.isEmpty(), file, xml, errors, xmlValidationWarnings);
    }

    private MappedFileResult getMappedXmlFromPdfService(Form form, Project project) throws IOException {
        List mappings = (List)this.objectMapper.readValue(form.getMapping().getURL(), (TypeReference)new TypeReference<List<MappingDefinitionDto>>(){});
        Map mapInput = (Map)this.objectMapper.convertValue((Object)project, (TypeReference)new TypeReference<Map<String, Object>>(){});
        MapAndGenerateXmlDto mapAndGenerateXmlDto = new MapAndGenerateXmlDto().mappings(mappings).input(mapInput).schemas(Collections.emptyList()).type(new XmlSchemaQNameDto().namespaceURI(form.getNamespace()).localPart(form.getLocalPart()));
        MapAndGenerateXmlResponseDto pdfServiceResponse = this.getPdfService().mapAndGenerateXml(mapAndGenerateXmlDto);
        String formName = this.getFormNameFromNamespace(form.getNamespace());
        byte[] xml = null;
        List<String> errors = pdfServiceResponse.getMessages().stream().filter(MessageDto::isError).map(MessageDto::getMessage).collect(Collectors.toList());
        List<String> xmlValidationWarnings = pdfServiceResponse.getMessages().stream().filter(message -> message.getKey().equals(XML_VALIDATION_ERROR)).map(MessageDto::getMessage).distinct().collect(Collectors.toList());
        if (!errors.isEmpty()) {
            LOG.error(this.objectMapper.writeValueAsString((Object)pdfServiceResponse));
        } else {
            xml = pdfServiceResponse.getXml().getBytes();
        }
        return new MappedFileResult(formName, errors.isEmpty() && xmlValidationWarnings.isEmpty(), null, xml, errors, xmlValidationWarnings);
    }

    private String getFormNameFromNamespace(String namespace) {
        return namespace.substring(namespace.lastIndexOf(47) + 1);
    }

    private String getPdfUrl(String filename) {
        return this.configurationService.getPropertyValueAsString("application.http.scheme") + "://" + this.configurationService.getPropertyValueAsString("application.host") + this.configurationService.getPropertyValueAsString("kra.externalizable.pdfs.url") + filename;
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=printNIHForms"})
    public ModelAndView printNIHForms(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, HttpServletResponse response) throws Exception {
        ProposalDevelopmentDocument proposalDevelopmentDocument = form.getProposalDevelopmentDocument();
        this.proposalDevelopmentDocumentViewAuthorizer.initializeDocumentAuthorizerIfNecessary((Document)form.getProposalDevelopmentDocument());
        if (!((ProposalDevelopmentDocumentAuthorizer)this.proposalDevelopmentDocumentViewAuthorizer.getDocumentAuthorizer()).isAuthorizedToPrint((Document)proposalDevelopmentDocument, this.getGlobalVariableService().getUserSession().getPerson())) {
            throw new AuthorizationException(this.getGlobalVariableService().getUserSession().getPrincipalName(), "printForms", "Proposal");
        }
        if (!form.getDevelopmentProposal().isNihOpportunity().booleanValue()) {
            this.getGlobalVariableService().getMessageMap().putError("noField", "error.nih.opportunity.not.nih", new String[0]);
            return this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        S2sAppSubmission submission = proposalDevelopmentDocument.getDevelopmentProposal().getDisplayedS2sAppSubmission();
        return submission != null ? this.printNihSubmission(form, response, submission) : this.printNihPreview(form, response);
    }

    private ModelAndView printNihSubmission(ProposalDevelopmentDocumentForm form, HttpServletResponse response, S2sAppSubmission submission) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)submission.getNihApplicationPdfFileId())) {
            ControllerFileUtils.streamToResponse(submission.getNihApplicationPdfData(), "Grant Submission.pdf", CONTENT_TYPE_PDF, response);
            return null;
        }
        if (submission.isMissingSubmissionData()) {
            return this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        ProposalDevelopmentDocument proposalDevelopmentDocument = form.getProposalDevelopmentDocument();
        String dunsNumber = proposalDevelopmentDocument.getDevelopmentProposal().getApplicantOrganization().getOrganization().getDunsNumber();
        try {
            KcFile s2sFileDto;
            Optional<KcFile> nihPdf = this.nihSubmissionImageService.getApplicationPdf(submission, dunsNumber);
            if (nihPdf.isPresent() && ArrayUtils.isNotEmpty((byte[])(s2sFileDto = nihPdf.get()).getData())) {
                submission.setNihApplicationPdfData(s2sFileDto.getData());
                this.getDataObjectService().save((Object)submission, new PersistenceOption[]{PersistenceOption.FLUSH});
                ControllerFileUtils.streamToResponse(s2sFileDto, response);
                return null;
            }
        }
        catch (S2sCommunicationException e) {
            LOG.error("Error communicating with the NIH Submission Image service", (Throwable)e);
            this.getGlobalVariableService().getMessageMap().putError("noField", "error.nih.service.unknown", new String[0]);
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    private ModelAndView printNihPreview(ProposalDevelopmentDocumentForm form, HttpServletResponse response) throws Exception {
        ProposalDevelopmentDocument proposalDevelopmentDocument = form.getProposalDevelopmentDocument();
        String dunsNumber = proposalDevelopmentDocument.getDevelopmentProposal().getApplicantOrganization().getOrganization().getDunsNumber();
        try {
            FormGenerationResults results = this.generateAndValidateForms(proposalDevelopmentDocument);
            if (CollectionUtils.isNotEmpty((Collection)results.getErrors()) || StringUtils.isBlank((CharSequence)results.getApplicationXml())) {
                this.setValidationErrorMessage(results.getErrors());
                this.copyAuditErrorsToPage();
                return this.getModelAndViewService().getModelAndView((UifFormBase)form);
            }
            Optional<KcFile> nihPdf = this.nihSubmissionImageService.getApplicationPdf(results.getApplicationXml(), results.getAttachments(), dunsNumber);
            if (nihPdf.isPresent()) {
                ControllerFileUtils.streamToResponse(nihPdf.get(), response);
                return null;
            }
        }
        catch (ModularBudgetCommunicationException | S2SException e) {
            if (!(e.getCause() instanceof ModularBudgetCommunicationException)) {
                LOG.error("Failed to generate S2s forms", e);
                this.getGlobalVariableService().getMessageMap().putError("noField", e.getMessage(), new String[0]);
            } else {
                LOG.error("Error communicating with standalone Budget service", e);
                this.getGlobalVariableService().getMessageMap().putError("noField", "error.standalone.budget.communication.error", new String[0]);
            }
        }
        catch (S2sCommunicationException e) {
            LOG.error("Error communicating with the NIH Submission Image service", (Throwable)e);
            this.getGlobalVariableService().getMessageMap().putError("noField", "error.nih.service.unknown", new String[0]);
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    protected void setValidationErrorMessage(List<org.kuali.coeus.s2sgen.api.core.AuditError> errors) {
        if (errors != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error list size:" + errors.size() + errors.toString());
            }
            List auditErrors = errors.stream().filter(error -> error.getLevel() != AuditError.Level.WARNING).map(error -> new AuditError(error.getErrorKey(), "error.grantsgov.schemavalidation.generic.errorkey", error.getLink(), new String[]{error.getMessageKey()})).collect(Collectors.toList());
            List auditWarnings = errors.stream().filter(error -> error.getLevel() == AuditError.Level.WARNING).map(error -> new AuditError(error.getErrorKey(), "error.grantsgov.schemavalidation.generic.errorkey", error.getLink(), new String[]{error.getMessageKey()})).collect(Collectors.toList());
            if (!auditErrors.isEmpty()) {
                this.getGlobalVariableService().getAuditErrorMap().put("grantsGovAuditErrors", new AuditCluster("GrantsGov", auditErrors, "Grants.Gov Errors"));
            }
            if (!auditWarnings.isEmpty()) {
                this.getGlobalVariableService().getAuditErrorMap().put("grantsGovAuditErrors", new AuditCluster("GrantsGov", auditErrors, "Grants.Gov Warnings"));
            }
        }
    }

    protected boolean copyAuditErrorsToPage() {
        boolean auditClusterFound = false;
        for (String errorKey : this.getGlobalVariableService().getAuditErrorMap().keySet()) {
            AuditError auditError;
            AuditCluster auditCluster = this.getGlobalVariableService().getAuditErrorMap().get(errorKey);
            if (StringUtils.equalsIgnoreCase((CharSequence)auditCluster.getCategory(), (CharSequence)"Grants.Gov Errors")) {
                auditClusterFound = true;
                for (Object error : auditCluster.getAuditErrorList()) {
                    auditError = (AuditError)error;
                    this.getGlobalVariableService().getMessageMap().putError(errorKey == null ? auditError.getErrorKey() : errorKey, auditError.getMessageKey(), auditError.getParams());
                }
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)auditCluster.getCategory(), (CharSequence)"Grants.Gov Warnings")) continue;
            for (Object error : auditCluster.getAuditErrorList()) {
                auditError = (AuditError)error;
                this.getGlobalVariableService().getMessageMap().putWarning(errorKey == null ? auditError.getErrorKey() : errorKey, auditError.getMessageKey(), auditError.getParams());
            }
        }
        return auditClusterFound;
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=addUserAttachedForm"})
    public ModelAndView addUserAttachedForm(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        S2sUserAttachedForm s2sUserAttachedForm = form.getS2sUserAttachedForm();
        ProposalDevelopmentDocument proposalDevelopmentDocument = form.getProposalDevelopmentDocument();
        MultipartFile userAttachedFormFile = s2sUserAttachedForm.getNewFormFile();
        s2sUserAttachedForm.setNewFormFileBytes(userAttachedFormFile.getBytes());
        s2sUserAttachedForm.setFormFileName(userAttachedFormFile.getOriginalFilename());
        s2sUserAttachedForm.setProposalNumber(proposalDevelopmentDocument.getDevelopmentProposal().getProposalNumber());
        try {
            List<S2sUserAttachedForm> userAttachedForms = this.getS2sUserAttachedFormService().extractNSaveUserAttachedForms(proposalDevelopmentDocument, s2sUserAttachedForm);
            proposalDevelopmentDocument.getDevelopmentProposal().getS2sUserAttachedForms().addAll(userAttachedForms);
            form.setS2sUserAttachedForm(new S2sUserAttachedForm());
        }
        catch (S2SException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            if (ex.getTabErrorKey() != null) {
                if (this.getGlobalVariableService().getMessageMap().getErrorMessagesForProperty(ex.getTabErrorKey()) == null) {
                    this.getGlobalVariableService().getMessageMap().putError(ex.getTabErrorKey(), ex.getErrorKey(), ex.getParams());
                }
            }
            this.getGlobalVariableService().getMessageMap().putError("noField", ex.getErrorKey(), ex.getParams());
        }
        return super.save(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=viewUserAttachedFormXML"})
    public ModelAndView viewUserAttachedFormXML(ProposalDevelopmentDocumentForm form, HttpServletResponse response, @RequestParam(value="selectedLine") String selectedLine) throws Exception {
        DevelopmentProposal developmentProposal = form.getDevelopmentProposal();
        List<S2sUserAttachedForm> s2sAttachedForms = developmentProposal.getS2sUserAttachedForms();
        S2sUserAttachedForm selectedForm = s2sAttachedForms.get(Integer.parseInt(selectedLine));
        S2sUserAttachedFormFileContract userAttachedFormFile = this.getUserAttachedFormService().findUserAttachedFormFile((S2sUserAttachedFormContract)selectedForm);
        if (userAttachedFormFile == null) {
            return this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        ControllerFileUtils.streamToResponse(userAttachedFormFile.getXmlFile().getBytes(), selectedForm.getFormName() + ".xml", CONTENT_TYPE_XML, response);
        return null;
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=viewUserAttachedFormPDF"})
    public ModelAndView viewUserAttachedFormPDF(ProposalDevelopmentDocumentForm form, HttpServletResponse response, @RequestParam(value="selectedLine") String selectedLine) throws Exception {
        DevelopmentProposal developmentProposal = form.getDevelopmentProposal();
        List<S2sUserAttachedForm> s2sAttachedForms = developmentProposal.getS2sUserAttachedForms();
        S2sUserAttachedForm selectedForm = s2sAttachedForms.get(Integer.parseInt(selectedLine));
        S2sUserAttachedFormFileContract userAttachedFormFile = this.getUserAttachedFormService().findUserAttachedFormFile((S2sUserAttachedFormContract)selectedForm);
        if (userAttachedFormFile == null) {
            return this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        ControllerFileUtils.streamToResponse(userAttachedFormFile.getFormFile(), selectedForm.getFormFileName(), CONTENT_TYPE_PDF, response);
        return null;
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=deleteUserAttachedForm"})
    public ModelAndView deleteUserAttachedForm(ProposalDevelopmentDocumentForm form, @RequestParam(value="selectedLine") String selectedLine) {
        S2sUserAttachedForm deleteForm = form.getDevelopmentProposal().getS2sUserAttachedForms().remove(Integer.parseInt(selectedLine));
        this.getDataObjectService().delete((Object)deleteForm);
        this.getS2sUserAttachedFormService().resetFormAvailability(form.getProposalDevelopmentDocument(), deleteForm.getNamespace());
        return super.save(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=refreshSubmissionDetails"})
    public ModelAndView refreshSubmissionDetails(ProposalDevelopmentDocumentForm form) {
        ProposalDevelopmentDocument document = form.getProposalDevelopmentDocument();
        Optional.of(document.getDevelopmentProposal().getDisplayedS2sAppSubmission()).ifPresent(submission -> {
            try {
                this.getS2sSubmissionService().refreshSubmission(document.getDevelopmentProposal().getS2sOpportunity(), (S2sAppSubmission)submission);
            }
            catch (S2sCommunicationException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                this.getGlobalVariableService().getMessageMap().putError("noField", ex.getErrorKey(), new String[]{ex.getMessage()});
            }
        });
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=saveUserAttachedForm"})
    public ModelAndView saveUserAttachedForm(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        String selectedCollectionPath = form.getActionParamaterValue("selectedCollectionPath");
        String selectedLine = form.getActionParamaterValue("selectedLineIndex");
        if (form.getEditableCollectionLines().containsKey(selectedCollectionPath)) {
            form.getEditableCollectionLines().get(selectedCollectionPath).remove(selectedLine);
        }
        return super.save(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=addNewS2sOverride"})
    public ModelAndView addNewS2sOverride(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        block4: {
            ProposalDevelopmentDocument document = form.getProposalDevelopmentDocument();
            S2sOverride s2sOverride = form.getNewS2sOverride();
            s2sOverride.setDevelopmentProposal(document.getDevelopmentProposal());
            s2sOverride.getDevelopmentProposal().setS2sOverride(s2sOverride);
            form.setNewS2sOverride(new S2sOverride());
            if (document.getDevelopmentProposal().hasS2sOpportunity()) {
                try {
                    FormGenerationResults result = this.generateWithoutOverride(document);
                    if (result.isValid()) {
                        this.syncGenerationResultToOverride(result, document.getDevelopmentProposal().getS2sOverride());
                    }
                }
                catch (S2SException e) {
                    if (!LOG.isInfoEnabled()) break block4;
                    LOG.info("Error creating submission information for override", (Throwable)e);
                }
            }
        }
        return super.save(form);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FormGenerationResults generateWithoutOverride(ProposalDevelopmentDocument document) {
        boolean requiresApplOverrideDisable;
        boolean bl = requiresApplOverrideDisable = document.getDevelopmentProposal().getS2sOverride() != null && document.getDevelopmentProposal().getS2sOverride().getApplicationOverride() != null && document.getDevelopmentProposal().getS2sOverride().getApplicationOverride().getApplication() != null && document.getDevelopmentProposal().getS2sOverride().isActive();
        if (requiresApplOverrideDisable) {
            String application = document.getDevelopmentProposal().getS2sOverride().getApplicationOverride().getApplication();
            try {
                document.getDevelopmentProposal().getS2sOverride().getApplicationOverride().setApplication(null);
                FormGenerationResults formGenerationResults = this.generateAndValidateForms(document);
                return formGenerationResults;
            }
            finally {
                document.getDevelopmentProposal().getS2sOverride().getApplicationOverride().setApplication(application);
            }
        }
        return this.generateAndValidateForms(document);
    }

    private FormGenerationResults generateAndValidateForms(ProposalDevelopmentDocument pdDoc) {
        return pdDoc.getDevelopmentProposal().isMultiProjectParent() ? this.getFormGeneratorService().generateAndValidateMPForms((ProposalDevelopmentDocumentContract)pdDoc, pdDoc.getHierarchyChildren()) : this.getFormGeneratorService().generateAndValidateForms((ProposalDevelopmentDocumentContract)pdDoc);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=removeExistingS2sOverride"})
    public ModelAndView removeExistingS2sOverride(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        this.getDataObjectService().delete((Object)form.getDevelopmentProposal().getS2sOverride());
        form.getDevelopmentProposal().setS2sOverride(null);
        return super.save(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=syncCurrentGrantInformation"})
    public ModelAndView syncCurrentGrantInformation(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        ProposalDevelopmentDocument document = form.getProposalDevelopmentDocument();
        if (document.getDevelopmentProposal().hasS2sOpportunity()) {
            try {
                FormGenerationResults result = this.generateWithoutOverride(document);
                if (result.isValid()) {
                    this.syncGenerationResultToOverride(result, document.getDevelopmentProposal().getS2sOverride());
                }
                this.setValidationErrorMessage(result.getErrors());
                if (this.copyAuditErrorsToPage()) {
                    this.getGlobalVariableService().getMessageMap().putError(GRANTS_GOV_FORM_VALIDATION_ERRORS, "validation.errors.before.grantsGov.submission", new String[0]);
                }
            }
            catch (S2SException e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Error creating submission information for override", (Throwable)e);
                }
                this.getGlobalVariableService().getMessageMap().putError("noField", "error.grantsgov.schemavalidation.generic.errorkey", new String[]{StringUtils.isNotBlank((CharSequence)e.getErrorMessage()) ? e.getErrorMessage() : e.getMessage()});
            }
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    protected void syncGenerationResultToOverride(FormGenerationResults result, S2sOverride s2sOverride) {
        if (s2sOverride.getApplication() == null) {
            s2sOverride.setApplication(new S2sOverrideApplicationData());
        }
        S2sOverrideApplicationData data = s2sOverride.getApplication();
        data.setApplication(result.getApplicationXml());
        data.setName(CURRENT_GRANT_APPLICATION_XML);
        data.setAttachments(result.getAttachments().stream().map(attachment -> {
            S2sOverrideAttachment s2sOverrideAttachment = new S2sOverrideAttachment();
            s2sOverrideAttachment.setApplication(data);
            s2sOverrideAttachment.setContentId(attachment.getContentId());
            s2sOverrideAttachment.setName(attachment.getFileName());
            s2sOverrideAttachment.setData(attachment.getContent());
            s2sOverrideAttachment.setContentType(attachment.getContentType());
            return s2sOverrideAttachment;
        }).collect(Collectors.toList()));
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=pushCurrentToOverride"})
    public ModelAndView pushCurrentToOverride(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        S2sOverride s2sOverride = form.getDevelopmentProposal().getS2sOverride();
        if (s2sOverride != null && s2sOverride.getApplication() != null && s2sOverride.getApplication().getApplication() != null) {
            S2sOverrideApplicationData current = s2sOverride.getApplication();
            if (s2sOverride.getApplicationOverride() == null) {
                s2sOverride.setApplicationOverride(new S2sOverrideApplicationData());
            }
            S2sOverrideApplicationData override = s2sOverride.getApplicationOverride();
            override.setApplication(current.getApplication());
            override.setName(OVERRRIDDEN_GRANT_APPLICATION_XML);
            override.setAttachments(current.getAttachments().stream().map(currentAttachment -> {
                S2sOverrideAttachment s2sOverrideAttachment = new S2sOverrideAttachment();
                s2sOverrideAttachment.setApplication(override);
                s2sOverrideAttachment.setContentId(currentAttachment.getContentId());
                s2sOverrideAttachment.setName(currentAttachment.getName());
                s2sOverrideAttachment.setData(currentAttachment.getData());
                s2sOverrideAttachment.setContentType(currentAttachment.getContentType());
                return s2sOverrideAttachment;
            }).collect(Collectors.toList()));
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=retrieveApplicationXml"})
    public ModelAndView retrieveApplicationXml(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, HttpServletResponse response) throws IOException {
        HttpServletRequest request = form.getRequest();
        String attachmentPath = request.getParameter("propertyPath");
        if (StringUtils.isBlank((CharSequence)attachmentPath)) {
            throw new RuntimeException("Selected attachment was not set for line action");
        }
        KcFile attachment = (KcFile)ObjectPropertyUtils.getPropertyValue((Object)form, (String)attachmentPath);
        byte[] data = attachment.getData();
        KRADUtils.addAttachmentToResponse((HttpServletResponse)response, (InputStream)new ByteArrayInputStream(data), (String)attachment.getType(), (String)attachment.getName(), (long)data.length);
        response.flushBuffer();
        return null;
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=save", "pageId=PropDev-OpportunityPage"})
    public ModelAndView saveOpportunityPage(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws IOException {
        this.setApplicationOverride(form.getDevelopmentProposal().getS2sOverride());
        return super.save(form);
    }

    protected void setApplicationOverride(S2sOverride s2sOverride) throws IOException {
        S2sOverrideApplicationData applicationOverride;
        MultipartFile file;
        byte[] content;
        if (s2sOverride != null && s2sOverride.getApplicationOverride() != null && s2sOverride.getApplicationOverride().getMultipartFile() != null && ArrayUtils.isNotEmpty((byte[])(content = (file = (applicationOverride = s2sOverride.getApplicationOverride()).getMultipartFile()).getBytes()))) {
            applicationOverride.setApplication(new String(content));
            applicationOverride.setName(file.getOriginalFilename());
        }
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=replaceS2sOverrideApplication"})
    public ModelAndView replaceS2sOverrideApplication(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws IOException {
        this.setApplicationOverride(form.getDevelopmentProposal().getS2sOverride());
        return super.save(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=updateHashS2sOverrideApplication"})
    public ModelAndView updateHashS2sOverrideApplication(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        this.updateHashApp(form);
        return super.save(form);
    }

    private void updateHashApp(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        boolean updated;
        S2sOverride s2sOverride = form.getDevelopmentProposal().getS2sOverride();
        if (s2sOverride != null && s2sOverride.getApplicationOverride() != null && s2sOverride.getApplicationOverride().isHeaderVersion1Form() && (updated = s2sOverride.getApplicationOverride().updateSha1HashInXml())) {
            this.getGlobalVariableService().getMessageMap().putInfoForSectionId("PropDev-OpportunityPage-Override-Override", "info.s2s.override.app.hash.update", new String[0]);
        }
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=updateHashFileUploadLine"})
    public ModelAndView updateHashFileUploadLine(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        CollectionControllerServiceImpl.CollectionActionParameters parameters = new CollectionControllerServiceImpl.CollectionActionParameters((UifFormBase)form, true);
        Runnable runnable = () -> this.processCollectionUpdateHashLine(form, parameters.getSelectedCollectionId(), parameters.getSelectedCollectionPath(), parameters.getSelectedLineIndex());
        ViewLifecycle.encapsulateLifecycle((View)form.getView(), (Object)form, (ViewPostMetadata)form.getViewPostMetadata(), null, (HttpServletRequest)form.getRequest(), (Runnable)runnable);
        return super.save(form);
    }

    private void processCollectionUpdateHashLine(ProposalDevelopmentDocumentForm form, String collectionId, String collectionPath, int lineIndex) {
        Collection collection = (Collection)ObjectPropertyUtils.getPropertyValue((Object)form, (String)collectionPath);
        if (collection == null) {
            throw new RuntimeException("Unable to get collection property from model for path: " + collectionPath);
        }
        if (collection instanceof List) {
            boolean updated;
            S2sOverrideAttachment attachment = (S2sOverrideAttachment)((List)collection).get(lineIndex);
            if (attachment != null && (updated = attachment.updateSha1HashInXml())) {
                String collectionLabel = (String)form.getViewPostMetadata().getComponentPostData(collectionId, "collectionLabel");
                this.getGlobalVariableService().getMessageMap().putInfoForSectionId(collectionId, "info.s2s.override.att.hash.update", new String[]{collectionLabel});
            }
        } else {
            throw new RuntimeException("Only List collection implementations are supported for the update hash by index method");
        }
    }

    public FormPrintService getFormPrintService() {
        return this.formPrintService;
    }

    public void setFormPrintService(FormPrintService formPrintService) {
        this.formPrintService = formPrintService;
    }

    public S2sUserAttachedFormService getS2sUserAttachedFormService() {
        return this.s2sUserAttachedFormService;
    }

    public void setS2sUserAttachedFormService(S2sUserAttachedFormService s2sUserAttachedFormService) {
        this.s2sUserAttachedFormService = s2sUserAttachedFormService;
    }

    public UserAttachedFormService getUserAttachedFormService() {
        return this.userAttachedFormService;
    }

    public void setUserAttachedFormService(UserAttachedFormService userAttachedFormService) {
        this.userAttachedFormService = userAttachedFormService;
    }

    public ProposalDevelopmentDocumentViewAuthorizer getProposalDevelopmentDocumentViewAuthorizer() {
        return this.proposalDevelopmentDocumentViewAuthorizer;
    }

    public void setProposalDevelopmentDocumentViewAuthorizer(ProposalDevelopmentDocumentViewAuthorizer proposalDevelopmentDocumentViewAuthorizer) {
        this.proposalDevelopmentDocumentViewAuthorizer = proposalDevelopmentDocumentViewAuthorizer;
    }

    public FormGeneratorService getFormGeneratorService() {
        return this.formGeneratorService;
    }

    public void setFormGeneratorService(FormGeneratorService formGeneratorService) {
        this.formGeneratorService = formGeneratorService;
    }

    public RefreshControllerService getRefreshControllerService() {
        return this.refreshControllerService;
    }

    public void setRefreshControllerService(RefreshControllerService refreshControllerService) {
        this.refreshControllerService = refreshControllerService;
    }

    public PdfService getPdfService() {
        return this.pdfService;
    }

    public void setPdfService(PdfService pdfService) {
        this.pdfService = pdfService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void afterPropertiesSet() throws IOException {
        this.mappings = Stream.of(org.kuali.coeus.sys.framework.util.CollectionUtils.entry(GG_LOBBYING_FORM_V_1_1, new Form(GG_LOBBYING_FORM_V_1_1, this.ggLobbyingForm11Mapping, this.ggLobbyingForm11Form, GG_LOBBYING_FORM_V_1_1_LOCAL_PART)), org.kuali.coeus.sys.framework.util.CollectionUtils.entry(CD_511_V_1_1, new Form(CD_511_V_1_1, this.cd51111Mapping, this.cd51111Form, CD_511_V_1_1_LOCAL_PART)), org.kuali.coeus.sys.framework.util.CollectionUtils.entry(SF_424_SHORT_V_1_1, new Form(SF_424_SHORT_V_1_1, this.sf424Short11Mapping, this.sf424Short11Form, SF_424_SHORT_V_1_1_LOCAL_PART)), org.kuali.coeus.sys.framework.util.CollectionUtils.entry(PHS398_COVERPAGE_SUPPLEMENT_5_0, new Form(PHS398_COVERPAGE_SUPPLEMENT_5_0, this.phs398CoverPageSupplementMapping, this.phs398CoverPageSupplementForm, PHS398_COVERPAGE_SUPPLEMENT_5_0_LOCAL_PART)), org.kuali.coeus.sys.framework.util.CollectionUtils.entry(RR_SF424_V_2_0, new Form(RR_SF424_V_2_0, this.rrSf42420Mapping, this.rrSf42420Form, RR_SF424_V_2_0_LOCAL_PART))).collect(org.kuali.coeus.sys.framework.util.CollectionUtils.entriesToMap());
        this.schemas = Arrays.asList(new PathMatchingResourcePatternResolver().getResources("classpath*:org/kuali/coeus/propdev/impl/s2s/map/schema/*.json"));
    }

    private static final class MappedFileResult {
        private String formName;
        private boolean valid;
        private byte[] file;
        private byte[] xml;
        private List<String> errors;
        private List<String> xmlValidationWarnings;

        public MappedFileResult(String formName, boolean valid, byte[] file, byte[] xml, List<String> errors, List<String> xmlValidationWarnings) {
            this.formName = formName;
            this.valid = valid;
            this.file = file;
            this.xml = xml;
            this.errors = errors;
            this.xmlValidationWarnings = xmlValidationWarnings;
        }

        public String getFormName() {
            return this.formName;
        }

        public boolean isValid() {
            return this.valid;
        }

        public byte[] getFile() {
            return this.file;
        }

        public byte[] getXml() {
            return this.xml;
        }

        public List<String> getErrors() {
            return this.errors;
        }

        public List<String> getXmlValidationWarnings() {
            return this.xmlValidationWarnings;
        }
    }

    private static final class Form {
        private final String namespace;
        private final Resource mapping;
        private final Resource form;
        private final String localPart;

        public Form(String namespace, Resource mapping, Resource form, String localPart) {
            this.namespace = namespace;
            this.mapping = mapping;
            this.form = form;
            this.localPart = localPart;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public Resource getMapping() {
            return this.mapping;
        }

        public String getMappingAsString() {
            try {
                return this.quietlyReadFileToString(this.getMapping().getFile());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Resource getForm() {
            return this.form;
        }

        public String getLocalPart() {
            return this.localPart;
        }

        private String quietlyReadFileToString(File file) {
            try {
                return FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

