/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.doctype;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.BeanPropertyComparator;

public class DocumentTypeLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private static final long serialVersionUID = -5162632536083995637L;

    protected List<? extends BusinessObject> getSearchResultsHelper(Map<String, String> fieldValues, boolean unbounded) {
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        this.setReferencesToRefresh(fieldValues.get("referencesToRefresh"));
        DocumentType documentType = this.loadDocumentTypeForSearch(fieldValues);
        String descendHierarchyValue = fieldValues.get("descendHierarchy");
        boolean descend = false;
        if ("Y".equals(descendHierarchyValue) || "Yes".equals(descendHierarchyValue)) {
            descend = true;
        }
        Collection<DocumentType> docTypesFound = KEWServiceLocator.getDocumentTypeService().find(documentType, fieldValues.get("parentDocType.name"), descend);
        ArrayList<DocumentType> searchResults = new ArrayList<DocumentType>(docTypesFound);
        List defaultSortColumns = this.getDefaultSortColumns();
        if (defaultSortColumns.size() > 0) {
            Collections.sort(searchResults, new BeanPropertyComparator(this.getDefaultSortColumns(), true));
        }
        return searchResults;
    }

    protected DocumentType loadDocumentTypeForSearch(Map<String, String> fieldValues) {
        DocumentType documentType = new DocumentType();
        String activeIndicator = fieldValues.get("active");
        String docTypeLabel = fieldValues.get("label");
        String documentTypeId = fieldValues.get("documentTypeId");
        String docTypeName = fieldValues.get("name");
        String applicationId = fieldValues.get("applicationId");
        if ("Y".equals(activeIndicator)) {
            documentType.setActive(Boolean.TRUE);
        } else if ("N".equals(activeIndicator)) {
            documentType.setActive(Boolean.FALSE);
        } else {
            documentType.setActive(null);
        }
        if (docTypeLabel != null && !"".equals(docTypeLabel.trim())) {
            docTypeLabel = docTypeLabel.replace('*', '%');
            documentType.setLabel("%" + docTypeLabel.trim() + "%");
        }
        if (docTypeName != null && !"".equals(docTypeName.trim())) {
            documentType.setName(docTypeName.trim());
        }
        if (documentTypeId != null && !"".equals(documentTypeId.trim())) {
            documentType.setDocumentTypeId(documentTypeId.trim());
        }
        if (!StringUtils.isBlank((String)applicationId)) {
            documentType.setActualApplicationId(applicationId);
        }
        return documentType;
    }
}

