/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.range.GeoDistanceAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.range.GeoDistanceAggregatorSupplier;
import org.elasticsearch.search.aggregations.bucket.range.InternalGeoDistance;
import org.elasticsearch.search.aggregations.bucket.range.InternalRange;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregator;
import org.elasticsearch.search.aggregations.support.AggregatorSupplier;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.internal.SearchContext;

public class GeoDistanceRangeAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final InternalRange.Factory<InternalGeoDistance.Bucket, InternalGeoDistance> rangeFactory = InternalGeoDistance.FACTORY;
    private final GeoPoint origin;
    private final GeoDistanceAggregationBuilder.Range[] ranges;
    private final DistanceUnit unit;
    private final GeoDistance distanceType;
    private final boolean keyed;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register("geo_distance", CoreValuesSourceType.GEOPOINT, (name, factories, distanceType, origin, units, valuesSource, format, rangeFactory, ranges, keyed, context, parent, metadata) -> {
            DistanceSource distanceSource = new DistanceSource((ValuesSource.GeoPoint)valuesSource, distanceType, origin, units);
            return new RangeAggregator(name, factories, distanceSource, format, rangeFactory, ranges, keyed, context, parent, metadata);
        });
    }

    public GeoDistanceRangeAggregatorFactory(String name, ValuesSourceConfig config, GeoPoint origin, GeoDistanceAggregationBuilder.Range[] ranges, DistanceUnit unit, GeoDistance distanceType, boolean keyed, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.origin = origin;
        this.ranges = ranges;
        this.unit = unit;
        this.distanceType = distanceType;
        this.keyed = keyed;
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new RangeAggregator.Unmapped(this.name, (RangeAggregator.Range[])this.ranges, this.keyed, this.config.format(), searchContext, parent, this.rangeFactory, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource valuesSource, SearchContext searchContext, Aggregator parent, boolean collectsFromSingleBucket, Map<String, Object> metadata) throws IOException {
        AggregatorSupplier aggregatorSupplier = this.queryShardContext.getValuesSourceRegistry().getAggregator(this.config.valueSourceType(), "geo_distance");
        if (!(aggregatorSupplier instanceof GeoDistanceAggregatorSupplier)) {
            throw new AggregationExecutionException("Registry miss-match - expected " + GeoDistanceAggregatorSupplier.class.getName() + ", found [" + aggregatorSupplier.getClass().toString() + "]");
        }
        return ((GeoDistanceAggregatorSupplier)aggregatorSupplier).build(this.name, this.factories, this.distanceType, this.origin, this.unit, this.config.toValuesSource(), this.config.format(), this.rangeFactory, this.ranges, this.keyed, searchContext, parent, metadata);
    }

    private static class DistanceSource
    extends ValuesSource.Numeric {
        private final ValuesSource.GeoPoint source;
        private final GeoDistance distanceType;
        private final DistanceUnit units;
        private final GeoPoint origin;

        DistanceSource(ValuesSource.GeoPoint source, GeoDistance distanceType, GeoPoint origin, DistanceUnit units) {
            this.source = source;
            this.distanceType = distanceType;
            this.units = units;
            this.origin = origin;
        }

        @Override
        public boolean isFloatingPoint() {
            return true;
        }

        @Override
        public SortedNumericDocValues longValues(LeafReaderContext ctx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedNumericDoubleValues doubleValues(LeafReaderContext ctx) {
            MultiGeoPointValues geoValues = this.source.geoPointValues(ctx);
            return GeoUtils.distanceValues(this.distanceType, this.units, geoValues, this.origin);
        }

        @Override
        public SortedBinaryDocValues bytesValues(LeafReaderContext ctx) {
            throw new UnsupportedOperationException();
        }
    }
}

