/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.terms.AbstractStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.BucketPriorityQueue;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.internal.SearchContext;

public class StringTermsAggregator
extends AbstractStringTermsAggregator {
    private final ValuesSource valuesSource;
    protected final BytesRefHash bucketOrds;
    private final IncludeExclude.StringFilter includeExclude;

    public StringTermsAggregator(String name, AggregatorFactories factories, ValuesSource valuesSource, BucketOrder order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude.StringFilter includeExclude, SearchContext context, Aggregator parent, Aggregator.SubAggCollectionMode collectionMode, boolean showTermDocCountError, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, order, format, bucketCountThresholds, collectionMode, showTermDocCountError, metadata);
        this.valuesSource = valuesSource;
        this.includeExclude = includeExclude;
        this.bucketOrds = new BytesRefHash(1L, context.bigArrays());
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.valuesSource != null && this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        final SortedBinaryDocValues values = this.valuesSource.bytesValues(ctx);
        return new LeafBucketCollectorBase(sub, values){
            final BytesRefBuilder previous;
            {
                super(sub2, values2);
                this.previous = new BytesRefBuilder();
            }

            @Override
            public void collect(int doc, long bucket) throws IOException {
                assert (bucket == 0L);
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    this.previous.clear();
                    for (int i = 0; i < valuesCount; ++i) {
                        BytesRef bytes = values.nextValue();
                        if (StringTermsAggregator.this.includeExclude != null && !StringTermsAggregator.this.includeExclude.accept(bytes) || i > 0 && this.previous.get().equals((Object)bytes)) continue;
                        long bucketOrdinal = StringTermsAggregator.this.bucketOrds.add(bytes);
                        if (bucketOrdinal < 0L) {
                            bucketOrdinal = -1L - bucketOrdinal;
                            StringTermsAggregator.this.collectExistingBucket(sub, doc, bucketOrdinal);
                        } else {
                            StringTermsAggregator.this.collectBucket(sub, doc, bucketOrdinal);
                        }
                        this.previous.copyBytes(bytes);
                    }
                }
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        int i;
        assert (owningBucketOrdinal == 0L);
        if (!(this.bucketCountThresholds.getMinDocCount() != 0L || InternalOrder.isCountDesc(this.order) && this.bucketOrds.size() >= (long)this.bucketCountThresholds.getRequiredSize())) {
            for (LeafReaderContext ctx : this.context.searcher().getTopReaderContext().leaves()) {
                SortedBinaryDocValues values = this.valuesSource.bytesValues(ctx);
                for (int docId = 0; docId < ctx.reader().maxDoc(); ++docId) {
                    if (!values.advanceExact(docId)) continue;
                    int valueCount = values.docValueCount();
                    for (i = 0; i < valueCount; ++i) {
                        BytesRef term = values.nextValue();
                        if (this.includeExclude != null && !this.includeExclude.accept(term)) continue;
                        this.bucketOrds.add(term);
                    }
                }
            }
        }
        int size = (int)Math.min(this.bucketOrds.size(), (long)this.bucketCountThresholds.getShardSize());
        long otherDocCount = 0L;
        BucketPriorityQueue ordered = new BucketPriorityQueue(size, this.partiallyBuiltBucketComparator);
        StringTerms.Bucket spare = null;
        i = 0;
        while ((long)i < this.bucketOrds.size()) {
            if (spare == null) {
                spare = new StringTerms.Bucket(new BytesRef(), 0L, null, this.showTermDocCountError, 0L, this.format);
            }
            this.bucketOrds.get(i, spare.termBytes);
            spare.docCount = this.bucketDocCount(i);
            otherDocCount += spare.docCount;
            spare.bucketOrd = i;
            if (this.bucketCountThresholds.getShardMinDocCount() <= spare.docCount && (spare = (StringTerms.Bucket)ordered.insertWithOverflow(spare)) == null) {
                this.consumeBucketsAndMaybeBreak(1);
            }
            ++i;
        }
        StringTerms.Bucket[] list = new StringTerms.Bucket[ordered.size()];
        long[] survivingBucketOrds = new long[ordered.size()];
        for (int i2 = ordered.size() - 1; i2 >= 0; --i2) {
            StringTerms.Bucket bucket = (StringTerms.Bucket)ordered.pop();
            survivingBucketOrds[i2] = bucket.bucketOrd;
            list[i2] = bucket;
            otherDocCount -= bucket.docCount;
        }
        this.runDeferredCollections(survivingBucketOrds);
        for (StringTerms.Bucket bucket : list) {
            bucket.termBytes = BytesRef.deepCopyOf((BytesRef)bucket.termBytes);
            bucket.aggregations = this.bucketAggregations(bucket.bucketOrd);
            bucket.docCountError = 0L;
        }
        return new StringTerms(this.name, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.metadata(), this.format, this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, otherDocCount, Arrays.asList(list), 0L);
    }

    @Override
    public void doClose() {
        Releasables.close(this.bucketOrds);
    }
}

