/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring.namespace;

import java.util.List;
import org.directwebremoting.annotations.Filter;
import org.directwebremoting.annotations.Param;
import org.directwebremoting.filter.ExtraLatencyAjaxFilter;
import org.directwebremoting.spring.namespace.ConfigurationParser;
import org.directwebremoting.spring.namespace.NamespaceParserHelper;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class FilterParserHelper
extends NamespaceParserHelper {
    protected void processLatencyFilter(BeanDefinitionRegistry registry, BeanDefinitionBuilder creatorConfig, Element child, String name) {
        BeanDefinitionBuilder beanFilter = BeanDefinitionBuilder.rootBeanDefinition(ExtraLatencyAjaxFilter.class);
        beanFilter.addPropertyValue("delay", (Object)child.getAttribute("delay"));
        FilterParserHelper.registerFilter(registry, (BeanDefinition)beanFilter.getBeanDefinition(), "__latencyFilter_" + name);
        ManagedList filterList = new ManagedList();
        filterList.add((Object)new RuntimeBeanReference("__latencyFilter_" + name));
        creatorConfig.addPropertyValue("filters", (Object)filterList);
    }

    protected void processFilter(BeanDefinitionRegistry registry, Element element, String javascript) {
        String filterClass = element.getAttribute("class");
        BeanDefinitionBuilder beanFilter = BeanDefinitionBuilder.rootBeanDefinition((String)filterClass);
        List filterParamElements = DomUtils.getChildElementsByTagName((Element)element, (String)"param");
        for (Element filterParamElement : filterParamElements) {
            beanFilter.addPropertyValue(filterParamElement.getAttribute("name"), (Object)filterParamElement.getAttribute("value"));
        }
        FilterParserHelper.registerFilter(registry, (BeanDefinition)beanFilter.getBeanDefinition(), "__filter_" + filterClass + "_" + javascript);
    }

    protected static void processFilter(BeanDefinitionRegistry registry, Filter filter, String javascript, ManagedList filters) {
        BeanDefinitionBuilder beanFilter = BeanDefinitionBuilder.rootBeanDefinition(filter.type());
        Param[] filterParams = filter.params();
        if (filterParams != null) {
            for (Param filterParam : filterParams) {
                beanFilter.addPropertyValue(filterParam.name(), (Object)filterParam.value());
            }
        }
        FilterParserHelper.registerFilter(registry, (BeanDefinition)beanFilter.getBeanDefinition(), "__filter_" + javascript);
        filters.add((Object)new RuntimeBeanReference("__filter_" + javascript));
    }

    private static void registerFilter(BeanDefinitionRegistry registry, BeanDefinition bean, String name) {
        BeanDefinitionHolder holder = new BeanDefinitionHolder(bean, name);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
    }

    protected void addGlobalFilter(BeanDefinitionRegistry registry, Element element, String javascript) {
        String filterClass = element.getAttribute("class");
        BeanDefinition springConfigurator = ConfigurationParser.registerConfigurationIfNecessary(registry);
        ManagedList filters = (ManagedList)springConfigurator.getPropertyValues().getPropertyValue("filters").getValue();
        filters.add((Object)new RuntimeBeanReference("__filter_" + filterClass + "_" + javascript));
    }

    protected ManagedList createManagedFilterList(Element element, String javascript) {
        return this.createManagedFilterList(element.getAttribute("class"), javascript);
    }

    protected ManagedList createManagedFilterList(String filterClass, String javascript) {
        ManagedList filterList = new ManagedList();
        filterList.add((Object)new RuntimeBeanReference("__filter_" + filterClass + "_" + javascript));
        return filterList;
    }
}

