/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core.spi.time;

import java.util.Timer;
import java.util.TimerTask;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceProvider;

public class TickingTimeSource
implements TimeSource,
Service {
    private final long granularity;
    private final long systemUpdatePeriod;
    private volatile long currentTime;
    private volatile long lastUpdate;
    private final Timer timer = new Timer("Ehcache-TickingTimeSource-timer", true);

    public TickingTimeSource(long granularity, long systemUpdatePeriod) {
        this.granularity = granularity;
        this.systemUpdatePeriod = systemUpdatePeriod;
    }

    private void updateToSystemTime() {
        long time;
        this.currentTime = time = System.currentTimeMillis();
        this.lastUpdate = time;
    }

    @Override
    public long getTimeMillis() {
        return this.currentTime;
    }

    public void start(ServiceProvider<Service> serviceProvider) {
        this.updateToSystemTime();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (TickingTimeSource.this.currentTime - TickingTimeSource.this.lastUpdate >= TickingTimeSource.this.systemUpdatePeriod) {
                    TickingTimeSource.this.updateToSystemTime();
                } else {
                    TickingTimeSource.this.currentTime = TickingTimeSource.this.currentTime + TickingTimeSource.this.granularity;
                }
            }
        }, this.granularity, this.granularity);
    }

    public void stop() {
        this.timer.cancel();
        this.timer.purge();
    }
}

