/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.person;

import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.coeus.common.framework.person.attr.DegreeType;
import org.kuali.coeus.propdev.api.person.ProposalPersonDegreeContract;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;

@Entity
@Table(name="EPS_PROP_PERSON_DEGREE")
@IdClass(value=ProposalPersonDegreeId.class)
public class ProposalPersonDegree
extends KcPersistableBusinessObjectBase
implements ProposalPersonDegreeContract {
    @Id
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="PROPOSAL_NUMBER", referencedColumnName="PROPOSAL_NUMBER"), @JoinColumn(name="PROP_PERSON_NUMBER", referencedColumnName="PROP_PERSON_NUMBER")})
    private ProposalPerson proposalPerson;
    @Id
    @Column(name="DEGREE_SEQUENCE_NUMBER")
    private Integer degreeSequenceNumber;
    @Column(name="GRADUATION_YEAR")
    private String graduationYear;
    @Column(name="DEGREE_CODE")
    private String degreeCode;
    @Column(name="DEGREE")
    private String degree;
    @Column(name="FIELD_OF_STUDY")
    private String fieldOfStudy;
    @Column(name="SPECIALIZATION")
    private String specialization;
    @Column(name="SCHOOL")
    private String school;
    @Column(name="SCHOOL_ID_CODE")
    private String schoolIdCode;
    @Column(name="SCHOOL_ID")
    private String schoolId;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="DEGREE_CODE", referencedColumnName="DEGREE_CODE", insertable=false, updatable=false)
    private DegreeType degreeType;

    public final String getGraduationYear() {
        return this.graduationYear;
    }

    public final void setGraduationYear(String argGraduationYear) {
        this.graduationYear = argGraduationYear;
    }

    public final String getDegreeCode() {
        return this.degreeCode;
    }

    public final void setDegreeCode(String argDegreeCode) {
        this.degreeCode = argDegreeCode;
        if (StringUtils.isBlank((CharSequence)this.degreeCode)) {
            this.degree = null;
        } else {
            this.refreshReferenceObject("degreeType");
        }
    }

    public String getDegree() {
        return this.degree;
    }

    public void setDegree(String argDegree) {
        this.degree = argDegree;
    }

    public final String getFieldOfStudy() {
        return this.fieldOfStudy;
    }

    public final void setFieldOfStudy(String argFieldOfStudy) {
        this.fieldOfStudy = argFieldOfStudy;
    }

    public final String getSpecialization() {
        return this.specialization;
    }

    public final void setSpecialization(String argSpecialization) {
        this.specialization = argSpecialization;
    }

    public final String getSchool() {
        return this.school;
    }

    public final void setSchool(String argSchool) {
        this.school = argSchool;
    }

    public final String getSchoolIdCode() {
        return this.schoolIdCode;
    }

    public final void setSchoolIdCode(String argSchoolIdCode) {
        this.schoolIdCode = argSchoolIdCode;
    }

    public final String getSchoolId() {
        return this.schoolId;
    }

    public final void setSchoolId(String argSchoolId) {
        this.schoolId = argSchoolId;
    }

    public final void setDegreeType(DegreeType type) {
        this.degreeType = type;
    }

    public final DegreeType getDegreeType() {
        return this.degreeType;
    }

    public String getProposalNumber() {
        return this.getProposalPerson().getDevelopmentProposal().getProposalNumber();
    }

    public Integer getProposalPersonNumber() {
        return this.getProposalPerson().getProposalPersonNumber();
    }

    public Integer getDegreeSequenceNumber() {
        return this.degreeSequenceNumber;
    }

    public void setDegreeSequenceNumber(Integer degreeSequenceNumber) {
        this.degreeSequenceNumber = degreeSequenceNumber;
    }

    public ProposalPerson getProposalPerson() {
        return this.proposalPerson;
    }

    public void setProposalPerson(ProposalPerson proposalPerson) {
        this.proposalPerson = proposalPerson;
    }

    public static final class ProposalPersonDegreeId
    implements Serializable,
    Comparable<ProposalPersonDegreeId> {
        private ProposalPerson.ProposalPersonId proposalPerson;
        private Integer degreeSequenceNumber;

        public ProposalPerson.ProposalPersonId getProposalPerson() {
            return this.proposalPerson;
        }

        public void setProposalPerson(ProposalPerson.ProposalPersonId proposalPerson) {
            this.proposalPerson = proposalPerson;
        }

        public Integer getDegreeSequenceNumber() {
            return this.degreeSequenceNumber;
        }

        public void setDegreeSequenceNumber(Integer degreeSequenceNumber) {
            this.degreeSequenceNumber = degreeSequenceNumber;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("proposalPerson", (Object)this.proposalPerson).append("degreeSequenceNumber", (Object)this.degreeSequenceNumber).toString();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            ProposalPersonDegreeId rhs = (ProposalPersonDegreeId)other;
            return new EqualsBuilder().append((Object)this.proposalPerson, (Object)rhs.proposalPerson).append((Object)this.degreeSequenceNumber, (Object)rhs.degreeSequenceNumber).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.proposalPerson).append((Object)this.degreeSequenceNumber).toHashCode();
        }

        @Override
        public int compareTo(ProposalPersonDegreeId other) {
            return new CompareToBuilder().append((Object)this.proposalPerson, (Object)other.proposalPerson).append((Object)this.degreeSequenceNumber, (Object)other.degreeSequenceNumber).toComparison();
        }
    }
}

