/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.notifications;

import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.notification.impl.NotificationRendererBase;
import org.kuali.kra.negotiations.bo.Negotiable;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.rice.core.api.CoreApiServiceLocator;

public class NegotiationNotificationRenderer
extends NotificationRendererBase {
    private static final String DATE_FORMAT_MM_DD_YYYY = "MM/dd/yyyy";
    private static final long serialVersionUID = 408846376074619623L;
    private Negotiation negotiation;
    private static String noneGiven = null;

    @Override
    public Map<String, String> getDefaultReplacementParameters() {
        if (noneGiven == null) {
            noneGiven = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("message.none.given");
        }
        Map<String, String> result = super.getDefaultReplacementParameters();
        Negotiable details = this.negotiation.getAssociatedNegotiable();
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT_MM_DD_YYYY);
        result.put("{NEGOTIATION_ID}", this.negotiation.getNegotiationId().toString());
        result.put("{NEGOTIATOR}", this.negotiation.getNegotiator().getFullName());
        result.put("{NEGOTIATION_STATUS}", this.negotiation.getNegotiationStatus().getDescription());
        if (this.negotiation.getAnticipatedAwardDate() != null) {
            result.put("{ANTICIPATED_START_DATE}", df.format(this.negotiation.getAnticipatedAwardDate()));
        } else {
            result.put("{ANTICIPATED_START_DATE}", "");
        }
        if (this.negotiation.getNegotiationStartDate() != null) {
            result.put("{START_DATE}", df.format(this.negotiation.getNegotiationStartDate()));
        } else {
            result.put("{START_DATE}", "");
        }
        if (this.negotiation.getNegotiationEndDate() != null) {
            result.put("{END_DATE}", df.format(this.negotiation.getNegotiationEndDate()));
        } else {
            result.put("{END_DATE}", "");
        }
        if (details != null && StringUtils.isNotBlank((CharSequence)details.getTitle())) {
            result.put("{TITLE}", details.getTitle());
        } else {
            result.put("{TITLE}", noneGiven);
        }
        if (details != null && details.getPiEmployeeName() != null) {
            result.put("{PI}", details.getPiEmployeeName());
        } else if (details != null && details.getPiNonEmployeeName() != null) {
            result.put("{PI}", details.getPiNonEmployeeName());
        } else {
            result.put("{PI}", noneGiven);
        }
        if (details != null && StringUtils.isNotBlank((CharSequence)details.getLeadUnitNumber())) {
            result.put("{LEAD_UNIT_NUMBER}", details.getLeadUnitName());
            result.put("{LEAD_UNIT_NAME}", details.getLeadUnitNumber());
        } else {
            result.put("{LEAD_UNIT_NUMBER}", noneGiven);
            result.put("{LEAD_UNIT_NAME}", noneGiven);
        }
        if (details != null && StringUtils.isNotBlank((CharSequence)details.getSponsorCode())) {
            result.put("{SPONSOR_NAME}", details.getSponsorName());
            result.put("{SPONSOR_CODE}", details.getSponsorCode());
        } else {
            result.put("{SPONSOR_NAME}", noneGiven);
            result.put("{SPONSOR_CODE}", noneGiven);
        }
        if (details != null && StringUtils.isNotBlank((CharSequence)details.getPrimeSponsorCode())) {
            result.put("{PRIME_SPONSOR_NAME}", details.getPrimeSponsorName());
            result.put("{PRIME_SPONSOR_CODE}", details.getPrimeSponsorCode());
        } else {
            result.put("{PRIME_SPONSOR_NAME}", noneGiven);
            result.put("{PRIME_SPONSOR_CODE}", noneGiven);
        }
        result.put("{DOCUMENT_NUMBER}", this.negotiation.getDocumentNumber());
        return result;
    }

    public Negotiation getNegotiation() {
        return this.negotiation;
    }

    public void setNegotiation(Negotiation negotiation) {
        this.negotiation = negotiation;
    }
}

