/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.histogram.NumericHistogramAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.RangeHistogramAggregator;
import org.elasticsearch.search.aggregations.support.AggregatorSupplier;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.HistogramAggregatorSupplier;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.internal.SearchContext;

public final class HistogramAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final double interval;
    private final double offset;
    private final BucketOrder order;
    private final boolean keyed;
    private final long minDocCount;
    private final double minBound;
    private final double maxBound;

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register("histogram", CoreValuesSourceType.RANGE, (AggregatorSupplier)new HistogramAggregatorSupplier(){

            @Override
            public Aggregator build(String name, AggregatorFactories factories, double interval, double offset, BucketOrder order, boolean keyed, long minDocCount, double minBound, double maxBound, ValuesSource valuesSource, DocValueFormat formatter, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
                ValuesSource.Range rangeValueSource = (ValuesSource.Range)valuesSource;
                if (!rangeValueSource.rangeType().isNumeric()) {
                    throw new IllegalArgumentException("Expected numeric range type but found non-numeric range [" + rangeValueSource.rangeType().name + "]");
                }
                return new RangeHistogramAggregator(name, factories, interval, offset, order, keyed, minDocCount, minBound, maxBound, rangeValueSource, formatter, context, parent, metadata);
            }
        });
        builder.register("histogram", Collections.unmodifiableList(Arrays.asList(CoreValuesSourceType.NUMERIC, CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN)), (AggregatorSupplier)new HistogramAggregatorSupplier(){

            @Override
            public Aggregator build(String name, AggregatorFactories factories, double interval, double offset, BucketOrder order, boolean keyed, long minDocCount, double minBound, double maxBound, ValuesSource valuesSource, DocValueFormat formatter, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
                return new NumericHistogramAggregator(name, factories, interval, offset, order, keyed, minDocCount, minBound, maxBound, (ValuesSource.Numeric)valuesSource, formatter, context, parent, metadata);
            }
        });
    }

    public HistogramAggregatorFactory(String name, ValuesSourceConfig config, double interval, double offset, BucketOrder order, boolean keyed, long minDocCount, double minBound, double maxBound, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.interval = interval;
        this.offset = offset;
        this.order = order;
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.minBound = minBound;
        this.maxBound = maxBound;
    }

    public long minDocCount() {
        return this.minDocCount;
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource valuesSource, SearchContext searchContext, Aggregator parent, boolean collectsFromSingleBucket, Map<String, Object> metadata) throws IOException {
        if (!collectsFromSingleBucket) {
            return HistogramAggregatorFactory.asMultiBucketAggregator(this, searchContext, parent);
        }
        AggregatorSupplier aggregatorSupplier = this.queryShardContext.getValuesSourceRegistry().getAggregator(this.config.valueSourceType(), "histogram");
        if (!(aggregatorSupplier instanceof HistogramAggregatorSupplier)) {
            throw new AggregationExecutionException("Registry miss-match - expected HistogramAggregatorSupplier, found [" + aggregatorSupplier.getClass().toString() + "]");
        }
        HistogramAggregatorSupplier histogramAggregatorSupplier = (HistogramAggregatorSupplier)aggregatorSupplier;
        return histogramAggregatorSupplier.build(this.name, this.factories, this.interval, this.offset, this.order, this.keyed, this.minDocCount, this.minBound, this.maxBound, valuesSource, this.config.format(), searchContext, parent, metadata);
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new NumericHistogramAggregator(this.name, this.factories, this.interval, this.offset, this.order, this.keyed, this.minDocCount, this.minBound, this.maxBound, null, this.config.format(), searchContext, parent, metadata);
    }
}

