/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tasks;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public abstract class CancellableTask
extends Task {
    private volatile String reason;
    private final AtomicBoolean cancelled = new AtomicBoolean(false);

    public CancellableTask(long id, String type, String action, String description, TaskId parentTaskId, Map<String, String> headers) {
        super(id, type, action, description, parentTaskId, headers);
    }

    final void cancel(String reason) {
        assert (reason != null);
        if (this.cancelled.compareAndSet(false, true)) {
            this.reason = reason;
            this.onCancelled();
        }
    }

    public boolean cancelOnParentLeaving() {
        return true;
    }

    public abstract boolean shouldCancelChildrenOnCancellation();

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    @Nullable
    public final String getReasonCancelled() {
        return this.reason;
    }

    protected void onCancelled() {
    }
}

