/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.person;

import java.time.LocalDate;
import java.time.MonthDay;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriodType;
import org.kuali.coeus.common.budget.framework.personnel.AppointmentType;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPerson;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.framework.personnel.TbnPerson;
import org.kuali.coeus.propdev.impl.budget.nonpersonnel.AddProjectBudgetLineItemHelper;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.DateUtils;
import org.kuali.rice.krad.data.DataObjectService;

public class AddProjectPersonnelHelper
extends AddProjectBudgetLineItemHelper {
    private static final long serialVersionUID = -6989960629251660073L;
    public static final String JOB_CODE_REF = "jobCodeRef";
    public static final String BUDGET_PERSON = "budgetPerson";
    private BudgetPerson editBudgetPerson;
    private transient DataObjectService dataObjectService;
    private List<TbnPerson> tbnPersons;
    private BudgetPersonnelDetails budgetPersonnelDetail;
    private BudgetPersonnelDetails editBudgetPersonnelDetail;
    private String budgetPersonGroupName;
    private boolean calculateSalaryByAppointmentDates;
    private List<BudgetPersonnelDetails> calculatedDetails;

    public AddProjectPersonnelHelper() {
        this.initPersonDetails();
    }

    @Override
    public void reset() {
        super.reset();
        this.initPersonDetails();
    }

    private void initPersonDetails() {
        this.editBudgetPerson = new BudgetPerson();
        this.budgetPersonnelDetail = new BudgetPersonnelDetails();
        this.editBudgetPersonnelDetail = new BudgetPersonnelDetails();
        this.budgetPersonGroupName = "";
        this.tbnPersons = new ArrayList<TbnPerson>();
        this.calculatedDetails = null;
        this.calculateSalaryByAppointmentDates = false;
    }

    public BudgetPerson getEditBudgetPerson() {
        return this.editBudgetPerson;
    }

    public void setEditBudgetPerson(BudgetPerson editBudgetPerson) {
        this.editBudgetPerson = editBudgetPerson;
    }

    public DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KcServiceLocator.getService(DataObjectService.class);
        }
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public List<TbnPerson> getTbnPersons() {
        if (this.tbnPersons.isEmpty()) {
            this.tbnPersons = this.getDataObjectService().findAll(TbnPerson.class).getResults();
        }
        return this.tbnPersons;
    }

    public void setTbnPersons(List<TbnPerson> tbnPersons) {
        this.tbnPersons = tbnPersons;
    }

    public BudgetPersonnelDetails getBudgetPersonnelDetail() {
        return this.budgetPersonnelDetail;
    }

    public void setBudgetPersonnelDetail(BudgetPersonnelDetails budgetPersonnelDetail) {
        this.budgetPersonnelDetail = budgetPersonnelDetail;
    }

    public String getBudgetPersonGroupName() {
        return this.budgetPersonGroupName;
    }

    public void setBudgetPersonGroupName(String budgetPersonGroupName) {
        this.budgetPersonGroupName = budgetPersonGroupName;
    }

    public String getJobTitle() {
        if (this.getEditBudgetPerson().getJobCode() != null) {
            this.getDataObjectService().wrap((Object)this.getEditBudgetPerson()).fetchRelationship(JOB_CODE_REF);
        }
        return this.getEditBudgetPerson().getJobCodeRef() != null ? this.getEditBudgetPerson().getJobCodeRef().getJobTitle() : "";
    }

    public AppointmentType getAppointmentType() {
        this.getDataObjectService().wrap((Object)this.getBudgetPersonnelDetail()).fetchRelationship(BUDGET_PERSON);
        BudgetPerson budgetPerson = this.getBudgetPersonnelDetail().getBudgetPerson();
        return budgetPerson != null ? budgetPerson.getAppointmentType() : null;
    }

    public BudgetPersonnelDetails getEditBudgetPersonnelDetail() {
        return this.editBudgetPersonnelDetail;
    }

    public void setEditBudgetPersonnelDetail(BudgetPersonnelDetails editBudgetPersonnelDetail) {
        this.editBudgetPersonnelDetail = editBudgetPersonnelDetail;
    }

    public boolean isCalculateSalaryByAppointmentDates() {
        return this.calculateSalaryByAppointmentDates;
    }

    public void setCalculateSalaryByAppointmentDates(boolean calculateSalaryByAppointmentDates) {
        this.calculateSalaryByAppointmentDates = calculateSalaryByAppointmentDates;
    }

    public List<BudgetPersonnelDetails> getCalculatedDetails() {
        if (this.calculatedDetails == null) {
            this.calculateLineItemDetails();
        }
        return this.calculatedDetails;
    }

    private void calculateLineItemDetails() {
        if (this.isCalculateSalaryByAppointmentDates() && this.budgetPeriodOverlapsAppointmentType()) {
            BudgetPersonnelDetails budgetPersonnelDetails = this.getBudgetPersonnelDetail();
            BudgetLineItem newBudgetLineItem = this.getBudgetLineItem();
            BudgetPersonnelDetails newBudgetPersonnelDetail = this.getBudgetPersonnelDetail();
            AppointmentType appointmentType = this.getAppointmentType();
            this.calculatedDetails = new ArrayList<BudgetPersonnelDetails>();
            LocalDate currentStartDate = budgetPersonnelDetails.getStartDate().toLocalDate();
            LocalDate periodEndDate = budgetPersonnelDetails.getEndDate().toLocalDate();
            while (currentStartDate.isBefore(periodEndDate)) {
                Pair<LocalDate, BudgetPeriodType> endDateAndPeriodType = this.findNextDateAndPeriodType(currentStartDate, appointmentType);
                this.calculatedDetails.add(this.copyDetails(newBudgetPersonnelDetail, currentStartDate, (LocalDate)endDateAndPeriodType.getKey(), (BudgetPeriodType)endDateAndPeriodType.getValue()));
                currentStartDate = ((LocalDate)endDateAndPeriodType.getKey()).plusDays(1L);
            }
            newBudgetLineItem.setStartDate(this.calculatedDetails.get(0).getStartDate());
            newBudgetLineItem.setEndDate(this.calculatedDetails.get(this.calculatedDetails.size() - 1).getEndDate());
        } else {
            this.calculatedDetails = List.of(this.getBudgetPersonnelDetail());
        }
    }

    private boolean budgetPeriodOverlapsAppointmentType() {
        BudgetPersonnelDetails newBudgetPersonnelDetail = this.getBudgetPersonnelDetail();
        AppointmentType appointmentType = this.getAppointmentType();
        MonthDay budgetPeriodStart = MonthDay.from(newBudgetPersonnelDetail.getStartDate().toLocalDate());
        MonthDay budgetPeriodEnd = MonthDay.from(newBudgetPersonnelDetail.getEndDate().toLocalDate());
        return DateUtils.periodsOverlap(budgetPeriodStart, budgetPeriodEnd, appointmentType.getStartDate(), appointmentType.getEndDate());
    }

    private Pair<LocalDate, BudgetPeriodType> findNextDateAndPeriodType(LocalDate from, AppointmentType appointmentType) {
        LocalDate appointmentStart = appointmentType.getStartDate().atYear(from.getYear());
        LocalDate appointmentEnd = appointmentType.getEndDate().atYear(from.getYear());
        boolean wrapEndOfYear = appointmentType.getEndDate().isBefore(appointmentType.getStartDate());
        if (wrapEndOfYear && from.isBefore(appointmentEnd)) {
            return Pair.of((Object)appointmentEnd, (Object)appointmentType.getBudgetPeriodType());
        }
        if (from.isBefore(appointmentStart)) {
            return Pair.of((Object)appointmentStart.plusDays(-1L), (Object)this.fetchDefaultBudgetPeriodType(appointmentType.getBudgetPeriodTypeCode()));
        }
        if (from.isBefore(appointmentEnd)) {
            return Pair.of((Object)appointmentEnd, (Object)appointmentType.getBudgetPeriodType());
        }
        LocalDate periodEnd = this.getBudgetPersonnelDetail().getEndDate().toLocalDate();
        BudgetPeriodType budgetPeriodType = DateUtils.periodsOverlap(MonthDay.from(from), MonthDay.from(periodEnd), appointmentType.getStartDate(), appointmentType.getEndDate()) ? appointmentType.getBudgetPeriodType() : this.fetchDefaultBudgetPeriodType(appointmentType.getBudgetPeriodTypeCode());
        return Pair.of((Object)periodEnd, (Object)budgetPeriodType);
    }

    private BudgetPeriodType fetchDefaultBudgetPeriodType(String appointmentBugetTypeCode) {
        switch (appointmentBugetTypeCode) {
            case "2": {
                return (BudgetPeriodType)this.getDataObjectService().find(BudgetPeriodType.class, (Object)"4");
            }
            case "4": {
                return (BudgetPeriodType)this.getDataObjectService().find(BudgetPeriodType.class, (Object)"2");
            }
        }
        return (BudgetPeriodType)this.getDataObjectService().find(BudgetPeriodType.class, (Object)"3");
    }

    private BudgetLineItem copyLineItem(BudgetLineItem template, LocalDate startDate, LocalDate endDate) {
        BudgetLineItem budgetLineItem = new BudgetLineItem();
        budgetLineItem.setStartDate(DateUtils.newDate(startDate));
        budgetLineItem.setEndDate(DateUtils.newDate(endDate));
        budgetLineItem.setBudgetCategoryCode(template.getBudgetCategoryCode());
        budgetLineItem.setCostElement(template.getCostElement());
        budgetLineItem.setCostElementBO(template.getCostElementBO());
        budgetLineItem.setGroupName(template.getGroupName());
        budgetLineItem.setBudgetPeriod(template.getBudgetPeriod());
        budgetLineItem.setBudgetId(template.getBudgetId());
        budgetLineItem.setBudget(template.getBudget());
        budgetLineItem.setBudgetCategoryCode(template.getBudgetCategoryCode());
        return budgetLineItem;
    }

    private BudgetPersonnelDetails copyDetails(BudgetPersonnelDetails template, LocalDate startDate, LocalDate endDate, BudgetPeriodType budgetPeriodType) {
        BudgetPersonnelDetails budgetPersonnelDetails = new BudgetPersonnelDetails();
        budgetPersonnelDetails.setStartDate(DateUtils.newDate(startDate));
        budgetPersonnelDetails.setEndDate(DateUtils.newDate(endDate));
        budgetPersonnelDetails.setPeriodTypeCode(budgetPeriodType.getBudgetPeriodTypeCode());
        budgetPersonnelDetails.setBudgetPeriod(template.getBudgetPeriod());
        budgetPersonnelDetails.setBudget(template.getBudget());
        budgetPersonnelDetails.setCostElement(template.getCostElement());
        budgetPersonnelDetails.setPersonId(template.getPersonId());
        budgetPersonnelDetails.setBudgetPerson(template.getBudgetPerson());
        budgetPersonnelDetails.setPersonSequenceNumber(template.getPersonSequenceNumber());
        budgetPersonnelDetails.setPercentEffort(template.getPercentEffort());
        budgetPersonnelDetails.setPercentCharged(template.getPercentCharged());
        budgetPersonnelDetails.setSalaryRequested(template.getSalaryRequested());
        return budgetPersonnelDetails;
    }
}

