/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import java.util.Objects;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.ComponentTree;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.geo.XYRectangle;
import org.apache.lucene.index.PointValues;

final class Rectangle2D
implements Component2D {
    private final double minX;
    private final double maxX;
    private final double minY;
    private final double maxY;
    private static double MIN_LON_INCL_QUANTIZE = GeoEncodingUtils.decodeLongitude(GeoEncodingUtils.MIN_LON_ENCODED);
    private static double MAX_LON_INCL_QUANTIZE = GeoEncodingUtils.decodeLongitude(GeoEncodingUtils.MAX_LON_ENCODED);

    private Rectangle2D(double minX, double maxX, double minY, double maxY) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
    }

    @Override
    public double getMinX() {
        return this.minX;
    }

    @Override
    public double getMaxX() {
        return this.maxX;
    }

    @Override
    public double getMinY() {
        return this.minY;
    }

    @Override
    public double getMaxY() {
        return this.maxY;
    }

    @Override
    public boolean contains(double x, double y) {
        return Component2D.containsPoint(x, y, this.minX, this.maxX, this.minY, this.maxY);
    }

    @Override
    public PointValues.Relation relate(double minX, double maxX, double minY, double maxY) {
        if (Component2D.disjoint(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY)) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (Component2D.within(minX, maxX, minY, maxY, this.minX, this.maxX, this.minY, this.maxY)) {
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        return PointValues.Relation.CELL_CROSSES_QUERY;
    }

    @Override
    public PointValues.Relation relateTriangle(double minX, double maxX, double minY, double maxY, double ax, double ay, double bx, double by, double cx, double cy) {
        if (Component2D.disjoint(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY)) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        int edgesContain = this.numberOfCorners(ax, ay, bx, by, cx, cy);
        if (edgesContain == 3) {
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        if (edgesContain != 0) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        if (Component2D.pointInTriangle(minX, maxX, minY, maxY, this.minX, this.minY, ax, ay, bx, by, cx, cy) || this.edgesIntersect(ax, ay, bx, by) || this.edgesIntersect(bx, by, cx, cy) || this.edgesIntersect(cx, cy, ax, ay)) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        return PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    @Override
    public Component2D.WithinRelation withinTriangle(double minX, double maxX, double minY, double maxY, double ax, double ay, boolean ab, double bx, double by, boolean bc, double cx, double cy, boolean ca) {
        if (ax == bx && ay == by || ax == cx && ay == cy || bx == cx && by == cy) {
            return Component2D.WithinRelation.DISJOINT;
        }
        if (Component2D.disjoint(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY)) {
            return Component2D.WithinRelation.DISJOINT;
        }
        if (this.contains(ax, ay) || this.contains(bx, by) || this.contains(cx, cy)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        Component2D.WithinRelation relation = Component2D.WithinRelation.DISJOINT;
        if (this.edgesIntersect(ax, ay, bx, by)) {
            if (ab) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (this.edgesIntersect(bx, by, cx, cy)) {
            if (bc) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (this.edgesIntersect(cx, cy, ax, ay)) {
            if (ca) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (relation == Component2D.WithinRelation.CANDIDATE) {
            return Component2D.WithinRelation.CANDIDATE;
        }
        if (Component2D.pointInTriangle(minX, maxX, minY, maxY, this.minX, this.minY, ax, ay, bx, by, cx, cy)) {
            return Component2D.WithinRelation.CANDIDATE;
        }
        return relation;
    }

    private boolean edgesIntersect(double ax, double ay, double bx, double by) {
        if (ax == bx && ay == by) {
            return false;
        }
        if (Math.max(ax, bx) < this.minX || Math.min(ax, bx) > this.maxX || Math.min(ay, by) > this.maxY || Math.max(ay, by) < this.minY) {
            return false;
        }
        if (GeoUtils.orient(ax, ay, bx, by, this.minX, this.maxY) * GeoUtils.orient(ax, ay, bx, by, this.maxX, this.maxY) <= 0 && GeoUtils.orient(this.minX, this.maxY, this.maxX, this.maxY, ax, ay) * GeoUtils.orient(this.minX, this.maxY, this.maxX, this.maxY, bx, by) <= 0) {
            return true;
        }
        if (GeoUtils.orient(ax, ay, bx, by, this.maxX, this.maxY) * GeoUtils.orient(ax, ay, bx, by, this.maxX, this.minY) <= 0 && GeoUtils.orient(this.maxX, this.maxY, this.maxX, this.minY, ax, ay) * GeoUtils.orient(this.maxX, this.maxY, this.maxX, this.minY, bx, by) <= 0) {
            return true;
        }
        if (GeoUtils.orient(ax, ay, bx, by, this.maxX, this.minY) * GeoUtils.orient(ax, ay, bx, by, this.minX, this.minY) <= 0 && GeoUtils.orient(this.maxX, this.minY, this.minX, this.minY, ax, ay) * GeoUtils.orient(this.maxX, this.minY, this.minX, this.minY, bx, by) <= 0) {
            return true;
        }
        return GeoUtils.orient(ax, ay, bx, by, this.minX, this.minY) * GeoUtils.orient(ax, ay, bx, by, this.minX, this.maxY) <= 0 && GeoUtils.orient(this.minX, this.minY, this.minX, this.maxY, ax, ay) * GeoUtils.orient(this.minX, this.minY, this.minX, this.maxY, bx, by) <= 0;
    }

    private int numberOfCorners(double ax, double ay, double bx, double by, double cx, double cy) {
        int containsCount = 0;
        if (this.contains(ax, ay)) {
            ++containsCount;
        }
        if (this.contains(bx, by)) {
            ++containsCount;
        }
        if (this.contains(cx, cy)) {
            ++containsCount;
        }
        return containsCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Rectangle2D)) {
            return false;
        }
        Rectangle2D that = (Rectangle2D)o;
        return this.minX == that.minX && this.maxX == that.maxX && this.minY == that.minY && this.maxY == that.maxY;
    }

    public int hashCode() {
        int result = Objects.hash(this.minX, this.maxX, this.minY, this.maxY);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("XYRectangle(x=");
        sb.append(this.minX);
        sb.append(" TO ");
        sb.append(this.maxX);
        sb.append(" y=");
        sb.append(this.minY);
        sb.append(" TO ");
        sb.append(this.maxY);
        sb.append(")");
        return sb.toString();
    }

    static Component2D create(XYRectangle rectangle) {
        return new Rectangle2D(rectangle.minX, rectangle.maxX, rectangle.minY, rectangle.maxY);
    }

    static Component2D create(Rectangle rectangle) {
        double qMinLat = GeoEncodingUtils.decodeLatitude(GeoEncodingUtils.encodeLatitudeCeil(rectangle.minLat));
        double qMaxLat = GeoEncodingUtils.decodeLatitude(GeoEncodingUtils.encodeLatitude(rectangle.maxLat));
        double qMinLon = GeoEncodingUtils.decodeLongitude(GeoEncodingUtils.encodeLongitudeCeil(rectangle.minLon));
        double qMaxLon = GeoEncodingUtils.decodeLongitude(GeoEncodingUtils.encodeLongitude(rectangle.maxLon));
        if (qMinLat > qMaxLat) {
            qMinLat = qMaxLat;
        }
        if (rectangle.minLon > rectangle.maxLon) {
            Component2D[] components = new Component2D[]{new Rectangle2D(MIN_LON_INCL_QUANTIZE, qMaxLon, qMinLat, qMaxLat), new Rectangle2D(qMinLon, MAX_LON_INCL_QUANTIZE, qMinLat, qMaxLat)};
            return ComponentTree.create(components);
        }
        if (qMinLon > qMaxLon) {
            qMinLon = qMaxLon;
        }
        return new Rectangle2D(qMinLon, qMaxLon, qMinLat, qMaxLat);
    }
}

