/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.reqheader;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.security.PropertySuppressionService;

public class HeaderForwardFilter
implements Filter {
    private Set<String> headerNames;
    private ConfigurationService configurationService;
    private GlobalVariableService globalVariableService;
    private PropertySuppressionService propertySuppressionService;

    public void init(FilterConfig filterConfig) {
        this.configurationService = (ConfigurationService)KcServiceLocator.getService("kualiConfigurationService");
        this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        this.propertySuppressionService = KcServiceLocator.getService(PropertySuppressionService.class);
        this.headerNames = Stream.of(this.getConfigurationService().getPropertyValueAsString("headers.forward").split(",")).map(String::trim).filter(StringUtils::isNotBlank).map(String::toLowerCase).collect(Collectors.toSet());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, filterChain);
    }

    public void destroy() {
        this.headerNames = null;
        this.globalVariableService = null;
        this.configurationService = null;
        this.propertySuppressionService = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.headerNames.isEmpty()) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            Map headers = CollectionUtils.asStream(request.getHeaderNames()).map(String::trim).map(String::toLowerCase).filter(name -> this.headerNames.contains(name)).map(name -> {
                Enumeration vals = request.getHeaders(name);
                return CollectionUtils.entry(name, vals != null ? Collections.list(vals) : null);
            }).filter(entry -> entry.getValue() != null).collect(CollectionUtils.entriesToMap());
            try {
                if (!headers.isEmpty()) {
                    this.globalVariableService.setRequestCache("headers.forward", headers);
                    ThreadContext.put((String)"headers.forward", (String)this.getPropertySuppressionService().suppressValuesMap(headers).toString());
                }
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            finally {
                this.globalVariableService.setRequestCache("headers.forward", Collections.emptyMap());
                ThreadContext.remove((String)"headers.forward");
            }
        }
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public PropertySuppressionService getPropertySuppressionService() {
        return this.propertySuppressionService;
    }

    public void setPropertySuppressionService(PropertySuppressionService propertySuppressionService) {
        this.propertySuppressionService = propertySuppressionService;
    }
}

