/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.award.AccountInformationBean;
import org.kuali.coeus.award.finance.AwardAccount;
import org.kuali.coeus.award.finance.AwardPostHistoryBean;
import org.kuali.coeus.award.finance.AwardPosts;
import org.kuali.coeus.award.finance.dao.AccountDao;
import org.kuali.coeus.award.finance.timeAndMoney.TimeAndMoneyPostHistoryBean;
import org.kuali.coeus.award.finance.timeAndMoney.TimeAndMoneyPosts;
import org.kuali.coeus.award.finance.timeAndMoney.dao.TimeAndMoneyPostsDao;
import org.kuali.coeus.coi.framework.DisclosureProjectStatus;
import org.kuali.coeus.coi.framework.DisclosureStatusRetrievalService;
import org.kuali.coeus.common.budget.framework.core.BudgetVersionFormBase;
import org.kuali.coeus.common.framework.custom.CustomDataDocumentForm;
import org.kuali.coeus.common.framework.medusa.MedusaBean;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.common.notification.impl.NotificationHelper;
import org.kuali.coeus.sys.framework.model.MultiLookupForm;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.Auditable;
import org.kuali.kra.award.AwardTemplateSyncScope;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyBean;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyTempObject;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncBean;
import org.kuali.kra.award.budget.AwardBudgetLimitsBean;
import org.kuali.kra.award.budget.BudgetLimitSummaryHelper;
import org.kuali.kra.award.commitments.AwardFandaRate;
import org.kuali.kra.award.commitments.CostShareFormHelper;
import org.kuali.kra.award.contacts.AwardCentralAdminContactsBean;
import org.kuali.kra.award.contacts.AwardCreditSplitBean;
import org.kuali.kra.award.contacts.AwardProjectPersonnelBean;
import org.kuali.kra.award.contacts.AwardSponsorContactsBean;
import org.kuali.kra.award.contacts.AwardUnitContactsBean;
import org.kuali.kra.award.customdata.CustomDataHelper;
import org.kuali.kra.award.detailsdates.DetailsAndDatesFormHelper;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardCfda;
import org.kuali.kra.award.home.AwardComment;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.home.approvedsubawards.ApprovedSubawardFormHelper;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposal;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposalBean;
import org.kuali.kra.award.notesandattachments.attachments.AwardAttachmentFormBean;
import org.kuali.kra.award.notesandattachments.comments.AwardCommentBean;
import org.kuali.kra.award.notesandattachments.notes.AwardNotepadBean;
import org.kuali.kra.award.notification.AwardNotificationContext;
import org.kuali.kra.award.paymentreports.ReportClass;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportsBean;
import org.kuali.kra.award.paymentreports.awardreports.reporting.ReportTracking;
import org.kuali.kra.award.paymentreports.awardreports.reporting.ReportTrackingBean;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingService;
import org.kuali.kra.award.paymentreports.closeout.AwardCloseoutBean;
import org.kuali.kra.award.paymentreports.paymentschedule.PaymentScheduleBean;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.ApprovedEquipmentBean;
import org.kuali.kra.award.paymentreports.specialapproval.foreigntravel.ApprovedForeignTravelBean;
import org.kuali.kra.award.permissions.PermissionsHelper;
import org.kuali.kra.award.printing.AwardPrintNotice;
import org.kuali.kra.award.printing.AwardTransactionSelectorBean;
import org.kuali.kra.award.service.AwardHierarchyUIService;
import org.kuali.kra.award.specialreview.SpecialReviewHelper;
import org.kuali.kra.award.web.struts.action.SponsorTermFormHelper;
import org.kuali.kra.external.award.AwardAccountService;
import org.kuali.kra.external.award.web.AccountCreationPresentationHelper;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.criteria.CountFlag;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.datadictionary.HeaderNavigation;
import org.kuali.rice.kns.util.ActionFormUtilMap;
import org.kuali.rice.kns.web.ui.ExtraButton;
import org.kuali.rice.kns.web.ui.HeaderField;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardForm
extends BudgetVersionFormBase
implements MultiLookupForm,
Auditable,
CustomDataDocumentForm {
    public static final String SAVE = "save";
    public static final String RELOAD = "reload";
    private static final String CUSTOM_DATA_NAV_TO = "customData";
    private static final int NUMBER_30 = 30;
    public static final String COLUMN = ":";
    public static final String UPDATE_TIMESTAMP_DD_NAME = "DataDictionary.Award.attributes.updateTimestamp";
    public static final String SPONSOR_DD_NAME = "DataDictionary.Sponsor.attributes.sponsorName";
    private static final Logger LOG = LogManager.getLogger(AwardForm.class);
    public static final String ACCOUNT_NUMBER = "accountNumber";
    public static final String METHOD_TO_CALL_POST_AWARD = "methodToCall.postAward";
    public static final String POST_AWARD_ALT_TEXT = "Post Award";
    public static final String BUTTONSMALL_POST_GIF = "buttonsmall_postawardbudget.gif";
    public static final String BUTTONSMALL_SEND_NOTIFICATION_GIF = "buttonsmall_send_notification.gif";
    public static final String SEND_NOTIFICATION = "Send Notification";
    public static final String METHOD_TO_CALL_SEND_NOTIFICATION = "methodToCall.sendNotification";
    private final String AWARD_HIERARCHY_TEMP_OBJ_PARAM_NAME_PREFIX = "awardHierarchyTempObject[";
    private final int AWARD_HIERARCHY_TEMP_OBJ_PARAM_NAME_PREFIX_LENGTH = "awardHierarchyTempObject[".length();
    private static final long serialVersionUID = -7633960906991275328L;
    private static final String PAYMENT_SCHEDULE_ACTIVE_LINKS_PARAMETER = "AwardPaymentScheduleActiveLinks";
    private static Boolean displayAwardPaymentScheduleActiveLinkFields;
    private String lookupResultsBOClassName;
    private String lookupResultsSequenceNumber;
    private String prevAwardNumber;
    private String prevRootAwardNumber;
    private AwardComment newAwardCostShareComment;
    private AwardCfda newAwardCfda;
    private AwardFandaRate newAwardFandaRate;
    private List<ConcreteKeyValue> reportClasses;
    private String directIndirectViewEnabled;
    private ApprovedEquipmentBean approvedEquipmentBean;
    private AwardProjectPersonnelBean projectPersonnelBean;
    private AwardUnitContactsBean unitContactsBean;
    private AwardCentralAdminContactsBean centralAdminContactsBean;
    private AwardSponsorContactsBean sponsorContactsBean;
    private CostShareFormHelper costShareFormHelper;
    private SponsorTermFormHelper sponsorTermFormHelper;
    private ApprovedSubawardFormHelper approvedSubawardFormHelper;
    private DetailsAndDatesFormHelper detailsAndDatesFormHelper;
    private AwardCloseoutBean awardCloseoutBean;
    private ReportClass reportClassForPaymentsAndInvoices;
    private PaymentScheduleBean paymentScheduleBean;
    private ApprovedForeignTravelBean approvedForeignTravelBean;
    private AwardReportsBean awardReportsBean;
    private AwardCommentBean awardCommentBean;
    private AwardNotepadBean awardNotepadBean;
    private AwardAttachmentFormBean awardAttachmentFormBean;
    private MedusaBean medusaBean;
    private AwardBudgetLimitsBean awardBudgetLimitsBean;
    private boolean auditActivated;
    private CustomDataHelper customDataHelper = new CustomDataHelper(this);
    private PermissionsHelper permissionsHelper;
    private SpecialReviewHelper specialReviewHelper;
    private NotificationHelper<AwardNotificationContext> notificationHelper;
    private AwardCreditSplitBean awardCreditSplitBean;
    private Map<String, AwardHierarchy> awardHierarchyNodes;
    private String awardNumberInputTemp;
    private AwardFundingProposalBean fundingProposalBean;
    private String awardHierarchy;
    private String awardNumber;
    private String awardHierarchyTargetAwardNumber;
    private String awardHierarchySourceAwardStrList;
    private String awardHierarchyTargetAwardStrList;
    private String addRA;
    private String deletedRas;
    private String rootAwardNumber;
    private AwardHierarchyBean awardHierarchyBean;
    private AwardPrintNotice awardPrintNotice;
    private AwardTransactionSelectorBean awardPrintChangeReport;
    private AwardTransactionSelectorBean awardTimeAndMoneyTransactionReport;
    private List<AwardComment> awardCommentHistoryByType;
    private Map<AwardTemplateSyncScope, Boolean> syncRequiresConfirmationMap;
    private AwardTemplateSyncScope[] currentSyncScopes;
    private String currentSyncQuestionId;
    private Integer oldTemplateCode;
    private boolean templateLookup = false;
    private String newProposalBudgetPeriods;
    private String currentAwardNumber;
    private String currentSeqNumber;
    private List<ReportTracking> reportTrackingsToDelete = new ArrayList<ReportTracking>();
    private boolean viewFundingSource;
    private boolean syncMode;
    private AwardSyncBean awardSyncBean;
    private Long placeHolderAwardId;
    private boolean docOpenedFromAwardSearch;
    private BudgetLimitSummaryHelper budgetLimitSummary;
    private transient ParameterService parameterService;
    private transient AwardService awardService;
    private transient AwardHierarchyUIService awardHierarchyUIService;
    private transient ReportTrackingService reportTrackingService;
    private transient DataObjectService dataObjectService;
    private List<ReportTrackingBean> reportTrackingBeans;
    private AccountInformationBean accountInformationBean;
    private AccountCreationPresentationHelper accountCreationHelper;
    private transient List<DisclosureProjectStatus> disclosureProjectStatuses;
    private transient DisclosureStatusRetrievalService disclosureStatusRetrievalService;
    private transient PermissionService permissionService;
    private transient AccountDao accountDao;
    private transient KcPersonService kcPersonService;
    private transient TimeAndMoneyPostsDao timeAndMoneyPostsDao;
    private Boolean isBudgetVersionSummaryCumulative;
    private transient AwardAccountService awardAccountService;

    public AwardForm() {
        this.initialize();
    }

    @Override
    protected String getDefaultDocumentTypeName() {
        return "AwardDocument";
    }

    public void initialize() {
        this.newAwardFandaRate = new AwardFandaRate();
        this.awardCommentHistoryByType = new ArrayList<AwardComment>();
        this.costShareFormHelper = new CostShareFormHelper(this);
        this.centralAdminContactsBean = new AwardCentralAdminContactsBean(this);
        this.sponsorTermFormHelper = new SponsorTermFormHelper(this);
        this.approvedSubawardFormHelper = new ApprovedSubawardFormHelper(this);
        this.approvedEquipmentBean = new ApprovedEquipmentBean(this);
        this.paymentScheduleBean = new PaymentScheduleBean(this);
        this.approvedForeignTravelBean = new ApprovedForeignTravelBean(this);
        this.projectPersonnelBean = new AwardProjectPersonnelBean(this);
        this.unitContactsBean = new AwardUnitContactsBean(this);
        this.sponsorContactsBean = new AwardSponsorContactsBean(this);
        this.detailsAndDatesFormHelper = new DetailsAndDatesFormHelper(this);
        this.awardReportsBean = new AwardReportsBean(this);
        this.awardNotepadBean = new AwardNotepadBean(this);
        this.awardAttachmentFormBean = new AwardAttachmentFormBean(this);
        this.setPermissionsHelper(new PermissionsHelper(this));
        this.setSpecialReviewHelper(new SpecialReviewHelper(this));
        this.setNotificationHelper(new NotificationHelper<AwardNotificationContext>());
        this.awardCreditSplitBean = new AwardCreditSplitBean(this);
        this.awardCommentBean = new AwardCommentBean(this);
        this.awardCloseoutBean = new AwardCloseoutBean(this);
        this.awardHierarchyNodes = new TreeMap<String, AwardHierarchy>();
        this.fundingProposalBean = new AwardFundingProposalBean(this);
        this.awardPrintNotice = new AwardPrintNotice();
        this.awardPrintChangeReport = new AwardTransactionSelectorBean();
        this.buildReportTrackingBeans();
        this.awardHierarchyBean = new AwardHierarchyBean(this);
        this.initializeAccountBean();
        this.medusaBean = new MedusaBean();
        this.syncRequiresConfirmationMap = null;
        this.currentSyncScopes = null;
        this.syncMode = false;
        this.awardSyncBean = new AwardSyncBean(this);
        this.setDirectIndirectViewEnabled(this.getDirectIndirectCostEnabled());
        this.budgetLimitSummary = new BudgetLimitSummaryHelper();
        this.awardBudgetLimitsBean = new AwardBudgetLimitsBean(this);
        this.accountCreationHelper = new AccountCreationPresentationHelper();
    }

    public String getDirectIndirectCostEnabled() {
        return this.getParameter("KC-AWARD", "Document", "ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST");
    }

    public String getParameter(String parameterModuleAward, String documentComponent, String parameterName) {
        return this.getParameterService().getParameterValueAsString(parameterModuleAward, documentComponent, parameterName);
    }

    public void buildReportTrackingBeans() {
        this.reportTrackingBeans = new ArrayList<ReportTrackingBean>();
        int numberOfReportItems = this.getAwardDocument().getAward().getAwardReportTermItems().size();
        for (int i = 0; i < numberOfReportItems; ++i) {
            this.reportTrackingBeans.add(new ReportTrackingBean());
        }
    }

    public boolean isCreditSplitOptInEnabled() {
        return this.getAwardService().isCreditSplitOptInEnabled();
    }

    public AwardDocument getAwardDocument() {
        return (AwardDocument)super.getDocument();
    }

    public ApprovedEquipmentBean getApprovedEquipmentBean() {
        return this.approvedEquipmentBean;
    }

    public ApprovedForeignTravelBean getApprovedForeignTravelBean() {
        return this.approvedForeignTravelBean;
    }

    public AwardCentralAdminContactsBean getCentralAdminContactsBean() {
        return this.centralAdminContactsBean;
    }

    public CostShareFormHelper getCostShareFormHelper() {
        return this.costShareFormHelper;
    }

    public AwardCommentBean getAwardCommentBean() {
        return this.awardCommentBean;
    }

    public void initializeFormOrDocumentBasedOnCommand() {
        if ("initiate".equals(this.getCommand())) {
            this.getAwardDocument().initialize();
        } else {
            this.initialize();
        }
    }

    public AwardComment getNewAwardCostShareComment() {
        return this.newAwardCostShareComment;
    }

    public void setNewAwardCostShareComment(AwardComment newAwardCostShareComment) {
        this.newAwardCostShareComment = newAwardCostShareComment;
    }

    public AwardCfda getNewAwardCfda() {
        return this.newAwardCfda;
    }

    public void setNewAwardCfda(AwardCfda newAwardCfda) {
        this.newAwardCfda = newAwardCfda;
    }

    public AwardFandaRate getNewAwardFandaRate() {
        return this.newAwardFandaRate;
    }

    public void setNewAwardFandaRate(AwardFandaRate newAwardFandaRate) {
        this.newAwardFandaRate = newAwardFandaRate;
    }

    @Override
    protected String getLockRegion() {
        return "AWARD";
    }

    @Override
    public String getLookupResultsBOClassName() {
        return this.lookupResultsBOClassName;
    }

    @Override
    public void setLookupResultsBOClassName(String lookupResultsBOClassName) {
        this.lookupResultsBOClassName = lookupResultsBOClassName;
    }

    @Override
    public String getLookupResultsSequenceNumber() {
        return this.lookupResultsSequenceNumber;
    }

    @Override
    public void setLookupResultsSequenceNumber(String lookupResultsSequenceNumber) {
        this.lookupResultsSequenceNumber = lookupResultsSequenceNumber;
    }

    public List<AwardComment> getAwardCommentHistoryByType() {
        return this.awardCommentHistoryByType;
    }

    public void setAwardCommentHistoryByType(List<AwardComment> awardCommentHistoryByType) {
        this.awardCommentHistoryByType = awardCommentHistoryByType;
    }

    public String getSelectedLeadUnit() {
        return this.projectPersonnelBean.getSelectedLeadUnit();
    }

    public AwardSponsorContactsBean getSponsorContactsBean() {
        return this.sponsorContactsBean;
    }

    public AccountCreationPresentationHelper getAccountCreationHelper() {
        return this.accountCreationHelper;
    }

    public AwardUnitContactsBean getUnitContactsBean() {
        return this.unitContactsBean;
    }

    public AwardProjectPersonnelBean getProjectPersonnelBean() {
        return this.projectPersonnelBean;
    }

    public List<ConcreteKeyValue> getReportClasses() {
        if (this.reportClasses != null) {
            Collections.sort(this.reportClasses);
        }
        return this.reportClasses;
    }

    public boolean isAccountCreated() {
        if (this.getAwardDocument().getAward().getAccountNumber() != null) {
            if (this.getAwardDocument().getAward().getFinancialAccountDocumentNumber() != null) {
                return true;
            }
            if (this.isFinancialSystemIntegrationOn()) {
                return this.getAwardDocument().getAward().getFinancialAccountDocumentNumber() != null;
            }
            if (this.getAwardAccountService().isFinancialRestApiEnabled()) {
                return this.accountExistsInQueue();
            }
        }
        return false;
    }

    protected boolean accountExistsInQueue() {
        HashMap<String, String> accountsMap = new HashMap<String, String>();
        accountsMap.put(ACCOUNT_NUMBER, this.getAwardDocument().getAward().getAccountNumber());
        int count = this.getDataObjectService().findMatching(AwardPosts.class, QueryByCriteria.Builder.andAttributes(accountsMap).setCountFlag(CountFlag.ONLY).build()).getTotalRowCount();
        return count != 0;
    }

    private void initializeAccountBean() {
        AwardAccount account;
        this.accountInformationBean = new AccountInformationBean();
        if (this.getAwardDocument().getAward().getAccountNumber() != null && this.getAwardAccountService().isFinancialRestApiEnabled() && Objects.nonNull(account = this.getAccountFromQueue())) {
            this.accountInformationBean.setIncome(account.getIncome());
            this.accountInformationBean.setBudgeted(account.getBudgeted());
            this.accountInformationBean.setAvailable(account.getAvailable());
            this.accountInformationBean.setExpense(account.getExpense());
            this.accountInformationBean.setPending(account.getPending());
            this.accountInformationBean.setComment(account.getComment());
        }
    }

    protected AwardAccount getAccountFromQueue() {
        HashMap<String, String> accountsMap = new HashMap<String, String>();
        accountsMap.put(ACCOUNT_NUMBER, this.getAwardDocument().getAward().getAccountNumber());
        List accounts = this.getDataObjectService().findMatching(AwardAccount.class, QueryByCriteria.Builder.andAttributes(accountsMap).build()).getResults();
        return accounts.isEmpty() ? null : (AwardAccount)accounts.get(0);
    }

    public boolean isDisplayAccountBalances() {
        return this.getParameterService().getParameterValueAsBoolean("KC-AWARD", "All", "DISPLAY_ACCOUNT_BALANCES");
    }

    public boolean isAccountNumberReadOnly() {
        return this.isFinancialSystemIntegrationOn() || this.isPostAwardFinancialsEnabled();
    }

    protected DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KcServiceLocator.getService(DataObjectService.class);
        }
        return this.dataObjectService;
    }

    protected boolean isFinancialSystemIntegrationOn() {
        return this.getParameterService().getParameterValueAsBoolean("KC-AWARD", "Document", "KUALI_FINANCIALS_INTEGRATION_ON");
    }

    protected boolean isPostAwardFinancialsEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-AWARD", "Document", "Enable_PostAwardFinancials");
    }

    public void setReportClasses(List<ConcreteKeyValue> reportClasses) {
        this.reportClasses = reportClasses;
    }

    public ApprovedSubawardFormHelper getApprovedSubawardFormHelper() {
        return this.approvedSubawardFormHelper;
    }

    public void setApprovedSubawardFormHelper(ApprovedSubawardFormHelper approvedSubawardFormHelper) {
        this.approvedSubawardFormHelper = approvedSubawardFormHelper;
    }

    public ReportClass getReportClassForPaymentsAndInvoices() {
        return this.reportClassForPaymentsAndInvoices;
    }

    public void setReportClassForPaymentsAndInvoices(ReportClass reportClassForPaymentsAndInvoices) {
        this.reportClassForPaymentsAndInvoices = reportClassForPaymentsAndInvoices;
    }

    public SponsorTermFormHelper getSponsorTermFormHelper() {
        return this.sponsorTermFormHelper;
    }

    public void setSelectedLeadUnit(String unitNumber) {
        this.projectPersonnelBean.setSelectedLeadUnit(unitNumber);
    }

    public void setSponsorTermFormHelper(SponsorTermFormHelper sponsorTermFormHelper) {
        this.sponsorTermFormHelper = sponsorTermFormHelper;
    }

    public PaymentScheduleBean getPaymentScheduleBean() {
        return this.paymentScheduleBean;
    }

    public void setPaymentScheduleBean(PaymentScheduleBean paymentScheduleBean) {
        this.paymentScheduleBean = paymentScheduleBean;
    }

    @Override
    public boolean isAuditActivated() {
        return this.auditActivated;
    }

    @Override
    public void setAuditActivated(boolean auditActivated) {
        this.auditActivated = auditActivated;
    }

    public boolean isAwardInMultipleNodeHierarchy() {
        return this.getAwardDocument().getAward().isAwardInMultipleNodeHierarchy();
    }

    public boolean isAwardHasAssociatedTandMOrIsVersioned() {
        return this.getAwardDocument().getAward().isAwardHasAssociatedTandMOrIsVersioned();
    }

    public int getIndexOfAwardAmountInfoForDisplay() {
        return this.getAwardDocument().getAward().getIndexOfAwardAmountInfoForDisplay();
    }

    public DetailsAndDatesFormHelper getDetailsAndDatesFormHelper() {
        return this.detailsAndDatesFormHelper;
    }

    public void setDetailsAndDatesFormHelper(DetailsAndDatesFormHelper detailsAndDatesFormHelper) {
        this.detailsAndDatesFormHelper = detailsAndDatesFormHelper;
    }

    public SpecialReviewHelper getSpecialReviewHelper() {
        return this.specialReviewHelper;
    }

    public void setSpecialReviewHelper(SpecialReviewHelper specialReviewHelper) {
        this.specialReviewHelper = specialReviewHelper;
    }

    public NotificationHelper<AwardNotificationContext> getNotificationHelper() {
        return this.notificationHelper;
    }

    public void setNotificationHelper(NotificationHelper<AwardNotificationContext> notificationHelper) {
        this.notificationHelper = notificationHelper;
    }

    public PermissionsHelper getPermissionsHelper() {
        return this.permissionsHelper;
    }

    public void setPermissionsHelper(PermissionsHelper awardPermissionsHelper) {
        this.permissionsHelper = awardPermissionsHelper;
    }

    public String getDocumentTypeName() {
        return "AwardDocument";
    }

    @Override
    public String getActionName() {
        return "award";
    }

    @Override
    public CustomDataHelper getCustomDataHelper() {
        return this.customDataHelper;
    }

    public void setCustomDataHelper(CustomDataHelper customDataHelper) {
        this.customDataHelper = customDataHelper;
    }

    public void setAwardAuditActivated(boolean awardAuditActivated) {
        this.auditActivated = awardAuditActivated;
    }

    public AwardCreditSplitBean getAwardCreditSplitBean() {
        return this.awardCreditSplitBean;
    }

    public void setAwardCreditSplitBean(AwardCreditSplitBean awardCreditSplitBean) {
        this.awardCreditSplitBean = awardCreditSplitBean;
    }

    public void setAwardProjectPersonnelBean(AwardProjectPersonnelBean projectPersonnelBean) {
        this.projectPersonnelBean = projectPersonnelBean;
    }

    public AwardReportsBean getAwardReportsBean() {
        return this.awardReportsBean;
    }

    public void setAwardReportsBean(AwardReportsBean awardReportsBean) {
        this.awardReportsBean = awardReportsBean;
    }

    public AwardCloseoutBean getAwardCloseoutBean() {
        return this.awardCloseoutBean;
    }

    public void setAwardCloseoutBean(AwardCloseoutBean awardCloseoutBean) {
        this.awardCloseoutBean = awardCloseoutBean;
    }

    public AwardNotepadBean getAwardNotepadBean() {
        return this.awardNotepadBean;
    }

    public void setAwardNotepadBean(AwardNotepadBean awardNotepadBean) {
        this.awardNotepadBean = awardNotepadBean;
    }

    public AwardAttachmentFormBean getAwardAttachmentFormBean() {
        return this.awardAttachmentFormBean;
    }

    public void setAwardAttachmentFormBean(AwardAttachmentFormBean awardAttachmentFormBean) {
        this.awardAttachmentFormBean = awardAttachmentFormBean;
    }

    public AwardFundingProposalBean getFundingProposalBean() {
        return this.fundingProposalBean;
    }

    public Map<String, AwardHierarchy> getAwardHierarchyNodes() {
        if (this.awardHierarchyNodes == null || this.awardHierarchyNodes.size() == 0) {
            this.awardHierarchyNodes = this.getAwardHierarchyBean().getAwardHierarchy(this.getAwardHierarchyBean().getRootNode(), new ArrayList<String>());
        }
        return this.awardHierarchyNodes;
    }

    public void setAwardHierarchyNodes(Map<String, AwardHierarchy> awardHierarchyNodes) {
        this.awardHierarchyNodes = awardHierarchyNodes;
    }

    public String getPrevAwardNumber() {
        return this.prevAwardNumber;
    }

    public void setPrevAwardNumber(String prevAwardNumber) {
        this.prevAwardNumber = prevAwardNumber;
    }

    public String getPrevRootAwardNumber() {
        return this.prevRootAwardNumber;
    }

    public void setPrevRootAwardNumber(String prevRootAwardNumber) {
        this.prevRootAwardNumber = prevRootAwardNumber;
    }

    public String getAwardNumberInputTemp() {
        return this.awardNumberInputTemp;
    }

    public void setAwardNumberInputTemp(String awardNumberInputTemp) {
        this.awardNumberInputTemp = awardNumberInputTemp;
    }

    public AwardHierarchyBean getAwardHierarchyBean() {
        return this.awardHierarchyBean;
    }

    public String getAwardHierarchy() throws ParseException {
        this.awardHierarchy = "";
        if (StringUtils.isBlank((CharSequence)this.awardNumber)) {
            this.awardNumber = this.getRootAwardNumber();
        }
        if (this.awardNumber != null && StringUtils.isNotBlank((CharSequence)this.addRA) && this.addRA.equals("E")) {
            this.setAwardHierarchy(this.getAwardHierarchyUIService().getSubAwardHierarchiesForTreeView(this.awardNumber, this.currentAwardNumber, this.currentSeqNumber));
        } else if (this.awardNumber != null && StringUtils.isNotBlank((CharSequence)this.addRA) && this.addRA.equals("N")) {
            this.setAwardHierarchy(this.getAwardHierarchyUIService().getRootAwardNode(this.awardNumber, this.currentAwardNumber, this.currentSeqNumber));
        }
        return this.awardHierarchy;
    }

    public void setAwardHierarchy(String awardHierarchy) {
        this.awardHierarchy = awardHierarchy;
    }

    public String getAwardNumber() {
        return this.awardNumber;
    }

    public void setAwardNumber(String awardNumber) {
        this.awardNumber = awardNumber;
    }

    public String getAddRA() {
        return this.addRA;
    }

    public void setAddRA(String addRA) {
        this.addRA = addRA;
    }

    public String getDeletedRas() {
        return this.deletedRas;
    }

    public void setDeletedRas(String deletedRas) {
        this.deletedRas = deletedRas;
    }

    private AwardHierarchyUIService getAwardHierarchyUIService() {
        if (this.awardHierarchyUIService == null) {
            this.awardHierarchyUIService = KcServiceLocator.getService(AwardHierarchyUIService.class);
        }
        return this.awardHierarchyUIService;
    }

    private ReportTrackingService getReportTrackingService() {
        if (this.reportTrackingService == null) {
            this.reportTrackingService = KcServiceLocator.getService(ReportTrackingService.class);
        }
        return this.reportTrackingService;
    }

    public boolean getDisplayRegenerateButton() {
        return !this.getReportTrackingService().autoRegenerateReports(this.getAwardDocument().getAward());
    }

    public String getRootAwardNumber() {
        return this.rootAwardNumber;
    }

    public void setRootAwardNumber(String rootAwardNumber) {
        this.rootAwardNumber = rootAwardNumber;
    }

    public AwardPrintNotice getAwardPrintNotice() {
        return this.awardPrintNotice;
    }

    public void setAwardPrintNotice(AwardPrintNotice awardPrintNotice) {
        this.awardPrintNotice = awardPrintNotice;
    }

    public AwardTransactionSelectorBean getAwardPrintChangeReport() {
        return this.awardPrintChangeReport;
    }

    public void setAwardPrintChangeReport(AwardTransactionSelectorBean awardPrintChangeReport) {
        this.awardPrintChangeReport = awardPrintChangeReport;
    }

    public List<AwardHierarchyTempObject> getAwardHierarchyTempObjects() {
        if (this.getAwardDocument().getAward().getAwardHierarchyTempObjects() == null) {
            this.getAwardDocument().getAward().initializeAwardHierarchyTempObjects();
        }
        return this.getAwardDocument().getAward().getAwardHierarchyTempObjects();
    }

    public AwardHierarchyTempObject getAwardHierarchyTempObject(int index) {
        while (this.getAwardHierarchyTempObjects().size() <= index) {
            this.getAwardDocument().getAward().getAwardHierarchyTempObjects().add(new AwardHierarchyTempObject());
        }
        return this.getAwardDocument().getAward().getAwardHierarchyTempObjects().get(index);
    }

    public String getValueFinderResultDoNotCache() {
        if (this.getActionFormUtilMap() instanceof ActionFormUtilMap) {
            ((ActionFormUtilMap)this.getActionFormUtilMap()).setCacheValueFinderResults(false);
        }
        return "";
    }

    public String getValueFinderResultCache() {
        if (this.getActionFormUtilMap() instanceof ActionFormUtilMap) {
            ((ActionFormUtilMap)this.getActionFormUtilMap()).setCacheValueFinderResults(true);
        }
        return "";
    }

    public List<ExtraButton> getExtraTopButtons() {
        this.extraButtons.clear();
        String externalImageURL = "kra.externalizable.images.url";
        String generatePeriodImage = this.lookupKualiConfigurationService().getPropertyValueAsString(externalImageURL) + "tinybutton-timemoney.gif";
        this.addExtraButton("methodToCall.timeAndMoney", generatePeriodImage, "Time And Money");
        return this.extraButtons;
    }

    public String getShortUrl() {
        return this.getBaseShortUrl() + "/kc-common/awards/" + this.getAwardDocument().getAward().getAwardNumber();
    }

    private ConfigurationService lookupKualiConfigurationService() {
        return CoreApiServiceLocator.getKualiConfigurationService();
    }

    public MedusaBean getMedusaBean() {
        return this.medusaBean;
    }

    public void setMedusaBean(MedusaBean medusaBean) {
        this.medusaBean = medusaBean;
    }

    public void postprocessRequestParameters(Map requestParameters) {
        super.postprocessRequestParameters(requestParameters);
        Map parms = requestParameters;
        for (String parmKey : parms.keySet()) {
            if (!parmKey.startsWith("awardHierarchyTempObject[")) continue;
            this.populateAwardHierarchyTempObject(parms, parmKey);
        }
    }

    private void populateAwardHierarchyTempObject(Map<String, Object> parms, String parmKey) {
        int indexOfClosingBracket = parmKey.indexOf("]");
        String fieldName = parmKey.substring(indexOfClosingBracket + 2);
        Object fieldValue = parms.get(parmKey);
        int tempObjectIndex = Integer.valueOf(parmKey.substring(this.AWARD_HIERARCHY_TEMP_OBJ_PARAM_NAME_PREFIX_LENGTH, indexOfClosingBracket));
        AwardHierarchyTempObject tempObject = this.getAwardHierarchyTempObject(tempObjectIndex);
        this.populateAwardHierarchyTempObjectFromRequestParms(tempObject, fieldName, fieldValue);
        if (tempObject.getCopyDescendants() == null) {
            tempObject.setCopyDescendants(false);
        }
    }

    private void populateAwardHierarchyTempObjectFromRequestParms(AwardHierarchyTempObject tempObject, String fieldName, Object fieldValue) {
        try {
            BeanUtils.setProperty((Object)tempObject, (String)fieldName, (Object)fieldValue);
        }
        catch (Exception e) {
            String message = String.format("Attempt to set %s property to %s on AwardHierarchyTempObject resulted in exception", fieldName, fieldValue.toString());
            LOG.error(message, (Throwable)e);
            throw new IllegalArgumentException(message, e);
        }
    }

    public Map<AwardTemplateSyncScope, Boolean> getSyncRequiresConfirmationMap() {
        return this.syncRequiresConfirmationMap;
    }

    public void setSyncRequiresConfirmationMap(Map<AwardTemplateSyncScope, Boolean> syncRequiresConfirmationMap) {
        this.syncRequiresConfirmationMap = syncRequiresConfirmationMap;
    }

    public void setCurrentSyncQuestionId(String currentSyncQuestionId) {
        this.currentSyncQuestionId = currentSyncQuestionId;
    }

    public String getCurrentSyncQuestionId() {
        return this.currentSyncQuestionId;
    }

    public AwardTemplateSyncScope[] getCurrentSyncScopes() {
        return this.currentSyncScopes;
    }

    public void setCurrentSyncScopes(AwardTemplateSyncScope[] currentSyncOperations) {
        this.currentSyncScopes = currentSyncOperations;
    }

    public Integer getOldTemplateCode() {
        return this.oldTemplateCode;
    }

    public void setOldTemplateCode(Integer oldTemplateCode) {
        this.oldTemplateCode = oldTemplateCode;
    }

    public boolean isTemplateLookup() {
        return this.templateLookup;
    }

    public void setTemplateLookup(boolean templateCodeChange) {
        this.templateLookup = templateCodeChange;
    }

    public List<Long> getLinkedProposals() {
        ArrayList<Long> linkedProposals = new ArrayList<Long>();
        if (this.getAwardDocument() != null && this.getAwardDocument().getAward() != null) {
            for (AwardFundingProposal fundingProposal : this.getAwardDocument().getAward().getAllFundingProposals()) {
                linkedProposals.add(fundingProposal.getProposalId());
            }
        }
        return linkedProposals;
    }

    public void populateHeaderFields(WorkflowDocument workflowDocument) {
        AwardDocument awardDocument = this.getAwardDocument();
        this.getDocInfo().clear();
        this.getDocInfo().add(new HeaderField("DataDictionary.KraAttributeReferenceDummy.attributes.principalInvestigator", awardDocument.getAward().getPrincipalInvestigatorName()));
        Object docIdAndStatus = COLUMN;
        if (workflowDocument != null) {
            docIdAndStatus = this.getAwardDocument().getDocumentNumber() + COLUMN + workflowDocument.getStatus().getLabel();
        }
        this.getDocInfo().add(new HeaderField("DataDictionary.Award.attributes.docIdStatus", "<div id = \"docIdAndStatus\">" + (String)docIdAndStatus + "</div>"));
        String unitName = awardDocument.getAward().getUnitName();
        if (StringUtils.isNotBlank((CharSequence)unitName) && unitName.length() > 30) {
            unitName = unitName.substring(0, 30);
        }
        this.getDocInfo().add(new HeaderField("DataDictionary.AwardPersonUnit.attributes.leadUnit", unitName));
        this.getDocInfo().add(new HeaderField("DataDictionary.Award.attributes.awardIdAccount", "<div id = \"awardIdAccount\">" + this.getAwardIdAccount(awardDocument) + "</div>"));
        this.setupSponsor(awardDocument);
        this.setupLastUpdate(awardDocument, UPDATE_TIMESTAMP_DD_NAME);
    }

    private String getAwardIdAccount(AwardDocument awardDocument) {
        String awardNum = awardDocument.getAward().getAwardNumber();
        String account = awardDocument.getAward().getAccountNumber() != null ? awardDocument.getAward().getAccountNumber() : "";
        return awardNum + COLUMN + account;
    }

    private void setupSponsor(AwardDocument awardDocument) {
        if (awardDocument.getAward().getSponsor() == null) {
            this.getDocInfo().add(new HeaderField(SPONSOR_DD_NAME, ""));
        } else {
            String sponsorName = awardDocument.getAward().getSponsorName();
            if (StringUtils.isNotBlank((CharSequence)sponsorName) && sponsorName.length() > 30) {
                sponsorName = sponsorName.substring(0, 30);
            }
            this.getDocInfo().add(new HeaderField(SPONSOR_DD_NAME, sponsorName));
        }
    }

    public String getNewProposalBudgetPeriods() {
        return this.newProposalBudgetPeriods;
    }

    public void setNewProposalBudgetPeriods(String newProposalBudgetPeriods) {
        this.newProposalBudgetPeriods = newProposalBudgetPeriods;
    }

    public boolean getDisplayEditButton() {
        return !this.getAwardDocument().isCanceled() && VersionStatus.ACTIVE.toString().equals(this.getAwardDocument().getAward().getAwardSequenceStatus());
    }

    protected VersionHistoryService getVersionHistoryService() {
        return KcServiceLocator.getService(VersionHistoryService.class);
    }

    public String getCurrentAwardNumber() {
        return this.currentAwardNumber;
    }

    public void setCurrentAwardNumber(String currentAwardNumber) {
        this.currentAwardNumber = currentAwardNumber;
    }

    public String getCurrentSeqNumber() {
        return this.currentSeqNumber;
    }

    public void setCurrentSeqNumber(String currentSeqNumber) {
        this.currentSeqNumber = currentSeqNumber;
    }

    public String getCanCreateAward() {
        Boolean aFlag = this.getEditingMode().containsKey("canCreateAward");
        return aFlag.toString();
    }

    public boolean getViewFundingSource() {
        return this.viewFundingSource;
    }

    public void setViewFundingSource(boolean viewFundingSource) {
        this.viewFundingSource = viewFundingSource;
    }

    public void setAwardTimeAndMoneyTransactionReport(AwardTransactionSelectorBean awardTimeAndMoneyTransactionReport) {
        this.awardTimeAndMoneyTransactionReport = awardTimeAndMoneyTransactionReport;
    }

    public AwardTransactionSelectorBean getAwardTimeAndMoneyTransactionReport() {
        return this.awardTimeAndMoneyTransactionReport;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    protected AwardService getAwardService() {
        if (this.awardService == null) {
            this.awardService = KcServiceLocator.getService(AwardService.class);
        }
        return this.awardService;
    }

    protected AwardAccountService getAwardAccountService() {
        if (this.awardAccountService == null) {
            this.awardAccountService = KcServiceLocator.getService(AwardAccountService.class);
        }
        return this.awardAccountService;
    }

    public String getDirectIndirectViewEnabled() {
        return this.directIndirectViewEnabled;
    }

    public boolean isSyncMode() {
        return this.syncMode;
    }

    public void setSyncMode(boolean syncMode) {
        this.syncMode = syncMode;
    }

    public AwardSyncBean getAwardSyncBean() {
        return this.awardSyncBean;
    }

    public void setAwardSyncBean(AwardSyncBean awardSyncBean) {
        this.awardSyncBean = awardSyncBean;
    }

    public void setDirectIndirectViewEnabled(String directIndirectViewEnabled) {
        this.directIndirectViewEnabled = directIndirectViewEnabled;
    }

    public HeaderNavigation[] getHeaderNavigationTabs() {
        HeaderNavigation[] navigation = super.getHeaderNavigationTabs();
        ArrayList<HeaderNavigation> resultList = new ArrayList<HeaderNavigation>();
        for (HeaderNavigation nav : navigation) {
            if (StringUtils.equals((CharSequence)nav.getHeaderTabNavigateTo(), (CharSequence)CUSTOM_DATA_NAV_TO)) {
                boolean displayTab = !this.getCustomDataHelper().getCustomAttributeDocuments().isEmpty();
                nav.setDisabled(!displayTab);
                if (!displayTab) continue;
                resultList.add(nav);
                continue;
            }
            resultList.add(nav);
        }
        HeaderNavigation[] result = new HeaderNavigation[resultList.size()];
        resultList.toArray(result);
        return result;
    }

    protected boolean isAutoPostAward() {
        return this.getParameterService().getParameterValueAsBoolean("KC-AWARD", "All", "AWARD_AUTO_POST_ENABLED");
    }

    public List<ExtraButton> getExtraActionsButtons() {
        this.extraButtons.clear();
        String externalImageURL = "kra.externalizable.images.url";
        ConfigurationService configurationService = CoreApiServiceLocator.getKualiConfigurationService();
        String sendNotificationImage = configurationService.getPropertyValueAsString(externalImageURL) + BUTTONSMALL_SEND_NOTIFICATION_GIF;
        this.addExtraButton(METHOD_TO_CALL_SEND_NOTIFICATION, sendNotificationImage, SEND_NOTIFICATION);
        if (!this.isAutoPostAward() && this.getAwardDocument().isAuthorizedToPostAward(GlobalVariables.getUserSession().getPrincipalId())) {
            String postAwardBudgetImage = this.buildExtraButtonSourceURI(BUTTONSMALL_POST_GIF);
            this.addExtraButton(METHOD_TO_CALL_POST_AWARD, postAwardBudgetImage, POST_AWARD_ALT_TEXT, "Post");
        }
        return this.extraButtons;
    }

    public List<AwardPostHistoryBean> getAwardPostHistory() {
        List<AwardPosts> awardPosts = this.getAccountDao().getAllAwardPostsInHierarchy(this.getAwardDocument().getAward().getAwardNumber());
        return awardPosts.stream().map(awardPost -> {
            AwardPostHistoryBean awardPostHistoryBean = new AwardPostHistoryBean(awardPost.isPosted(), awardPost.isActive(), awardPost.getDocumentNumber(), awardPost.getUpdateUser(), awardPost.getUpdateTimestamp());
            KcPerson person = this.getKcPersonService().getKcPersonByUserName(awardPost.getUpdateUser());
            awardPostHistoryBean.setFirstName(person.getFirstName());
            awardPostHistoryBean.setLastName(person.getLastName());
            return awardPostHistoryBean;
        }).collect(Collectors.toList());
    }

    public List<TimeAndMoneyPostHistoryBean> getTmPostHistory() {
        List<TimeAndMoneyPosts> timeAndMoneyPosts = this.getTimeAndMoneyPostsDao().getActiveTimeAndMoneyPostsForAwardHierarchy(this.getAwardDocument().getAward().getAwardNumber());
        return timeAndMoneyPosts.stream().map(timeAndMoneyPost -> {
            TimeAndMoneyPostHistoryBean timeAndMoneyPostHistoryBean = new TimeAndMoneyPostHistoryBean(timeAndMoneyPost.isActive(), timeAndMoneyPost.getDocumentNumber(), timeAndMoneyPost.getUpdateUser(), timeAndMoneyPost.getUpdateTimestamp());
            KcPerson person = this.getKcPersonService().getKcPersonByUserName(timeAndMoneyPost.getUpdateUser());
            timeAndMoneyPostHistoryBean.setFirstName(person.getFirstName());
            timeAndMoneyPostHistoryBean.setLastName(person.getLastName());
            return timeAndMoneyPostHistoryBean;
        }).collect(Collectors.toList());
    }

    public KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    protected AccountDao getAccountDao() {
        if (this.accountDao == null) {
            this.accountDao = KcServiceLocator.getService(AccountDao.class);
        }
        return this.accountDao;
    }

    protected TimeAndMoneyPostsDao getTimeAndMoneyPostsDao() {
        if (this.timeAndMoneyPostsDao == null) {
            this.timeAndMoneyPostsDao = KcServiceLocator.getService(TimeAndMoneyPostsDao.class);
        }
        return this.timeAndMoneyPostsDao;
    }

    protected PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = KimApiServiceLocator.getPermissionService();
        }
        return this.permissionService;
    }

    protected String buildExtraButtonSourceURI(String buttonFileName) {
        return this.lookupKualiConfigurationService().getPropertyValueAsString("kra.externalizable.images.url") + buttonFileName;
    }

    public Long getPlaceHolderAwardId() {
        return this.placeHolderAwardId;
    }

    public void setPlaceHolderAwardId(Long placeHolderAwardId) {
        this.placeHolderAwardId = placeHolderAwardId;
    }

    public boolean isDocOpenedFromAwardSearch() {
        return this.docOpenedFromAwardSearch;
    }

    public void setDocOpenedFromAwardSearch(boolean docOpenedFromAwardSearch) {
        this.docOpenedFromAwardSearch = docOpenedFromAwardSearch;
    }

    public BudgetLimitSummaryHelper getBudgetLimitSummary() {
        return this.budgetLimitSummary;
    }

    public void setBudgetLimitSummary(BudgetLimitSummaryHelper budgetLimitSummary) {
        this.budgetLimitSummary = budgetLimitSummary;
    }

    public AwardBudgetLimitsBean getAwardBudgetLimitsBean() {
        return this.awardBudgetLimitsBean;
    }

    public void setAwardBudgetLimitsBean(AwardBudgetLimitsBean awardBudgetLimitsBean) {
        this.awardBudgetLimitsBean = awardBudgetLimitsBean;
    }

    public void setAwardHierarchyUIService(AwardHierarchyUIService awardHierarchyUIService) {
        this.awardHierarchyUIService = awardHierarchyUIService;
    }

    public List<ReportTracking> getReportTrackingsToDelete() {
        return this.reportTrackingsToDelete;
    }

    public void setReportTrackingsToDelete(List<ReportTracking> reportTrackingsToDelete) {
        this.reportTrackingsToDelete = reportTrackingsToDelete;
    }

    public boolean getDisplayAwardPaymentScheduleActiveLinkFields() {
        if (displayAwardPaymentScheduleActiveLinkFields == null) {
            String parmVal = this.getParameter("KC-AWARD", "Document", PAYMENT_SCHEDULE_ACTIVE_LINKS_PARAMETER);
            displayAwardPaymentScheduleActiveLinkFields = StringUtils.equalsIgnoreCase((CharSequence)"Y", (CharSequence)parmVal);
        }
        return displayAwardPaymentScheduleActiveLinkFields;
    }

    public void setReportTrackingService(ReportTrackingService reportTrackingService) {
        this.reportTrackingService = reportTrackingService;
    }

    public List<ReportTrackingBean> getReportTrackingBeans() {
        return this.reportTrackingBeans;
    }

    public void setReportTrackingBeans(List<ReportTrackingBean> reportTrackingBeans) {
        this.reportTrackingBeans = reportTrackingBeans;
    }

    public String determineRootAwardNumber() {
        String prevRootAwardNumber = this.getPrevRootAwardNumber();
        return prevRootAwardNumber != null ? prevRootAwardNumber : this.getAwardDocument().getAward().getAwardNumber();
    }

    public String determineParentAwardNumber() {
        String prevAwardNumber = this.getPrevAwardNumber();
        return prevAwardNumber != null ? prevAwardNumber : "000000-00000";
    }

    public List<Award> getAwardsForHistoryDisplay() {
        ArrayList<Award> results = new ArrayList<Award>();
        List<Award> rawList = this.getAwardDocument().getAward().getAwardVersions();
        int sequenceNumber = this.getAwardDocument().getAward().getSequenceNumber();
        for (Award award : rawList) {
            if (award.getSequenceNumber() > sequenceNumber) continue;
            results.add(award);
        }
        Collections.reverse(results);
        return results;
    }

    public String getAwardHierarchyTargetAwardNumber() {
        return this.awardHierarchyTargetAwardNumber;
    }

    public void setAwardHierarchyTargetAwardNumber(String awardHierarchyTargetAwardNumber) {
        this.awardHierarchyTargetAwardNumber = awardHierarchyTargetAwardNumber;
    }

    public String getAwardHierarchySourceAwardStrList() {
        return this.awardHierarchySourceAwardStrList;
    }

    public void setAwardHierarchySourceAwardStrList(String awardHierarchySourceAwardStrList) {
        this.awardHierarchySourceAwardStrList = awardHierarchySourceAwardStrList;
    }

    public String getAwardHierarchyTargetAwardStrList() {
        return this.awardHierarchyTargetAwardStrList;
    }

    public void setAwardHierarchyTargetAwardStrList(String awardHierarchyTargetAwardStrList) {
        this.awardHierarchyTargetAwardStrList = awardHierarchyTargetAwardStrList;
    }

    public AccountInformationBean getAccountInformationBean() {
        return this.accountInformationBean;
    }

    public void setAccountInformationBean(AccountInformationBean accountInformationBean) {
        this.accountInformationBean = accountInformationBean;
    }

    public boolean isAwardObligatedAndAnticipatedAmountsEditable() {
        return this.getParameterService().getParameterValueAsBoolean("KC-AWARD", "Document", "MAKE_AWD_CUM_ANTICIPATED_OBL_EDITABLE");
    }

    public boolean getDisplayCoiDisclosureStatus() {
        return this.getParameterService().getParameterValueAsBoolean("KC-AWARD", "Document", "ENABLE_DISCLOSURE_STATUS_FROM_COI_MODULE");
    }

    public boolean getDisplayCoiProjectStatus() {
        return this.getParameterService().getParameterValueAsBoolean("KC-SYS", "All", "COI_PROJECT_STATUS_FEATURE");
    }

    public boolean getDisplayCoiDispositionStatus() {
        return this.getParameterService().getParameterValueAsBoolean("KC-AWARD", "Document", "ENABLE_DISCLOSURE_DISPOSITION_STATUS_FROM_COI_MODULE");
    }

    public List<DisclosureProjectStatus> getDisclosureProjectStatuses() {
        if (this.disclosureProjectStatuses == null) {
            this.disclosureProjectStatuses = this.getDisclosureStatusRetrievalService().getDisclosureStatusesForProject("KC-AWARD", this.getAwardDocument().getAward().getAwardNumber());
        }
        return this.disclosureProjectStatuses;
    }

    public void refreshDisclosureProjectStatuses() {
        if (this.getDisplayCoiDispositionStatus() || this.getDisplayCoiDisclosureStatus()) {
            this.disclosureProjectStatuses = this.getDisclosureStatusRetrievalService().getDisclosureStatusesForProject("KC-AWARD", this.getAwardDocument().getAward().getAwardNumber());
        }
    }

    protected DisclosureStatusRetrievalService getDisclosureStatusRetrievalService() {
        if (this.disclosureStatusRetrievalService == null) {
            this.disclosureStatusRetrievalService = KcServiceLocator.getService(DisclosureStatusRetrievalService.class);
        }
        return this.disclosureStatusRetrievalService;
    }

    public boolean isBudgetVersionSummaryCumulative() {
        if (this.isBudgetVersionSummaryCumulative == null) {
            this.isBudgetVersionSummaryCumulative = this.getParameterService().getParameterValueAsBoolean("KC-AB", "All", "Award_budget_version_summary_cumulative");
        }
        return this.isBudgetVersionSummaryCumulative;
    }
}

