/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project.notification;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.notification.impl.NotificationRendererBase;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.ExconProjectPerson;

public class ExconProjectNotificationRenderer
extends NotificationRendererBase {
    private static final long serialVersionUID = 4251030213667597533L;
    private ExconProject exconProject;

    public ExconProjectNotificationRenderer() {
    }

    public ExconProjectNotificationRenderer(ExconProject exconProject) {
        this.exconProject = exconProject;
    }

    @Override
    public Map<String, String> getDefaultReplacementParameters() {
        return this.getExconProjectReplacementParameters(this.exconProject);
    }

    public Map<String, String> getExconProjectReplacementParameters(ExconProject exconProject) {
        Map<String, String> result = super.getDefaultReplacementParameters();
        result.put("{DOCUMENT_NUMBER}", exconProject.getExconProjectDocument().getDocumentNumber());
        result.put("{EC_NUMBER}", exconProject.getProjectNumber());
        result.put("{EC_TITLE}", exconProject.getTitle());
        result.put("{PROJECT_TYPE_NAME}", exconProject.getProjectType().getDescription());
        result.put("{PROJECT_TYPE_CODE}", exconProject.getProjectTypeCode());
        result.put("{EC_STATUS_NAME}", exconProject.getProjectStatus().getDescription());
        result.put("{EC_STATUS_CODE}", exconProject.getProjectStatusCode());
        result.put("{LEAD_UNIT_NUMBER}", StringUtils.defaultString((String)exconProject.getLeadUnitNumber()));
        result.put("{LEAD_UNIT_NAME}", StringUtils.defaultString(exconProject.getUnit() != null ? exconProject.getUnit().getUnitName() : null));
        result.put("{SPONSOR_NAME}", StringUtils.defaultString(exconProject.getSponsor() != null ? exconProject.getSponsor().getSponsorName() : null));
        result.put("{SPONSOR_CODE}", StringUtils.defaultString((String)exconProject.getSponsorCode()));
        result.put("{PROJECT_PERSONNEL_NAMES}", this.getProjectPersonnelNames(exconProject));
        result.put("{EC_ASSOCIATIONS_LIST}", this.getAssociatedDocumentsList(exconProject));
        return result;
    }

    private String getProjectPersonnelNames(ExconProject exconProject) {
        return exconProject.getExconProjectPersons().stream().map(ExconProjectPerson::getFullName).filter(StringUtils::isNotBlank).collect(Collectors.joining("; "));
    }

    private String getAssociatedDocumentsList(ExconProject exconProject) {
        return exconProject.getExconProjectAssociatedDocuments().stream().map(associatedDocument -> associatedDocument.getAssocDocType().getAssocDocTypeName() + " " + associatedDocument.getAssocDocNumber() + " " + associatedDocument.getAssocDocTitle()).filter(StringUtils::isNotBlank).collect(Collectors.joining("<br />"));
    }

    public ExconProject getExconProject() {
        return this.exconProject;
    }

    public void setExconProject(ExconProject exconProject) {
        this.exconProject = exconProject;
    }
}

