/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.index.mapper.RangeType;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationSupplier;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.DateRangeHistogramAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.ExtendedBounds;
import org.elasticsearch.search.aggregations.support.AggregatorSupplier;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.internal.SearchContext;

public final class DateHistogramAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final BucketOrder order;
    private final boolean keyed;
    private final long minDocCount;
    private final ExtendedBounds extendedBounds;
    private final Rounding rounding;
    private final Rounding shardRounding;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register("date_histogram", Arrays.asList(CoreValuesSourceType.DATE, CoreValuesSourceType.NUMERIC, CoreValuesSourceType.BOOLEAN), (name, factories, rounding, shardRounding, order, keyed, minDocCount, extendedBounds, valuesSource, formatter, aggregationContext, parent, metadata) -> new DateHistogramAggregator(name, factories, rounding, shardRounding, order, keyed, minDocCount, extendedBounds, (ValuesSource.Numeric)valuesSource, formatter, aggregationContext, parent, metadata));
        builder.register("date_histogram", CoreValuesSourceType.RANGE, (name, factories, rounding, shardRounding, order, keyed, minDocCount, extendedBounds, valuesSource, formatter, aggregationContext, parent, metadata) -> {
            ValuesSource.Range rangeValueSource = (ValuesSource.Range)valuesSource;
            if (rangeValueSource.rangeType() != RangeType.DATE) {
                throw new IllegalArgumentException("Expected date range type but found range type [" + rangeValueSource.rangeType().name + "]");
            }
            return new DateRangeHistogramAggregator(name, factories, rounding, shardRounding, order, keyed, minDocCount, extendedBounds, rangeValueSource, formatter, aggregationContext, parent, metadata);
        });
    }

    public DateHistogramAggregatorFactory(String name, ValuesSourceConfig config, BucketOrder order, boolean keyed, long minDocCount, Rounding rounding, Rounding shardRounding, ExtendedBounds extendedBounds, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.order = order;
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.extendedBounds = extendedBounds;
        this.rounding = rounding;
        this.shardRounding = shardRounding;
    }

    public long minDocCount() {
        return this.minDocCount;
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource valuesSource, SearchContext searchContext, Aggregator parent, boolean collectsFromSingleBucket, Map<String, Object> metadata) throws IOException {
        if (!collectsFromSingleBucket) {
            return DateHistogramAggregatorFactory.asMultiBucketAggregator(this, searchContext, parent);
        }
        AggregatorSupplier aggregatorSupplier = this.queryShardContext.getValuesSourceRegistry().getAggregator(this.config.valueSourceType(), "date_histogram");
        if (!(aggregatorSupplier instanceof DateHistogramAggregationSupplier)) {
            throw new AggregationExecutionException("Registry miss-match - expected DateHistogramAggregationSupplier, found [" + aggregatorSupplier.getClass().toString() + "]");
        }
        return ((DateHistogramAggregationSupplier)aggregatorSupplier).build(this.name, this.factories, this.rounding, this.shardRounding, this.order, this.keyed, this.minDocCount, this.extendedBounds, valuesSource, this.config.format(), searchContext, parent, metadata);
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new DateHistogramAggregator(this.name, this.factories, this.rounding, this.shardRounding, this.order, this.keyed, this.minDocCount, this.extendedBounds, null, this.config.format(), searchContext, parent, metadata);
    }
}

