/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.subaward;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.PostRemove;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.coeus.common.framework.attachment.KcAttachmentDataDao;
import org.kuali.coeus.common.framework.org.Organization;
import org.kuali.coeus.propdev.api.budget.subaward.BudgetSubAwardsContract;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwardAttachment;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwardFiles;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwardPeriodDetail;
import org.kuali.coeus.propdev.impl.hierarchy.HierarchyMaintainable;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.springframework.web.multipart.MultipartFile;

@Entity
@Table(name="BUDGET_SUB_AWARDS")
@IdClass(value=BudgetSubAwardsId.class)
public class BudgetSubAwards
extends KcPersistableBusinessObjectBase
implements HierarchyMaintainable,
Comparable<BudgetSubAwards>,
BudgetSubAwardsContract {
    private static final long serialVersionUID = -857485535655759499L;
    @Column(name="BUDGET_ID", insertable=false, updatable=false)
    private Long budgetId;
    @Id
    @JoinColumn(name="BUDGET_ID")
    @ManyToOne(cascade={CascadeType.REFRESH})
    private ProposalDevelopmentBudgetExt budget;
    @Id
    @Column(name="SUB_AWARD_NUMBER")
    private Integer subAwardNumber;
    @Transient
    private Integer budgetVersionNumber;
    @Column(name="COMMENTS")
    private String comments;
    @Column(name="ORGANIZATION_ID")
    private String organizationId;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="ORGANIZATION_ID", referencedColumnName="ORGANIZATION_ID", insertable=false, updatable=false)
    private Organization organization;
    @Column(name="SUB_AWARD_STATUS_CODE")
    private Integer subAwardStatusCode;
    @Column(name="FILE_DATA_ID")
    private String fileDataId;
    @Transient
    private transient SoftReference<byte[]> subAwardXfdFileData;
    @Column(name="SUB_AWARD_XFD_FILE_NAME")
    private String subAwardXfdFileName;
    @Column(name="XML_DATA_ID")
    private String xmlDataId;
    @Transient
    private transient SoftReference<String> subAwardXmlFileData;
    @Column(name="TRANSLATION_COMMENTS")
    private String translationComments;
    @Column(name="XFD_UPDATE_TIMESTAMP")
    private Timestamp xfdUpdateTimestamp;
    @Column(name="XFD_UPDATE_USER")
    private String xfdUpdateUser;
    @Column(name="XML_UPDATE_TIMESTAMP")
    private Timestamp xmlUpdateTimestamp;
    @Column(name="XML_UPDATE_USER")
    private String xmlUpdateUser;
    @Column(name="NAMESPACE")
    private String namespace;
    @Column(name="FORM_NAME")
    private String formName;
    @OneToMany(mappedBy="budgetSubAward", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<BudgetSubAwardAttachment> budgetSubAwardAttachments = new ArrayList<BudgetSubAwardAttachment>();
    @OneToMany(mappedBy="budgetSubAward", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<BudgetSubAwardFiles> budgetSubAwardFiles = new ArrayList<BudgetSubAwardFiles>();
    @OneToMany(mappedBy="budgetSubAward", orphanRemoval=true, cascade={CascadeType.ALL})
    @OrderBy(value="budgetPeriod")
    private List<BudgetSubAwardPeriodDetail> budgetSubAwardPeriodDetails = new ArrayList<BudgetSubAwardPeriodDetail>();
    @Column(name="HIERARCHY_PROPOSAL_NUMBER")
    private String hierarchyProposalNumber;
    @Column(name="HIDE_IN_HIERARCHY")
    @Convert(converter=BooleanYNConverter.class)
    private boolean hiddenInHierarchy;
    @Transient
    private transient boolean edit = false;
    @Transient
    private transient MultipartFile newSubAwardFile;
    @Transient
    private transient boolean newSubAwardFileError = false;

    public Long getBudgetId() {
        return this.budgetId;
    }

    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }

    public Integer getSubAwardNumber() {
        return this.subAwardNumber;
    }

    public void setSubAwardNumber(Integer subAwardNumber) {
        this.subAwardNumber = subAwardNumber;
    }

    public Integer getBudgetVersionNumber() {
        return this.budgetVersionNumber;
    }

    public void setBudgetVersionNumber(Integer budgetVersionNumber) {
        this.budgetVersionNumber = budgetVersionNumber;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getOrganizationName() {
        if (this.organization != null) {
            return this.organization.getOrganizationName();
        }
        return null;
    }

    public Integer getSubAwardStatusCode() {
        return this.subAwardStatusCode;
    }

    public void setSubAwardStatusCode(Integer subAwardStatusCode) {
        this.subAwardStatusCode = subAwardStatusCode;
    }

    public String getSubAwardXfdFileName() {
        return this.subAwardXfdFileName;
    }

    public void setSubAwardXfdFileName(String subAwardXfdFileName) {
        this.subAwardXfdFileName = subAwardXfdFileName;
    }

    public String getTranslationComments() {
        return this.translationComments;
    }

    public void setTranslationComments(String translationComments) {
        this.translationComments = translationComments;
    }

    public Timestamp getXfdUpdateTimestamp() {
        return this.xfdUpdateTimestamp;
    }

    public void setXfdUpdateTimestamp(Timestamp xfdUpdateTimestamp) {
        this.xfdUpdateTimestamp = xfdUpdateTimestamp;
    }

    public String getXfdUpdateUser() {
        return this.xfdUpdateUser;
    }

    public void setXfdUpdateUser(String xfdUpdateUser) {
        this.xfdUpdateUser = xfdUpdateUser;
    }

    public Timestamp getXmlUpdateTimestamp() {
        return this.xmlUpdateTimestamp;
    }

    public void setXmlUpdateTimestamp(Timestamp xmlUpdateTimestamp) {
        this.xmlUpdateTimestamp = xmlUpdateTimestamp;
    }

    public String getXmlUpdateUser() {
        return this.xmlUpdateUser;
    }

    public void setXmlUpdateUser(String xmlUpdateUser) {
        this.xmlUpdateUser = xmlUpdateUser;
    }

    public List<BudgetSubAwardAttachment> getBudgetSubAwardAttachments() {
        if (this.budgetSubAwardAttachments == null) {
            this.budgetSubAwardAttachments = new ArrayList<BudgetSubAwardAttachment>();
        }
        return this.budgetSubAwardAttachments;
    }

    public String getAttachmentContentIds() {
        String SEPARATOR = "; ";
        StringBuilder sb = new StringBuilder();
        for (BudgetSubAwardAttachment attachment : this.getBudgetSubAwardAttachments()) {
            sb.append(attachment.getName());
            sb.append("; ");
        }
        sb.deleteCharAt(sb.length() - 2);
        return sb.toString();
    }

    public void setBudgetSubAwardAttachments(List<BudgetSubAwardAttachment> budgetSubAwardAttachments) {
        this.budgetSubAwardAttachments = budgetSubAwardAttachments;
    }

    public List<BudgetSubAwardFiles> getBudgetSubAwardFiles() {
        return this.budgetSubAwardFiles;
    }

    public void setBudgetSubAwardFiles(List<BudgetSubAwardFiles> budgetSubAwardFiles) {
        this.budgetSubAwardFiles = budgetSubAwardFiles;
    }

    public String getHierarchyProposalNumber() {
        return this.hierarchyProposalNumber;
    }

    @Override
    public void setHierarchyProposalNumber(String hierarchyProposalNumber) {
        this.hierarchyProposalNumber = hierarchyProposalNumber;
    }

    public boolean isHiddenInHierarchy() {
        return this.hiddenInHierarchy;
    }

    @Override
    public void setHiddenInHierarchy(boolean hiddenInHierarchy) {
        this.hiddenInHierarchy = hiddenInHierarchy;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formaName) {
        this.formName = formaName;
    }

    public boolean getEdit() {
        return this.edit;
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }

    public MultipartFile getNewSubAwardFile() {
        return this.newSubAwardFile;
    }

    public void setNewSubAwardFile(MultipartFile newSubAwardFile) {
        this.newSubAwardFile = newSubAwardFile;
    }

    public boolean getNewSubAwardFileError() {
        return this.newSubAwardFileError;
    }

    public void setNewSubAwardFileError(boolean pNewSubAwardFileError) {
        this.newSubAwardFileError = pNewSubAwardFileError;
    }

    @Override
    public int compareTo(BudgetSubAwards o) {
        int retVal = -1;
        if (o != null && (retVal = ObjectUtils.compare((Comparable)((Object)this.getOrganizationName()), (Comparable)((Object)o.getOrganizationName()))) == 0 && (retVal = ObjectUtils.compare((Comparable)((Object)this.getComments()), (Comparable)((Object)o.getComments()))) == 0 && (retVal = ObjectUtils.compare((Comparable)((Object)this.getSubAwardXfdFileName()), (Comparable)((Object)o.getSubAwardXfdFileName()))) == 0) {
            retVal = ObjectUtils.compare((Comparable)this.getSubAwardNumber(), (Comparable)o.getSubAwardNumber());
        }
        return retVal;
    }

    public List<BudgetSubAwardPeriodDetail> getBudgetSubAwardPeriodDetails() {
        return this.budgetSubAwardPeriodDetails;
    }

    public void setBudgetSubAwardPeriodDetails(List<BudgetSubAwardPeriodDetail> budgetSubAwardPeriodDetails) {
        this.budgetSubAwardPeriodDetails = budgetSubAwardPeriodDetails;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public void setOrganization(Organization organization) {
        if (organization != null) {
            this.organizationId = organization.getOrganizationId();
        }
        this.organization = organization;
    }

    public void computePeriodDetails() {
        for (BudgetSubAwardPeriodDetail detail : this.getBudgetSubAwardPeriodDetails()) {
            detail.computeTotal();
        }
    }

    public boolean hasModifiedAmounts() {
        for (BudgetSubAwardPeriodDetail detail : this.getBudgetSubAwardPeriodDetails()) {
            if (!detail.isAmountsModified()) continue;
            return true;
        }
        return false;
    }

    public ProposalDevelopmentBudgetExt getBudget() {
        return this.budget;
    }

    public void setBudget(ProposalDevelopmentBudgetExt budget) {
        this.budget = budget;
    }

    public String getFileDataId() {
        return this.fileDataId;
    }

    public void setFileDataId(String fileDataId) {
        this.fileDataId = fileDataId;
    }

    public String getXmlDataId() {
        return this.xmlDataId;
    }

    public void setXmlDataId(String xmlDataId) {
        this.xmlDataId = xmlDataId;
    }

    public byte[] getSubAwardXfdFileData() {
        byte[] existingData;
        if (this.subAwardXfdFileData != null && (existingData = this.subAwardXfdFileData.get()) != null) {
            return existingData;
        }
        byte[] newData = this.getKcAttachmentDao().getData(this.fileDataId);
        this.subAwardXfdFileData = new SoftReference<byte[]>(newData);
        return newData;
    }

    public void setSubAwardXfdFileData(byte[] subAwardXfdFileData) {
        if (subAwardXfdFileData == null) {
            this.getKcAttachmentDao().removeData(this.fileDataId);
            this.fileDataId = null;
        } else {
            this.fileDataId = this.getKcAttachmentDao().saveData(subAwardXfdFileData, this.fileDataId);
        }
        this.subAwardXfdFileData = new SoftReference<byte[]>(subAwardXfdFileData);
    }

    public String getSubAwardXmlFileData() {
        if (this.subAwardXmlFileData != null) {
            return this.subAwardXmlFileData.get();
        }
        byte[] newData = this.getKcAttachmentDao().getData(this.xmlDataId);
        String newString = newData != null ? new String(newData) : null;
        this.subAwardXmlFileData = new SoftReference<String>(newString);
        return newString;
    }

    public void setSubAwardXmlFileData(String subAwardXmlFileData) {
        if (subAwardXmlFileData == null) {
            this.getKcAttachmentDao().removeData(this.xmlDataId);
            this.xmlDataId = null;
        } else {
            this.xmlDataId = this.getKcAttachmentDao().saveData(subAwardXmlFileData.getBytes(StandardCharsets.UTF_8), this.xmlDataId);
        }
        this.subAwardXmlFileData = new SoftReference<String>(subAwardXmlFileData);
    }

    private KcAttachmentDataDao getKcAttachmentDao() {
        return KcServiceLocator.getService(KcAttachmentDataDao.class);
    }

    @PostRemove
    public void removeData() {
        if (this.getFileDataId() != null) {
            this.getKcAttachmentDao().removeData(this.getFileDataId());
        }
        if (this.getXmlDataId() != null) {
            this.getKcAttachmentDao().removeData(this.getXmlDataId());
        }
    }

    public static final class BudgetSubAwardsId
    implements Serializable,
    Comparable<BudgetSubAwardsId> {
        private Integer subAwardNumber;
        private Long budget;

        public Integer getSubAwardNumber() {
            return this.subAwardNumber;
        }

        public void setSubAwardNumber(Integer subAwardNumber) {
            this.subAwardNumber = subAwardNumber;
        }

        public Long getBudget() {
            return this.budget;
        }

        public void setBudget(Long budget) {
            this.budget = budget;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("budget", (Object)this.budget).append("subAwardNumber", (Object)this.subAwardNumber).toString();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            BudgetSubAwardsId rhs = (BudgetSubAwardsId)other;
            return new EqualsBuilder().append((Object)this.budget, (Object)rhs.budget).append((Object)this.subAwardNumber, (Object)rhs.subAwardNumber).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.budget).append((Object)this.subAwardNumber).toHashCode();
        }

        @Override
        public int compareTo(BudgetSubAwardsId other) {
            return new CompareToBuilder().append((Object)this.budget, (Object)other.budget).append((Object)this.subAwardNumber, (Object)other.subAwardNumber).toComparison();
        }
    }
}

