/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.auth;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.auth.KcTransactionalDocumentAuthorizerBase;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.auth.task.ApplicationTask;
import org.kuali.coeus.common.framework.auth.task.TaskAuthorizationService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.KcWorkflowService;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.auth.IacucProtocolTask;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class IacucProtocolDocumentAuthorizer
extends KcTransactionalDocumentAuthorizerBase {
    private static final long serialVersionUID = -5078229085592345997L;

    public Set<String> getEditModes(Document document, Person user, Set<String> currentEditModes) {
        HashSet<String> editModes = new HashSet<String>();
        IacucProtocolDocument iacucProtocolDocument = (IacucProtocolDocument)document;
        String userId = user.getPrincipalId();
        if (iacucProtocolDocument.getProtocol().getProtocolId() == null) {
            if (this.canCreateIacucProtocol(user)) {
                editModes.add("fullEntry");
            } else {
                editModes.add("unviewable");
            }
        } else {
            if (this.canExecuteIacucProtocolTask(userId, iacucProtocolDocument, "modifyIacucProtocol")) {
                editModes.add("fullEntry");
            } else if (this.canExecuteIacucProtocolTask(userId, iacucProtocolDocument, "viewIacucProtocol")) {
                editModes.add("viewOnly");
            } else {
                editModes.add("unviewable");
            }
            if (this.canExecuteIacucProtocolTask(userId, iacucProtocolDocument, "maintainIacucProtocolOnlineReviews")) {
                editModes.add("maintainIacucProtocolOnlineReviews");
            }
            if (this.canViewReviewComments((Document)iacucProtocolDocument, user)) {
                editModes.add("viewReviewComments");
            }
            if (this.canModify(iacucProtocolDocument, user)) {
                editModes.add("canModify");
            }
        }
        return editModes;
    }

    public boolean canViewReviewComments(Document document, Person user) {
        ProtocolDocumentBase protocolDoc = (ProtocolDocumentBase)document;
        List<ProtocolPersonBase> participants = protocolDoc.getProtocol().getProtocolPersons();
        for (ProtocolPersonBase participant : participants) {
            String statusCode;
            if (!StringUtils.equalsIgnoreCase((CharSequence)participant.getPersonId(), (CharSequence)user.getPrincipalId()) || !(statusCode = protocolDoc.getProtocol().getProtocolStatusCode()).equalsIgnoreCase("101")) continue;
            return false;
        }
        return true;
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        if (GlobalVariables.getUserSession().getObjectMap().get("onAmendAndRenewAllowNewProtocolDocument") != null) {
            GlobalVariables.getUserSession().removeObject("onAmendAndRenewAllowNewProtocolDocument");
            return true;
        }
        return this.canCreateIacucProtocol(user);
    }

    public boolean canOpen(Document document, Person user) {
        IacucProtocolDocument protocolDocument = (IacucProtocolDocument)document;
        if (protocolDocument.getProtocol().getProtocolId() == null) {
            return this.canCreateIacucProtocol(user);
        }
        return this.canExecuteIacucProtocolTask(user.getPrincipalId(), (IacucProtocolDocument)document, "viewIacucProtocol");
    }

    private boolean canCreateIacucProtocol(Person user) {
        ApplicationTask task = new ApplicationTask("createIacucProtocol");
        TaskAuthorizationService taskAuthenticationService = KcServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthenticationService.isAuthorized(user.getPrincipalId(), task);
    }

    private boolean canExecuteIacucProtocolTask(String userId, IacucProtocolDocument doc, String taskName) {
        IacucProtocolTask task = new IacucProtocolTask(taskName, doc.getIacucProtocol());
        TaskAuthorizationService taskAuthenticationService = KcServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthenticationService.isAuthorized(userId, task);
    }

    @Override
    public boolean canEdit(Document document, Person user) {
        return this.canExecuteIacucProtocolTask(user.getPrincipalId(), (IacucProtocolDocument)document, "modifyIacucProtocol");
    }

    @Override
    public boolean canSave(Document document, Person user) {
        return this.canEdit(document, user);
    }

    @Override
    public boolean canCopy(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canCancel(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canRoute(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canBlanketApprove(Document document, Person user) {
        return false;
    }

    public boolean canSendNoteFyi(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canFyi(Document document, Person user) {
        return false;
    }

    public boolean canModify(IacucProtocolDocument document, Person user) {
        IacucProtocol iacucProtocol = document.getIacucProtocol();
        return (!this.getWorkFlowService().isInWorkflow((Document)document) || iacucProtocol.isCorrectionMode()) && this.getAuthorizationService().hasPermission(user.getPrincipalId(), iacucProtocol, "Modify IACUC Protocol");
    }

    protected KcWorkflowService getWorkFlowService() {
        return KcServiceLocator.getService(KcWorkflowService.class);
    }

    protected KcAuthorizationService getAuthorizationService() {
        return KcServiceLocator.getService(KcAuthorizationService.class);
    }
}

