/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.onlinereview;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.config.ForwardConfig;
import org.kuali.coeus.common.committee.impl.bo.CommitteeMembershipBase;
import org.kuali.coeus.common.committee.impl.meeting.CommitteeScheduleMinuteBase;
import org.kuali.coeus.common.framework.attachment.AttachmentFile;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.DateUtils;
import org.kuali.coeus.sys.framework.workflow.KcWorkflowService;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolAction;
import org.kuali.kra.iacuc.IacucProtocolForm;
import org.kuali.kra.iacuc.actions.reviewcomments.IacucReviewAttachmentsBean;
import org.kuali.kra.iacuc.actions.reviewcomments.IacucReviewCommentsService;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolReviewerBean;
import org.kuali.kra.iacuc.committee.bo.IacucCommitteeMembership;
import org.kuali.kra.iacuc.committee.meeting.IacucCommitteeScheduleMinute;
import org.kuali.kra.iacuc.notification.IacucProtocolNotification;
import org.kuali.kra.iacuc.notification.IacucProtocolNotificationContext;
import org.kuali.kra.iacuc.notification.IacucProtocolNotificationRenderer;
import org.kuali.kra.iacuc.notification.IacucProtocolNotificationRequestBean;
import org.kuali.kra.iacuc.notification.IacucRejectReviewNotificationRenderer;
import org.kuali.kra.iacuc.onlinereview.IacucProtocolOnlineReview;
import org.kuali.kra.iacuc.onlinereview.IacucProtocolReviewAttachment;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.ProtocolOnlineReviewDocumentBase;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewAttachmentsBeanBase;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewCommentsBeanBase;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewCommentsService;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewer;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.onlinereview.OnlineReviewsActionHelperBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.kuali.kra.protocol.onlinereview.ProtocolReviewAttachmentBase;
import org.kuali.kra.protocol.onlinereview.event.AddProtocolOnlineReviewAttachmentEvent;
import org.kuali.kra.protocol.onlinereview.event.AddProtocolOnlineReviewCommentEvent;
import org.kuali.kra.protocol.onlinereview.event.DeleteProtocolOnlineReviewEvent;
import org.kuali.kra.protocol.onlinereview.event.RejectProtocolOnlineReviewCommentEvent;
import org.kuali.kra.protocol.onlinereview.event.RouteProtocolOnlineReviewEvent;
import org.kuali.kra.protocol.onlinereview.event.SaveProtocolOnlineReviewEvent;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;

public class IacucProtocolOnlineReviewAction
extends IacucProtocolAction {
    private static final String PROTOCOL_DOCUMENT_NUMBER = "protocolDocumentNumber";
    private static final Logger LOG = LogManager.getLogger(IacucProtocolOnlineReviewAction.class);
    private static final String NOT_FOUND_SELECTION = "the attachment was not found for selection ";
    private static final ActionForward RESPONSE_ALREADY_HANDLED = null;
    private static final String PROTOCOL_OLR_TAB = "iacucProtocolOnlineReview";
    private static final String DOCUMENT_REJECT_QUESTION = "DocReject";
    private static final String DOCUMENT_DELETE_QUESTION = "ProtocolDocDelete";
    private static final String DOCUMENT_REJECT_REASON_MAXLENGTH = "2000";
    private static final String ERROR_DOCUMENT_DELETE_REASON_REQUIRED = "You must enter a reason for this deletion.  The reason must be no more than {0} characters long.";

    public ActionForward createOnlineReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        OnlineReviewsActionHelperBase onlineReviewHelper = protocolForm.getOnlineReviewsActionHelper();
        if (this.validateCreateNewProtocolOnlineReview(protocolForm)) {
            CommitteeMembershipBase membership = (CommitteeMembershipBase)this.getBusinessObjectService().findBySinglePrimaryKey(IacucCommitteeMembership.class, (Object)onlineReviewHelper.getNewProtocolReviewCommitteeMembershipId());
            IacucProtocolReviewerBean bean = new IacucProtocolReviewerBean(membership);
            String principalId = bean.getPersonId();
            boolean nonEmployeeFlag = bean.getNonEmployeeFlag();
            String reviewerTypeCode = onlineReviewHelper.getNewReviewerTypeCode();
            ProtocolSubmissionBase submission = protocolForm.getProtocolDocument().getProtocol().getProtocolSubmission();
            ProtocolReviewer reviewer = this.getProtocolOnlineReviewService().createProtocolReviewer(principalId, nonEmployeeFlag, reviewerTypeCode, submission);
            ProtocolOnlineReviewDocumentBase document = this.getProtocolOnlineReviewService().createAndRouteProtocolOnlineReviewDocument(submission, reviewer, onlineReviewHelper.getNewReviewDocumentDescription(), onlineReviewHelper.getNewReviewExplanation(), onlineReviewHelper.getNewReviewOrganizationDocumentNumber(), null, true, onlineReviewHelper.getNewReviewDateRequested(), onlineReviewHelper.getNewReviewDateDue(), GlobalVariables.getUserSession().getPrincipalId());
            protocolForm.getOnlineReviewsActionHelper().init(true);
            this.recordOnlineReviewActionSuccess("created", document);
            ProtocolBase protocol = submission.getProtocol();
            ProtocolOnlineReviewBase protocolOnlineReviewBase = document.getProtocolOnlineReview();
        }
        return mapping.findForward("basic");
    }

    protected void recordOnlineReviewActionSuccess(String onlineReviewActionName, ProtocolOnlineReviewDocumentBase document) {
        String documentInfo = String.format("document number:%s, reviewer:%s", document.getDocumentNumber(), document.getProtocolOnlineReview().getProtocolReviewer().getFullName());
        KNSGlobalVariables.getMessageList().add("message.protocol.onlinereview.document.action.successfully.completed", new String[]{onlineReviewActionName, documentInfo});
    }

    public ActionForward startProtocolOnlineReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String protocolDocumentNumber = request.getParameter(PROTOCOL_DOCUMENT_NUMBER);
        ((ProtocolFormBase)form).setDocument(this.getDocumentService().getByDocumentHeaderId(protocolDocumentNumber));
        ((ProtocolFormBase)form).initialize();
        return mapping.findForward("basic");
    }

    public ActionForward addOnlineReviewComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        OnlineReviewsActionHelperBase actionHelper = protocolForm.getOnlineReviewsActionHelper();
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        String documentNumber = this.getOnlineReviewActionDocumentNumber(parameterName, "addOnlineReviewComment");
        ProtocolOnlineReviewDocumentBase document = actionHelper.getDocumentFromHelperMap(documentNumber);
        ReviewCommentsBeanBase reviewCommentsBean = actionHelper.getReviewCommentsBeanFromHelperMap(documentNumber);
        long documentIndex = actionHelper.getIndexByDocumentNumber(documentNumber);
        if (this.applyRules((DocumentEvent)new AddProtocolOnlineReviewCommentEvent(document, reviewCommentsBean.getNewReviewComment(), documentIndex)) && this.applyRules((DocumentEvent)new SaveProtocolOnlineReviewEvent(document, reviewCommentsBean.getReviewComments(), documentIndex))) {
            CommitteeScheduleMinuteBase newReviewComment = reviewCommentsBean.getNewReviewComment();
            List<CommitteeScheduleMinuteBase> reviewComments = reviewCommentsBean.getReviewComments();
            List<CommitteeScheduleMinuteBase> deletedReviewComments = reviewCommentsBean.getDeletedReviewComments();
            if (protocolForm.getEditingMode().get("maintainIacucProtocolOnlineReviews") == null) {
                newReviewComment.setPrivateCommentFlag(true);
                newReviewComment.setFinalFlag(false);
            }
            newReviewComment.setMinuteEntryTypeCode("6");
            newReviewComment.setReadOnly(false);
            this.getReviewCommentsService().addReviewComment(newReviewComment, reviewComments, document.getProtocolOnlineReview());
            this.getReviewCommentsService().saveReviewComments(reviewComments, deletedReviewComments);
            this.getDocumentService().saveDocument((Document)document);
            reviewCommentsBean.setNewReviewComment(new IacucCommitteeScheduleMinute("6"));
        }
        return mapping.findForward("basic");
    }

    protected String getOnlineReviewActionDocumentNumber(String parameterName, String actionMethodToCall) {
        String idxStr = null;
        if (StringUtils.isBlank((CharSequence)parameterName) || !parameterName.contains("." + actionMethodToCall + ".")) {
            throw new IllegalArgumentException(String.format("getOnlineReviewActionIndex expects a non-empty value for parameterName parameter, and it must contain as a substring the parameter actionMethodToCall. The passed values were (%s,%s).", parameterName, actionMethodToCall));
        }
        idxStr = StringUtils.substringBetween((String)parameterName, (String)("." + actionMethodToCall + "."), (String)".");
        if (idxStr == null || StringUtils.isBlank((CharSequence)idxStr)) {
            throw new IllegalArgumentException(String.format("parameterName must be of the form '.(actionMethodToCall).(index).anchor, the passed values were (%s,%s)", parameterName, actionMethodToCall));
        }
        return idxStr;
    }

    private ReviewCommentsService getReviewCommentsService() {
        return KcServiceLocator.getService(IacucReviewCommentsService.class);
    }

    public ActionForward deleteOnlineReviewComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        OnlineReviewsActionHelperBase actionHelper = protocolForm.getOnlineReviewsActionHelper();
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        String documentNumber = this.getOnlineReviewActionDocumentNumber(parameterName, "deleteOnlineReviewComment");
        ProtocolOnlineReviewDocumentBase document = actionHelper.getDocumentFromHelperMap(documentNumber);
        ReviewCommentsBeanBase reviewCommentsBean = actionHelper.getReviewCommentsBeanFromHelperMap(documentNumber);
        long documentIndex = actionHelper.getIndexByDocumentNumber(documentNumber);
        int commentIndex = this.getOnlineReviewActionIndexNumber(parameterName, "deleteOnlineReviewComment");
        if (this.applyRules((DocumentEvent)new SaveProtocolOnlineReviewEvent(document, reviewCommentsBean.getReviewComments(), documentIndex))) {
            List<CommitteeScheduleMinuteBase> reviewComments = reviewCommentsBean.getReviewComments();
            List<CommitteeScheduleMinuteBase> deletedReviewComments = reviewCommentsBean.getDeletedReviewComments();
            this.getReviewCommentsService().deleteReviewComment(reviewComments, commentIndex, deletedReviewComments);
            this.getReviewCommentsService().saveReviewComments(reviewComments, deletedReviewComments);
            this.getDocumentService().saveDocument((Document)document);
        }
        protocolForm.getOnlineReviewsActionHelper().init(true);
        return mapping.findForward("basic");
    }

    protected int getOnlineReviewActionIndexNumber(String parameterName, String actionMethodToCall) {
        if (StringUtils.isBlank((CharSequence)parameterName) || !parameterName.contains("." + actionMethodToCall + ".")) {
            throw new IllegalArgumentException(String.format("getOnlineReviewActionIndex expects a non-empty value for parameterName parameter, and it must contain as a substring the parameter actionMethodToCall. The passed values were (%s,%s).", parameterName, actionMethodToCall));
        }
        String idxNmbr = StringUtils.substringBetween((String)parameterName, (String)".line.", (String)".anchor");
        return Integer.parseInt(idxNmbr);
    }

    public ActionForward addOnlineReviewAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        OnlineReviewsActionHelperBase actionHelper = protocolForm.getOnlineReviewsActionHelper();
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        String documentNumber = this.getOnlineReviewActionDocumentNumber(parameterName, "addOnlineReviewAttachment");
        ProtocolOnlineReviewDocumentBase document = actionHelper.getDocumentFromHelperMap(documentNumber);
        ReviewAttachmentsBeanBase reviewAttachmentsBean = actionHelper.getReviewAttachmentsBeanFromHelperMap(documentNumber);
        long documentIndex = actionHelper.getIndexByDocumentNumber(documentNumber);
        if (this.applyRules((DocumentEvent)new AddProtocolOnlineReviewAttachmentEvent(document, reviewAttachmentsBean.getErrorPropertyName() + "s[" + documentIndex + "].", (ProtocolReviewAttachmentBase)reviewAttachmentsBean.getNewReviewAttachment()))) {
            Object newReviewAttachment = reviewAttachmentsBean.getNewReviewAttachment();
            List reviewAttachments = reviewAttachmentsBean.getReviewAttachments();
            List deletedReviewAttachments = reviewAttachmentsBean.getDeletedReviewAttachments();
            if (protocolForm.getEditingMode().get("maintainProtocolOnlineReviews") == null) {
                ((ProtocolReviewAttachmentBase)newReviewAttachment).setProtocolPersonCanView(false);
            }
            this.getReviewCommentsService().addReviewAttachment(newReviewAttachment, reviewAttachments, document.getProtocolOnlineReview().getProtocol());
            this.getReviewCommentsService().saveReviewAttachments(reviewAttachments, deletedReviewAttachments);
            this.getDocumentService().saveDocument((Document)document);
            reviewAttachmentsBean.setNewReviewAttachment(new IacucProtocolReviewAttachment());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteOnlineReviewAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        OnlineReviewsActionHelperBase actionHelper = protocolForm.getOnlineReviewsActionHelper();
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        String documentNumber = this.getOnlineReviewActionDocumentNumber(parameterName, "deleteOnlineReviewAttachment");
        ProtocolOnlineReviewDocumentBase document = actionHelper.getDocumentFromHelperMap(documentNumber);
        ReviewAttachmentsBeanBase reviewCommentsBean = actionHelper.getReviewAttachmentsBeanFromHelperMap(documentNumber);
        long documentIndex = actionHelper.getIndexByDocumentNumber(documentNumber);
        int attachmentIndex = this.getOnlineReviewActionIndexNumber(parameterName, "deleteOnlineReviewAttachment");
        if (this.applyRules((DocumentEvent)new SaveProtocolOnlineReviewEvent(document, actionHelper.getReviewCommentsBeanFromHelperMap(documentNumber).getReviewComments(), documentIndex))) {
            List<ProtocolReviewAttachmentBase> reviewAttachments = document.getProtocolOnlineReview().getReviewAttachments();
            List deletedReviewAttachments = reviewCommentsBean.getDeletedReviewAttachments();
            this.getReviewCommentsService().deleteReviewAttachment(reviewAttachments, attachmentIndex, deletedReviewAttachments);
            this.getReviewCommentsService().saveReviewAttachments(reviewAttachments, deletedReviewAttachments);
            actionHelper.getReviewAttachmentsBeanFromHelperMap(documentNumber).setReviewAttachments(reviewAttachments);
            this.getDocumentService().saveDocument((Document)document);
        }
        protocolForm.getOnlineReviewsActionHelper().init(true);
        return mapping.findForward("basic");
    }

    private boolean validateCreateNewProtocolOnlineReview(ProtocolFormBase protocolForm) {
        boolean valid = true;
        if (protocolForm.getOnlineReviewsActionHelper().getNewProtocolReviewCommitteeMembershipId() == null) {
            valid = false;
            GlobalVariables.getMessageMap().putError("onlineReviewsActionHelper.newProtocolReviewCommitteeMembershipId", "error.protocol.onlinereview.create.requiresReviewer", new String[0]);
        }
        if (protocolForm.getOnlineReviewsActionHelper().getNewReviewDateRequested() != null && protocolForm.getOnlineReviewsActionHelper().getNewReviewDateDue() != null && !DateUtils.isSameDay(protocolForm.getOnlineReviewsActionHelper().getNewReviewDateDue(), protocolForm.getOnlineReviewsActionHelper().getNewReviewDateRequested()) && !protocolForm.getOnlineReviewsActionHelper().getNewReviewDateDue().after(protocolForm.getOnlineReviewsActionHelper().getNewReviewDateRequested())) {
            valid = false;
            GlobalVariables.getMessageMap().putError("onlineReviewsActionHelper.newReviewDateDue", "error.protocol.onlinereview.create.dueDateAfterRequestedDate", new String[0]);
        }
        if (StringUtils.isEmpty((CharSequence)protocolForm.getOnlineReviewsActionHelper().getNewReviewerTypeCode())) {
            valid = false;
            GlobalVariables.getMessageMap().putError("onlineReviewsActionHelper.newReviewerTypeCode", "error.protocol.onlinereview.create.protocolReviewerTypeCode", new String[0]);
        }
        return valid;
    }

    public ActionForward moveUpOnlineReviewComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        OnlineReviewsActionHelperBase actionHelper = protocolForm.getOnlineReviewsActionHelper();
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        String documentNumber = this.getOnlineReviewActionDocumentNumber(parameterName, "moveUpOnlineReviewComment");
        ProtocolOnlineReviewDocumentBase document = actionHelper.getDocumentFromHelperMap(documentNumber);
        ReviewCommentsBeanBase reviewCommentsBean = actionHelper.getReviewCommentsBeanFromHelperMap(documentNumber);
        long documentIndex = actionHelper.getIndexByDocumentNumber(documentNumber);
        int commentIndex = this.getOnlineReviewActionIndexNumber(parameterName, "moveUpOnlineReviewComment");
        if (this.applyRules((DocumentEvent)new SaveProtocolOnlineReviewEvent(document, reviewCommentsBean.getReviewComments(), documentIndex))) {
            ProtocolBase protocol = protocolForm.getProtocolDocument().getProtocol();
            List<CommitteeScheduleMinuteBase> reviewComments = reviewCommentsBean.getReviewComments();
            List<CommitteeScheduleMinuteBase> deletedReviewComments = reviewCommentsBean.getDeletedReviewComments();
            this.getReviewCommentsService().moveUpReviewComment(reviewComments, protocol, commentIndex);
            this.getReviewCommentsService().saveReviewComments(reviewComments, deletedReviewComments);
            this.getDocumentService().saveDocument((Document)document);
        }
        protocolForm.getOnlineReviewsActionHelper().init(true);
        return mapping.findForward("basic");
    }

    public ActionForward moveDownOnlineReviewComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        OnlineReviewsActionHelperBase actionHelper = protocolForm.getOnlineReviewsActionHelper();
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        String documentNumber = this.getOnlineReviewActionDocumentNumber(parameterName, "moveDownOnlineReviewComment");
        ProtocolOnlineReviewDocumentBase document = actionHelper.getDocumentFromHelperMap(documentNumber);
        ReviewCommentsBeanBase reviewCommentsBean = actionHelper.getReviewCommentsBeanFromHelperMap(documentNumber);
        long documentIndex = actionHelper.getIndexByDocumentNumber(documentNumber);
        int commentIndex = this.getOnlineReviewActionIndexNumber(parameterName, "moveDownOnlineReviewComment");
        if (this.applyRules((DocumentEvent)new SaveProtocolOnlineReviewEvent(document, reviewCommentsBean.getReviewComments(), documentIndex))) {
            ProtocolBase protocol = protocolForm.getProtocolDocument().getProtocol();
            List<CommitteeScheduleMinuteBase> reviewComments = reviewCommentsBean.getReviewComments();
            List<CommitteeScheduleMinuteBase> deletedReviewComments = reviewCommentsBean.getDeletedReviewComments();
            this.getReviewCommentsService().moveDownReviewComment(reviewComments, protocol, commentIndex);
            this.getReviewCommentsService().saveReviewComments(reviewComments, deletedReviewComments);
            this.getDocumentService().saveDocument((Document)document);
        }
        protocolForm.getOnlineReviewsActionHelper().init(true);
        return mapping.findForward("basic");
    }

    public ActionForward viewOnlineReviewAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        OnlineReviewsActionHelperBase actionHelper = protocolForm.getOnlineReviewsActionHelper();
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        String documentNumber = this.getOnlineReviewActionDocumentNumber(parameterName, "viewOnlineReviewAttachment");
        IacucReviewAttachmentsBean reviewAttachmentsBean = (IacucReviewAttachmentsBean)actionHelper.getReviewAttachmentsBeanFromHelperMap(documentNumber);
        int attachmentIndex = this.getOnlineReviewActionIndexNumber(parameterName, "viewOnlineReviewAttachment");
        IacucProtocolReviewAttachment attachment = (IacucProtocolReviewAttachment)reviewAttachmentsBean.getReviewAttachments().get(attachmentIndex);
        if (attachment == null) {
            LOG.info(NOT_FOUND_SELECTION + attachmentIndex);
            return mapping.findForward("basic");
        }
        AttachmentFile file = attachment.getFile();
        this.streamToResponse(file.getData(), IacucProtocolOnlineReviewAction.getValidHeaderString(file.getName()), IacucProtocolOnlineReviewAction.getValidHeaderString(file.getType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    public ActionForward saveOnlineReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String onlineReviewDocumentNumber = this.getOnlineReviewActionDocumentNumber((String)request.getAttribute("methodToCallAttribute"), "saveOnlineReview");
        DocumentService documentService = KcServiceLocator.getService(DocumentService.class);
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        ProtocolOnlineReviewDocumentBase prDoc = protocolForm.getOnlineReviewsActionHelper().getDocumentFromHelperMap(onlineReviewDocumentNumber);
        ReviewCommentsBeanBase reviewCommentsBean = protocolForm.getOnlineReviewsActionHelper().getReviewCommentsBeanFromHelperMap(onlineReviewDocumentNumber);
        ReviewAttachmentsBeanBase reviewAttachmentsBean = protocolForm.getOnlineReviewsActionHelper().getReviewAttachmentsBeanFromHelperMap(onlineReviewDocumentNumber);
        if (this.applyRules((DocumentEvent)new SaveProtocolOnlineReviewEvent(prDoc, reviewCommentsBean.getReviewComments(), protocolForm.getOnlineReviewsActionHelper().getIndexByDocumentNumber(onlineReviewDocumentNumber)))) {
            ProtocolReviewer reviewer = prDoc.getProtocolOnlineReview().getProtocolReviewer();
            this.getReviewCommentsService().saveReviewComments(reviewCommentsBean.getReviewComments(), reviewCommentsBean.getDeletedReviewComments());
            this.getReviewCommentsService().saveReviewAttachments(reviewAttachmentsBean.getReviewAttachments(), reviewAttachmentsBean.getDeletedReviewAttachments());
            this.getBusinessObjectService().save((PersistableBusinessObject)reviewer);
            documentService.saveDocument((Document)prDoc);
            this.recordOnlineReviewActionSuccess("saved", prDoc);
            protocolForm.getOnlineReviewsActionHelper().init(true);
        }
        return mapping.findForward("basic");
    }

    public ActionForward approveOnlineReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String onlineReviewDocumentNumber = this.getOnlineReviewActionDocumentNumber((String)request.getAttribute("methodToCallAttribute"), "approveOnlineReview");
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        ProtocolOnlineReviewDocumentBase prDoc = protocolForm.getOnlineReviewsActionHelper().getDocumentFromHelperMap(onlineReviewDocumentNumber);
        ReviewCommentsBeanBase reviewCommentsBean = protocolForm.getOnlineReviewsActionHelper().getReviewCommentsBeanFromHelperMap(onlineReviewDocumentNumber);
        ReviewAttachmentsBeanBase reviewAttachmentsBean = protocolForm.getOnlineReviewsActionHelper().getReviewAttachmentsBeanFromHelperMap(onlineReviewDocumentNumber);
        boolean validComments = this.applyRules((DocumentEvent)new RouteProtocolOnlineReviewEvent(prDoc, reviewCommentsBean.getReviewComments(), protocolForm.getOnlineReviewsActionHelper().getIndexByDocumentNumber(onlineReviewDocumentNumber)));
        boolean statusIsOk = false;
        if (validComments && this.getKraWorkflowService().isUserApprovalRequested((Document)prDoc, GlobalVariables.getUserSession().getPrincipalId())) {
            prDoc.getProtocolOnlineReview().setProtocolOnlineReviewStatusCode("F");
            prDoc.getProtocolOnlineReview().setReviewerApproved(true);
            if (this.getKraWorkflowService().isDocumentOnNode((Document)prDoc, "IACUCAdminReview")) {
                prDoc.getProtocolOnlineReview().setAdminAccepted(true);
                this.setOnlineReviewCommentFinalFlags(prDoc.getProtocolOnlineReview(), true);
            }
            this.getBusinessObjectService().save((PersistableBusinessObject)prDoc.getProtocolOnlineReview());
            this.getDocumentService().saveDocument((Document)prDoc);
            statusIsOk = true;
        }
        if (validComments && statusIsOk) {
            this.getReviewCommentsService().saveReviewComments(reviewCommentsBean.getReviewComments(), reviewCommentsBean.getDeletedReviewComments());
            this.getReviewCommentsService().saveReviewAttachments(reviewAttachmentsBean.getReviewAttachments(), reviewAttachmentsBean.getDeletedReviewAttachments());
            prDoc.getProtocolOnlineReview().addActionPerformed("Approve");
            this.getDocumentService().saveDocument((Document)prDoc);
            this.getDocumentService().approveDocument((Document)prDoc, "", null);
            protocolForm.getOnlineReviewsActionHelper().init(true);
            this.recordOnlineReviewActionSuccess("approved", prDoc);
            IacucProtocol protocol = (IacucProtocol)protocolForm.getProtocolDocument().getProtocol();
            IacucProtocolOnlineReview protocolOnlineReview = (IacucProtocolOnlineReview)prDoc.getProtocolOnlineReview();
            IacucProtocolNotificationRenderer renderer = new IacucProtocolNotificationRenderer(protocol);
            IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(protocol, protocolOnlineReview, "902", "Review Complete", prDoc.getDocumentNumber(), "Approve");
            ActionForward forward = null;
            if (!protocolForm.getEditingMode().containsKey("maintainProtocolOnlineReviews")) {
                forward = mapping.findForward(PROTOCOL_OLR_TAB);
            }
            return this.checkToSendNotificationWithHoldingPage(mapping, forward, protocolForm, renderer, notificationBean);
        }
        return mapping.findForward("basic");
    }

    private ActionForward checkToSendNotificationWithHoldingPage(ActionMapping mapping, ActionForward forward, IacucProtocolForm protocolForm, IacucProtocolNotificationRenderer renderer, IacucProtocolNotificationRequestBean notificationRequestBean) {
        IacucProtocolNotificationContext context = new IacucProtocolNotificationContext(notificationRequestBean.getIacucProtocol(), notificationRequestBean.getIacucProtocolOnlineReview(), notificationRequestBean.getActionType(), notificationRequestBean.getDescription(), renderer);
        if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
            if (forward == null) {
                context.setForwardName("holdingPage:" + notificationRequestBean.getDocNumber() + ":" + notificationRequestBean.getOlrEvent());
            } else {
                context.setForwardName(forward.getName());
            }
            protocolForm.getNotificationHelper().initializeDefaultValues(context);
            return mapping.findForward("iacucProtocolNotificationEditor");
        }
        this.getNotificationService().sendNotificationAndPersist(context, new IacucProtocolNotification(), protocolForm.getProtocolDocument().getProtocol());
        if (forward == null) {
            return this.routeProtocolOLRToHoldingPage(mapping, protocolForm, notificationRequestBean.getDocNumber(), notificationRequestBean.getOlrEvent());
        }
        return forward;
    }

    private ActionForward routeProtocolOLRToHoldingPage(ActionMapping mapping, ProtocolFormBase protocolForm, String olrDocId, String olrEvent) {
        String routeHeaderId = protocolForm.getDocument().getDocumentNumber();
        Object returnLocation = this.buildActionUrl(routeHeaderId, "onlineReview", "IacucProtocolDocument");
        returnLocation = (String)returnLocation + "&olrDocId=" + olrDocId + "&olrEvent=" + olrEvent;
        ActionForward basicForward = mapping.findForward("portal");
        ActionRedirect holdingPageForward = new ActionRedirect((ForwardConfig)mapping.findForward("kraHoldingPage"));
        holdingPageForward.addParameter("holdingPageDocumentId", (Object)routeHeaderId);
        return this.routeToHoldingPage(basicForward, basicForward, holdingPageForward, (String)returnLocation, olrDocId);
    }

    private KcWorkflowService getKraWorkflowService() {
        return KcServiceLocator.getService(KcWorkflowService.class);
    }

    private void setOnlineReviewCommentFinalFlags(ProtocolOnlineReviewBase onlineReview, boolean flagValue) {
        List<CommitteeScheduleMinuteBase> minutes = onlineReview.getCommitteeScheduleMinutes();
        for (CommitteeScheduleMinuteBase minute : minutes) {
            minute.setFinalFlag(flagValue);
        }
    }

    public ActionForward deleteOnlineReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int noteTextMaxLength;
        String onlineReviewDocumentNumber = this.getOnlineReviewActionDocumentNumber((String)request.getAttribute("methodToCallAttribute"), "deleteOnlineReview");
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        ProtocolOnlineReviewDocumentBase prDoc = (ProtocolOnlineReviewDocumentBase)protocolForm.getOnlineReviewsActionHelper().getDocumentHelperMap().get(onlineReviewDocumentNumber).get("document");
        ReviewCommentsBeanBase reviewCommentsBean = protocolForm.getOnlineReviewsActionHelper().getReviewCommentsBeanFromHelperMap(onlineReviewDocumentNumber);
        String question = request.getParameter("questionIndex");
        String reason = request.getParameter("reason");
        Object deleteNoteText = "";
        String callerString = String.format("disapproveOnlineReview.%s.anchor%s", prDoc.getDocumentNumber(), 0);
        if (!this.applyRules((DocumentEvent)new SaveProtocolOnlineReviewEvent(prDoc, reviewCommentsBean.getReviewComments(), protocolForm.getOnlineReviewsActionHelper().getIndexByDocumentNumber(onlineReviewDocumentNumber)))) {
            return mapping.findForward("basic");
        }
        if (question == null) {
            return this.performQuestionWithInput(mapping, form, request, response, DOCUMENT_DELETE_QUESTION, "Are you sure you want to delete this document?", "confirmationQuestion", callerString, "");
        }
        String buttonClicked = request.getParameter("buttonClicked");
        if (DOCUMENT_DELETE_QUESTION.equals(question) && "1".equals(buttonClicked)) {
            return mapping.findForward("basic");
        }
        String introNoteMessage = "Deletion reason - ";
        deleteNoteText = introNoteMessage + reason;
        if (!this.applyRules((DocumentEvent)new DeleteProtocolOnlineReviewEvent(prDoc, reason, (String)deleteNoteText, noteTextMaxLength = this.getDataDictionaryService().getAttributeMaxLength(Note.class, "noteText").intValue()))) {
            int reasonLimit = noteTextMaxLength - introNoteMessage.length();
            if (reason == null) {
                reason = "";
            }
            return this.performQuestionWithInputAgainBecauseOfErrors(mapping, form, request, response, DOCUMENT_DELETE_QUESTION, "Are you sure you want to delete this document?", "confirmationQuestion", callerString, "", reason, ERROR_DOCUMENT_DELETE_REASON_REQUIRED, "reason", Integer.valueOf(reasonLimit).toString());
        }
        if (KRADUtils.containsSensitiveDataPatternMatch((String)deleteNoteText)) {
            return this.performQuestionWithInputAgainBecauseOfErrors(mapping, form, request, response, DOCUMENT_DELETE_QUESTION, "Are you sure you want to delete this document?", "confirmationQuestion", callerString, "", reason, "error.document.fieldContainsPossibleSensitiveData", "reason", "reason");
        }
        prDoc.getProtocolOnlineReview().addActionPerformed("Delete");
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)protocolForm.getOnlineReviewsActionHelper().getDocumentHelperMap().get(onlineReviewDocumentNumber).get("kualiForm");
        this.doProcessingAfterPost((KualiForm)kualiDocumentFormBase, request);
        ProtocolOnlineReviewDocumentBase document = (ProtocolOnlineReviewDocumentBase)kualiDocumentFormBase.getDocument();
        document.getProtocolOnlineReview().setProtocolOnlineReviewStatusCode("X");
        document.getProtocolOnlineReview().setReviewerApproved(false);
        document.getProtocolOnlineReview().setAdminAccepted(false);
        this.getBusinessObjectService().save((PersistableBusinessObject)document.getProtocolOnlineReview());
        this.getDocumentService().disapproveDocument((Document)document, (String)deleteNoteText);
        KNSGlobalVariables.getMessageList().add("message.route.disapproved", new String[0]);
        kualiDocumentFormBase.setAnnotation("");
        protocolForm.getOnlineReviewsActionHelper().init(true);
        this.recordOnlineReviewActionSuccess("deleted", prDoc);
        return mapping.findForward("basic");
    }

    public ActionForward rejectOnlineReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String onlineReviewDocumentNumber = this.getOnlineReviewActionDocumentNumber((String)request.getAttribute("methodToCallAttribute"), "rejectOnlineReview");
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        ProtocolOnlineReviewDocumentBase prDoc = (ProtocolOnlineReviewDocumentBase)protocolForm.getOnlineReviewsActionHelper().getDocumentHelperMap().get(onlineReviewDocumentNumber).get("document");
        String question = request.getParameter("questionIndex");
        String buttonClicked = request.getParameter("buttonClicked");
        String reason = request.getParameter("reason");
        String callerString = String.format("rejectOnlineReview.%s.anchor%s", prDoc.getDocumentNumber(), 0);
        if (question == null) {
            return this.performQuestionWithInput(mapping, form, request, response, DOCUMENT_REJECT_QUESTION, "Are you sure you want to return this document to reviewer ?", "confirmationQuestion", callerString, "");
        }
        if (!DOCUMENT_REJECT_QUESTION.equals(question) || !"1".equals(buttonClicked)) {
            if (!this.applyRules((DocumentEvent)new RejectProtocolOnlineReviewCommentEvent(prDoc, reason, Integer.valueOf(DOCUMENT_REJECT_REASON_MAXLENGTH)))) {
                if (reason == null) {
                    reason = "";
                }
                return this.performQuestionWithInputAgainBecauseOfErrors(mapping, form, request, response, DOCUMENT_REJECT_QUESTION, "Are you sure you want to return this document to reviewer ?", "confirmationQuestion", callerString, "", reason, "error.protocol.onlinereview.comment.rejected", "reason", DOCUMENT_REJECT_REASON_MAXLENGTH);
            }
            if (KRADUtils.containsSensitiveDataPatternMatch((String)reason)) {
                return this.performQuestionWithInputAgainBecauseOfErrors(mapping, form, request, response, DOCUMENT_REJECT_QUESTION, "Are you sure you want to return this document to reviewer ?", "confirmationQuestion", callerString, "", reason, "error.document.fieldContainsPossibleSensitiveData", "reason", "reason");
            }
            prDoc.getProtocolOnlineReview().setProtocolOnlineReviewStatusCode("S");
            prDoc.getProtocolOnlineReview().addActionPerformed("Return");
            prDoc.getProtocolOnlineReview().setReviewerApproved(false);
            prDoc.getProtocolOnlineReview().setAdminAccepted(false);
            this.setOnlineReviewCommentFinalFlags(prDoc.getProtocolOnlineReview(), false);
            this.getDocumentService().saveDocument((Document)prDoc);
            this.getProtocolOnlineReviewService().returnProtocolOnlineReviewDocumentToReviewer(prDoc, reason, GlobalVariables.getUserSession().getPrincipalId());
            IacucProtocol protocol = (IacucProtocol)protocolForm.getProtocolDocument().getProtocol();
            IacucProtocolOnlineReview protocolOnlineReview = (IacucProtocolOnlineReview)prDoc.getProtocolOnlineReview();
            protocolForm.getOnlineReviewsActionHelper().init(true);
            IacucRejectReviewNotificationRenderer renderer = new IacucRejectReviewNotificationRenderer(protocol, reason);
            IacucProtocolNotificationRequestBean notificationBean = new IacucProtocolNotificationRequestBean(protocol, protocolOnlineReview, "903", "Return to Reviewer", prDoc.getDocumentNumber(), "Return");
            return this.checkToSendNotificationWithHoldingPage(mapping, null, (IacucProtocolForm)protocolForm, renderer, notificationBean);
        }
        return mapping.findForward("basic");
    }
}

