/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.printing.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.printing.service.InstitutionalProposalPersonService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class InstitutionalProposalPersonServiceImpl
implements InstitutionalProposalPersonService {
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;

    @Override
    public List<ProposalPerson> getInvestigatorsFromDevelopmentProposal(String proposalNumber) {
        DevelopmentProposal developmentProposal;
        ArrayList<ProposalPerson> proposalPersonsList = new ArrayList<ProposalPerson>();
        List developmentProposals = (List)this.dataObjectService.find(DevelopmentProposal.class, (Object)proposalNumber);
        if (developmentProposals != null && !developmentProposals.isEmpty() && (developmentProposal = (DevelopmentProposal)developmentProposals.get(0)).getProposalPersons() != null) {
            for (ProposalPerson proposalPerson : developmentProposal.getProposalPersons()) {
                if (!"PI".equals(proposalPerson.getProjectRole()) && !"COI".equals(proposalPerson.getProjectRole())) continue;
                proposalPersonsList.add(proposalPerson);
            }
        }
        return proposalPersonsList;
    }

    @Override
    public Boolean isCreditSplitOptInEnabled() {
        return this.parameterService.getParameterValueAsBoolean("KC-PD", "All", "ENABLE_OPT_IN_PERSONNEL_CREDIT_SPLIT_FUNCTIONALITY");
    }

    @Override
    public Boolean generateCreditSplitForPerson(InstitutionalProposalPerson person) {
        boolean optIn = this.isCreditSplitOptInEnabled();
        return !optIn || person.getIncludeInCreditAllocation() != false;
    }

    @Override
    public List<InstitutionalProposalPerson> getPersonsSelectedForCreditSplit(List<InstitutionalProposalPerson> projectPersons) {
        List<InstitutionalProposalPerson> institutionalProposalPersons = projectPersons.stream().filter(person -> this.generateCreditSplitForPerson((InstitutionalProposalPerson)person)).collect(Collectors.toList());
        return institutionalProposalPersons;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

