/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.ProtocolSubmissionBuilder;
import org.kuali.kra.irb.actions.request.ProtocolRequestBean;
import org.kuali.kra.irb.actions.request.ProtocolRequestService;
import org.kuali.kra.irb.actions.submit.ProtocolActionService;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class ProtocolRequestServiceImpl
implements ProtocolRequestService {
    private static final Logger LOG = LogManager.getLogger(ProtocolRequestServiceImpl.class);
    private static final String MODULE_ITEM_CODE = "moduleItemCode";
    private static final String MODULE_ITEM_KEY = "moduleItemKey";
    private BusinessObjectService businessObjectService;
    private DocumentService documentService;
    private ProtocolActionService protocolActionService;

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setProtocolActionService(ProtocolActionService protocolActionService) {
        this.protocolActionService = protocolActionService;
    }

    @Override
    public void submitRequest(Protocol protocol, ProtocolRequestBean requestBean) throws WorkflowException {
        LOG.info("submitRequest " + requestBean.getProtocolActionTypeCode() + " " + protocol.getProtocolDocument().getDocumentNumber());
        String prevSubmissionStatusCode = protocol.getProtocolSubmission().getSubmissionStatusCode();
        ProtocolSubmission submission = this.createProtocolSubmission(protocol, requestBean);
        String submissionTypeCode = submission.getSubmissionTypeCode();
        protocol.setProtocolSubmission(submission);
        ProtocolAction protocolAction = new ProtocolAction(protocol, submission, requestBean.getProtocolActionTypeCode());
        protocolAction.setComments(requestBean.getReason());
        protocolAction.setProtocol(protocol);
        protocolAction.setPrevProtocolStatusCode(protocol.getProtocolStatusCode());
        protocolAction.setPrevSubmissionStatusCode(prevSubmissionStatusCode);
        protocolAction.setSubmissionTypeCode(submissionTypeCode);
        protocol.getProtocolActions().add(protocolAction);
        this.protocolActionService.updateProtocolStatus(protocolAction, protocol);
        if (!CollectionUtils.isEmpty(requestBean.getQuestionnaireHelper().getAnswerHeaders())) {
            this.saveQuestionnaire(requestBean, submission.getSubmissionNumber());
            requestBean.getQuestionnaireHelper().setAnswerHeaders(new ArrayList<AnswerHeader>());
        }
        this.cleanUnreferencedQuestionnaire(protocol.getProtocolNumber());
        this.documentService.saveDocument((Document)protocol.getProtocolDocument());
    }

    private void saveQuestionnaire(ProtocolRequestBean requestBean, Integer submissionNumber) {
        ArrayList<AnswerHeader> saveHeaders = new ArrayList<AnswerHeader>();
        for (AnswerHeader answerHeader : requestBean.getQuestionnaireHelper().getAnswerHeaders()) {
            if (answerHeader.getId() == null) continue;
            answerHeader.setModuleSubItemKey(submissionNumber.toString());
            if (answerHeader.getModuleItemKey().matches(".*[A-Z]$")) {
                answerHeader.setModuleItemKey(answerHeader.getModuleItemKey().substring(0, answerHeader.getModuleItemKey().length() - 1));
            }
            saveHeaders.add(answerHeader);
        }
        if (!saveHeaders.isEmpty()) {
            this.businessObjectService.save(saveHeaders);
        }
    }

    private void cleanUnreferencedQuestionnaire(String protocolNumber) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put(MODULE_ITEM_CODE, "7");
        fieldValues.put(MODULE_ITEM_KEY, protocolNumber + "T");
        List answerHeaders = (List)this.businessObjectService.findMatching(AnswerHeader.class, fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)answerHeaders)) {
            this.businessObjectService.delete(answerHeaders);
        }
    }

    protected ProtocolSubmission createProtocolSubmission(Protocol protocol, ProtocolRequestBean requestBean) {
        ProtocolSubmissionBuilder submissionBuilder = new ProtocolSubmissionBuilder(protocol, requestBean.getSubmissionTypeCode());
        submissionBuilder.setProtocolReviewTypeCode("1");
        submissionBuilder.setSubmissionStatus("102");
        submissionBuilder.setCommittee(requestBean.getCommitteeId());
        submissionBuilder.setActionAttachments(requestBean.getActionAttachments());
        return submissionBuilder.create();
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }
}

