/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.drools.util;

import java.io.IOException;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.internal.io.ResourceFactory;
import org.kuali.kra.protocol.drools.brms.FactBean;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public class DroolsRuleHandler {
    private static final Logger LOG = LogManager.getLogger(DroolsRuleHandler.class);
    private KieContainer rules;

    public DroolsRuleHandler(String ruleFile) {
        this.rules = this.getRuleBase(ruleFile);
    }

    private KieContainer getRuleBase(String rulesFile) {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader(ClassLoaderUtils.getDefaultClassLoader());
        Resource resource = resourceLoader.getResource(rulesFile);
        try {
            KieServices kieServices = KieServices.Factory.get();
            KieFileSystem kfs = kieServices.newKieFileSystem();
            kfs.write(ResourceFactory.newUrlResource((URL)resource.getURL()));
            KieBuilder kieBuilder = kieServices.newKieBuilder(kfs).buildAll();
            Results results = kieBuilder.getResults();
            if (results.hasMessages(new Message.Level[]{Message.Level.INFO})) {
                LOG.info((Object)results.getMessages(new Message.Level[]{Message.Level.INFO}));
            }
            if (results.hasMessages(new Message.Level[]{Message.Level.WARNING})) {
                LOG.warn((Object)results.getMessages(new Message.Level[]{Message.Level.WARNING}));
            }
            if (results.hasMessages(new Message.Level[]{Message.Level.ERROR})) {
                throw new RuntimeException(results.getMessages(new Message.Level[]{Message.Level.ERROR}).toString());
            }
            return kieServices.newKieContainer(kieServices.getRepository().getDefaultReleaseId());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T extends FactBean> void executeRules(T fact) {
        KieSession session = null;
        try {
            session = this.rules.newKieSession();
            session.insert(fact);
            session.fireAllRules();
        }
        finally {
            if (session != null) {
                session.dispose();
            }
        }
    }
}

