/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.permission;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.auth.SystemAuthorizationService;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kim.api.permission.PermissionQueryResults;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.type.KimType;

public abstract class PermissionsHelperBase
extends org.kuali.coeus.common.permissions.impl.web.struts.form.PermissionsHelperBase {
    private static final long serialVersionUID = 5896277052902587682L;
    protected static final String AGGREGATOR_NAME = "Aggregator";
    protected static final String VIEWER_NAME = "Viewer";
    protected static final String UNASSIGNED_NAME = "unassigned";
    protected Collection<String> excludeRoles;
    protected ProtocolFormBase form;
    protected Map<String, String> displayNameMap = null;
    private String roleType;

    public PermissionsHelperBase(ProtocolFormBase form, String roleType) {
        super(roleType);
        this.roleType = roleType;
        this.form = form;
    }

    protected abstract void initExcludedRolesHook();

    protected abstract void buildDisplayNameMap();

    @Override
    public List<KeyValue> getRoleSelection() {
        this.buildDisplayNameMap();
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        for (String role : this.displayNameMap.keySet()) {
            ConcreteKeyValue pair = new ConcreteKeyValue(role, this.displayNameMap.get(role));
            keyValues.add((KeyValue)pair);
        }
        this.addNonDerivedRoles(keyValues);
        return keyValues;
    }

    protected void addNonDerivedRoles(List<KeyValue> keyValues) {
        List<Role> kimRoles = this.getSortedKimRoles(this.roleType);
        for (Role kimRole : kimRoles) {
            KimType type;
            String roleName = kimRole.getName();
            if (this.excludeRoles.contains(roleName) || this.displayNameMap.keySet().contains(roleName) || StringUtils.startsWith((CharSequence)(type = this.getSystemAuthorizationService().getKimTypeInfoForRole(kimRole)).getName(), (CharSequence)"Derived Role") || StringUtils.startsWith((CharSequence)type.getName(), (CharSequence)"Default")) continue;
            ConcreteKeyValue pair = new ConcreteKeyValue(roleName, roleName);
            keyValues.add((KeyValue)pair);
        }
    }

    protected SystemAuthorizationService getSystemAuthorizationService() {
        return KcServiceLocator.getService(SystemAuthorizationService.class);
    }

    protected ProtocolBase getProtocol() {
        ProtocolDocumentBase document = this.form.getProtocolDocument();
        if (document == null || document.getProtocol() == null) {
            throw new IllegalArgumentException("invalid (null) ProtocolDocumentBase in ProtocolFormBase");
        }
        return document.getProtocol();
    }

    @Override
    public String getUnassignedRoleName() {
        return "Protocol Unassigned";
    }

    @Override
    protected String getRoleDisplayName(String roleName) {
        this.buildDisplayNameMap();
        String displayName = this.displayNameMap.get(roleName);
        if (displayName == null) {
            displayName = roleName;
        }
        return displayName;
    }

    @Override
    protected void buildRoles(String roleType) {
        this.initExcludedRolesHook();
        ArrayList<org.kuali.coeus.common.permissions.impl.web.bean.Role> roles = new ArrayList<org.kuali.coeus.common.permissions.impl.web.bean.Role>();
        List<Role> kimRoles = this.getSortedKimRoles(roleType);
        for (Role kimRole : kimRoles) {
            if (this.excludeRoles.contains(kimRole.getName())) continue;
            QueryByCriteria.Builder queryBuilder = QueryByCriteria.Builder.create();
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(PredicateFactory.equal((String)"rolePermissions.roleId", (Object)kimRole.getId()));
            queryBuilder.setPredicates(new Predicate[]{PredicateFactory.and((Predicate[])predicates.toArray(new Predicate[0]))});
            PermissionQueryResults permissionResults = this.getKimPermissionService().findPermissions(queryBuilder.build());
            org.kuali.coeus.common.permissions.impl.web.bean.Role role = new org.kuali.coeus.common.permissions.impl.web.bean.Role(kimRole.getName(), this.getRoleDisplayName(kimRole.getName()), permissionResults.getResults());
            roles.add(role);
        }
        this.setRoles(roles);
    }

    @Override
    protected List<KcPerson> getPersonsInRole(String roleName) {
        KcAuthorizationService kraAuthorizationService = KcServiceLocator.getService(KcAuthorizationService.class);
        KcPersonService kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        List<String> users = kraAuthorizationService.getPrincipalsInRole(roleName, this.getProtocol());
        ArrayList<KcPerson> persons = new ArrayList<KcPerson>();
        for (String userId : users) {
            KcPerson person = kcPersonService.getKcPersonByPersonId(userId);
            if (person == null || !person.getActive().booleanValue()) continue;
            persons.add(person);
        }
        return persons;
    }

    public String getRoleType() {
        return this.roleType;
    }
}

