/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.personnel;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.upload.FormFile;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentPersonnelBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentService;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentTypeBase;
import org.kuali.kra.protocol.personnel.AddProtocolAttachmentPersonnelEvent;
import org.kuali.kra.protocol.personnel.AddProtocolAttachmentPersonnelRule;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ProtocolAttachmentPersonnelRuleBase
extends KcTransactionalDocumentRuleBase
implements AddProtocolAttachmentPersonnelRule {
    private static final Logger LOG = LogManager.getLogger(ProtocolAttachmentPersonnelRuleBase.class);
    protected static final String PROPERTY_NAME_NEW_ATTACHMENT_TYPE = "personnelHelper.newProtocolAttachmentPersonnels[%1$s].typeCode";
    protected static final String PROPERTY_NAME_NEW_ATTACHMENT_DESCRIPTION = "personnelHelper.newProtocolAttachmentPersonnels[%1$s].description";
    protected static final String PROPERTY_NAME_NEW_ATTACHMENT_FILE = "personnelHelper.newProtocolAttachmentPersonnels[%1$s].newFile";

    @Override
    public boolean processAddProtocolAttachmentPersonnelRules(AddProtocolAttachmentPersonnelEvent event) {
        boolean isValid = true;
        String typePropertyName = String.format(PROPERTY_NAME_NEW_ATTACHMENT_TYPE, event.getPersonIndex());
        String descriptionPropertyName = String.format(PROPERTY_NAME_NEW_ATTACHMENT_DESCRIPTION, event.getPersonIndex());
        String filePropertyName = String.format(PROPERTY_NAME_NEW_ATTACHMENT_FILE, event.getPersonIndex());
        ProtocolAttachmentPersonnelBase newAttachment = event.getProtocolAttachmentPersonnel();
        ProtocolPersonBase person = ((ProtocolDocumentBase)event.getDocument()).getProtocol().getProtocolPerson(event.getPersonIndex());
        isValid &= this.validType(newAttachment.getTypeCode(), newAttachment.getGroupCode(), typePropertyName);
        isValid &= this.duplicateType(newAttachment.getTypeCode(), person, typePropertyName);
        isValid &= this.validDescription(newAttachment.getDescription(), newAttachment.getTypeCode(), descriptionPropertyName);
        return isValid &= this.validFile(newAttachment.getNewFile(), filePropertyName);
    }

    protected boolean validType(String typeCode, String groupCode, String propertyName) {
        assert (!StringUtils.isEmpty((CharSequence)groupCode));
        for (ProtocolAttachmentTypeBase type : this.getProtocolAttachmentService().getTypesForGroup(groupCode)) {
            if (!StringUtils.equals((CharSequence)type.getCode(), (CharSequence)typeCode)) continue;
            return true;
        }
        GlobalVariables.getMessageMap().putError(propertyName, "error.protocol.attachment.personnel.invalid.type", new String[0]);
        return false;
    }

    protected boolean duplicateType(String typeCode, ProtocolPersonBase person, String propertyName) {
        for (ProtocolAttachmentPersonnelBase attachment : person.getAttachmentPersonnels()) {
            if (!StringUtils.equals((CharSequence)attachment.getTypeCode(), (CharSequence)typeCode)) continue;
            GlobalVariables.getMessageMap().putError(propertyName, "error.protocol.attachment.personnel.duplicate.type", new String[0]);
            return false;
        }
        return true;
    }

    protected boolean validDescription(String description, String typeCode, String propertyName) {
        if (StringUtils.isEmpty((CharSequence)description)) {
            GlobalVariables.getMessageMap().putError(propertyName, "error.protocol.attachment.personnel.invalid.description", new String[0]);
            return false;
        }
        return true;
    }

    protected boolean validFile(FormFile file, String propertyName) {
        byte[] fileData;
        try {
            fileData = file.getFileData();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            GlobalVariables.getMessageMap().putError(propertyName, "error.protocol.attachment.personnel.empty.file", new String[0]);
            return false;
        }
        if (fileData == null || fileData.length == 0) {
            GlobalVariables.getMessageMap().putError(propertyName, "error.protocol.attachment.personnel.empty.file", new String[0]);
            return false;
        }
        return true;
    }

    protected abstract ProtocolAttachmentService getProtocolAttachmentService();
}

