/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.platform;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.kuali.rice.krad.data.platform.DatabasePlatformInfo;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

public final class DatabasePlatforms {
    public static final String ORACLE = "Oracle";
    public static final String MYSQL = "MySQL";
    private static final Map<DataSource, DatabasePlatformInfo> platformCache = Collections.synchronizedMap(new IdentityHashMap(8));

    public static DatabasePlatformInfo detectPlatform(DataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException("DataSource must not be null.");
        }
        DatabasePlatformInfo platformInfo = platformCache.get(dataSource);
        if (platformInfo == null) {
            JdbcTemplate template = new JdbcTemplate(dataSource);
            platformCache.put(dataSource, (DatabasePlatformInfo)template.execute((ConnectionCallback)new ConnectionCallback<DatabasePlatformInfo>(){

                public DatabasePlatformInfo doInConnection(Connection connection) throws SQLException, DataAccessException {
                    DatabaseMetaData metadata = connection.getMetaData();
                    String vendorName = metadata.getDatabaseProductName();
                    int version = metadata.getDatabaseMajorVersion();
                    return new DatabasePlatformInfo(vendorName, version);
                }
            }));
            if (platformInfo == null) {
                platformInfo = platformCache.get(dataSource);
            }
        }
        return platformInfo;
    }

    private DatabasePlatforms() {
    }
}

