/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.dc.access.proposal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;
import org.kuali.coeus.dc.access.kim.KimAttributeDocumentValueHandler;
import org.kuali.coeus.dc.access.proposal.ProposalKimAttributeDefnDao;
import org.kuali.coeus.dc.common.db.ConnectionDaoService;
import org.kuali.coeus.dc.common.db.PreparedStatementUtils;

public class ProposalKimAttributeDocumentValueHandler
implements KimAttributeDocumentValueHandler {
    private static final Logger LOG = Logger.getLogger(ProposalKimAttributeDocumentValueHandler.class.getName());
    private ProposalKimAttributeDefnDao proposalKimAttributeDefnDao;
    private ConnectionDaoService connectionDaoService;
    private boolean delete;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String transform(String val) {
        Connection connection = this.connectionDaoService.getCoeusConnection();
        try (PreparedStatement stmt = PreparedStatementUtils.setString(1, val, connection.prepareStatement("SELECT DOCUMENT_NUMBER FROM EPS_PROPOSAL WHERE PROPOSAL_NUMBER = ?"));
             ResultSet result = stmt.executeQuery();){
            if (result.next()) {
                String string = result.getString(1);
                return string;
            }
            LOG.warning("cannot find document number for proposal: " + val);
            return null;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isDocumentValueType(String attrDefnId) {
        return this.proposalKimAttributeDefnDao.getDocumentQualifierAttrDefnId().equals(attrDefnId);
    }

    @Override
    public void cleanup() {
        if (!this.proposalKimAttributeDefnDao.isDocumentQualifierAttrDefnUsed()) {
            if (this.delete) {
                this.proposalKimAttributeDefnDao.deleteDocumentQualifierAttrDefn();
            } else {
                this.proposalKimAttributeDefnDao.inactivateDocumentQualifierAttrDefn();
            }
        } else {
            LOG.warning("Proposal Attribute Definition is still used.  It cannot be " + (this.delete ? "deleted" : "inactivated") + ".");
        }
    }

    public ProposalKimAttributeDefnDao getProposalKimAttributeDefnDao() {
        return this.proposalKimAttributeDefnDao;
    }

    public void setProposalKimAttributeDefnDao(ProposalKimAttributeDefnDao proposalKimAttributeDefnDao) {
        this.proposalKimAttributeDefnDao = proposalKimAttributeDefnDao;
    }

    public ConnectionDaoService getConnectionDaoService() {
        return this.connectionDaoService;
    }

    public void setConnectionDaoService(ConnectionDaoService connectionDaoService) {
        this.connectionDaoService = connectionDaoService;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }
}

