/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.resourceloader;

import java.util.Set;
import javax.xml.namespace.QName;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.resourceloader.ResourceLoader;
import org.kuali.rice.core.framework.resourceloader.BeanFactoryResourceLoader;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;

public class RiceSpringResourceLoaderConfigurer
implements BeanFactoryAware,
InitializingBean {
    private QName name;
    private String localServiceName;
    private String serviceNameSpaceURI;
    private Set<String> beanNames;
    private BeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.name == null) {
            if (this.getServiceNameSpaceURI() == null) {
                this.setServiceNameSpaceURI(CoreConfigHelper.getApplicationId());
            }
            if (this.getLocalServiceName() == null) {
                throw new ConfigurationException("Need to give " + this.getClass().getName() + " a LocalServiceName");
            }
        }
        BeanFactoryResourceLoader beanFactoryRL = new BeanFactoryResourceLoader(this.getName(), this.beanFactory, this.beanNames);
        GlobalResourceLoader.addResourceLoaderFirst((ResourceLoader)beanFactoryRL);
    }

    public QName getName() {
        if (this.name == null) {
            this.setName(new QName(this.getServiceNameSpaceURI(), this.getLocalServiceName()));
        }
        return this.name;
    }

    public void setName(QName name) {
        this.name = name;
    }

    public String getLocalServiceName() {
        return this.localServiceName;
    }

    public void setLocalServiceName(String localServiceName) {
        this.localServiceName = localServiceName;
    }

    public String getServiceNameSpaceURI() {
        return this.serviceNameSpaceURI;
    }

    public void setServiceNameSpaceURI(String serviceNameSpaceURI) {
        this.serviceNameSpaceURI = serviceNameSpaceURI;
    }

    public void setBeanNames(Set<String> beanNames) {
        this.beanNames = beanNames;
    }
}

