/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.ojb.broker.MtoNImplementor;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerSQLException;
import org.apache.ojb.broker.accesslayer.ResultSetAndStatement;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.JdbcType;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class MtoNBroker {
    private Logger log = LoggerFactory.getLogger(MtoNBroker.class);
    private PersistenceBrokerImpl pb;
    private List tempObjects = new ArrayList();

    public MtoNBroker(PersistenceBrokerImpl persistenceBrokerImpl) {
        this.pb = persistenceBrokerImpl;
    }

    public void reset() {
        this.tempObjects.clear();
    }

    public void storeMtoNImplementor(CollectionDescriptor collectionDescriptor, Object object, Object object2, Collection collection) {
        ClassDescriptor classDescriptor = this.pb.getDescriptorRepository().getDescriptorFor(object.getClass());
        Object[] objectArray = this.pb.serviceBrokerHelper().getKeyValues(classDescriptor, object);
        Object[] objectArray2 = collectionDescriptor.getFksToThisClass();
        ClassDescriptor classDescriptor2 = this.pb.getDescriptorRepository().getDescriptorFor(ProxyHelper.getRealClass(object2));
        ValueContainer[] valueContainerArray = this.pb.serviceBrokerHelper().getKeyValues(classDescriptor2, object2);
        String[] stringArray = collectionDescriptor.getFksToItemClass();
        String string = collectionDescriptor.getIndirectionTable();
        Key key = new Key(valueContainerArray);
        if (collection.contains(key)) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            int n = ArrayUtils.indexOf((Object[])objectArray2, (Object)stringArray[i]);
            if (n == -1) continue;
            objectArray2 = (String[])ArrayUtils.remove((Object[])objectArray2, (int)n);
            objectArray = (ValueContainer[])ArrayUtils.remove((Object[])objectArray, (int)n);
        }
        String[] stringArray2 = this.mergeColumns((String[])objectArray2, stringArray);
        String string2 = this.pb.serviceSqlGenerator().getInsertMNStatement(string, (String[])objectArray2, stringArray);
        ValueContainer[] valueContainerArray2 = this.mergeContainer((ValueContainer[])objectArray, valueContainerArray);
        GenericObject genericObject = new GenericObject(string, stringArray2, valueContainerArray2);
        if (!this.tempObjects.contains(genericObject)) {
            this.pb.serviceJdbcAccess().executeUpdateSQL(string2, classDescriptor, (ValueContainer[])objectArray, valueContainerArray);
            this.tempObjects.add(genericObject);
        }
    }

    public List getMtoNImplementor(CollectionDescriptor collectionDescriptor, Object object) {
        FieldDescriptor[] fieldDescriptorArray;
        ResultSetAndStatement resultSetAndStatement = null;
        ArrayList<Key> arrayList = new ArrayList<Key>();
        ClassDescriptor classDescriptor = this.pb.getDescriptorRepository().getDescriptorFor(object.getClass());
        ValueContainer[] valueContainerArray = this.pb.serviceBrokerHelper().getKeyValues(classDescriptor, object);
        String[] stringArray = collectionDescriptor.getFksToThisClass();
        String[] stringArray2 = collectionDescriptor.getFksToItemClass();
        String string = collectionDescriptor.getIndirectionTable();
        String string2 = this.pb.serviceSqlGenerator().getSelectMNStatement(string, stringArray2, stringArray);
        ClassDescriptor classDescriptor2 = this.pb.getDescriptorRepository().getDescriptorFor(collectionDescriptor.getItemClass());
        Collection collection = this.pb.getDescriptorRepository().getAllConcreteSubclassDescriptors(classDescriptor2);
        if (collection.size() > 0) {
            classDescriptor2 = (ClassDescriptor)collection.iterator().next();
        }
        if ((fieldDescriptorArray = classDescriptor2.getPkFields()).length != stringArray2.length) {
            throw new PersistenceBrokerException("All pk fields of the element-class need to be declared in the indirection table. Element class is " + classDescriptor2.getClassNameOfObject() + " with " + fieldDescriptorArray.length + " pk-fields." + " Declared 'fk-pointing-to-element-class' elements in collection-descriptor are" + stringArray2.length);
        }
        try {
            resultSetAndStatement = this.pb.serviceJdbcAccess().executeSQL(string2, classDescriptor, valueContainerArray, false);
            while (resultSetAndStatement.m_rs.next()) {
                ValueContainer[] valueContainerArray2 = new ValueContainer[stringArray2.length];
                for (int i = 0; i < valueContainerArray2.length; ++i) {
                    valueContainerArray2[i] = new ValueContainer(resultSetAndStatement.m_rs.getObject(i + 1), fieldDescriptorArray[i].getJdbcType());
                }
                arrayList.add(new Key(valueContainerArray2));
            }
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            throw persistenceBrokerException;
        }
        catch (SQLException sQLException) {
            throw new PersistenceBrokerSQLException(sQLException);
        }
        finally {
            if (resultSetAndStatement != null) {
                resultSetAndStatement.close();
            }
        }
        return arrayList;
    }

    public void deleteMtoNImplementor(CollectionDescriptor collectionDescriptor, Object object) {
        ClassDescriptor classDescriptor = this.pb.getDescriptorRepository().getDescriptorFor(object.getClass());
        ValueContainer[] valueContainerArray = this.pb.serviceBrokerHelper().getKeyValues(classDescriptor, object);
        String[] stringArray = collectionDescriptor.getFksToThisClass();
        String string = collectionDescriptor.getIndirectionTable();
        String string2 = this.pb.serviceSqlGenerator().getDeleteMNStatement(string, stringArray, null);
        this.pb.serviceJdbcAccess().executeUpdateSQL(string2, classDescriptor, valueContainerArray, null);
    }

    public void deleteMtoNImplementor(CollectionDescriptor collectionDescriptor, Object object, Iterator iterator, Collection collection) {
        if (collection.isEmpty() || iterator == null) {
            return;
        }
        ArrayList arrayList = new ArrayList(collection);
        ClassDescriptor classDescriptor = this.pb.getDescriptorRepository().getDescriptorFor(collectionDescriptor.getItemClass());
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Key key = new Key(this.pb.serviceBrokerHelper().getKeyValues(classDescriptor, e, true));
            arrayList.remove(key);
        }
        ClassDescriptor classDescriptor2 = this.pb.getDescriptorRepository().getDescriptorFor(object.getClass());
        ValueContainer[] valueContainerArray = this.pb.serviceBrokerHelper().getKeyValues(classDescriptor2, object);
        String[] stringArray = collectionDescriptor.getFksToThisClass();
        String[] stringArray2 = collectionDescriptor.getFksToItemClass();
        String string = collectionDescriptor.getIndirectionTable();
        Iterator iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            ValueContainer[] valueContainerArray2 = ((Key)iterator2.next()).m_containers;
            String string2 = this.pb.serviceSqlGenerator().getDeleteMNStatement(string, stringArray, stringArray2);
            this.pb.serviceJdbcAccess().executeUpdateSQL(string2, classDescriptor2, valueContainerArray, valueContainerArray2);
        }
    }

    public void storeMtoNImplementor(MtoNImplementor mtoNImplementor) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Storing M2N implementor [" + mtoNImplementor + "]");
        }
        this.insertOrDeleteMtoNImplementor(mtoNImplementor, true);
    }

    public void deleteMtoNImplementor(MtoNImplementor mtoNImplementor) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Deleting M2N implementor [" + mtoNImplementor + "]");
        }
        this.insertOrDeleteMtoNImplementor(mtoNImplementor, false);
    }

    private void insertOrDeleteMtoNImplementor(MtoNImplementor mtoNImplementor, boolean bl) throws PersistenceBrokerException {
        DescriptorRepository descriptorRepository = this.pb.getDescriptorRepository();
        Object object = mtoNImplementor.getLeftObject();
        Class clazz = mtoNImplementor.getLeftClass();
        Object object2 = mtoNImplementor.getRightObject();
        Class clazz2 = mtoNImplementor.getRightClass();
        ClassDescriptor classDescriptor = descriptorRepository.getDescriptorFor(clazz);
        ClassDescriptor classDescriptor2 = descriptorRepository.getDescriptorFor(clazz2);
        CollectionDescriptor collectionDescriptor = mtoNImplementor.getLeftDescriptor();
        if (object == null || object2 == null) {
            this.log.error("Can't handle MtoNImplementor in correct way, found a 'null' object");
        } else {
            ValueContainer[] valueContainerArray = this.pb.serviceBrokerHelper().getKeyValues(classDescriptor, object);
            ValueContainer[] valueContainerArray2 = this.pb.serviceBrokerHelper().getKeyValues(classDescriptor2, object2);
            String[] stringArray = collectionDescriptor.getFksToThisClass();
            String[] stringArray2 = collectionDescriptor.getFksToItemClass();
            String string = collectionDescriptor.getIndirectionTable();
            if (string == null) {
                throw new PersistenceBrokerException("Can't remove MtoN implementor without an indirection table");
            }
            String[] stringArray3 = this.mergeColumns(stringArray, stringArray2);
            ValueContainer[] valueContainerArray3 = this.mergeContainer(valueContainerArray, valueContainerArray2);
            if (bl) {
                String string2 = this.pb.serviceSqlGenerator().getInsertMNStatement(string, stringArray, stringArray2);
                GenericObject genericObject = new GenericObject(string, stringArray3, valueContainerArray3);
                if (!this.tempObjects.contains(genericObject)) {
                    this.pb.serviceJdbcAccess().executeUpdateSQL(string2, classDescriptor, valueContainerArray, valueContainerArray2);
                    this.tempObjects.add(genericObject);
                }
            } else {
                String string3 = this.pb.serviceSqlGenerator().getDeleteMNStatement(string, stringArray, stringArray2);
                this.pb.serviceJdbcAccess().executeUpdateSQL(string3, classDescriptor, valueContainerArray, valueContainerArray2);
            }
        }
    }

    private String[] mergeColumns(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    private ValueContainer[] mergeContainer(ValueContainer[] valueContainerArray, ValueContainer[] valueContainerArray2) {
        ValueContainer[] valueContainerArray3 = new ValueContainer[valueContainerArray.length + valueContainerArray2.length];
        System.arraycopy(valueContainerArray, 0, valueContainerArray3, 0, valueContainerArray.length);
        System.arraycopy(valueContainerArray2, 0, valueContainerArray3, valueContainerArray.length, valueContainerArray2.length);
        return valueContainerArray3;
    }

    private static final class GenericObject {
        private String tablename;
        private String[] columnNames;
        private ValueContainer[] values;

        public GenericObject(String string, String[] stringArray, ValueContainer[] valueContainerArray) {
            this.tablename = string;
            this.columnNames = stringArray;
            this.values = valueContainerArray;
            if (valueContainerArray != null && stringArray.length != valueContainerArray.length) {
                throw new OJBRuntimeException("Column name array and value array have NOT same length");
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            boolean bl = false;
            if (object instanceof GenericObject) {
                GenericObject genericObject = (GenericObject)object;
                boolean bl2 = bl = this.tablename.equalsIgnoreCase(genericObject.tablename) && this.columnNames != null && genericObject.columnNames != null && this.columnNames.length == genericObject.columnNames.length;
                if (bl) {
                    for (int i = 0; i < this.columnNames.length; ++i) {
                        int n = genericObject.indexForColumn(this.columnNames[i]);
                        if (n < 0) {
                            bl = false;
                            break;
                        }
                        bl = this.values[i].equals(genericObject.values[n]);
                        if (!bl) break;
                    }
                }
            }
            return bl;
        }

        int indexForColumn(String string) {
            int n = -1;
            for (int i = 0; i < this.columnNames.length; ++i) {
                if (!this.columnNames[i].equals(string)) continue;
                n = i;
                break;
            }
            return n;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public ValueContainer getValueFor(String string) {
            try {
                return this.values[this.indexForColumn(string)];
            }
            catch (Exception exception) {
                throw new OJBRuntimeException("Can't find value for column " + string + (this.indexForColumn(string) < 0 ? ". Column name was not found" : ""), exception);
            }
        }

        public String getTablename() {
            return this.tablename;
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        public ValueContainer[] getValues() {
            return this.values;
        }

        public void setValues(ValueContainer[] valueContainerArray) {
            this.values = valueContainerArray;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("tableName", (Object)this.tablename).append("columnNames", (Object[])this.columnNames).append("values", (Object[])this.values).toString();
        }
    }

    private static final class Key {
        final ValueContainer[] m_containers;

        Key(ValueContainer[] valueContainerArray) {
            this.m_containers = new ValueContainer[valueContainerArray.length];
            for (int i = 0; i < valueContainerArray.length; ++i) {
                Object object = valueContainerArray[i].getValue();
                JdbcType jdbcType = valueContainerArray[i].getJdbcType();
                if (object instanceof Number) {
                    object = new Long(((Number)object).longValue());
                }
                this.m_containers[i] = new ValueContainer(object, jdbcType);
            }
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Key)) {
                return false;
            }
            Key key = (Key)object;
            EqualsBuilder equalsBuilder = new EqualsBuilder();
            equalsBuilder.append((Object[])this.m_containers, (Object[])key.m_containers);
            return equalsBuilder.isEquals();
        }

        public int hashCode() {
            HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
            hashCodeBuilder.append((Object[])this.m_containers);
            return hashCodeBuilder.toHashCode();
        }
    }
}

