/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.species;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.iacuc.IacucProtocolAction;
import org.kuali.kra.iacuc.IacucProtocolDocument;
import org.kuali.kra.iacuc.IacucProtocolForm;
import org.kuali.kra.iacuc.species.IacucProtocolSpecies;
import org.kuali.kra.iacuc.species.IacucProtocolSpeciesService;
import org.kuali.kra.iacuc.species.rule.AddProtocolSpeciesEvent;
import org.kuali.rice.krad.util.GlobalVariables;

public class IacucProtocolSpeciesAction
extends IacucProtocolAction {
    private static final String CONFIRM_DELETE_PROTOCOL_SPECIES_KEY = "confirmDeleteProtocolSpecies";
    private static final String DUPLICATE_SPECIES_ERROR_PATH = "iacucProtocolSpeciesHelper.newIacucProtocolSpecies";
    private static final String DUPLICATE_SPECIES_ERROR_KEY = "error.iacuc.validation.duplicate.group";

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.execute(mapping, form, request, response);
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        protocolForm.getIacucProtocolSpeciesHelper().prepareView();
        return forward;
    }

    public ActionForward addProtocolSpecies(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolForm protocolForm = (IacucProtocolForm)form;
        IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
        List<IacucProtocolSpecies> iacucProtocolSpeciesList = document.getIacucProtocol().getIacucProtocolSpeciesList();
        IacucProtocolSpecies iacucProtocolSpecies = protocolForm.getIacucProtocolSpeciesHelper().getNewIacucProtocolSpecies();
        boolean found = false;
        for (IacucProtocolSpecies oldSpecies : iacucProtocolSpeciesList) {
            if (!iacucProtocolSpecies.isSameGroupAs(oldSpecies)) continue;
            GlobalVariables.getMessageMap().clearErrorPath();
            GlobalVariables.getMessageMap().addToErrorPath(DUPLICATE_SPECIES_ERROR_PATH);
            GlobalVariables.getMessageMap().putError("speciesGroup", DUPLICATE_SPECIES_ERROR_KEY, new String[0]);
            found = true;
        }
        if (!found && this.applyRules(new AddProtocolSpeciesEvent("", document, iacucProtocolSpecies))) {
            this.getIacucProtocolSpeciesService().addProtocolSpecies(document.getIacucProtocol(), iacucProtocolSpecies);
            protocolForm.getIacucProtocolSpeciesHelper().setNewIacucProtocolSpecies(new IacucProtocolSpecies());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteProtocolSpecies(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_DELETE_PROTOCOL_SPECIES_KEY, "question.iacuc.protocol.species.delete.confirmation", new String[0]), CONFIRM_DELETE_PROTOCOL_SPECIES_KEY, "");
    }

    public ActionForward confirmDeleteProtocolSpecies(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_DELETE_PROTOCOL_SPECIES_KEY.equals(question)) {
            IacucProtocolForm protocolForm = (IacucProtocolForm)form;
            IacucProtocolDocument document = protocolForm.getIacucProtocolDocument();
            document.getIacucProtocol().getIacucProtocolSpeciesList().remove(this.getLineToDelete(request));
        }
        return mapping.findForward("basic");
    }

    protected IacucProtocolSpeciesService getIacucProtocolSpeciesService() {
        return (IacucProtocolSpeciesService)KcServiceLocator.getService("iacucProtocolSpeciesService");
    }
}

