/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.submit;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.auth.UnitAuthorizationService;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDao;
import org.kuali.kra.protocol.ProtocolSpecialVersion;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.followup.FollowupActionService;
import org.kuali.kra.protocol.actions.submit.ActionRightMapping;
import org.kuali.kra.protocol.actions.submit.ProtocolActionMappingBase;
import org.kuali.kra.protocol.actions.submit.ProtocolActionService;
import org.kuali.kra.protocol.actions.submit.ProtocolActionUpdateMapping;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.drools.util.DroolsRuleHandler;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ProtocolActionServiceImplBase
implements ProtocolActionService {
    protected static final String NONE = "NONE";
    protected BusinessObjectService businessObjectService;
    protected KcAuthorizationService kraAuthorizationService;
    protected UnitAuthorizationService unitAuthorizationService;
    protected FollowupActionService<?> followupActionService;
    private ProtocolDao<? extends ProtocolBase> protocolDao;
    protected DroolsRuleHandler canPerformRuleHandler;
    protected List<String> actions = Arrays.asList(this.getActionCodesArrayHook());
    protected List<DroolsRuleHandler> rulesList;
    protected static final Map<String, String> ACTION_SUBMISSION_MAPPINGS;

    protected abstract String[] getActionCodesArrayHook();

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setKraAuthorizationService(KcAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }

    public void setUnitAuthorizationService(UnitAuthorizationService unitAuthorizationService) {
        this.unitAuthorizationService = unitAuthorizationService;
    }

    public void setProtocolDao(ProtocolDao<? extends ProtocolBase> protocolDao) {
        this.protocolDao = protocolDao;
    }

    public void setFollowupActionService(FollowupActionService<?> followupActionService) {
        this.followupActionService = followupActionService;
    }

    @Override
    public boolean isActionAllowed(String actionTypeCode, ProtocolBase protocol) {
        return this.canPerformAction(actionTypeCode, protocol) || protocol.isFollowupAction(actionTypeCode);
    }

    @Override
    public List<String> getActionsAllowed(ProtocolBase protocol) {
        ArrayList<String> actionList = new ArrayList<String>();
        for (String actionTypeCode : this.actions) {
            if (!this.canPerformAction(actionTypeCode, protocol)) continue;
            actionList.add(actionTypeCode);
        }
        return actionList;
    }

    protected abstract boolean hasPermissionLeadUnit(String var1, ProtocolBase var2, ActionRightMapping var3);

    protected abstract boolean hasPermissionToSubmit(String var1, ProtocolBase var2, ActionRightMapping var3);

    private List<String> getPersonnelIds(ProtocolBase protcol) {
        ArrayList<String> PersonnelIds = new ArrayList<String>();
        for (ProtocolPersonBase person : protcol.getProtocolPersons()) {
            if (StringUtils.isNotBlank((CharSequence)person.getPersonId())) {
                PersonnelIds.add(person.getPersonId());
                continue;
            }
            PersonnelIds.add(person.getRolodexId().toString());
        }
        return PersonnelIds;
    }

    @Override
    public boolean isProtocolPersonnel(ProtocolBase protocol) {
        Person person = GlobalVariables.getUserSession().getPerson();
        return this.getPersonnelIds(protocol).contains(person.getPrincipalId());
    }

    protected String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    public boolean canPerformAction(String actionTypeCode, ProtocolBase protocol) {
        String submissionStatusCode = protocol.getProtocolSubmission().getSubmissionStatusCode();
        String submissionTypeCode = protocol.getProtocolSubmission().getSubmissionTypeCode();
        String protocolReviewTypeCode = protocol.getProtocolSubmission().getProtocolReviewTypeCode();
        String protocolStatusCode = protocol.getProtocolStatusCode();
        String scheduleId = protocol.getProtocolSubmission().getScheduleId();
        Integer submissionNumber = protocol.getProtocolSubmission().getSubmissionNumber();
        ProtocolActionMappingBase protocolAction = this.getNewProtocolActionMappingInstanceHook(actionTypeCode, submissionStatusCode, submissionTypeCode, protocolReviewTypeCode, protocolStatusCode, scheduleId, submissionNumber);
        protocolAction.setBusinessObjectService(this.businessObjectService);
        protocolAction.setDao(this.protocolDao);
        protocolAction.setProtocol(protocol);
        this.rulesList.get(this.getPerformActionRuleIndexHook()).executeRules(protocolAction);
        return protocolAction.isAllowed();
    }

    protected abstract Logger getLOGHook();

    protected abstract int getPerformActionRuleIndexHook();

    protected abstract ProtocolActionMappingBase getNewProtocolActionMappingInstanceHook(String var1, String var2, String var3, String var4, String var5, String var6, Integer var7);

    @Override
    public void updateProtocolStatus(ProtocolActionBase protocolActionBo, ProtocolBase protocol) {
        String protocolNumberUpper = protocol.getProtocolNumber().toUpperCase();
        String specialCondition = protocolNumberUpper.contains(ProtocolSpecialVersion.AMENDMENT.getCode()) ? ProtocolSpecialVersion.AMENDMENT.getCode() : (protocolNumberUpper.contains(ProtocolSpecialVersion.RENEWAL.getCode()) ? ProtocolSpecialVersion.RENEWAL.getCode() : (protocolNumberUpper.contains(ProtocolSpecialVersion.FYI.getCode()) ? ProtocolSpecialVersion.FYI.getCode() : NONE));
        ProtocolActionUpdateMapping protocolAction = this.getNewProtocolActionUpdateMappingHook(protocolActionBo.getProtocolActionTypeCode(), protocol.getProtocolSubmission().getProtocolSubmissionType().getSubmissionTypeCode(), protocol.getProtocolStatusCode(), specialCondition);
        protocol.refreshReferenceObject("protocolSubmission");
        protocolAction.setProtocol(protocol);
        protocolAction.setProtocolSubmission(this.getSubmissionForAction(protocolAction.getActionTypeCode(), protocol));
        protocolAction.setSubmissionTypeCode(protocolAction.getProtocolSubmission().getProtocolSubmissionType().getSubmissionTypeCode());
        protocolAction.setProtocolAction(protocolActionBo);
        this.rulesList.get(this.getUpdateRuleIndexHook()).executeRules(protocolAction);
        this.businessObjectService.save((PersistableBusinessObject)protocol);
    }

    protected ProtocolSubmissionBase getSubmissionForAction(String actionTypeCode, ProtocolBase protocol) {
        if (ACTION_SUBMISSION_MAPPINGS.containsKey(actionTypeCode) && protocol.getProtocolSubmissions() != null) {
            for (ProtocolSubmissionBase submission : Lists.reverse(protocol.getProtocolSubmissions())) {
                if (!submission.getSubmissionStatusCode().equals("102") || !ACTION_SUBMISSION_MAPPINGS.get(actionTypeCode).equals(submission.getSubmissionTypeCode())) continue;
                return submission;
            }
        }
        return protocol.getProtocolSubmission();
    }

    protected abstract ProtocolActionUpdateMapping getNewProtocolActionUpdateMappingHook(String var1, String var2, String var3, String var4);

    protected abstract int getUpdateRuleIndexHook();

    @Override
    public abstract void resetProtocolStatus(ProtocolActionBase var1, ProtocolBase var2);

    @Override
    public boolean isActionOpenForFollowup(String protocolActionTypeCode, ProtocolBase protocol) {
        return this.followupActionService.isActionOpenForFollowup(protocolActionTypeCode, protocol);
    }

    public DroolsRuleHandler getCanPerformRuleHandler() {
        if (this.canPerformRuleHandler == null) {
            this.canPerformRuleHandler = new DroolsRuleHandler(this.getPerformActionFileNameHook());
        }
        return this.canPerformRuleHandler;
    }

    protected abstract String getPerformActionFileNameHook();

    public void setRuleFiles(List<String> ruleFiles) throws IOException {
        this.loadRules(ruleFiles);
    }

    protected void loadRules(List<String> ruleFiles) {
        this.rulesList = new ArrayList<DroolsRuleHandler>();
        for (String ruleFile : ruleFiles) {
            this.rulesList.add(new DroolsRuleHandler(ruleFile));
        }
    }

    static {
        HashMap<String, String> actionSubmissionMappings = new HashMap<String, String>();
        actionSubmissionMappings.put("211", "113");
        actionSubmissionMappings.put("207", "111");
        actionSubmissionMappings.put("302", "110");
        actionSubmissionMappings.put("300", "109");
        actionSubmissionMappings.put("212", "114");
        ACTION_SUBMISSION_MAPPINGS = Collections.unmodifiableMap(actionSubmissionMappings);
    }
}

